/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.jts;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

final class PathIteratorAdapter
implements PathIterator {
    private final AffineTransform at;
    private final Iterator<CoordinateSequence> sequences;
    private CoordinateSequence coordinates;
    private int pointCount;
    private int closingPoint;
    private int currentIndex;

    PathIteratorAdapter(Geometry geometry, AffineTransform at) {
        this.at = at != null ? at : new AffineTransform();
        this.sequences = PathIteratorAdapter.iterator(geometry);
        this.nextSequence();
    }

    private void nextSequence() {
        while (this.sequences.hasNext()) {
            this.coordinates = this.sequences.next();
            this.pointCount = this.coordinates.size();
            this.closingPoint = this.pointCount - 1;
            if (this.closingPoint < 1 || !this.coordinates.getCoordinate(0).equals2D(this.coordinates.getCoordinate(this.closingPoint))) {
                this.closingPoint = -1;
            }
            if (this.pointCount <= 0) continue;
            return;
        }
    }

    @Override
    public void next() {
        if (++this.currentIndex >= this.pointCount) {
            this.currentIndex = 0;
            this.coordinates = null;
            this.nextSequence();
        }
    }

    @Override
    public boolean isDone() {
        return this.coordinates == null;
    }

    @Override
    public int getWindingRule() {
        return 0;
    }

    @Override
    public int currentSegment(double[] coords) {
        if (this.currentIndex == this.closingPoint) {
            return 4;
        }
        coords[0] = this.coordinates.getX(this.currentIndex);
        coords[1] = this.coordinates.getY(this.currentIndex);
        this.at.transform(coords, 0, coords, 0, 1);
        return this.currentIndex == 0 ? 0 : 1;
    }

    @Override
    public int currentSegment(float[] coords) {
        if (this.currentIndex == this.closingPoint) {
            return 4;
        }
        coords[0] = (float)this.coordinates.getX(this.currentIndex);
        coords[1] = (float)this.coordinates.getY(this.currentIndex);
        this.at.transform(coords, 0, coords, 0, 1);
        return this.currentIndex == 0 ? 0 : 1;
    }

    private static Iterator<CoordinateSequence> iterator(Geometry geometry) {
        List<CoordinateSequence> sequences;
        if (geometry instanceof LineString) {
            sequences = List.of(((LineString)geometry).getCoordinateSequence());
        } else if (geometry instanceof Point) {
            sequences = List.of(((Point)geometry).getCoordinateSequence());
        } else {
            if (geometry instanceof Polygon) {
                return new RingIterator((Polygon)geometry);
            }
            if (geometry instanceof GeometryCollection) {
                return new GeomIterator((GeometryCollection)geometry);
            }
            throw new IllegalArgumentException(Errors.format((short)200, (Object)Classes.getShortClassName((Object)geometry)));
        }
        return sequences.iterator();
    }

    private static final class RingIterator
    implements Iterator<CoordinateSequence> {
        private final Polygon polygon;
        private int interior;

        RingIterator(Polygon geometry) {
            this.polygon = geometry;
            this.interior = -1;
        }

        @Override
        public boolean hasNext() {
            return this.interior < this.polygon.getNumInteriorRing();
        }

        @Override
        public CoordinateSequence next() {
            LinearRing current = this.interior < 0 ? this.polygon.getExteriorRing() : this.polygon.getInteriorRingN(this.interior);
            ++this.interior;
            return current.getCoordinateSequence();
        }
    }

    private static final class GeomIterator
    implements Iterator<CoordinateSequence> {
        private final GeometryCollection collection;
        private int index;
        private Iterator<CoordinateSequence> current;

        GeomIterator(GeometryCollection collection) {
            this.collection = collection;
            while (this.index < collection.getNumGeometries()) {
                this.current = PathIteratorAdapter.iterator(collection.getGeometryN(this.index));
                if (this.current.hasNext()) break;
                ++this.index;
            }
        }

        @Override
        public boolean hasNext() {
            while (!this.current.hasNext()) {
                if (++this.index >= this.collection.getNumGeometries()) {
                    return false;
                }
                this.current = PathIteratorAdapter.iterator(this.collection.getGeometryN(this.index));
            }
            return true;
        }

        @Override
        public CoordinateSequence next() {
            return this.current.next();
        }
    }
}

