/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.armeria;

import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.netty.util.AsciiString;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public abstract class ArmeriaClientInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String KEY_SAFE_CLOSEABLE = "SAFE_CLOSEABLE";

    protected void beforeMethod(URI uri, HttpMethod httpMethod, String path) {
        ContextCarrier contextCarrier = new ContextCarrier();
        String remotePeer = uri.getHost() + ":" + uri.getPort();
        AbstractSpan exitSpan = ContextManager.createExitSpan((String)path, (ContextCarrier)contextCarrier, (String)remotePeer);
        exitSpan.setComponent((Component)ComponentsDefine.ARMERIA);
        exitSpan.setLayer(SpanLayer.HTTP);
        Tags.HTTP.METHOD.set(exitSpan, httpMethod.name());
        ContextManager.getRuntimeContext().put((Object)KEY_SAFE_CLOSEABLE, (Object)Clients.withHttpHeaders(headers -> {
            HttpHeadersBuilder builder = headers.toBuilder();
            CarrierItem item = contextCarrier.items();
            while (item.hasNext()) {
                item = item.next();
                builder.add((CharSequence)AsciiString.of((CharSequence)item.getHeadKey()), item.getHeadValue());
            }
            return builder.build();
        }));
    }

    protected void afterMethod(Object req) {
        SafeCloseable safeCloseable;
        if (req instanceof HttpRequest && ContextManager.isActive()) {
            ContextManager.stopSpan();
        }
        if ((safeCloseable = (SafeCloseable)ContextManager.getRuntimeContext().get((Object)KEY_SAFE_CLOSEABLE, SafeCloseable.class)) != null) {
            safeCloseable.close();
        }
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }
}

