/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.artifacts;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.sling.feature.io.artifacts.spi.ArtifactProviderContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ArtifactManagerConfig
implements ArtifactProviderContext {
    private String[] repositoryUrls;
    private File cacheDirectory;
    private final AtomicLong cachedArtifacts = new AtomicLong();
    private final AtomicLong downloadedArtifacts = new AtomicLong();
    private final AtomicLong localArtifacts = new AtomicLong();
    private boolean useMvn = false;
    @NotNull
    private final String repoHome;
    private static final Logger logger = LoggerFactory.getLogger(ArtifactManagerConfig.class);

    public ArtifactManagerConfig() {
        String mvnRepositoryDirectory = ArtifactManagerConfig.getMvnRepositoryDirectory();
        this.repositoryUrls = new String[]{ArtifactManagerConfig.toFileUrl(mvnRepositoryDirectory), "https://repo.maven.apache.org/maven2", "https://repository.apache.org/content/groups/snapshots"};
        this.repoHome = mvnRepositoryDirectory + "/";
    }

    public void setRepositoryUrls(String[] urls) {
        if (urls == null || urls.length == 0) {
            this.repositoryUrls = new String[0];
        } else {
            this.repositoryUrls = new String[urls.length];
            System.arraycopy(urls, 0, this.repositoryUrls, 0, urls.length);
            for (int i = 0; i < this.repositoryUrls.length; ++i) {
                if (!this.repositoryUrls[i].endsWith("/")) continue;
                this.repositoryUrls[i] = this.repositoryUrls[i].substring(0, this.repositoryUrls[i].length() - 1);
            }
        }
    }

    @NotNull
    public String[] getRepositoryUrls() {
        return this.repositoryUrls;
    }

    @Override
    @Nullable
    public File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(File dir) {
        this.cacheDirectory = dir;
    }

    @Override
    public void incCachedArtifacts() {
        this.cachedArtifacts.incrementAndGet();
    }

    @Override
    public void incDownloadedArtifacts() {
        this.downloadedArtifacts.incrementAndGet();
    }

    @Override
    public void incLocalArtifacts() {
        this.localArtifacts.incrementAndGet();
    }

    public long getCachedArtifacts() {
        return this.cachedArtifacts.get();
    }

    public long getDownloadedArtifacts() {
        return this.downloadedArtifacts.get();
    }

    public long getLocalArtifacts() {
        return this.localArtifacts.get();
    }

    public boolean isUseMvn() {
        return this.useMvn;
    }

    public void setUseMvn(boolean useMvn) {
        this.useMvn = useMvn;
    }

    @NotNull
    String getMvnHome() {
        return this.repoHome;
    }

    private static final String getMvnRepositoryDirectory() {
        String mavenDirectory = System.getProperty("user.home") + "/.m2";
        File settings = new File(mavenDirectory, "settings.xml");
        if (settings.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(settings);
                NodeList nodes = doc.getElementsByTagName("localRepository");
                if (nodes.getLength() > 0) {
                    String localRepository = nodes.item(0).getTextContent();
                    return new File(localRepository).getAbsolutePath();
                }
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                logger.warn("Unable to parse " + settings.getAbsolutePath(), (Throwable)ex);
            }
        }
        return mavenDirectory + "/repository";
    }

    static final String toFileUrl(String path) {
        return "file://" + new File(path).toURI().getPath();
    }
}

