/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.BinaryArithmeticWithDatetimeResolver$;
import org.apache.spark.sql.catalyst.analysis.resolver.BinaryArithmeticResolver$;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ProducesUnresolvedSubtree;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvesExpressionChildren;
import org.apache.spark.sql.catalyst.analysis.resolver.TimezoneAwareExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.TypeCoercionResolver;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.DateAdd;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.SubtractDates$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005I4AAE\n\u0001E!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001d1\u0005A1A\u0005\n\u001dCaa\u0016\u0001!\u0002\u0013A\u0005b\u0002-\u0001\u0005\u0004%I!\u0017\u0005\u0007;\u0002\u0001\u000b\u0011\u0002.\t\u000by\u0003A\u0011I0\t\u000b\t\u0004A\u0011B2\t\u000b\u0019\u0004A\u0011B4\b\u000b)\u001c\u0002\u0012A6\u0007\u000bI\u0019\u0002\u0012\u00017\t\u000b\u0005cA\u0011A7\t\u000f9d!\u0019!C\u0005\u000f\"1q\u000e\u0004Q\u0001\n!Cq\u0001\u001d\u0007C\u0002\u0013%q\t\u0003\u0004r\u0019\u0001\u0006I\u0001\u0013\u0002\u0019\u0005&t\u0017M]=Be&$\b.\\3uS\u000e\u0014Vm]8mm\u0016\u0014(B\u0001\u000b\u0016\u0003!\u0011Xm]8mm\u0016\u0014(B\u0001\f\u0018\u0003!\tg.\u00197zg&\u001c(B\u0001\r\u001a\u0003!\u0019\u0017\r^1msN$(B\u0001\u000e\u001c\u0003\r\u0019\u0018\u000f\u001c\u0006\u00039u\tQa\u001d9be.T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO\u000e\u00011\u0003\u0002\u0001$SY\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u0016,[Mj\u0011aE\u0005\u0003YM\u0011\u0001\u0003\u0016:fK:{G-\u001a*fg>dg/\u001a:\u0011\u00059\nT\"A\u0018\u000b\u0005A:\u0012aC3yaJ,7o]5p]NL!AM\u0018\u0003!\tKg.\u0019:z\u0003JLG\u000f[7fi&\u001c\u0007C\u0001\u00185\u0013\t)tF\u0001\u0006FqB\u0014Xm]:j_:\u0004\"AK\u001c\n\u0005a\u001a\"!\u0007)s_\u0012,8-Z:V]J,7o\u001c7wK\u0012\u001cVO\u0019;sK\u0016\f!#\u001a=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\u001c<feB\u0011!fO\u0005\u0003yM\u0011!#\u0012=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\u001c<fe\u0006yB/[7fu>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c*fg>dg/\u001a:\u0011\u0005)z\u0014B\u0001!\u0014\u0005}!\u0016.\\3{_:,\u0017i^1sK\u0016C\bO]3tg&|gNU3t_24XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r#U\t\u0005\u0002+\u0001!)\u0011h\u0001a\u0001u!)Qh\u0001a\u0001}\u0005YB/\u001f9f\u0007>,'oY5p]R\u0013\u0018M\\:g_Jl\u0017\r^5p]N,\u0012\u0001\u0013\t\u0004\u0013F#fB\u0001&P\u001d\tYe*D\u0001M\u0015\ti\u0015%\u0001\u0004=e>|GOP\u0005\u0002M%\u0011\u0001+J\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00116KA\u0002TKFT!\u0001U\u0013\u0011\t\u0011*6gM\u0005\u0003-\u0016\u0012\u0011BR;oGRLwN\\\u0019\u00029QL\b/Z\"pKJ\u001c\u0017n\u001c8Ue\u0006t7OZ8s[\u0006$\u0018n\u001c8tA\u0005!B/\u001f9f\u0007>,'oY5p]J+7o\u001c7wKJ,\u0012A\u0017\t\u0003UmK!\u0001X\n\u0003)QK\b/Z\"pKJ\u001c\u0017n\u001c8SKN|GN^3s\u0003U!\u0018\u0010]3D_\u0016\u00148-[8o%\u0016\u001cx\u000e\u001c<fe\u0002\nqA]3t_24X\r\u0006\u00024A\")\u0011\r\u0003a\u0001[\u0005QRO\u001c:fg>dg/\u001a3CS:\f'/_!sSRDW.\u001a;jG\u0006iBO]1og\u001a|'/\u001c\"j]\u0006\u0014\u00180\u0011:ji\"lW\r^5d\u001d>$W\r\u0006\u00024I\")Q-\u0003a\u0001[\u0005\u0001\"-\u001b8bef\f%/\u001b;i[\u0016$\u0018nY\u0001\u0010e\u0016\u0004H.Y2f\t\u0006$X\rV=qKR\u00111\u0007\u001b\u0005\u0006S*\u0001\raM\u0001\u000bKb\u0004(/Z:tS>t\u0017\u0001\u0007\"j]\u0006\u0014\u00180\u0011:ji\"lW\r^5d%\u0016\u001cx\u000e\u001c<feB\u0011!\u0006D\n\u0003\u0019\r\"\u0012a[\u0001\u001e)f\u0003ViX\"P\u000bJ\u001b\u0015j\u0014(`)J\u000bej\u0015$P%6\u000bE+S(O'\u0006qB+\u0017)F?\u000e{UIU\"J\u001f:{FKU!O'\u001a{%+T!U\u0013>s5\u000bI\u0001#\u0003:\u001b\u0016j\u0018+Z!\u0016{6iT#S\u0007&{ej\u0018+S\u0003:\u001bfi\u0014*N\u0003RKuJT*\u0002G\u0005s5+S0U3B+ulQ(F%\u000eKuJT0U%\u0006s5KR(S\u001b\u0006#\u0016j\u0014(TA\u0001")
public class BinaryArithmeticResolver
implements TreeNodeResolver<BinaryArithmetic, Expression>,
ProducesUnresolvedSubtree {
    private final ExpressionResolver expressionResolver;
    private final TimezoneAwareExpressionResolver timezoneAwareExpressionResolver;
    private final Seq<Function1<Expression, Expression>> typeCoercionTransformations;
    private final TypeCoercionResolver typeCoercionResolver;

    @Override
    public Expression withResolvedSubtree(Expression expression, Function1<Expression, Expression> expressionResolver, Function0<Expression> body) {
        return ProducesUnresolvedSubtree.withResolvedSubtree$(this, expression, expressionResolver, body);
    }

    @Override
    public <ExpressionType extends Expression> ExpressionType withResolvedChildren(ExpressionType unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return (ExpressionType)ResolvesExpressionChildren.withResolvedChildren$(this, unresolvedExpression, resolveChild);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private Seq<Function1<Expression, Expression>> typeCoercionTransformations() {
        return this.typeCoercionTransformations;
    }

    private TypeCoercionResolver typeCoercionResolver() {
        return this.typeCoercionResolver;
    }

    @Override
    public Expression resolve(BinaryArithmetic unresolvedBinaryArithmetic) {
        BinaryArithmetic binaryArithmeticWithResolvedChildren = this.withResolvedChildren(unresolvedBinaryArithmetic, (Function1<Expression, Expression>)(Function1 & Serializable)unresolvedExpression -> $this.expressionResolver.resolve((Expression)unresolvedExpression));
        Expression binaryArithmeticWithResolvedSubtree = this.withResolvedSubtree(binaryArithmeticWithResolvedChildren, (Function1<Expression, Expression>)(Function1 & Serializable)unresolvedExpression -> $this.expressionResolver.resolve((Expression)unresolvedExpression), (Function0<Expression>)(Function0 & Serializable)() -> this.transformBinaryArithmeticNode(binaryArithmeticWithResolvedChildren));
        return this.timezoneAwareExpressionResolver.withResolvedTimezone(binaryArithmeticWithResolvedSubtree, this.conf().sessionLocalTimeZone());
    }

    private Expression transformBinaryArithmeticNode(BinaryArithmetic binaryArithmetic) {
        Expression binaryArithmeticWithDateTypeReplaced = this.replaceDateType(binaryArithmetic);
        Expression binaryArithmeticWithTypeCoercion = this.typeCoercionResolver().resolve(binaryArithmeticWithDateTypeReplaced);
        Tuple2 tuple2 = new Tuple2((Object)((Expression)binaryArithmetic.left()).dataType(), (Object)((Expression)binaryArithmetic.right()).dataType());
        if (tuple2 != null && tuple2._1() instanceof DateType && tuple2._2() instanceof StringType) {
            Expression expression = binaryArithmeticWithTypeCoercion;
            if (expression instanceof Add) {
                Add add = (Add)expression;
                return new DateAdd(add.left(), add.right());
            }
            if (expression instanceof Subtract) {
                Subtract subtract = (Subtract)expression;
                return SubtractDates$.MODULE$.apply(subtract.left(), subtract.right());
            }
            return expression;
        }
        return binaryArithmeticWithTypeCoercion;
    }

    private Expression replaceDateType(Expression expression) {
        Expression expression2 = expression;
        if (expression2 instanceof Add ? true : (expression2 instanceof Subtract ? true : (expression2 instanceof Multiply ? true : expression2 instanceof Divide))) {
            return BinaryArithmeticWithDatetimeResolver$.MODULE$.resolve(expression2);
        }
        return expression2;
    }

    public BinaryArithmeticResolver(ExpressionResolver expressionResolver, TimezoneAwareExpressionResolver timezoneAwareExpressionResolver) {
        this.expressionResolver = expressionResolver;
        this.timezoneAwareExpressionResolver = timezoneAwareExpressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        ResolvesExpressionChildren.$init$(this);
        ProducesUnresolvedSubtree.$init$(this);
        this.typeCoercionTransformations = this.conf().ansiEnabled() ? BinaryArithmeticResolver$.MODULE$.org$apache$spark$sql$catalyst$analysis$resolver$BinaryArithmeticResolver$$ANSI_TYPE_COERCION_TRANSFORMATIONS() : BinaryArithmeticResolver$.MODULE$.org$apache$spark$sql$catalyst$analysis$resolver$BinaryArithmeticResolver$$TYPE_COERCION_TRANSFORMATIONS();
        this.typeCoercionResolver = new TypeCoercionResolver(timezoneAwareExpressionResolver, this.typeCoercionTransformations());
    }
}

