/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.CallMethodViaReflection$;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ArrayImplicits$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ExpressionDescription(usage="_FUNC_(class, method[, arg1[, arg2 ..]]) - Calls a method with reflection.", examples="\n    Examples:\n      > SELECT _FUNC_('java.util.UUID', 'randomUUID');\n       c33fb387-8500-4bfa-81d2-6e0e3e930df2\n      > SELECT _FUNC_('java.util.UUID', 'fromString', 'a5cf6c42-0c85-418f-af6c-3e4e5b1328f2');\n       a5cf6c42-0c85-418f-af6c-3e4e5b1328f2\n  ", since="2.0.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0005\tMe\u0001B\u0015+\u0001^B\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\tK\u0002\u0011\t\u0012)A\u0005E\"Aa\r\u0001BK\u0002\u0013\u0005q\r\u0003\u0005l\u0001\tE\t\u0015!\u0003i\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u0015a\u0007\u0001\"\u0001r\u0011\u0015\u0019\b\u0001\"\u0011u\u0011\u0015i\b\u0001\"\u0011\u007f\u0011\u0019\tY\u0001\u0001C!O\"9\u0011Q\u0002\u0001\u0005R\u0005=\u0001bBA\u0011\u0001\u0011E\u00131\u0005\u0005\u000b\u0003o\u0001\u0001R1A\u0005\n\u0005e\u0002BCA%\u0001!\u0015\r\u0011\"\u0003\u0002L!I\u0011Q\f\u0001\t\u0006\u0004%Ia\u001a\u0005\u000b\u0003C\u0002\u0001R1A\u0005\n\u0005-\u0003BCA3\u0001!\u0015\r\u0011\"\u0001\u0002h!Q\u0011q\u000f\u0001\t\u0006\u0004%I!!\u001f\t\u000f\u0005\u0015\u0005\u0001\"\u0015\u0002\b\"I\u00111\u0013\u0001\u0002\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u00037\u0003\u0011\u0013!C\u0001\u0003;C\u0011\"a-\u0001#\u0003%\t!!.\t\u0013\u0005e\u0006!!A\u0005B\u0005-\u0003\"CA^\u0001\u0005\u0005I\u0011AA_\u0011%\ty\fAA\u0001\n\u0003\t\t\rC\u0005\u0002H\u0002\t\t\u0011\"\u0011\u0002J\"I\u0011q\u001b\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001c\u0005\n\u0003;\u0004\u0011\u0011!C!\u0003?D\u0011\"a9\u0001\u0003\u0003%\t%!:\b\u000f\t%!\u0006#\u0001\u0003\f\u00191\u0011F\u000bE\u0001\u0005\u001bAa\u0001\u001c\u0010\u0005\u0002\t}\u0001\"\u0003B\u0011=\t\u0007I\u0011\u0001B\u0012\u0011!\u0011\tF\bQ\u0001\n\t\u0015\u0002bBA/=\u0011%!1\f\u0005\b\u0005?rB\u0011\u0001B1\u0011%\u0011\u0019HHA\u0001\n\u0003\u0013)\bC\u0005\u0003|y\t\n\u0011\"\u0001\u00026\"I!Q\u0010\u0010\u0002\u0002\u0013\u0005%q\u0010\u0005\n\u0005\u001bs\u0012\u0013!C\u0001\u0003kC\u0011Ba$\u001f\u0003\u0003%IA!%\u0003/\r\u000bG\u000e\\'fi\"|GMV5b%\u00164G.Z2uS>t'BA\u0016-\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u00055r\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005=\u0002\u0014aA:rY*\u0011\u0011GM\u0001\u0006gB\f'o\u001b\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0011\u0001ADh\u0010\"I\u001dR\u0003\"!\u000f\u001e\u000e\u0003)J!a\u000f\u0016\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002:{%\u0011aH\u000b\u0002\u0011\u001d>tG-\u001a;fe6Lg.[:uS\u000e\u0004\"!\u000f!\n\u0005\u0005S#\u0001\t#fM\u0006,H\u000e^*ue&tw\r\u0015:pIV\u001c\u0017N\\4FqB\u0014Xm]:j_:\u0004\"a\u0011$\u000e\u0003\u0011S!!\u0012\u0016\u0002\u000f\r|G-Z4f]&\u0011q\t\u0012\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011\u0011\nT\u0007\u0002\u0015*\u00111JL\u0001\u0007KJ\u0014xN]:\n\u00055S%aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005=\u0013V\"\u0001)\u000b\u0003E\u000bQa]2bY\u0006L!a\u0015)\u0003\u000fA\u0013x\u000eZ;diB\u0011Q+\u0018\b\u0003-ns!a\u0016.\u000e\u0003aS!!\u0017\u001c\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0016B\u0001/Q\u0003\u001d\u0001\u0018mY6bO\u0016L!AX0\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005q\u0003\u0016\u0001C2iS2$'/\u001a8\u0016\u0003\t\u00042!V29\u0013\t!wLA\u0002TKF\f\u0011b\u00195jY\u0012\u0014XM\u001c\u0011\u0002\u0017\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN]\u000b\u0002QB\u0011q*[\u0005\u0003UB\u0013qAQ8pY\u0016\fg.\u0001\u0007gC&dwJ\\#se>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0004]>\u0004\bCA\u001d\u0001\u0011\u0015\u0001W\u00011\u0001c\u0011\u001d1W\u0001%AA\u0002!$\"A\u001c:\t\u000b\u00014\u0001\u0019\u00012\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001v!\t1(P\u0004\u0002xqB\u0011q\u000bU\u0005\u0003sB\u000ba\u0001\u0015:fI\u00164\u0017BA>}\u0005\u0019\u0019FO]5oO*\u0011\u0011\u0010U\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0002\u007fB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u00061\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003\u0013\t\u0019AA\bUsB,7\t[3dWJ+7/\u001e7u\u0003!qW\u000f\u001c7bE2,\u0017AE5oSRL\u0017\r\\5{K&sG/\u001a:oC2$B!!\u0005\u0002\u0018A\u0019q*a\u0005\n\u0007\u0005U\u0001K\u0001\u0003V]&$\bbBA\r\u0015\u0001\u0007\u00111D\u0001\u000fa\u0006\u0014H/\u001b;j_:Le\u000eZ3y!\ry\u0015QD\u0005\u0004\u0003?\u0001&aA%oi\u0006aQM^1m\u0013:$XM\u001d8bYR!\u0011QEA\u0016!\ry\u0015qE\u0005\u0004\u0003S\u0001&aA!os\"9\u0011QF\u0006A\u0002\u0005=\u0012!B5oaV$\b\u0003BA\u0019\u0003gi\u0011\u0001L\u0005\u0004\u0003ka#aC%oi\u0016\u0014h.\u00197S_^\f\u0001\"\u0019:h\u000bb\u0004(o]\u000b\u0003\u0003w\u0001BaTA\u001fq%\u0019\u0011q\b)\u0003\u000b\u0005\u0013(/Y=)\u00071\t\u0019\u0005E\u0002P\u0003\u000bJ1!a\u0012Q\u0005%!(/\u00198tS\u0016tG/A\u0005dY\u0006\u001c8OT1nKV\u0011\u0011Q\n\t\u0005\u0003\u001f\nI&\u0004\u0002\u0002R)!\u00111KA+\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0013\u0001\u00026bm\u0006L1a_A)Q\ri\u00111I\u0001\fG2\f7o]#ySN$8\u000fK\u0002\u000f\u0003\u0007\n!\"\\3uQ>$g*Y7fQ\ry\u00111I\u0001\u0007[\u0016$\bn\u001c3\u0016\u0005\u0005%\u0004\u0003BA6\u0003cj!!!\u001c\u000b\t\u0005=\u0014\u0011K\u0001\be\u00164G.Z2u\u0013\u0011\t\u0019(!\u001c\u0003\r5+G\u000f[8eQ\r\u0001\u00121I\u0001\u0007EV4g-\u001a:\u0016\u0005\u0005m\u0004#B(\u0002>\u0005u\u0004\u0003BA(\u0003\u007fJA!!!\u0002R\t1qJ\u00196fGRD3!EA\"\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002o\u0003\u0013Cq!a#\u0013\u0001\u0004\ti)A\u0006oK^\u001c\u0005.\u001b7ee\u0016t\u0007\u0003B+\u0002\u0010bJ1!!%`\u0005)Ie\u000eZ3yK\u0012\u001cV-]\u0001\u0005G>\u0004\u0018\u0010F\u0003o\u0003/\u000bI\nC\u0004a'A\u0005\t\u0019\u00012\t\u000f\u0019\u001c\u0002\u0013!a\u0001Q\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAPU\r\u0011\u0017\u0011U\u0016\u0003\u0003G\u0003B!!*\u000206\u0011\u0011q\u0015\u0006\u0005\u0003S\u000bY+A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0016)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00022\u0006\u001d&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\\U\rA\u0017\u0011U\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003K\t\u0019\rC\u0005\u0002Fb\t\t\u00111\u0001\u0002\u001c\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a3\u0011\r\u00055\u00171[A\u0013\u001b\t\tyMC\u0002\u0002RB\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t).a4\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004Q\u0006m\u0007\"CAc5\u0005\u0005\t\u0019AA\u0013\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u00055\u0013\u0011\u001d\u0005\n\u0003\u000b\\\u0012\u0011!a\u0001\u00037\ta!Z9vC2\u001cHc\u00015\u0002h\"I\u0011Q\u0019\u000f\u0002\u0002\u0003\u0007\u0011Q\u0005\u0015\u0014\u0001\u0005-\u0018\u0011_Az\u0003o\fI0!@\u0002\u0000\n\r!Q\u0001\t\u0004s\u00055\u0018bAAxU\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA{\u0003){f)\u0016(D?\"\u001aG.Y:tY\u0001jW\r\u001e5pInc\u0003%\u0019:hcmc\u0003%\u0019:he\u0001rc&X/*A5\u00023)\u00197mg\u0002\n\u0007%\\3uQ>$\u0007e^5uQ\u0002\u0012XM\u001a7fGRLwN\u001c\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a?\u0002\u0003\u007fT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n6bm\u0006tS\u000f^5m]U+\u0016\nR\u0014-A\u001d\u0012\u0018M\u001c3p[V+\u0016\nR\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a7g\r4cga:T\u0006O\u001b1a5\"$MZ1.qE\"''\f\u001cfa\u0015\u001cT-O\u001a1I\u001a\u0014$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014kCZ\fg&\u001e;jY:*V+\u0013#(Y\u0001:cM]8n'R\u0014\u0018N\\4(Y\u0001:\u0013-N2gm\r$$'\f\u0019dqUjC'\r\u001dg[\u00054ggY\u00174KR*WGY\u00194ea2'gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005,4M\u001a\u001cdiIj\u0003g\u0019\u001d6[Q\n\u0004HZ\u0017bMZ\u001aWfM35KV\u0012\u0017g\r\u001a9MJR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0005\u0003\tQA\r\u00181]A\nQa\u001a:pkB\f#Aa\u0002\u0002\u00155L7oY0gk:\u001c7/A\fDC2dW*\u001a;i_\u00124\u0016.\u0019*fM2,7\r^5p]B\u0011\u0011HH\n\u0006=\t=!Q\u0003\t\u0004\u001f\nE\u0011b\u0001B\n!\n1\u0011I\\=SK\u001a\u0004BAa\u0006\u0003\u001e5\u0011!\u0011\u0004\u0006\u0005\u00057\t)&\u0001\u0002j_&\u0019aL!\u0007\u0015\u0005\t-\u0011a\u0003;za\u0016l\u0015\r\u001d9j]\u001e,\"A!\n\u0011\u0011\t\u001d\"Q\u0006B\u0019\u0005{i!A!\u000b\u000b\t\t-\u0012qZ\u0001\nS6lW\u000f^1cY\u0016LAAa\f\u0003*\t\u0019Q*\u00199\u0011\t\tM\"\u0011H\u0007\u0003\u0005kQ1Aa\u000e/\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u0011YD!\u000e\u0003\u0011\u0011\u000bG/\u0019+za\u0016\u0004bAa\n\u0003@\t\u0005\u0013b\u00013\u0003*A\"!1\tB'!\u0019\tyE!\u0012\u0003J%!!qIA)\u0005\u0015\u0019E.Y:t!\u0011\u0011YE!\u0014\r\u0001\u0011Y!qJ\u0011\u0002\u0002\u0003\u0005)\u0011\u0001B*\u0005\ryF%M\u0001\rif\u0004X-T1qa&tw\rI\t\u0005\u0005+\n)\u0003E\u0002P\u0005/J1A!\u0017Q\u0005\u001dqu\u000e\u001e5j]\u001e$2\u0001\u001bB/\u0011\u0019\tIE\ta\u0001k\u0006Qa-\u001b8e\u001b\u0016$\bn\u001c3\u0015\u0011\t\r$\u0011\u000eB6\u0005[\u0002Ra\u0014B3\u0003SJ1Aa\u001aQ\u0005\u0019y\u0005\u000f^5p]\"1\u0011\u0011J\u0012A\u0002UDa!!\u0019$\u0001\u0004)\bb\u0002B8G\u0001\u0007!\u0011O\u0001\tCJ<G+\u001f9fgB!Qk\u0019B\u0019\u0003\u0015\t\u0007\u000f\u001d7z)\u0015q'q\u000fB=\u0011\u0015\u0001G\u00051\u0001c\u0011\u001d1G\u0005%AA\u0002!\fq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tI!#\u0011\u000b=\u0013)Ga!\u0011\u000b=\u0013)I\u00195\n\u0007\t\u001d\u0005K\u0001\u0004UkBdWM\r\u0005\t\u0005\u00173\u0013\u0011!a\u0001]\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ti\b")
public class CallMethodViaReflection
extends Expression
implements Nondeterministic,
DefaultStringProducingExpression,
CodegenFallback,
QueryErrorsBase,
Serializable {
    private transient Expression[] argExprs;
    private transient String className;
    private transient boolean classExists;
    private transient String methodName;
    private transient Method method;
    private transient Object[] buffer;
    private final Seq<Expression> children;
    private final boolean failOnError;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$2() {
        return CallMethodViaReflection$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(CallMethodViaReflection x$0) {
        return CallMethodViaReflection$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return CallMethodViaReflection$.MODULE$.apply$default$2();
    }

    public static Option<Method> findMethod(String className, String methodName, Seq<DataType> argTypes) {
        return CallMethodViaReflection$.MODULE$.findMethod(className, methodName, argTypes);
    }

    public static Map<DataType, Seq<Class<?>>> typeMapping() {
        return CallMethodViaReflection$.MODULE$.typeMapping();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    private boolean deterministic$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if (!this.bitmap$0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = true;
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if (!this.bitmap$0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "reflect");
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().size() < 2) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(this.toSQLId(this.prettyName()), (Seq<Object>)new .colon.colon((Object)"> 1", (List)Nil$.MODULE$), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        Option unexpectedParameter = ((IterableOnceOps)this.children().zipWithIndex()).collectFirst((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CallMethodViaReflection $outer;

            public final <A1 extends Tuple2<Expression, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (!(0 != n || e.dataType() instanceof StringType && e.foldable())) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)this.$outer.toSQLId("class")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)StringTypeWithCollation$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.$outer.toSQLExpr((Expression)this.$outer.children().head()))}))));
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (0 == n && e.eval(e.eval$default$1()) == null) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)this.$outer.toSQLId("class"))}))));
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (!(1 != n || e.dataType() instanceof StringType && e.foldable())) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)this.$outer.toSQLId("method")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)StringTypeWithCollation$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.$outer.toSQLExpr((Expression)this.$outer.children().apply(1)))}))));
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (1 == n && e.eval(e.eval$default$1()) == null) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)this.$outer.toSQLId("method"))}))));
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int idx = A1._2$mcI$sp();
                    if (idx > 1 && !CallMethodViaReflection$.MODULE$.typeMapping().contains((Object)e.dataType()) && !(e.dataType() instanceof StringType)) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.$outer.ordinalNumber(idx)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.$outer.toSQLType((AbstractDataType)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{BooleanType$.MODULE$, ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3())})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.$outer.toSQLExpr(e)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)e.dataType()))}))));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Expression, Object> x1) {
                Tuple2<Expression, Object> tuple2 = x1;
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (!(0 != n || e.dataType() instanceof StringType && e.foldable())) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (0 == n && e.eval(e.eval$default$1()) == null) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (!(1 != n || e.dataType() instanceof StringType && e.foldable())) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (1 == n && e.eval(e.eval$default$1()) == null) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (idx > 1 && !CallMethodViaReflection$.MODULE$.typeMapping().contains((Object)e.dataType()) && !(e.dataType() instanceof StringType)) {
                        return true;
                    }
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Option option = unexpectedParameter;
        if (option instanceof Some) {
            Some some = (Some)option;
            TypeCheckResult.DataTypeMismatch mismatch = (TypeCheckResult.DataTypeMismatch)some.value();
            return mismatch;
        }
        if (!this.classExists()) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_CLASS_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)this.className())}))));
        }
        if (this.method() == null) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_STATIC_METHOD", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"methodName"), (Object)this.methodName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)this.className())}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
    }

    @Override
    public Object evalInternal(InternalRow input) {
        UTF8String uTF8String;
        for (int i = 0; i < this.argExprs().length; ++i) {
            this.buffer()[i] = this.argExprs()[i].eval(input);
            if (!(this.buffer()[i] instanceof UTF8String)) continue;
            this.buffer()[i] = this.buffer()[i].toString();
        }
        try {
            Object ret = this.method().invoke(null, this.buffer());
            uTF8String = UTF8String.fromString((String)String.valueOf(ret));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty() && !this.failOnError()) {
                uTF8String = null;
            }
            throw throwable;
        }
        return uTF8String;
    }

    private Expression[] argExprs$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.argExprs = (Expression[])((IterableOnceOps)this.children().drop(2)).toArray(ClassTag$.MODULE$.apply(Expression.class));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.argExprs;
    }

    private Expression[] argExprs() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.argExprs$lzycompute();
        }
        return this.argExprs;
    }

    private String className$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Expression qual$1 = (Expression)this.children().apply(0);
                InternalRow x$1 = qual$1.eval$default$1();
                this.className = ((UTF8String)qual$1.eval(x$1)).toString();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.className;
    }

    private String className() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.className$lzycompute();
        }
        return this.className;
    }

    private boolean classExists$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.classExists = CallMethodViaReflection$.MODULE$.org$apache$spark$sql$catalyst$expressions$CallMethodViaReflection$$classExists(this.className());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.classExists;
    }

    private boolean classExists() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.classExists$lzycompute();
        }
        return this.classExists;
    }

    private String methodName$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.methodName = ((UTF8String)((Expression)this.children().apply(1)).eval(null)).toString();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.methodName;
    }

    private String methodName() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.methodName$lzycompute();
        }
        return this.methodName;
    }

    private Method method$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.method = (Method)CallMethodViaReflection$.MODULE$.findMethod(this.className(), this.methodName(), (Seq<DataType>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.argExprs()), (Function1 & Serializable)x$1 -> x$1.dataType(), ClassTag$.MODULE$.apply(DataType.class))).toImmutableArraySeq()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.method;
    }

    public Method method() {
        if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
            return this.method$lzycompute();
        }
        return this.method;
    }

    private Object[] buffer$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                this.buffer = new Object[this.argExprs().length];
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
        }
        return this.buffer;
    }

    private Object[] buffer() {
        if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
            return this.buffer$lzycompute();
        }
        return this.buffer;
    }

    @Override
    public CallMethodViaReflection withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public CallMethodViaReflection copy(Seq<Expression> children2, boolean failOnError) {
        return new CallMethodViaReflection(children2, failOnError);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "CallMethodViaReflection";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CallMethodViaReflection;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "children";
            }
            case 1: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CallMethodViaReflection)) return false;
        boolean bl = true;
        if (!bl) return false;
        CallMethodViaReflection callMethodViaReflection = (CallMethodViaReflection)x$1;
        if (this.failOnError() != callMethodViaReflection.failOnError()) return false;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = callMethodViaReflection.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!callMethodViaReflection.canEqual(this)) return false;
        return true;
    }

    public CallMethodViaReflection(Seq<Expression> children2, boolean failOnError) {
        this.children = children2;
        this.failOnError = failOnError;
        Nondeterministic.$init$(this);
        DefaultStringProducingExpression.$init$(this);
        CodegenFallback.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }

    public CallMethodViaReflection(Seq<Expression> children2) {
        this(children2, true);
    }
}

