/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.expressions.aggregate;

import java.util.Arrays;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.SortValue;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.internal.connector.ExpressionWithToString;

@Evolving
public final class GeneralAggregateFunc
extends ExpressionWithToString
implements AggregateFunc {
    private final String name;
    private final boolean isDistinct;
    private final Expression[] children;
    private final SortValue[] orderingWithinGroups;

    public GeneralAggregateFunc(String name, boolean isDistinct, Expression[] children2) {
        this.name = name;
        this.isDistinct = isDistinct;
        this.children = children2;
        this.orderingWithinGroups = new SortValue[0];
    }

    public GeneralAggregateFunc(String name, boolean isDistinct, Expression[] children2, SortValue[] orderingWithinGroups) {
        this.name = name;
        this.isDistinct = isDistinct;
        this.children = children2;
        this.orderingWithinGroups = orderingWithinGroups;
    }

    public String name() {
        return this.name;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public Expression[] children() {
        return this.children;
    }

    public SortValue[] orderingWithinGroups() {
        return this.orderingWithinGroups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneralAggregateFunc that = (GeneralAggregateFunc)o;
        if (this.isDistinct != that.isDistinct) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!Arrays.equals(this.children, that.children)) {
            return false;
        }
        return Arrays.equals(this.orderingWithinGroups, that.orderingWithinGroups);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.isDistinct ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.children);
        result = 31 * result + Arrays.hashCode(this.orderingWithinGroups);
        return result;
    }
}

