/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channels;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFiles$;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.api.python.PythonWorker;
import org.apache.spark.api.python.PythonWorkerFactory$;
import org.apache.spark.api.python.PythonWorkerUtils$;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.Python$;
import org.apache.spark.security.SocketAuthHelper;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.WeakHashMap;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\tUd!\u0002!B\u0001\u0015[\u0005\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011\u0015\u0004!\u0011!Q\u0001\niC\u0001B\u001a\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\tO\u0002\u0011\t\u0011)A\u0005Q\"A1\u000e\u0001BC\u0002\u0013\u0005A\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003n\u0011\u0015\t\b\u0001\"\u0001s\u0011\u0015\t\b\u0001\"\u0001{\u0011\u001dy\bA1A\u0005\n1Dq!!\u0001\u0001A\u0003%Q\u000eC\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0003\u0002\u0006!A\u0011q\u0002\u0001!\u0002\u0013\t9\u0001C\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0003\u0002\u0014!A\u0011\u0011\u0005\u0001!\u0002\u0013\t)\u0002\u0003\u0005\u0002$\u0001\u0011\r\u0011\"\u0003m\u0011\u001d\t)\u0003\u0001Q\u0001\n5D\u0011\"a\n\u0001\u0001\u0004%I!!\u000b\t\u0013\u0005m\u0002\u00011A\u0005\n\u0005u\u0002\u0002CA%\u0001\u0001\u0006K!a\u000b\t\u0013\u0005\u001d\u0004A1A\u0005\u0002\u0005%\u0004\u0002CA<\u0001\u0001\u0006I!a\u001b\t\u0013\u0005e\u0004\u00011A\u0005\n\u0005m\u0004\"CAB\u0001\u0001\u0007I\u0011BAC\u0011!\tI\t\u0001Q!\n\u0005u\u0004\"CAG\u0001\t\u0007I\u0011BAH\u0011!\ti\u000b\u0001Q\u0001\n\u0005E\u0005bCAY\u0001\u0001\u0007\t\u0019!C\u0005\u0003gC1\"!.\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00028\"Q\u00111\u0018\u0001A\u0002\u0003\u0005\u000b\u0015\u0002.\t\u0015\u0005}\u0006A1A\u0005\u0002\u0015\u000b\t\r\u0003\u0005\u0002J\u0002\u0001\u000b\u0011BAb\u0011%\ti\r\u0001b\u0001\n\u0013\ty\r\u0003\u0005\u0002X\u0002\u0001\u000b\u0011BAi\u0011%\tY\u000e\u0001a\u0001\n\u0013\ti\u000eC\u0005\u0002f\u0002\u0001\r\u0011\"\u0003\u0002h\"A\u00111\u001e\u0001!B\u0013\ty\u000eC\u0005\u0002p\u0002\u0011\r\u0011\"\u0003\u0002r\"A\u0011Q\u001f\u0001!\u0002\u0013\t\u0019\u0010C\u0005\u0002z\u0002\u0011\r\u0011\"\u0003\u00024\"9\u00111 \u0001!\u0002\u0013Q\u0006bBA\u007f\u0001\u0011\u0005\u0011q \u0005\b\u0005\u0013\u0001A\u0011BA\u0000\u0011!\u0011Y\u0001\u0001C\u0001\u000b\n5\u0001b\u0002B\n\u0001\u0011%!Q\u0003\u0005\b\u0005/\u0001A\u0011\u0002B\r\r\u0019\u0011y\u0003\u0001\u0003\u00032!1\u0011O\fC\u0001\u0005sAqAa\u0010/\t\u0003\u0012)\u0002C\u0004\u0003B\u0001!IA!\u0006\t\u000f\t\r\u0003\u0001\"\u0003\u0003\u0016!9!Q\t\u0001\u0005\u0002\tU\u0001b\u0002B$\u0001\u0011\u0005!\u0011\n\u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u0011\u001d\u0011)\u0006\u0001C\u0001\u0005/:\u0001Ba\u0017B\u0011\u0003)%Q\f\u0004\b\u0001\u0006C\t!\u0012B0\u0011\u0019\t\b\b\"\u0001\u0003b!I!1\r\u001dC\u0002\u0013\u0005\u00111\u0010\u0005\t\u0005KB\u0004\u0015!\u0003\u0002~!I!q\r\u001dC\u0002\u0013\u0005\u0011Q\u001c\u0005\t\u0005SB\u0004\u0015!\u0003\u0002`\"Q!1\u000e\u001dC\u0002\u0013\u0005QI!\u001c\t\u0011\tM\u0004\b)A\u0005\u0005_\u00121\u0003U=uQ>twk\u001c:lKJ4\u0015m\u0019;pefT!AQ\"\u0002\rALH\u000f[8o\u0015\t!U)A\u0002ba&T!AR$\u0002\u000bM\u0004\u0018M]6\u000b\u0005!K\u0015AB1qC\u000eDWMC\u0001K\u0003\ry'oZ\n\u0004\u00011\u0013\u0006CA'Q\u001b\u0005q%\"A(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Es%AB!osJ+g\r\u0005\u0002T-6\tAK\u0003\u0002V\u000b\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002X)\n9Aj\\4hS:<\u0017A\u00039zi\"|g.\u0012=fG\u000e\u0001\u0001CA.c\u001d\ta\u0006\r\u0005\u0002^\u001d6\taL\u0003\u0002`3\u00061AH]8pizJ!!\u0019(\u0002\rA\u0013X\rZ3g\u0013\t\u0019GM\u0001\u0004TiJLgn\u001a\u0006\u0003C:\u000bAb^8sW\u0016\u0014Xj\u001c3vY\u0016\fA\u0002Z1f[>tWj\u001c3vY\u0016\fq!\u001a8w-\u0006\u00148\u000f\u0005\u0003\\SjS\u0016B\u00016e\u0005\ri\u0015\r]\u0001\u0011kN,G)Y3n_:,e.\u00192mK\u0012,\u0012!\u001c\t\u0003\u001b:L!a\u001c(\u0003\u000f\t{w\u000e\\3b]\u0006\tRo]3EC\u0016lwN\\#oC\ndW\r\u001a\u0011\u0002\rqJg.\u001b;?)\u0019\u0019XO^<ysB\u0011A\u000fA\u0007\u0002\u0003\")\u0001l\u0002a\u00015\")Qm\u0002a\u00015\")am\u0002a\u00015\")qm\u0002a\u0001Q\")1n\u0002a\u0001[R)1o\u001f?~}\")\u0001\f\u0003a\u00015\")Q\r\u0003a\u00015\")q\r\u0003a\u0001Q\")1\u000e\u0003a\u0001[\u0006IQo]3EC\u0016lwN\\\u0001\u000bkN,G)Y3n_:\u0004\u0013\u0001B2p]\u001a,\"!a\u0002\u0011\t\u0005%\u00111B\u0007\u0002\u000b&\u0019\u0011QB#\u0003\u0013M\u0003\u0018M]6D_:4\u0017!B2p]\u001a\u0004\u0013AC1vi\"DU\r\u001c9feV\u0011\u0011Q\u0003\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111D#\u0002\u0011M,7-\u001e:jifLA!a\b\u0002\u001a\t\u00012k\\2lKR\fU\u000f\u001e5IK2\u0004XM]\u0001\fCV$\b\u000eS3ma\u0016\u0014\b%\u0001\tjgVs\u0017\u000e\u001f#p[\u0006LgnU8dW\u0006\t\u0012n]+oSb$u.\\1j]N{7m\u001b\u0011\u0002\r\u0011\fW-\\8o+\t\tY\u0003\u0005\u0003\u0002.\u0005]RBAA\u0018\u0015\u0011\t\t$a\r\u0002\t1\fgn\u001a\u0006\u0003\u0003k\tAA[1wC&!\u0011\u0011HA\u0018\u0005\u001d\u0001&o\\2fgN\f!\u0002Z1f[>tw\fJ3r)\u0011\ty$!\u0012\u0011\u00075\u000b\t%C\u0002\u0002D9\u0013A!\u00168ji\"I\u0011q\t\n\u0002\u0002\u0003\u0007\u00111F\u0001\u0004q\u0012\n\u0014a\u00023bK6|g\u000e\t\u0015\b'\u00055\u0013\u0011MA2!\u0011\ty%!\u0018\u000e\u0005\u0005E#\u0002BA*\u0003+\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\t9&!\u0017\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002\u0002\\\u0005)!.\u0019<bq&!\u0011qLA)\u0005%9U/\u0019:eK\u0012\u0014\u00150A\u0003wC2,X-\t\u0002\u0002f\u0005!1/\u001a7g\u0003)!\u0017-Z7p]\"{7\u000f^\u000b\u0003\u0003W\u0002B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019$A\u0002oKRLA!!\u001e\u0002p\tY\u0011J\\3u\u0003\u0012$'/Z:t\u0003-!\u0017-Z7p]\"{7\u000f\u001e\u0011\u0002\u0015\u0011\fW-\\8o!>\u0014H/\u0006\u0002\u0002~A\u0019Q*a \n\u0007\u0005\u0005eJA\u0002J]R\fa\u0002Z1f[>t\u0007k\u001c:u?\u0012*\u0017\u000f\u0006\u0003\u0002@\u0005\u001d\u0005\"CA$/\u0005\u0005\t\u0019AA?\u0003-!\u0017-Z7p]B{'\u000f\u001e\u0011)\u000fa\ti%!\u0019\u0002d\u0005iA-Y3n_:<vN]6feN,\"!!%\u0011\u0011\u0005M\u0015QTAQ\u0003Ok!!!&\u000b\t\u0005]\u0015\u0011T\u0001\b[V$\u0018M\u00197f\u0015\r\tYJT\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAP\u0003+\u00131bV3bW\"\u000b7\u000f['baB\u0019A/a)\n\u0007\u0005\u0015\u0016I\u0001\u0007QsRDwN\\,pe.,'\u000f\u0005\u0003\u0002.\u0005%\u0016\u0002BAV\u0003_\u0011Q\u0002\u0015:pG\u0016\u001c8\u000fS1oI2,\u0017A\u00043bK6|gnV8sW\u0016\u00148\u000f\t\u0015\b5\u00055\u0013\u0011MA2\u00039!\u0017-Z7p]N{7m\u001b)bi\",\u0012AW\u0001\u0013I\u0006,Wn\u001c8T_\u000e\\\u0007+\u0019;i?\u0012*\u0017\u000f\u0006\u0003\u0002@\u0005e\u0006\u0002CA$9\u0005\u0005\t\u0019\u0001.\u0002\u001f\u0011\fW-\\8o'>\u001c7\u000eU1uQ\u0002Bs!HA'\u0003C\n\u0019'A\u0006jI2,wk\u001c:lKJ\u001cXCAAb!\u0019\t\u0019*!2\u0002\"&!\u0011qYAK\u0005\u0015\tV/Z;f\u00031IG\r\\3X_J\\WM]:!Q\u001dy\u0012QJA1\u0003G\nQ#\\1y\u0013\u0012dWmV8sW\u0016\u0014\bk\\8m'&TX-\u0006\u0002\u0002RB)Q*a5\u0002~%\u0019\u0011Q\u001b(\u0003\r=\u0003H/[8o\u0003Yi\u0017\r_%eY\u0016<vN]6feB{w\u000e\\*ju\u0016\u0004\u0003fB\u0011\u0002N\u0005\u0005\u00141M\u0001\u000fY\u0006\u001cH/Q2uSZLG/\u001f(t+\t\ty\u000eE\u0002N\u0003CL1!a9O\u0005\u0011auN\\4\u0002%1\f7\u000f^!di&4\u0018\u000e^=Og~#S-\u001d\u000b\u0005\u0003\u007f\tI\u000fC\u0005\u0002H\r\n\t\u00111\u0001\u0002`\u0006yA.Y:u\u0003\u000e$\u0018N^5us:\u001b\b\u0005K\u0004%\u0003\u001b\n\t'a\u0019\u0002\u001bMLW\u000e\u001d7f/>\u00148.\u001a:t+\t\t\u0019\u0010\u0005\u0005\u0002\u0014\u0006u\u0015\u0011UA\u0016\u00039\u0019\u0018.\u001c9mK^{'o[3sg\u0002BsAJA'\u0003C\n\u0019'\u0001\u0006qsRDwN\u001c)bi\"\f1\u0002]=uQ>t\u0007+\u0019;iA\u000511M]3bi\u0016$\"A!\u0001\u0011\u000f5\u0013\u0019!!)\u0003\b%\u0019!Q\u0001(\u0003\rQ+\b\u000f\\33!\u0015i\u00151[AT\u0003M\u0019'/Z1uKRC'o\\;hQ\u0012\u000bW-\\8o\u0003I\u0019'/Z1uKNKW\u000e\u001d7f/>\u00148.\u001a:\u0015\t\t\u0005!q\u0002\u0005\u0007\u0005#Y\u0003\u0019A7\u0002\u0019\tdwnY6j]\u001elu\u000eZ3\u0002\u0017M$\u0018M\u001d;EC\u0016lwN\u001c\u000b\u0003\u0003\u007f\tqC]3eSJ,7\r^*ue\u0016\fWn\u001d+p'R$WM\u001d:\u0015\r\u0005}\"1\u0004B\u0016\u0011\u001d\u0011i\"\fa\u0001\u0005?\taa\u001d;e_V$\b\u0003\u0002B\u0011\u0005Oi!Aa\t\u000b\t\t\u0015\u00121G\u0001\u0003S>LAA!\u000b\u0003$\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\u0011i#\fa\u0001\u0005?\taa\u001d;eKJ\u0014(!D'p]&$xN\u001d+ie\u0016\fGmE\u0002/\u0005g\u0001B!!\f\u00036%!!qGA\u0018\u0005\u0019!\u0006N]3bIR\u0011!1\b\t\u0004\u0005{qS\"\u0001\u0001\u0002\u0007I,h.\u0001\ndY\u0016\fg.\u001e9JI2,wk\u001c:lKJ\u001c\u0018AC:u_B$\u0015-Z7p]\u0006!1\u000f^8q\u0003)\u0019Ho\u001c9X_J\\WM\u001d\u000b\u0005\u0003\u007f\u0011Y\u0005C\u0004\u0003NQ\u0002\r!!)\u0002\r]|'o[3s\u00035\u0011X\r\\3bg\u0016<vN]6feR!\u0011q\bB*\u0011\u001d\u0011i%\u000ea\u0001\u0003C\u000bq\"[:X_J\\WM]*u_B\u0004X\r\u001a\u000b\u0004[\ne\u0003b\u0002B'm\u0001\u0007\u0011\u0011U\u0001\u0014!f$\bn\u001c8X_J\\WM\u001d$bGR|'/\u001f\t\u0003ib\u001a\"\u0001\u000f'\u0015\u0005\tu\u0013a\u0006)S\u001f\u000e+5kU0X\u0003&#v\fV%N\u000b>+FkX'T\u0003a\u0001&kT\"F'N{v+Q%U?RKU*R(V)~k5\u000bI\u0001\u0017\u0013\u0012cUiX,P%.+%k\u0018+J\u001b\u0016{U\u000bV0O'\u00069\u0012\n\u0012'F?^{%kS#S?RKU*R(V)~s5\u000bI\u0001\u0014I\u00164\u0017-\u001e7u\t\u0006,Wn\u001c8N_\u0012,H.Z\u000b\u0003\u0005_\u0002B!!\f\u0003r%\u00191-a\f\u0002)\u0011,g-Y;mi\u0012\u000bW-\\8o\u001b>$W\u000f\\3!\u0001")
public class PythonWorkerFactory
implements Logging {
    public final String org$apache$spark$api$python$PythonWorkerFactory$$pythonExec;
    private final String workerModule;
    private final String daemonModule;
    private final scala.collection.immutable.Map<String, String> envVars;
    private final boolean useDaemonEnabled;
    private final boolean useDaemon;
    private final SparkConf conf;
    private final SocketAuthHelper authHelper;
    private final boolean isUnixDomainSock;
    @GuardedBy(value="self")
    private Process daemon;
    private final InetAddress daemonHost;
    @GuardedBy(value="self")
    private int daemonPort;
    @GuardedBy(value="self")
    private final WeakHashMap<PythonWorker, ProcessHandle> daemonWorkers;
    @GuardedBy(value="self")
    private String daemonSockPath;
    @GuardedBy(value="self")
    private final Queue<PythonWorker> idleWorkers;
    @GuardedBy(value="self")
    private final Option<Object> maxIdleWorkerPoolSize;
    @GuardedBy(value="self")
    private long org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs;
    @GuardedBy(value="self")
    private final WeakHashMap<PythonWorker, Process> simpleWorkers;
    private final String pythonPath;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static long IDLE_WORKER_TIMEOUT_NS() {
        return PythonWorkerFactory$.MODULE$.IDLE_WORKER_TIMEOUT_NS();
    }

    public static int PROCESS_WAIT_TIMEOUT_MS() {
        return PythonWorkerFactory$.MODULE$.PROCESS_WAIT_TIMEOUT_MS();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean useDaemonEnabled() {
        return this.useDaemonEnabled;
    }

    private boolean useDaemon() {
        return this.useDaemon;
    }

    private SparkConf conf() {
        return this.conf;
    }

    private SocketAuthHelper authHelper() {
        return this.authHelper;
    }

    private boolean isUnixDomainSock() {
        return this.isUnixDomainSock;
    }

    private Process daemon() {
        return this.daemon;
    }

    private void daemon_$eq(Process x$1) {
        this.daemon = x$1;
    }

    public InetAddress daemonHost() {
        return this.daemonHost;
    }

    private int daemonPort() {
        return this.daemonPort;
    }

    private void daemonPort_$eq(int x$1) {
        this.daemonPort = x$1;
    }

    private WeakHashMap<PythonWorker, ProcessHandle> daemonWorkers() {
        return this.daemonWorkers;
    }

    private String daemonSockPath() {
        return this.daemonSockPath;
    }

    private void daemonSockPath_$eq(String x$1) {
        this.daemonSockPath = x$1;
    }

    public Queue<PythonWorker> idleWorkers() {
        return this.idleWorkers;
    }

    private Option<Object> maxIdleWorkerPoolSize() {
        return this.maxIdleWorkerPoolSize;
    }

    public long org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs() {
        return this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs;
    }

    public void org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs_$eq(long x$1) {
        this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs = x$1;
    }

    private WeakHashMap<PythonWorker, Process> simpleWorkers() {
        return this.simpleWorkers;
    }

    private String pythonPath() {
        return this.pythonPath;
    }

    public Tuple2<PythonWorker, Option<ProcessHandle>> create() {
        Tuple2<PythonWorker, Option<ProcessHandle>> tuple2;
        block8: {
            Object object = new Object();
            try {
                if (this.useDaemon()) {
                    PythonWorkerFactory pythonWorkerFactory = this;
                    synchronized (pythonWorkerFactory) {
                        while (this.idleWorkers().nonEmpty()) {
                            PythonWorker worker = (PythonWorker)this.idleWorkers().dequeue();
                            this.daemonWorkers().get((Object)worker).foreach((Function1 & Serializable)workerHandle -> {
                                PythonWorkerFactory.$anonfun$create$1(object, worker, workerHandle);
                                return BoxedUnit.UNIT;
                            });
                            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Worker ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.WORKER, worker)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"process from idle queue is dead, discarding."}))).log((Seq)Nil$.MODULE$))));
                            this.stopWorker(worker);
                        }
                    }
                    tuple2 = this.createThroughDaemon();
                    break block8;
                }
                tuple2 = this.createSimpleWorker(false);
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    tuple2 = (Tuple2<PythonWorker, Option<ProcessHandle>>)ex.value();
                }
                throw ex;
            }
        }
        return tuple2;
    }

    private Tuple2<PythonWorker, Option<ProcessHandle>> createThroughDaemon() {
        Tuple2 tuple2;
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            this.startDaemon();
            tuple2 = this.liftedTree1$1();
        }
        return tuple2;
    }

    public Tuple2<PythonWorker, Option<ProcessHandle>> createSimpleWorker(boolean blockingMode) {
        Tuple2 tuple2;
        LazyRef sockPath$lzy = new LazyRef();
        ServerSocketChannel serverSocketChannel = null;
        try {
            String jobArtifactUUID;
            if (this.isUnixDomainSock()) {
                serverSocketChannel = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
                this.sockPath$1(sockPath$lzy).deleteOnExit();
                v0 = serverSocketChannel.bind(UnixDomainSocketAddress.of(this.sockPath$1(sockPath$lzy).getPath()));
            } else {
                serverSocketChannel = ServerSocketChannel.open();
                v0 = serverSocketChannel.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0), 1);
            }
            ProcessBuilder pb = new ProcessBuilder(Arrays.asList((Object[])new String[]{this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, "-m", this.workerModule}));
            String string = jobArtifactUUID = (String)this.envVars.getOrElse((Object)"SPARK_JOB_ARTIFACT_UUID", (Function0 & Serializable)() -> "default");
            String string2 = "default";
            if (string == null ? string2 != null : !string.equals(string2)) {
                File f = new File(SparkFiles$.MODULE$.getRootDirectory(), jobArtifactUUID);
                f.mkdir();
                v2 = pb.directory(f);
            } else {
                v2 = BoxedUnit.UNIT;
            }
            Map<String, String> workerEnv = pb.environment();
            workerEnv.putAll(CollectionConverters$.MODULE$.MapHasAsJava(this.envVars).asJava());
            workerEnv.put("PYTHONPATH", this.pythonPath());
            workerEnv.put("PYTHONUNBUFFERED", "YES");
            if (this.isUnixDomainSock()) {
                workerEnv.put("PYTHON_WORKER_FACTORY_SOCK_PATH", this.sockPath$1(sockPath$lzy).getPath());
                v3 = workerEnv.put("PYTHON_UNIX_DOMAIN_ENABLED", "True");
            } else {
                workerEnv.put("PYTHON_WORKER_FACTORY_PORT", Integer.toString(serverSocketChannel.socket().getLocalPort()));
                v3 = workerEnv.put("PYTHON_WORKER_FACTORY_SECRET", this.authHelper().secret());
            }
            Object object = Utils$.MODULE$.preferIPv6() ? workerEnv.put("SPARK_PREFER_IPV6", "True") : BoxedUnit.UNIT;
            Process workerProcess = pb.start();
            this.redirectStreamsToStderr(workerProcess.getInputStream(), workerProcess.getErrorStream());
            try {
                serverSocketChannel.configureBlocking(false);
                Selector serverSelector = Selector.open();
                serverSocketChannel.register(serverSelector, 16);
                if (serverSelector.select(10000L) <= 0) {
                    throw new SocketTimeoutException("Timed out while waiting for the Python worker to connect back");
                }
                SocketChannel socketChannel = serverSocketChannel.accept();
                this.authHelper().authClient(socketChannel);
                int pid = new DataInputStream(Channels.newInputStream(socketChannel)).readInt();
                if (pid < 0) {
                    throw new IllegalStateException("Python failed to launch worker with code " + pid);
                }
                Object object2 = !blockingMode ? socketChannel.configureBlocking(false) : BoxedUnit.UNIT;
                PythonWorker worker = new PythonWorker(socketChannel);
                PythonWorkerFactory pythonWorkerFactory = this;
                synchronized (pythonWorkerFactory) {
                    this.simpleWorkers().put((Object)worker, (Object)workerProcess);
                }
                tuple2 = new Tuple2((Object)worker.refresh(), (Object)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(ProcessHandle.of(pid))));
            }
            catch (Exception e) {
                throw new SparkException("Python worker failed to connect back.", (Throwable)e);
            }
        }
        finally {
            if (serverSocketChannel != null) {
                serverSocketChannel.close();
                if (this.isUnixDomainSock()) {
                    this.sockPath$1(sockPath$lzy).delete();
                }
            }
        }
        return tuple2;
    }

    private synchronized void startDaemon() {
        if (this.daemon() != null) {
            return;
        }
        try {
            String errorMsg;
            String jobArtifactUUID;
            List<Object> command = Arrays.asList((Object[])new String[]{this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, "-m", this.daemonModule, this.workerModule});
            ProcessBuilder pb = new ProcessBuilder(command);
            String string = jobArtifactUUID = (String)this.envVars.getOrElse((Object)"SPARK_JOB_ARTIFACT_UUID", (Function0 & Serializable)() -> "default");
            String string2 = "default";
            if (string == null ? string2 != null : !string.equals(string2)) {
                File f = new File(SparkFiles$.MODULE$.getRootDirectory(), jobArtifactUUID);
                f.mkdir();
                v1 = pb.directory(f);
            } else {
                v1 = BoxedUnit.UNIT;
            }
            Map<String, String> workerEnv = pb.environment();
            workerEnv.putAll(CollectionConverters$.MODULE$.MapHasAsJava(this.envVars).asJava());
            workerEnv.put("PYTHONPATH", this.pythonPath());
            if (this.isUnixDomainSock()) {
                workerEnv.put("PYTHON_WORKER_FACTORY_SOCK_DIR", this.authHelper().sockDir());
                v2 = workerEnv.put("PYTHON_UNIX_DOMAIN_ENABLED", "True");
            } else {
                v2 = workerEnv.put("PYTHON_WORKER_FACTORY_SECRET", this.authHelper().secret());
            }
            Object object = Utils$.MODULE$.preferIPv6() ? workerEnv.put("SPARK_PREFER_IPV6", "True") : BoxedUnit.UNIT;
            workerEnv.put("PYTHONUNBUFFERED", "YES");
            this.daemon_$eq(pb.start());
            DataInputStream in = new DataInputStream(this.daemon().getInputStream());
            try {
                if (this.isUnixDomainSock()) {
                    this.daemonSockPath_$eq(PythonWorkerUtils$.MODULE$.readUTF(in));
                } else {
                    this.daemonPort_$eq(in.readInt());
                }
            }
            catch (EOFException eOFException) {
                if (this.daemon().isAlive()) {
                    throw SparkCoreErrors$.MODULE$.eofExceptionWhileReadPortNumberError(this.daemonModule, SparkCoreErrors$.MODULE$.eofExceptionWhileReadPortNumberError$default$2());
                }
                throw SparkCoreErrors$.MODULE$.eofExceptionWhileReadPortNumberError(this.daemonModule, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.daemon().exitValue())));
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            boolean isMalformedPort = !this.isUnixDomainSock() && (this.daemonPort() < 1 || this.daemonPort() > 65535);
            boolean isMalformedSockPath = this.isUnixDomainSock() && !new File(this.daemonSockPath()).exists();
            String string3 = errorMsg = this.isUnixDomainSock() ? this.daemonSockPath() : StringOps$.MODULE$.format$extension("%s (0x%08x)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.daemonPort()), BoxesRunTime.boxToInteger((int)this.daemonPort())}));
            if (isMalformedPort || isMalformedSockPath) {
                String exceptionMessage = "\n            |Bad data in " + this.daemonModule + "'s standard output. Invalid port number/socket path:\n            |  " + errorMsg + "\n            |Python command to execute the daemon was:\n            |  " + CollectionConverters$.MODULE$.ListHasAsScala(command).asScala().mkString(" ") + "\n            |Check that you don't have any unexpected modules or libraries in\n            |your PYTHONPATH:\n            |  " + this.pythonPath() + "\n            |Also, check if you have a sitecustomize.py module in your python path,\n            |or in your python installation, that is printing to standard output";
                throw new SparkException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(exceptionMessage)));
            }
            this.redirectStreamsToStderr(in, this.daemon().getErrorStream());
        }
        catch (Exception e) {
            String stderr = (String)Option$.MODULE$.apply((Object)this.daemon()).flatMap((Function1 & Serializable)d -> Utils$.MODULE$.getStderr((Process)d, PythonWorkerFactory$.MODULE$.PROCESS_WAIT_TIMEOUT_MS())).getOrElse((Function0 & Serializable)() -> "");
            this.stopDaemon();
            String string = stderr;
            String string4 = "";
            if (string == null ? string4 != null : !string.equals(string4)) {
                String formattedStderr = stderr.replace("\n", "\n  ");
                String errorMessage = "\n              |Error from python worker:\n              |  " + formattedStderr + "\n              |PYTHONPATH was:\n              |  " + this.pythonPath() + "\n              |" + e;
                SparkException wrappedException = new SparkException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(errorMessage)));
                wrappedException.setStackTrace(e.getStackTrace());
                throw wrappedException;
            }
            throw e;
        }
    }

    private void redirectStreamsToStderr(InputStream stdout, InputStream stderr) {
        try {
            new RedirectThread(stdout, System.err, "stdout reader for " + this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
            new RedirectThread(stderr, System.err, "stderr reader for " + this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "Exception in redirecting streams", (Throwable)e);
        }
    }

    public void org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers() {
        while (this.idleWorkers().nonEmpty()) {
            PythonWorker worker = (PythonWorker)this.idleWorkers().dequeue();
            try {
                worker.stop();
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to stop worker socket", (Throwable)e);
            }
        }
    }

    private synchronized void stopDaemon() {
        if (this.useDaemon()) {
            this.org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers();
            if (this.daemon() != null) {
                this.daemon().destroy();
            }
            this.daemon_$eq(null);
            this.daemonPort_$eq(0);
            this.daemonSockPath_$eq(null);
            return;
        }
        this.simpleWorkers().values().foreach((Function1 & Serializable)x$5 -> {
            x$5.destroy();
            return BoxedUnit.UNIT;
        });
    }

    public void stop() {
        this.stopDaemon();
    }

    public void stopWorker(PythonWorker worker) {
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            if (this.useDaemon()) {
                if (this.daemon() != null) {
                    this.daemonWorkers().get((Object)worker).foreach((Function1 & Serializable)processHandle -> {
                        PythonWorkerFactory.$anonfun$stopWorker$1(this, processHandle);
                        return BoxedUnit.UNIT;
                    });
                }
            } else {
                this.simpleWorkers().get((Object)worker).foreach((Function1 & Serializable)x$6 -> {
                    x$6.destroy();
                    return BoxedUnit.UNIT;
                });
            }
        }
        worker.stop();
    }

    public void releaseWorker(PythonWorker worker) {
        if (this.useDaemon()) {
            PythonWorkerFactory pythonWorkerFactory = this;
            synchronized (pythonWorkerFactory) {
                this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs_$eq(System.nanoTime());
                if (this.maxIdleWorkerPoolSize().exists((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> this.idleWorkers().size() >= x$7)) {
                    PythonWorker oldestWorker = (PythonWorker)this.idleWorkers().dequeue();
                    this.liftedTree2$1(oldestWorker);
                }
                this.idleWorkers().enqueue((Object)worker);
            }
            return;
        }
        try {
            worker.stop();
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to close worker", (Throwable)e);
        }
    }

    public boolean isWorkerStopped(PythonWorker worker) {
        Predef$.MODULE$.assert(!this.useDaemon(), (Function0 & Serializable)() -> "isWorkerStopped() is not supported for daemon mode");
        return this.simpleWorkers().get((Object)worker).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)PythonWorkerFactory.$anonfun$isWorkerStopped$2(x$8)));
    }

    public static final /* synthetic */ void $anonfun$create$1(Object nonLocalReturnKey1$1, PythonWorker worker$1, ProcessHandle workerHandle) {
        if (workerHandle.isAlive()) {
            try {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Tuple2((Object)worker$1.refresh(), (Object)new Some((Object)workerHandle)));
            }
            catch (CancelledKeyException cancelledKeyException) {
                return;
            }
        }
    }

    private final Tuple2 createWorker$1() {
        SocketChannel socketChannel = this.isUnixDomainSock() ? SocketChannel.open(UnixDomainSocketAddress.of(this.daemonSockPath())) : SocketChannel.open(new InetSocketAddress(this.daemonHost(), this.daemonPort()));
        int pid = new DataInputStream(Channels.newInputStream(socketChannel)).readInt();
        if (pid < 0) {
            throw new IllegalStateException("Python daemon failed to launch worker with code " + pid);
        }
        ProcessHandle processHandle = ProcessHandle.of(pid).orElseThrow(() -> new IllegalStateException("Python daemon failed to launch worker."));
        this.authHelper().authToServer(socketChannel);
        socketChannel.configureBlocking(false);
        PythonWorker worker = new PythonWorker(socketChannel);
        this.daemonWorkers().put((Object)worker, (Object)processHandle);
        return new Tuple2((Object)worker.refresh(), (Object)new Some((Object)processHandle));
    }

    private final /* synthetic */ Tuple2 liftedTree1$1() {
        Tuple2 tuple2;
        try {
            tuple2 = this.createWorker$1();
        }
        catch (SocketException exc) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to open socket to Python daemon:", (Throwable)exc);
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Assuming that daemon unexpectedly quit, attempting to restart");
            this.stopDaemon();
            this.startDaemon();
            tuple2 = this.createWorker$1();
        }
        return tuple2;
    }

    private final /* synthetic */ File sockPath$lzycompute$1(LazyRef sockPath$lzy$1) {
        File file;
        LazyRef lazyRef = sockPath$lzy$1;
        synchronized (lazyRef) {
            file = sockPath$lzy$1.initialized() ? (File)sockPath$lzy$1.value() : (File)sockPath$lzy$1.initialize((Object)new File(this.authHelper().sockDir(), "." + UUID.randomUUID() + ".sock"));
        }
        return file;
    }

    private final File sockPath$1(LazyRef sockPath$lzy$1) {
        if (sockPath$lzy$1.initialized()) {
            return (File)sockPath$lzy$1.value();
        }
        return this.sockPath$lzycompute$1(sockPath$lzy$1);
    }

    public static final /* synthetic */ void $anonfun$stopWorker$1(PythonWorkerFactory $this, ProcessHandle processHandle) {
        DataOutputStream output = new DataOutputStream($this.daemon().getOutputStream());
        output.writeInt((int)processHandle.pid());
        output.flush();
        $this.daemon().getOutputStream().flush();
    }

    private final /* synthetic */ void liftedTree2$1(PythonWorker oldestWorker$1) {
        try {
            this.stopWorker(oldestWorker$1);
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to stop evicted worker", (Throwable)e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$isWorkerStopped$2(Process x$8) {
        return !x$8.isAlive();
    }

    public PythonWorkerFactory(String pythonExec, String workerModule, String daemonModule, scala.collection.immutable.Map<String, String> envVars, boolean useDaemonEnabled) {
        this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec = pythonExec;
        this.workerModule = workerModule;
        this.daemonModule = daemonModule;
        this.envVars = envVars;
        this.useDaemonEnabled = useDaemonEnabled;
        Logging.$init$((Logging)this);
        this.useDaemon = !Utils$.MODULE$.isWindows() && useDaemonEnabled;
        this.conf = SparkEnv$.MODULE$.get().conf();
        this.authHelper = new SocketAuthHelper(this.conf());
        this.isUnixDomainSock = this.authHelper().isUnixDomainSock();
        this.daemon = null;
        this.daemonHost = InetAddress.getLoopbackAddress();
        this.daemonPort = 0;
        this.daemonWorkers = new WeakHashMap();
        this.idleWorkers = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        this.maxIdleWorkerPoolSize = (Option)this.conf().get(Python$.MODULE$.PYTHON_FACTORY_IDLE_WORKER_MAX_POOL_SIZE());
        this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs = 0L;
        new MonitorThread().start();
        this.simpleWorkers = new WeakHashMap();
        this.pythonPath = PythonUtils$.MODULE$.mergePythonPaths((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PythonUtils$.MODULE$.sparkPythonPath(), (String)envVars.getOrElse((Object)"PYTHONPATH", (Function0 & Serializable)() -> ""), (String)package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable)() -> "")}));
    }

    public PythonWorkerFactory(String pythonExec, String workerModule, scala.collection.immutable.Map<String, String> envVars, boolean useDaemonEnabled) {
        this(pythonExec, workerModule, PythonWorkerFactory$.MODULE$.defaultDaemonModule(), envVars, useDaemonEnabled);
    }

    private class MonitorThread
    extends Thread {
        @Override
        public void run() {
            while (true) {
                PythonWorkerFactory pythonWorkerFactory = this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer();
                synchronized (pythonWorkerFactory) {
                    if (PythonWorkerFactory$.MODULE$.IDLE_WORKER_TIMEOUT_NS() < System.nanoTime() - this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs()) {
                        this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers();
                        this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs_$eq(System.nanoTime());
                    }
                }
                Thread.sleep(10000L);
            }
        }

        public /* synthetic */ PythonWorkerFactory org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer() {
            return PythonWorkerFactory.this;
        }

        public MonitorThread() {
            if (PythonWorkerFactory.this == null) {
                throw null;
            }
            super("Idle Worker Monitor for " + PythonWorkerFactory.this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec);
            this.setDaemon(true);
        }
    }
}

