/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.MergeIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.MergeIntoTable$;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;

public final class ResolveMergeIntoSchemaEvolution$
extends Rule<LogicalPlan> {
    public static final ResolveMergeIntoSchemaEvolution$ MODULE$ = new ResolveMergeIntoSchemaEvolution$();

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.resolveOperators((PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                MergeIntoTable mergeIntoTable;
                A1 A1 = x1;
                if (A1 instanceof MergeIntoTable && (mergeIntoTable = (MergeIntoTable)A1).needSchemaEvolution()) {
                    LogicalPlan newTarget = (LogicalPlan)mergeIntoTable.targetTable().transform(new Serializable(null, mergeIntoTable){
                        private static final long serialVersionUID = 0L;
                        private final MergeIntoTable x2$1;

                        public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 instanceof DataSourceV2Relation) {
                                DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)A1;
                                return (B1)ResolveMergeIntoSchemaEvolution$.MODULE$.org$apache$spark$sql$catalyst$analysis$ResolveMergeIntoSchemaEvolution$$performSchemaEvolution(dataSourceV2Relation, this.x2$1.sourceTable());
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(LogicalPlan x1) {
                            LogicalPlan logicalPlan = x1;
                            return logicalPlan instanceof DataSourceV2Relation;
                        }
                        {
                            this.x2$1 = x2$1;
                        }
                    });
                    return (B1)mergeIntoTable.copy(newTarget, mergeIntoTable.copy$default$2(), mergeIntoTable.copy$default$3(), mergeIntoTable.copy$default$4(), mergeIntoTable.copy$default$5(), mergeIntoTable.copy$default$6(), mergeIntoTable.copy$default$7());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                MergeIntoTable mergeIntoTable;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof MergeIntoTable && (mergeIntoTable = (MergeIntoTable)logicalPlan).needSchemaEvolution();
            }
        });
    }

    public DataSourceV2Relation org$apache$spark$sql$catalyst$analysis$ResolveMergeIntoSchemaEvolution$$performSchemaEvolution(DataSourceV2Relation relation, LogicalPlan source) {
        Tuple2 tuple2 = new Tuple2(relation.catalog(), relation.identifier());
        if (tuple2 != null) {
            Some some;
            CatalogPlugin c;
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some && (c = (CatalogPlugin)(some = (Some)option).value()) instanceof TableCatalog) {
                TableCatalog tableCatalog = (TableCatalog)c;
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Identifier i = (Identifier)some2.value();
                    TableChange[] changes = MergeIntoTable$.MODULE$.schemaChanges(relation.schema(), source.schema(), MergeIntoTable$.MODULE$.schemaChanges$default$3());
                    tableCatalog.alterTable(i, changes);
                    Table newTable = tableCatalog.loadTable(i);
                    StructType newSchema = CatalogV2Util$.MODULE$.v2ColumnsToStructType(newTable.columns());
                    TableChange[] remainingChanges = MergeIntoTable$.MODULE$.schemaChanges(newSchema, source.schema(), MergeIntoTable$.MODULE$.schemaChanges$default$3());
                    if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])remainingChanges))) {
                        throw QueryCompilationErrors$.MODULE$.unsupportedTableChangesInAutoSchemaEvolutionError(remainingChanges, CatalogV2Implicits$.MODULE$.IdentifierHelper(i).toQualifiedNameParts(tableCatalog));
                    }
                    return relation.copy(newTable, DataTypeUtils$.MODULE$.toAttributes(newSchema), relation.copy$default$3(), relation.copy$default$4(), relation.copy$default$5());
                }
            }
        }
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Schema Evolution enabled but data source " + relation + " does not support it, skipping.");
        return relation;
    }

    private ResolveMergeIntoSchemaEvolution$() {
    }
}

