/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.Serializable;
import java.io.Writer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.CSVOptions$;
import org.apache.spark.sql.catalyst.expressions.BinaryFormatter;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.ToStringBase$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001\u0002\u0010 \u00011B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A1\t\u0001B\u0001B\u0003%A\tC\u0003I\u0001\u0011\u0005\u0011\nC\u0004O\u0001\t\u0007I\u0011B(\t\rm\u0003\u0001\u0015!\u0003Q\u0011\u001da\u0006A1A\u0005\nuCa!\u0019\u0001!\u0002\u0013qV\u0001\u00022\u0001\t\rDqA\u001f\u0001C\u0002\u0013%1\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002?\t\u0013\u0005\u0015\u0001A1A\u0005\n\u0005\u001d\u0001\u0002CA\u000b\u0001\u0001\u0006I!!\u0003\t\u0013\u0005]\u0001A1A\u0005\n\u0005\u001d\u0001\u0002CA\r\u0001\u0001\u0006I!!\u0003\t\u0013\u0005m\u0001A1A\u0005\n\u0005u\u0001\u0002CA\u0013\u0001\u0001\u0006I!a\b\t\u0013\u0005\u001d\u0002A1A\u0005\n\u0005%\u0002\u0002CA\u0019\u0001\u0001\u0006I!a\u000b\t\u0013\u0005M\u0002A1A\u0005\n\u0005U\u0002\u0002CA\u001f\u0001\u0001\u0006I!a\u000e\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B!9\u0011Q\n\u0001\u0005\n\u0005=\u0003bBA7\u0001\u0011%\u0011q\u000e\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!!$\u0001\t\u0003\ty\tC\u0004\u0002\u0014\u0002!\t!!\"\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0006\n\u0011RK\\5w_\u000eLG/_$f]\u0016\u0014\u0018\r^8s\u0015\t\u0001\u0013%A\u0002dgZT!AI\u0012\u0002\u0011\r\fG/\u00197zgRT!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g\u0003\u0019\u00198\r[3nCB\u0011Q\u0007O\u0007\u0002m)\u0011qgI\u0001\u0006if\u0004Xm]\u0005\u0003sY\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003\u00199(/\u001b;feB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0003S>T\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002C{\t1qK]5uKJ\fqa\u001c9uS>t7\u000f\u0005\u0002F\r6\tq$\u0003\u0002H?\tQ1i\u0015,PaRLwN\\:\u0002\rqJg.\u001b;?)\u0011Q5\nT'\u0011\u0005\u0015\u0003\u0001\"B\u001a\u0005\u0001\u0004!\u0004\"\u0002\u001e\u0005\u0001\u0004Y\u0004\"B\"\u0005\u0001\u0004!\u0015AD<sSR,'oU3ui&twm]\u000b\u0002!B\u0011\u0011+W\u0007\u0002%*\u0011\u0001e\u0015\u0006\u0003)V\u000bq\u0001]1sg\u0016\u00148O\u0003\u0002W/\u0006IQO\\5w_\u000eLG/\u001f\u0006\u00021\u0006\u00191m\\7\n\u0005i\u0013&!E\"tm^\u0013\u0018\u000e^3s'\u0016$H/\u001b8hg\u0006yqO]5uKJ\u001cV\r\u001e;j]\u001e\u001c\b%A\u0002hK:,\u0012A\u0018\t\u0003#~K!\u0001\u0019*\u0003\u0013\r\u001bho\u0016:ji\u0016\u0014\u0018\u0001B4f]\u0002\u0012aBV1mk\u0016\u001cuN\u001c<feR,'\u000fE\u0003/I\u001adw.\u0003\u0002f_\tIa)\u001e8di&|gN\r\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S\u0006\n1\"\u001a=qe\u0016\u001c8/[8og&\u00111\u000e\u001b\u0002\u0013'B,7-[1mSj,GmR3ui\u0016\u00148\u000f\u0005\u0002/[&\u0011an\f\u0002\u0004\u0013:$\bC\u00019x\u001d\t\tX\u000f\u0005\u0002s_5\t1O\u0003\u0002uW\u00051AH]8pizJ!A^\u0018\u0002\rA\u0013X\rZ3g\u0013\tA\u0018P\u0001\u0004TiJLgn\u001a\u0006\u0003m>\nqB^1mk\u0016\u001cuN\u001c<feR,'o]\u000b\u0002yB\u0019a&`@\n\u0005y|#!B!se\u0006L\bcAA\u0001\u00135\t\u0001!\u0001\twC2,XmQ8om\u0016\u0014H/\u001a:tA\u0005\u0011B/[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s+\t\tI\u0001\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty!I\u0001\u0005kRLG.\u0003\u0003\u0002\u0014\u00055!A\u0005+j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\f1\u0003^5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;fe\u0002\nQ\u0003^5nKN$\u0018-\u001c9O)j3uN]7biR,'/\u0001\fuS6,7\u000f^1na:#&LR8s[\u0006$H/\u001a:!\u00035!\u0017\r^3G_Jl\u0017\r\u001e;feV\u0011\u0011q\u0004\t\u0005\u0003\u0017\t\t#\u0003\u0003\u0002$\u00055!!\u0004#bi\u00164uN]7biR,'/\u0001\beCR,gi\u001c:nCR$XM\u001d\u0011\u0002/9,H\u000e\\!t#V|G/\u001a3F[B$\u0018p\u0015;sS:<WCAA\u0016!\rq\u0013QF\u0005\u0004\u0003_y#a\u0002\"p_2,\u0017M\\\u0001\u0019]VdG.Q:Rk>$X\rZ#naRL8\u000b\u001e:j]\u001e\u0004\u0013a\u00042j]\u0006\u0014\u0018PR8s[\u0006$H/\u001a:\u0016\u0005\u0005]\u0002cA4\u0002:%\u0019\u00111\b5\u0003\u001f\tKg.\u0019:z\r>\u0014X.\u0019;uKJ\f\u0001CY5oCJLhi\u001c:nCR$XM\u001d\u0011\u0002\u001b5\f7.Z\"p]Z,'\u000f^3s)\ry\u00181\t\u0005\b\u0003\u000b2\u0002\u0019AA$\u0003!!\u0017\r^1UsB,\u0007cA\u001b\u0002J%\u0019\u00111\n\u001c\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u00199qK:$g*\u001e7m)\u0011\t\t&a\u0016\u0011\u00079\n\u0019&C\u0002\u0002V=\u0012A!\u00168ji\"9\u0011\u0011L\fA\u0002\u0005m\u0013a\u00022vS2$WM\u001d\t\u0005\u0003;\n9G\u0004\u0003\u0002`\u0005\rdb\u0001:\u0002b%\t\u0001'C\u0002\u0002f=\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002j\u0005-$!D*ue&twMQ;jY\u0012,'OC\u0002\u0002f=\n!bY8om\u0016\u0014HOU8x)\u0011\t\t(a\u001e\u0011\u000b\u0005u\u00131O8\n\t\u0005U\u00141\u000e\u0002\u0004'\u0016\f\bbBA=1\u0001\u0007\u00111P\u0001\u0004e><\b\u0003BA?\u0003\u007fj\u0011!I\u0005\u0004\u0003\u0003\u000b#aC%oi\u0016\u0014h.\u00197S_^\fAb\u001e:ji\u0016DU-\u00193feN$\"!!\u0015\u0002\u000b]\u0014\u0018\u000e^3\u0015\t\u0005E\u00131\u0012\u0005\b\u0003sR\u0002\u0019AA>\u000359(/\u001b;f)>\u001cFO]5oOR\u0019q.!%\t\u000f\u0005e4\u00041\u0001\u0002|\u0005)1\r\\8tK\u0006)a\r\\;tQ\u0002")
public class UnivocityGenerator {
    private final CSVOptions options;
    private final CsvWriterSettings writerSettings;
    private final CsvWriter gen;
    private final Function2<SpecializedGetters, Object, String>[] valueConverters;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;
    private final DateFormatter dateFormatter;
    private final boolean nullAsQuotedEmptyString;
    private final BinaryFormatter binaryFormatter;

    private CsvWriterSettings writerSettings() {
        return this.writerSettings;
    }

    private CsvWriter gen() {
        return this.gen;
    }

    private Function2<SpecializedGetters, Object, String>[] valueConverters() {
        return this.valueConverters;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter() {
        return this.dateFormatter;
    }

    private boolean nullAsQuotedEmptyString() {
        return this.nullAsQuotedEmptyString;
    }

    private BinaryFormatter binaryFormatter() {
        return this.binaryFormatter;
    }

    private Function2<SpecializedGetters, Object, String> makeConverter(DataType dataType2) {
        DataType dataType3;
        while (true) {
            if (BinaryType$.MODULE$.equals(dataType3 = dataType2)) {
                return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$1(this, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (DateType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$2(this, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (TimestampType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$3(this, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (TimestampNTZType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$4(this, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (dataType3 instanceof YearMonthIntervalType) {
                YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType3;
                byte start = yearMonthIntervalType.startField();
                byte end = yearMonthIntervalType.endField();
                return (Function2 & Serializable)(getter, ordinal) -> IntervalUtils$.MODULE$.toYearMonthIntervalString(getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start, end);
            }
            if (dataType3 instanceof DayTimeIntervalType) {
                DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType3;
                byte start = dayTimeIntervalType.startField();
                byte end = dayTimeIntervalType.endField();
                return (Function2 & Serializable)(getter, ordinal) -> IntervalUtils$.MODULE$.toDayTimeIntervalString(getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start, end);
            }
            if (!(dataType3 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType3;
            dataType2 = userDefinedType.sqlType();
        }
        if (dataType3 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType3;
            DataType et = arrayType.elementType();
            Function2<SpecializedGetters, Object, String> elementConverter = this.makeConverter(et);
            return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$7(this, elementConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        if (dataType3 instanceof MapType) {
            MapType mapType = (MapType)dataType3;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            Function2<SpecializedGetters, Object, String> keyConverter = this.makeConverter(kt);
            Function2<SpecializedGetters, Object, String> valueConverter = this.makeConverter(vt);
            return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$8(this, keyConverter, valueConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        if (dataType3 instanceof StructType) {
            StructType structType = (StructType)dataType3;
            StructField[] fields = structType.fields();
            Function2[] converters = (Function2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x$2 -> x$2.dataType(), ClassTag$.MODULE$.apply(DataType.class))), (Function1 & Serializable)dataType -> this.makeConverter((DataType)dataType), ClassTag$.MODULE$.apply(Function2.class));
            return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$11(this, fields, converters, getter, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        if (dataType3 != null) {
            DataType dataType4 = dataType3;
            return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$12(dataType4, getter, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        throw new MatchError((Object)dataType3);
    }

    private void appendNull(StringBuilder builder) {
        Option option = this.options.parameters().get(CSVOptions$.MODULE$.NULL_VALUE());
        if (option instanceof Some) {
            builder.append(" " + this.options.nullValue());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    private Seq<String> convertRow(InternalRow row) {
        String[] values = new String[row.numFields()];
        for (int i = 0; i < row.numFields(); ++i) {
            if (!row.isNullAt(i)) {
                values[i] = (String)this.valueConverters()[i].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            if (!this.nullAsQuotedEmptyString()) continue;
            values[i] = this.options.nullValue();
        }
        return ArrayImplicits$.MODULE$.SparkArrayOps((Object)values).toImmutableArraySeq();
    }

    public void writeHeaders() {
        this.gen().writeHeaders();
    }

    public void write(InternalRow row) {
        this.gen().writeRow((Object[])this.convertRow(row).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public String writeToString(InternalRow row) {
        return this.gen().writeRowToString((Object[])this.convertRow(row).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public void close() {
        this.gen().close();
    }

    public void flush() {
        this.gen().flush();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$1(UnivocityGenerator $this, SpecializedGetters getter, int ordinal) {
        return ((UTF8String)$this.binaryFormatter().apply(getter.getBinary(ordinal))).toString();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$2(UnivocityGenerator $this, SpecializedGetters getter, int ordinal) {
        return $this.dateFormatter().format(getter.getInt(ordinal));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$3(UnivocityGenerator $this, SpecializedGetters getter, int ordinal) {
        return $this.timestampFormatter().format(getter.getLong(ordinal));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$4(UnivocityGenerator $this, SpecializedGetters getter, int ordinal) {
        return $this.timestampNTZFormatter().format(DateTimeUtils$.MODULE$.microsToLocalDateTime(getter.getLong(ordinal)));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$7(UnivocityGenerator $this, Function2 elementConverter$1, SpecializedGetters getter, int ordinal) {
        ArrayData array = getter.getArray(ordinal);
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (array.numElements() > 0) {
            if (array.isNullAt(0)) {
                $this.appendNull(builder);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = builder.append((String)elementConverter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)0)));
            }
            for (int i = 1; i < array.numElements(); ++i) {
                BoxedUnit boxedUnit;
                builder.append(",");
                if (array.isNullAt(i)) {
                    $this.appendNull(builder);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = builder.append(" " + elementConverter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$8(UnivocityGenerator $this, Function2 keyConverter$1, Function2 valueConverter$1, SpecializedGetters getter, int ordinal) {
        MapData map = getter.getMap(ordinal);
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (map.numElements() > 0) {
            ArrayData keyArray = map.keyArray();
            ArrayData valueArray = map.valueArray();
            builder.append((String)keyConverter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)0)));
            builder.append(" ->");
            if (valueArray.isNullAt(0)) {
                $this.appendNull(builder);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = builder.append(" " + valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)0)));
            }
            for (int i = 1; i < map.numElements(); ++i) {
                BoxedUnit boxedUnit;
                builder.append(", ");
                builder.append((String)keyConverter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i)));
                builder.append(" ->");
                if (valueArray.isNullAt(i)) {
                    $this.appendNull(builder);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = builder.append(" " + valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$11(UnivocityGenerator $this, StructField[] fields$1, Function2[] converters$1, SpecializedGetters getter, int ordinal) {
        InternalRow row = getter.getStruct(ordinal, fields$1.length);
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (row.numFields() > 0) {
            if (row.isNullAt(0)) {
                $this.appendNull(builder);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = builder.append((String)converters$1[0].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)0)));
            }
            for (int i = 1; i < row.numFields(); ++i) {
                BoxedUnit boxedUnit;
                builder.append(",");
                if (row.isNullAt(i)) {
                    $this.appendNull(builder);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = builder.append(" " + converters$1[i].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$12(DataType x14$1, SpecializedGetters getter, int ordinal) {
        return getter.get(ordinal, x14$1).toString();
    }

    public UnivocityGenerator(StructType schema, Writer writer, CSVOptions options) {
        this.options = options;
        this.writerSettings = options.asWriterSettings();
        this.writerSettings().setHeaders(schema.fieldNames());
        this.gen = new CsvWriter(writer, this.writerSettings());
        this.valueConverters = (Function2[])((IterableOnceOps)((IterableOps)schema.map((Function1 & Serializable)x$1 -> x$1.dataType())).map((Function1 & Serializable)dataType -> this.makeConverter((DataType)dataType))).toArray(ClassTag$.MODULE$.apply(Function2.class));
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInWrite(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInWrite(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false, true);
        this.dateFormatter = DateFormatter$.MODULE$.apply(options.dateFormatInWrite(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
        this.nullAsQuotedEmptyString = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_NULL_VALUE_WRITTEN_AS_QUOTED_EMPTY_STRING_CSV()));
        this.binaryFormatter = ToStringBase$.MODULE$.getBinaryFormatter();
    }
}

