/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CurrentTime$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimeType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_([precision]) - Returns the current time at the start of query evaluation.\n    All calls of current_time within the same query return the same value.\n\n    _FUNC_ - Returns the current time at the start of query evaluation.\n  ", arguments="\n    Arguments:\n      * precision - An optional integer literal in the range [0..6], indicating how many\n                    fractional digits of seconds to include. If omitted, the default is 6.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_();\n       15:49:11.914120\n      > SELECT _FUNC_;\n       15:49:11.914120\n      > SELECT _FUNC_(0);\n       15:49:11\n      > SELECT _FUNC_(3);\n       15:49:11.914\n      > SELECT _FUNC_(1+1);\n       15:49:11.91\n  ", group="datetime_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\t}c\u0001\u0002\u0015*\u0001ZB\u0001\"\u0017\u0001\u0003\u0016\u0004%\tA\u0017\u0005\t=\u0002\u0011\t\u0012)A\u00057\"Aq\f\u0001BK\u0002\u0013\u0005\u0001\r\u0003\u0005m\u0001\tE\t\u0015!\u0003b\u0011\u0015i\u0007\u0001\"\u0001o\u0011\u0015i\u0007\u0001\"\u0001s\u0011\u0015i\u0007\u0001\"\u0001t\u0011\u0015)\b\u0001\"\u0012w\u0011\u001d\ty\u0002\u0001C!\u0003CAq!!\u000b\u0001\t\u0003\n\t\u0003C\u0004\u0002,\u0001!\t%!\f\t\u0015\u0005m\u0002\u0001#b\u0001\n\u0003\ti\u0004C\u0004\u0002F\u0001!\t%a\u0012\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u0011\u0011\f\u0001\u0005B\u0005m\u0003bBA0\u0001\u0011E\u0013\u0011\r\u0005\b\u0003O\u0002A\u0011IA5\u0011\u001d\t\u0019\b\u0001C!\u0003kB\u0011\"!#\u0001\u0003\u0003%\t!a#\t\u0013\u0005E\u0005!%A\u0005\u0002\u0005M\u0005\"CAU\u0001E\u0005I\u0011AAV\u0011%\ty\u000bAA\u0001\n\u0003\n\t\fC\u0005\u0002B\u0002\t\t\u0011\"\u0001\u0002>!I\u00111\u0019\u0001\u0002\u0002\u0013\u0005\u0011Q\u0019\u0005\n\u0003\u0017\u0004\u0011\u0011!C!\u0003\u001bD\u0011\"a7\u0001\u0003\u0003%\t!!8\t\u0013\u0005\u0005\b!!A\u0005B\u0005\r\b\"CAt\u0001\u0005\u0005I\u0011IAu\u000f%\u0011\u0019\"KA\u0001\u0012\u0003\u0011)B\u0002\u0005)S\u0005\u0005\t\u0012\u0001B\f\u0011\u0019ig\u0004\"\u0001\u00030!I!\u0011\u0007\u0010\u0002\u0002\u0013\u0015#1\u0007\u0005\n\u0005kq\u0012\u0011!CA\u0005oA\u0011B!\u0010\u001f#\u0003%\t!a%\t\u0013\t}b$%A\u0005\u0002\u0005-\u0006\"\u0003B!=\u0005\u0005I\u0011\u0011B\"\u0011%\u0011\tFHI\u0001\n\u0003\t\u0019\nC\u0005\u0003Ty\t\n\u0011\"\u0001\u0002,\"I!Q\u000b\u0010\u0002\u0002\u0013%!q\u000b\u0002\f\u0007V\u0014(/\u001a8u)&lWM\u0003\u0002+W\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\taS&\u0001\u0005dCR\fG._:u\u0015\tqs&A\u0002tc2T!\u0001M\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u001a\u0014AB1qC\u000eDWMC\u00015\u0003\ry'oZ\u0002\u0001'\u001d\u0001qg\u000f B\u000f6\u0003\"\u0001O\u001d\u000e\u0003%J!AO\u0015\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\u000f\u001f\n\u0005uJ#a\u0006+j[\u0016TvN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o!\tAt(\u0003\u0002AS\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002C\u000b6\t1I\u0003\u0002ES\u000591m\u001c3fO\u0016t\u0017B\u0001$D\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007C\u0001%L\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%a\u0002)s_\u0012,8\r\u001e\t\u0003\u001dZs!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005I+\u0014A\u0002\u001fs_>$h(C\u0001K\u0013\t)\u0016*A\u0004qC\u000e\\\u0017mZ3\n\u0005]C&\u0001D*fe&\fG.\u001b>bE2,'BA+J\u0003\u0015\u0019\u0007.\u001b7e+\u0005Y\u0006C\u0001\u001d]\u0013\ti\u0016F\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0003;j[\u0016TvN\\3JIV\t\u0011\rE\u0002IE\u0012L!aY%\u0003\r=\u0003H/[8o!\t)\u0017N\u0004\u0002gOB\u0011\u0001+S\u0005\u0003Q&\u000ba\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001.S\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004_B\f\bC\u0001\u001d\u0001\u0011\u001dIV\u0001%AA\u0002mCqaX\u0003\u0011\u0002\u0003\u0007\u0011\rF\u0001p)\tyG\u000fC\u0003Z\u000f\u0001\u00071,\u0001\u000bo_\u0012,\u0007+\u0019;uKJt7/\u00138uKJt\u0017\r\u001c\u000b\u0002oB\u0019a\n\u001f>\n\u0005eD&aA*fcB\u001910!\u0007\u000f\u0007q\f\u0019BD\u0002~\u0003\u001fq1A`A\u0007\u001d\ry\u00181\u0002\b\u0005\u0003\u0003\tIA\u0004\u0003\u0002\u0004\u0005\u001dab\u0001)\u0002\u0006%\tA'\u0003\u00023g%\u0011\u0001'M\u0005\u0003]=J!\u0001L\u0017\n\u0007\u0005E1&A\u0003ue\u0016,7/\u0003\u0003\u0002\u0016\u0005]\u0011a\u0003+sK\u0016\u0004\u0016\r\u001e;fe:T1!!\u0005,\u0013\u0011\tY\"!\b\u0003\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0005\u0003+\t9\"\u0001\u0005ok2d\u0017M\u00197f+\t\t\u0019\u0003E\u0002I\u0003KI1!a\nJ\u0005\u001d\u0011un\u001c7fC:\f\u0001BZ8mI\u0006\u0014G.Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003_\u0001B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003kY\u0013\u0001C1oC2L8/[:\n\t\u0005e\u00121\u0007\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006I\u0001O]3dSNLwN\\\u000b\u0003\u0003\u007f\u00012\u0001SA!\u0013\r\t\u0019%\u0013\u0002\u0004\u0013:$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005%\u0003\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=S&A\u0003usB,7/\u0003\u0003\u0002T\u00055#\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001e\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\rY\u0014Q\f\u0005\u0006?>\u0001\r\u0001Z\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007m\u000b\u0019\u0007\u0003\u0004\u0002fA\u0001\raW\u0001\t]\u0016<8\t[5mI\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005-\u0004\u0003\u0002(y\u0003[\u0002B!a\u0013\u0002p%!\u0011\u0011OA'\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0003fm\u0006dG\u0003BA<\u0003{\u00022\u0001SA=\u0013\r\tY(\u0013\u0002\u0004\u0003:L\b\"CA@%A\u0005\t\u0019AAA\u0003\u0015Ig\u000e];u!\u0011\t\u0019)!\"\u000e\u0003-J1!a\",\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\t\r|\u0007/\u001f\u000b\u0006_\u00065\u0015q\u0012\u0005\b3N\u0001\n\u00111\u0001\\\u0011\u001dy6\u0003%AA\u0002\u0005\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0016*\u001a1,a&,\u0005\u0005e\u0005\u0003BAN\u0003Kk!!!(\u000b\t\u0005}\u0015\u0011U\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a)J\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\u000biJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002.*\u001a\u0011-a&\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\f\u0005\u0003\u00026\u0006}VBAA\\\u0015\u0011\tI,a/\u0002\t1\fgn\u001a\u0006\u0003\u0003{\u000bAA[1wC&\u0019!.a.\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qOAd\u0011%\tI\rGA\u0001\u0002\u0004\ty$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u001f\u0004b!!5\u0002X\u0006]TBAAj\u0015\r\t).S\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAm\u0003'\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111EAp\u0011%\tIMGA\u0001\u0002\u0004\t9(\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAZ\u0003KD\u0011\"!3\u001c\u0003\u0003\u0005\r!a\u0010\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019#a;\t\u0013\u0005%G$!AA\u0002\u0005]\u0004f\u0006\u0001\u0002p\u0006U\u0018q_A~\u0003{\u0014\tAa\u0001\u0003\b\t%!Q\u0002B\b!\rA\u0014\u0011_\u0005\u0004\u0003gL#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003s\f\u0011\u0011\u001c\u0006!A\u0001\u0002sLR+O\u0007~C3\f\u001d:fG&\u001c\u0018n\u001c8^S\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\u001aWO\u001d:f]R\u0004C/[7fA\u0005$\b\u0005\u001e5fAM$\u0018M\u001d;!_\u001a\u0004\u0013/^3ss\u0002*g/\u00197vCRLwN\u001c\u0018\u000bA\u0001\u0002\u0003%\u00117mA\r\fG\u000e\\:!_\u001a\u00043-\u001e:sK:$x\f^5nK\u0002:\u0018\u000e\u001e5j]\u0002\"\b.\u001a\u0011tC6,\u0007%];fef\u0004#/\u001a;ve:\u0004C\u000f[3!g\u0006lW\r\t<bYV,gF\u0003\u0006!A\u0001\u0002sLR+O\u0007~\u0003S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043-\u001e:sK:$\b\u0005^5nK\u0002\nG\u000f\t;iK\u0002\u001aH/\u0019:uA=4\u0007%];fef\u0004SM^1mk\u0006$\u0018n\u001c8/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\ty0AAG\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u0003O]3dSNLwN\u001c\u0011.A\u0005s\u0007e\u001c9uS>t\u0017\r\u001c\u0011j]R,w-\u001a:!Y&$XM]1mA%t\u0007\u0005\u001e5fAI\fgnZ3!7BrcFN/-A%tG-[2bi&tw\r\t5po\u0002j\u0017M\\=\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011ge\u0006\u001cG/[8oC2\u0004C-[4jiN\u0004sN\u001a\u0011tK\u000e|g\u000eZ:!i>\u0004\u0013N\\2mk\u0012,g\u0006I%gA=l\u0017\u000e\u001e;fI2\u0002C\u000f[3!I\u00164\u0017-\u001e7uA%\u001c\bE\u000e\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u000b\t\u0011Q\u001e\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013'\u000e\u001e5si\n\u0014GL\u001d2iE\u0012\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5iX\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cURD'\u000f\u001e2c9J\u0014\u0007N\u00193a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cURD'\u000f\u001e2c)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cURD'\u000f\u001e2c9J\u0014\u0007\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)c-\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112ki\"\u0014HO\u00192]e\n$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t-\u0011A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005#\tQ\u0001\u000e\u00182]A\n1bQ;se\u0016tG\u000fV5nKB\u0011\u0001HH\n\u0006=\te!Q\u0005\t\b\u00057\u0011\tcW1p\u001b\t\u0011iBC\u0002\u0003 %\u000bqA];oi&lW-\u0003\u0003\u0003$\tu!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!!q\u0005B\u0017\u001b\t\u0011IC\u0003\u0003\u0003,\u0005m\u0016AA5p\u0013\r9&\u0011\u0006\u000b\u0003\u0005+\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003g\u000bQ!\u00199qYf$Ra\u001cB\u001d\u0005wAq!W\u0011\u0011\u0002\u0003\u00071\fC\u0004`CA\u0005\t\u0019A1\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE\nq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)E!\u0014\u0011\t!\u0013'q\t\t\u0006\u0011\n%3,Y\u0005\u0004\u0005\u0017J%A\u0002+va2,'\u0007\u0003\u0005\u0003P\u0011\n\t\u00111\u0001p\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011I\u0006\u0005\u0003\u00026\nm\u0013\u0002\u0002B/\u0003o\u0013aa\u00142kK\u000e$\b")
public class CurrentTime
extends UnaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
CodegenFallback,
Serializable {
    private int precision;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<String> $lessinit$greater$default$2() {
        return CurrentTime$.MODULE$.$lessinit$greater$default$2();
    }

    public static Expression $lessinit$greater$default$1() {
        return CurrentTime$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Tuple2<Expression, Option<String>>> unapply(CurrentTime x$0) {
        return CurrentTime$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$2() {
        return CurrentTime$.MODULE$.apply$default$2();
    }

    public static Expression apply$default$1() {
        return CurrentTime$.MODULE$.apply$default$1();
    }

    public static Function1<Tuple2<Expression, Option<String>>, CurrentTime> tupled() {
        return CurrentTime$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<String>, CurrentTime>> curried() {
        return CurrentTime$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        CurrentTime currentTime = this;
        synchronized (currentTime) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        CurrentTime currentTime = this;
        synchronized (currentTime) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if (!this.bitmap$trans$0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatternsInternal() {
        return new .colon.colon((Object)TreePattern$.MODULE$.CURRENT_LIKE(), (List)Nil$.MODULE$);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public boolean foldable() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (!this.child().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)Cast$.MODULE$.toSQLId("precision")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.child().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)Cast$.MODULE$.toSQLExpr(this.child()))}))));
        }
        Object precisionValue = this.child().eval(this.child().eval$default$1());
        if (precisionValue == null) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"precision")}))));
        }
        Object object = precisionValue;
        if (object instanceof Number) {
            Number number = (Number)object;
            int p = number.intValue();
            if (p < TimeType$.MODULE$.MIN_PRECISION() || p > TimeType$.MODULE$.MICROS_PRECISION()) {
                return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)Cast$.MODULE$.toSQLId("precision")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)("[" + TimeType$.MODULE$.MIN_PRECISION() + ", " + TimeType$.MODULE$.MICROS_PRECISION() + "]")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)Cast$.MODULE$.toSQLValue(BoxesRunTime.boxToInteger((int)p), (DataType)IntegerType$.MODULE$))}))));
            }
        } else {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)TypeUtils$.MODULE$.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)Cast$.MODULE$.toSQLExpr(this.child())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.child().dataType()))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    private int precision$lzycompute() {
        CurrentTime currentTime = this;
        synchronized (currentTime) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.precision = ((Number)this.child().eval(this.child().eval$default$1())).intValue();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.precision;
    }

    public int precision() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.precision$lzycompute();
        }
        return this.precision;
    }

    @Override
    public DataType dataType() {
        return new TimeType(this.precision());
    }

    @Override
    public String prettyName() {
        return "current_time";
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<String>)x$1);
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public Object eval(InternalRow input) {
        long currentTimeOfDayNanos = DateTimeUtils$.MODULE$.instantToNanosOfDay(Instant.now(), this.zoneId());
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.truncateTimeToPrecision(currentTimeOfDayNanos, this.precision()));
    }

    public CurrentTime copy(Expression child, Option<String> timeZoneId) {
        return new CurrentTime(child, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<String> copy$default$2() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "CurrentTime";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CurrentTime;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CurrentTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        CurrentTime currentTime = (CurrentTime)x$1;
        Expression expression = this.child();
        Expression expression2 = currentTime.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = currentTime.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!currentTime.canEqual(this)) return false;
        return true;
    }

    public CurrentTime(Expression child, Option<String> timeZoneId) {
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
        Statics.releaseFence();
    }

    public CurrentTime() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)TimeType$.MODULE$.MICROS_PRECISION())), (Option<String>)None$.MODULE$);
    }

    public CurrentTime(Expression child) {
        this(child, (Option<String>)None$.MODULE$);
    }
}

