/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.classic;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.logical.ColumnDefinition$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OptionList;
import org.apache.spark.sql.catalyst.plans.logical.TableSpecBase;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedTableSpec;
import org.apache.spark.sql.catalyst.streaming.InternalOutputModes$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.classic.DataStreamWriter$;
import org.apache.spark.sql.classic.Dataset$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.catalog.V2TableWithV1Fallback;
import org.apache.spark.sql.connector.expressions.ClusterByTransform;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.python.PythonDataSourceV2;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.sources.ForeachBatchSink;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterTable;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterTable$;
import org.apache.spark.sql.execution.streaming.sources.MemoryPlan;
import org.apache.spark.sql.execution.streaming.sources.MemorySink;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\r=g\u0001\u0002)R\u0005qC\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IA\u001d\u0005\u0007m\u0002!\taU<\t\u000bi\u0004A\u0011A>\t\ri\u0004A\u0011AA\u0002\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003O\u0002A\u0011AA5\u0011\u001d\t9\u0007\u0001C\u0001\u0003sBq!a#\u0001\t\u0003\ti\tC\u0004\u0002\f\u0002!\t!!'\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\"9\u0011q\u001d\u0001\u0005\n\u0005%\b\"\u0003B\u0005\u0001E\u0005I\u0011\u0002B\u0006\u0011\u001d\u0011i\u0002\u0001C\u0005\u0005?A\u0011B!\u001a\u0001#\u0003%IAa\u001a\t\u0013\t-\u0004!%A\u0005\n\t5\u0004\"\u0003B9\u0001E\u0005I\u0011\u0002B\u0006\u0011\u001d\u0011\u0019\b\u0001C\u0005\u0005kBqA!#\u0001\t\u0003\u0011Y\t\u0003\u0005\u0003\u001a\u0002!\ta\u0015BN\u0011)\u0011\u0019\fAI\u0001\n\u0003\u0019&Q\u0017\u0005\b\u0005s\u0003A\u0011\u0001B^\u0011\u001d\u0011I\u000e\u0001C\u0005\u00057DqA!=\u0001\t\u0013\u0011Y\u000eC\u0004\u0003t\u0002!IA!>\t\u000f\t}\b\u0001\"\u0003\u0004\u0002!91q\u0001\u0001\u0005\n\r%\u0001bBA.\u0001\u0011\u000531\u0002\u0005\b\u00037\u0002A\u0011IB\t\u0011\u001d\tY\u0006\u0001C!\u0007/AqA!/\u0001\t\u0003\u001a\u0019\u0003C\u0005\u00026\u0001\u0001\r\u0011\"\u0003\u0004>!I1q\b\u0001A\u0002\u0013%1\u0011\t\u0005\t\u0007\u000f\u0002\u0001\u0015)\u0003\u0002\b!A!\u0010\u0001a\u0001\n\u0013\u0019I\u0005C\u0005\u0004L\u0001\u0001\r\u0011\"\u0003\u0004N!91\u0011\u000b\u0001!B\u0013q\b\"CA\u000f\u0001\u0001\u0007I\u0011BB*\u0011%\u0019)\u0006\u0001a\u0001\n\u0013\u00199\u0006\u0003\u0005\u0004\\\u0001\u0001\u000b\u0015BA\u0012\u0011%\u0019i\u0006\u0001a\u0001\n\u0013\u0019y\u0006C\u0005\u0004b\u0001\u0001\r\u0011\"\u0003\u0004d!A1q\r\u0001!B\u0013\u00119\u0004C\u0006\u0004j\u0001\u0001\r\u00111A\u0005\n\r-\u0004bCB7\u0001\u0001\u0007\t\u0019!C\u0005\u0007_B1ba\u001d\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003 \"I1Q\u000f\u0001A\u0002\u0013%1q\u000f\u0005\n\u0007s\u0002\u0001\u0019!C\u0005\u0007wB\u0001ba \u0001A\u0003&!q\u0015\u0005\f\u0007\u0003\u0003\u0001\u0019!a\u0001\n\u0013\u0019\u0019\tC\u0006\u0004\u0006\u0002\u0001\r\u00111A\u0005\n\r\u001d\u0005bCBF\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u0003D\u0011b!$\u0001\u0001\u0004%IAa7\t\u0013\r=\u0005\u00011A\u0005\n\rE\u0005\u0002CBK\u0001\u0001\u0006KA!8\t\u0013\r]\u0005\u00011A\u0005\n\tm\u0007\"CBM\u0001\u0001\u0007I\u0011BBN\u0011!\u0019y\n\u0001Q!\n\tuwaBBR#\"\u00051Q\u0015\u0004\u0007!FC\taa*\t\rY\u0004E\u0011ABX\u0011%\u0019\t\f\u0011b\u0001\n\u0003\u0019i\u0004\u0003\u0005\u00044\u0002\u0003\u000b\u0011BA\u0004\u0011%\u0019)\f\u0011b\u0001\n\u0003\u0019i\u0004\u0003\u0005\u00048\u0002\u0003\u000b\u0011BA\u0004\u0011%\u0019I\f\u0011b\u0001\n\u0003\u0019i\u0004\u0003\u0005\u0004<\u0002\u0003\u000b\u0011BA\u0004\u0011%\u0019i\f\u0011b\u0001\n\u0003\u0019i\u0004\u0003\u0005\u0004@\u0002\u0003\u000b\u0011BA\u0004\u0011%\u0019\t\r\u0011b\u0001\n\u0003\u0019i\u0004\u0003\u0005\u0004D\u0002\u0003\u000b\u0011BA\u0004\u0011%\u0019)\r\u0011b\u0001\n\u0003\u0019i\u0004\u0003\u0005\u0004H\u0002\u0003\u000b\u0011BA\u0004\u0011%\u0019I\r\u0011b\u0001\n\u0003\u0019Y\r\u0003\u0005\u0004N\u0002\u0003\u000b\u0011\u0002Bp\u0005A!\u0015\r^1TiJ,\u0017-\\,sSR,'O\u0003\u0002S'\u000691\r\\1tg&\u001c'B\u0001+V\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003-^\u000bQa\u001d9be.T!\u0001W-\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0016aA8sO\u000e\u0001QCA/f'\t\u0001a\fE\u0002`E\u000el\u0011\u0001\u0019\u0006\u0003CN\u000b\u0011b\u001d;sK\u0006l\u0017N\\4\n\u0005A\u0003\u0007C\u00013f\u0019\u0001!QA\u001a\u0001C\u0002\u001d\u0014\u0011\u0001V\t\u0003Q:\u0004\"!\u001b7\u000e\u0003)T\u0011a[\u0001\u0006g\u000e\fG.Y\u0005\u0003[*\u0014qAT8uQ&tw\r\u0005\u0002j_&\u0011\u0001O\u001b\u0002\u0004\u0003:L\u0018A\u00013t!\r\u0019HoY\u0007\u0002#&\u0011Q/\u0015\u0002\b\t\u0006$\u0018m]3u\u0003\u0019a\u0014N\\5u}Q\u0011\u00010\u001f\t\u0004g\u0002\u0019\u0007\"B9\u0003\u0001\u0004\u0011\u0018AC8viB,H/T8eKR\u0011A0`\u0007\u0002\u0001!)!p\u0001a\u0001}B\u0011ql`\u0005\u0004\u0003\u0003\u0001'AC(viB,H/T8eKR\u0019A0!\u0002\t\ri$\u0001\u0019AA\u0004!\u0011\tI!a\u0006\u000f\t\u0005-\u00111\u0003\t\u0004\u0003\u001bQWBAA\b\u0015\r\t\tbW\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005U!.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\tYB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003+Q\u0017a\u0002;sS\u001e<WM\u001d\u000b\u0004y\u0006\u0005\u0002bBA\u000f\u000b\u0001\u0007\u00111\u0005\t\u0004?\u0006\u0015\u0012bAA\u0014A\n9AK]5hO\u0016\u0014\u0018!C9vKJLh*Y7f)\ra\u0018Q\u0006\u0005\b\u0003S1\u0001\u0019AA\u0004\u0003\u00191wN]7biR\u0019A0a\r\t\u000f\u0005Ur\u00011\u0001\u0002\b\u000511o\\;sG\u0016\f1\u0002]1si&$\u0018n\u001c8CsR\u0019A0a\u000f\t\u000f\u0005u\u0002\u00021\u0001\u0002@\u0005A1m\u001c7OC6,7\u000fE\u0003j\u0003\u0003\n9!C\u0002\u0002D)\u0014!\u0002\u0010:fa\u0016\fG/\u001a3?Q\rA\u0011q\t\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011Q\n6\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0005-#a\u0002<be\u0006\u0014xm]\u0001\nG2,8\u000f^3s\u0005f$2\u0001`A,\u0011\u001d\ti$\u0003a\u0001\u0003\u007fA3!CA$\u0003\u0019y\u0007\u000f^5p]R)A0a\u0018\u0002d!9\u0011\u0011\r\u0006A\u0002\u0005\u001d\u0011aA6fs\"9\u0011Q\r\u0006A\u0002\u0005\u001d\u0011!\u0002<bYV,\u0017aB8qi&|gn\u001d\u000b\u0004y\u0006-\u0004bBA4\u0017\u0001\u0007\u0011Q\u000e\t\t\u0003_\n)(a\u0002\u0002\b5\u0011\u0011\u0011\u000f\u0006\u0004\u0003gR\u0017AC2pY2,7\r^5p]&!\u0011qOA9\u0005\ri\u0015\r\u001d\u000b\u0004y\u0006m\u0004bBA4\u0019\u0001\u0007\u0011Q\u0010\t\t\u0003\u007f\nI)a\u0002\u0002\b5\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))\u0001\u0003vi&d'BAAD\u0003\u0011Q\u0017M^1\n\t\u0005]\u0014\u0011Q\u0001\u0006gR\f'\u000f\u001e\u000b\u0005\u0003\u001f\u000b)\nE\u0002`\u0003#K1!a%a\u00059\u0019FO]3b[&tw-U;fefDq!a&\u000e\u0001\u0004\t9!\u0001\u0003qCRDGCAAHQ\u0015q\u0011QTAX!\u0015I\u0017qTAR\u0013\r\t\tK\u001b\u0002\u0007i\"\u0014xn^:\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OSA!!+\u0002\u0002\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u00055\u0016q\u0015\u0002\u0011)&lWm\\;u\u000bb\u001cW\r\u001d;j_:\fT!JAY\u0003\u0017TC!a-\u0002>B!\u0011QWA^\u001b\t\t9L\u0003\u0003\u0002:\u0006\u0015\u0015\u0001\u00027b]\u001eLA!!\u0007\u00028.\u0012\u0011q\u0018\t\u0005\u0003\u0003\f9-\u0004\u0002\u0002D*!\u0011QYA&\u0003\u0011iW\r^1\n\t\u0005%\u00171\u0019\u0002\u000bI\u00164\u0017-\u001e7u\u0003J<\u0017EAAg\u0003\u0001\tq\u0001^8UC\ndW\r\u0006\u0003\u0002\u0010\u0006M\u0007bBAk\u001f\u0001\u0007\u0011qA\u0001\ni\u0006\u0014G.\u001a(b[\u0016D3aDAm!\u0011\tY.a8\u000e\u0005\u0005u'bAA'+&!\u0011\u0011]Ao\u0005!)eo\u001c7wS:<\u0007&B\b\u0002\u001e\u0006\u0015\u0018'B\u0013\u00022\u0006-\u0017!D:uCJ$\u0018J\u001c;fe:\fG\u000e\u0006\u0004\u0002\u0010\u0006-\u00181\u001f\u0005\b\u0003/\u0003\u0002\u0019AAw!\u0015I\u0017q^A\u0004\u0013\r\t\tP\u001b\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005U\b\u0003%AA\u0002\u0005]\u0018\u0001D2bi\u0006dwn\u001a+bE2,\u0007#B5\u0002p\u0006e\b\u0003BA~\u0005\u000bi!!!@\u000b\t\u0005}(\u0011A\u0001\bG\u0006$\u0018\r\\8h\u0015\r\u0011\u0019aU\u0001\tG\u0006$\u0018\r\\=ti&!!qAA\u007f\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0003]\u0019H/\u0019:u\u0013:$XM\u001d8bY\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u000e)\"\u0011q\u001fB\bW\t\u0011\t\u0002\u0005\u0003\u0003\u0014\teQB\u0001B\u000b\u0015\u0011\u00119\"a\u0013\u0002\u0013Ut7\r[3dW\u0016$\u0017\u0002\u0002B\u000e\u0005+\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003)\u0019H/\u0019:u#V,'/\u001f\u000b\r\u0003\u001f\u0013\tCa\r\u0003B\t-#1\r\u0005\b\u0005G\u0011\u0002\u0019\u0001B\u0013\u0003\u0011\u0019\u0018N\\6\u0011\t\t\u001d\"qF\u0007\u0003\u0005SQA!a@\u0003,)\u0019!QF*\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002\u0002B\u0019\u0005S\u0011Q\u0001V1cY\u0016DqA!\u000e\u0013\u0001\u0004\u00119$\u0001\u0006oK^|\u0005\u000f^5p]N\u0004bA!\u000f\u0003>\u0005\u001dQB\u0001B\u001e\u0015\u0011\t\u0019I!\u0001\n\t\t}\"1\b\u0002\u0013\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wK6\u000b\u0007\u000fC\u0005\u0003DI\u0001\n\u00111\u0001\u0003F\u0005)\"/Z2pm\u0016\u0014hI]8n\u0007\",7m\u001b9pS:$\bcA5\u0003H%\u0019!\u0011\n6\u0003\u000f\t{w\u000e\\3b]\"I!Q\n\n\u0011\u0002\u0003\u0007!qJ\u0001\u0010G\u0006$\u0018\r\\8h\u0003:$\u0017\nZ3oiB)\u0011.a<\u0003RA9\u0011Na\u0015\u0003X\tu\u0013b\u0001B+U\n1A+\u001e9mKJ\u0002BAa\n\u0003Z%!!1\fB\u0015\u00051!\u0016M\u00197f\u0007\u0006$\u0018\r\\8h!\u0011\u00119Ca\u0018\n\t\t\u0005$\u0011\u0006\u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014\b\"CA{%A\u0005\t\u0019AA|\u0003Q\u0019H/\u0019:u#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u000e\u0016\u0005\u0005\u000b\u0012y!\u0001\u000bti\u0006\u0014H/U;fef$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005_RCAa\u0014\u0003\u0010\u0005!2\u000f^1siF+XM]=%I\u00164\u0017-\u001e7uIU\nAb\u0019:fCR,g+M*j].$BAa\u001e\u0003\u0006B!!\u0011\u0010BA\u001b\t\u0011YHC\u0002b\u0005{R1Aa T\u0003%)\u00070Z2vi&|g.\u0003\u0003\u0003\u0004\nm$\u0001B*j].DqAa\"\u0017\u0001\u0004\u00119$A\bpaRLwN\\:XSRD\u0007+\u0019;i\u0003\u001d1wN]3bG\"$2\u0001 BG\u0011\u001d\u0011yi\u0006a\u0001\u0005#\u000baa\u001e:ji\u0016\u0014\b#\u0002BJ\u0005+\u001bW\"A*\n\u0007\t]5KA\u0007G_J,\u0017m\u00195Xe&$XM]\u0001\u0016M>\u0014X-Y2i\u00136\u0004H.Z7f]R\fG/[8o)\u0015a(Q\u0014BQ\u0011\u001d\u0011y\t\u0007a\u0001\u0005?\u0003RAa%\u0003\u0016:D\u0011Ba)\u0019!\u0003\u0005\rA!*\u0002\u000f\u0015t7m\u001c3feB)\u0011.a<\u0003(B)!\u0011\u0016BX]6\u0011!1\u0016\u0006\u0005\u0005[\u0013\t!\u0001\u0005f]\u000e|G-\u001a:t\u0013\u0011\u0011\tLa+\u0003#\u0015C\bO]3tg&|g.\u00128d_\u0012,'/A\u0010g_J,\u0017m\u00195J[BdW-\\3oi\u0006$\u0018n\u001c8%I\u00164\u0017-\u001e7uII*\"Aa.+\t\t\u0015&qB\u0001\rM>\u0014X-Y2i\u0005\u0006$8\r\u001b\u000b\u0004y\nu\u0006b\u0002B`5\u0001\u0007!\u0011Y\u0001\tMVt7\r^5p]BI\u0011Na1\u0003H\n-'\u0011[\u0005\u0004\u0005\u000bT'!\u0003$v]\u000e$\u0018n\u001c83!\u0015\u0011\u0019J!3d\u0013\t)8\u000bE\u0002j\u0005\u001bL1Aa4k\u0005\u0011auN\\4\u0011\u0007%\u0014\u0019.C\u0002\u0003V*\u0014A!\u00168ji\"\u001a!$!7\u0002#9|'/\\1mSj,G\rU1s\u0007>d7/\u0006\u0002\u0003^B)\u0011.a<\u0003`B1!\u0011\u001dBv\u0003\u000fqAAa9\u0003h:!\u0011Q\u0002Bs\u0013\u0005Y\u0017b\u0001BuU\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002Bw\u0005_\u00141aU3r\u0015\r\u0011IO[\u0001\u0019]>\u0014X.\u00197ju\u0016$7\t\\;ti\u0016\u0014\u0018N\\4D_2\u001c\u0018!\u00038pe6\fG.\u001b>f)\u0019\t9Aa>\u0003|\"9!\u0011`\u000fA\u0002\u0005\u001d\u0011AC2pYVlgNT1nK\"9!Q`\u000fA\u0002\u0005\u001d\u0011AC2pYVlg\u000eV=qK\u0006!\u0012m]:feRtu\u000e\u001e)beRLG/[8oK\u0012$BA!5\u0004\u0004!91Q\u0001\u0010A\u0002\u0005\u001d\u0011!C8qKJ\fG/[8o\u0003\u00052\u0018\r\\5eCR,\u0007+\u0019:uSRLwN\\5oO\u0006sGm\u00117vgR,'/\u001b8h)\t\u0011\t\u000eF\u0003}\u0007\u001b\u0019y\u0001C\u0004\u0002b\u0001\u0002\r!a\u0002\t\u000f\u0005\u0015\u0004\u00051\u0001\u0003FQ)Apa\u0005\u0004\u0016!9\u0011\u0011M\u0011A\u0002\u0005\u001d\u0001bBA3C\u0001\u0007!1\u001a\u000b\u0006y\u000ee11\u0004\u0005\b\u0003C\u0012\u0003\u0019AA\u0004\u0011\u001d\t)G\ta\u0001\u0007;\u00012![B\u0010\u0013\r\u0019\tC\u001b\u0002\u0007\t>,(\r\\3\u0015\u0007q\u001c)\u0003C\u0004\u0003@\u000e\u0002\raa\n\u0011\u0011\r%21\u0007Bd\u0007oi!aa\u000b\u000b\t\t}6Q\u0006\u0006\u0005\u0003\u000f\u001byCC\u0002\u00042U\u000b1!\u00199j\u0013\u0011\u0019)da\u000b\u0003\u001bY{\u0017\u000e\u001a$v]\u000e$\u0018n\u001c83!\u0011\t)l!\u000f\n\t\t=\u0017q\u0017\u0015\u0004G\u0005eWCAA\u0004\u0003)\u0019x.\u001e:dK~#S-\u001d\u000b\u0005\u0005#\u001c\u0019\u0005C\u0005\u0004F\u0015\n\t\u00111\u0001\u0002\b\u0005\u0019\u0001\u0010J\u0019\u0002\u000fM|WO]2fAU\ta0\u0001\bpkR\u0004X\u000f^'pI\u0016|F%Z9\u0015\t\tE7q\n\u0005\t\u0007\u000bB\u0013\u0011!a\u0001}\u0006Yq.\u001e;qkRlu\u000eZ3!+\t\t\u0019#A\u0006ue&<w-\u001a:`I\u0015\fH\u0003\u0002Bi\u00073B\u0011b!\u0012,\u0003\u0003\u0005\r!a\t\u0002\u0011Q\u0014\u0018nZ4fe\u0002\nA\"\u001a=ue\u0006|\u0005\u000f^5p]N,\"Aa\u000e\u0002!\u0015DHO]1PaRLwN\\:`I\u0015\fH\u0003\u0002Bi\u0007KB\u0011b!\u0012/\u0003\u0003\u0005\rAa\u000e\u0002\u001b\u0015DHO]1PaRLwN\\:!\u000351wN]3bG\"<&/\u001b;feV\u0011!qT\u0001\u0012M>\u0014X-Y2i/JLG/\u001a:`I\u0015\fH\u0003\u0002Bi\u0007cB\u0011b!\u00122\u0003\u0003\u0005\rAa(\u0002\u001d\u0019|'/Z1dQ^\u0013\u0018\u000e^3sA\u0005!bm\u001c:fC\u000eDwK]5uKJ,enY8eKJ,\"Aa*\u00021\u0019|'/Z1dQ^\u0013\u0018\u000e^3s\u000b:\u001cw\u000eZ3s?\u0012*\u0017\u000f\u0006\u0003\u0003R\u000eu\u0004\"CB#i\u0005\u0005\t\u0019\u0001BT\u0003U1wN]3bG\"<&/\u001b;fe\u0016s7m\u001c3fe\u0002\n!CZ8sK\u0006\u001c\u0007NQ1uG\"<&/\u001b;feV\u0011!\u0011Y\u0001\u0017M>\u0014X-Y2i\u0005\u0006$8\r[,sSR,'o\u0018\u0013fcR!!\u0011[BE\u0011%\u0019)eNA\u0001\u0002\u0004\u0011\t-A\ng_J,\u0017m\u00195CCR\u001c\u0007n\u0016:ji\u0016\u0014\b%A\nqCJ$\u0018\u000e^5p]&twmQ8mk6t7/A\fqCJ$\u0018\u000e^5p]&twmQ8mk6t7o\u0018\u0013fcR!!\u0011[BJ\u0011%\u0019)EOA\u0001\u0002\u0004\u0011i.\u0001\u000bqCJ$\u0018\u000e^5p]&twmQ8mk6t7\u000fI\u0001\u0012G2,8\u000f^3sS:<7i\u001c7v[:\u001c\u0018!F2mkN$XM]5oO\u000e{G.^7og~#S-\u001d\u000b\u0005\u0005#\u001ci\nC\u0005\u0004Fu\n\t\u00111\u0001\u0003^\u0006\u00112\r\\;ti\u0016\u0014\u0018N\\4D_2,XN\\:!Q\r\u0001\u0011\u0011\\\u0001\u0011\t\u0006$\u0018m\u0015;sK\u0006lwK]5uKJ\u0004\"a\u001d!\u0014\u0007\u0001\u001bI\u000bE\u0002j\u0007WK1a!,k\u0005\u0019\te.\u001f*fMR\u00111QU\u0001\u0013'>+&kQ#`\u001d\u0006kUiX'F\u001b>\u0013\u0016,A\nT\u001fV\u00136)R0O\u00036+u,T#N\u001fJK\u0006%A\nT\u001fV\u00136)R0O\u00036+uLR(S\u000b\u0006\u001b\u0005*\u0001\u000bT\u001fV\u00136)R0O\u00036+uLR(S\u000b\u0006\u001b\u0005\nI\u0001\u001a'>+&kQ#`\u001d\u0006kUi\u0018$P%\u0016\u000b5\tS0C\u0003R\u001b\u0005*\u0001\u000eT\u001fV\u00136)R0O\u00036+uLR(S\u000b\u0006\u001b\u0005j\u0018\"B)\u000eC\u0005%A\nT\u001fV\u00136)R0O\u00036+ulQ(O'>cU)\u0001\u000bT\u001fV\u00136)R0O\u00036+ulQ(O'>cU\tI\u0001\u0012'>+&kQ#`\u001d\u0006kUi\u0018+B\u00052+\u0015AE*P+J\u001bUi\u0018(B\u001b\u0016{F+\u0011\"M\u000b\u0002\n\u0001cU(V%\u000e+uLT!N\u000b~suj\u0014)\u0002#M{UKU\"F?:\u000bU*R0O\u001f>\u0003\u0006%\u0001\u000fT\u001fV\u00136)R*`\u00032cujV0P\u001d\u0016{F+S'F?F+VIU-\u0016\u0005\t}\u0017!H*P+J\u001bUiU0B\u00192{ukX(O\u000b~#\u0016*T#`#V+%+\u0017\u0011")
public final class DataStreamWriter<T>
extends org.apache.spark.sql.streaming.DataStreamWriter<T> {
    private final org.apache.spark.sql.classic.Dataset<T> ds;
    private String source;
    private OutputMode outputMode;
    private Trigger trigger;
    private CaseInsensitiveMap<String> extraOptions;
    private ForeachWriter<Object> foreachWriter;
    private ExpressionEncoder<Object> foreachWriterEncoder;
    private Function2<Dataset<T>, Object, BoxedUnit> foreachBatchWriter;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> clusteringColumns;

    public static Seq<String> SOURCES_ALLOW_ONE_TIME_QUERY() {
        return DataStreamWriter$.MODULE$.SOURCES_ALLOW_ONE_TIME_QUERY();
    }

    public static String SOURCE_NAME_NOOP() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_NOOP();
    }

    public static String SOURCE_NAME_TABLE() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_TABLE();
    }

    public static String SOURCE_NAME_CONSOLE() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_CONSOLE();
    }

    public static String SOURCE_NAME_FOREACH_BATCH() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH();
    }

    public static String SOURCE_NAME_FOREACH() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH();
    }

    public static String SOURCE_NAME_MEMORY() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY();
    }

    public DataStreamWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataStreamWriter<T> clusterBy(String ... colNames) {
        return this.clusterBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataStreamWriter<T> outputMode(OutputMode outputMode) {
        this.outputMode_$eq(outputMode);
        return this;
    }

    public DataStreamWriter<T> outputMode(String outputMode) {
        this.outputMode_$eq(InternalOutputModes$.MODULE$.apply(outputMode));
        return this;
    }

    public DataStreamWriter<T> trigger(Trigger trigger) {
        this.trigger_$eq(trigger);
        return this;
    }

    public DataStreamWriter<T> queryName(String queryName) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"queryName"), (Object)queryName)));
        return this;
    }

    public DataStreamWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        this.validatePartitioningAndClustering();
        return this;
    }

    public DataStreamWriter<T> clusterBy(Seq<String> colNames) {
        this.clusteringColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        this.validatePartitioningAndClustering();
        return this;
    }

    public DataStreamWriter<T> option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataStreamWriter<T> options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataStreamWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(options).asScala());
        return this;
    }

    public StreamingQuery start(String path) {
        if (!this.ds.sparkSession().sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw QueryCompilationErrors$.MODULE$.setPathOptionAndCallWithPathParameterError("start");
        }
        return this.startInternal((Option<String>)new Some((Object)path), this.startInternal$default$2());
    }

    public StreamingQuery start() throws TimeoutException {
        return this.startInternal((Option<String>)None$.MODULE$, this.startInternal$default$2());
    }

    @Evolving
    public StreamingQuery toTable(String tableName) throws TimeoutException {
        SupportsWrite supportsWrite;
        Table tableInstance;
        Option option;
        ParserInterface parser = this.ds.sparkSession().sessionState().sqlParser();
        Seq originalMultipartIdentifier = parser.parseMultipartIdentifier(tableName);
        Seq seq = originalMultipartIdentifier;
        if (seq == null || (option = this.ds.sparkSession().sessionState().analyzer().CatalogAndIdentifier().unapply(seq)).isEmpty()) {
            throw new MatchError((Object)seq);
        }
        CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option.get())._1();
        Identifier identifier = (Identifier)((Tuple2)option.get())._2();
        Tuple2 tuple2 = new Tuple2((Object)catalog, (Object)identifier);
        CatalogPlugin catalog2 = (CatalogPlugin)tuple2._1();
        Identifier identifier2 = (Identifier)tuple2._2();
        if (this.ds.sparkSession().sessionState().catalog().isTempView(originalMultipartIdentifier)) {
            throw QueryCompilationErrors$.MODULE$.tempViewNotSupportStreamingWriteError(tableName);
        }
        if (!CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().tableExists(identifier2)) {
            scala.collection.immutable.Map properties = (scala.collection.immutable.Map)this.normalizedClusteringCols().map((Function1 & Serializable)cols -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.CLUSTERING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)cols))}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
            ArraySeq partitioningOrClusteringTransform = (ArraySeq)this.normalizedClusteringCols().map((Function1 & Serializable)colNames -> ArrayImplicits$.MODULE$.SparkArrayOps((Object)new ClusterByTransform[]{new ClusterByTransform((Seq)colNames.map((Function1 & Serializable)col -> FieldReference$.MODULE$.apply(col)))}).toImmutableArraySeq()).getOrElse((Function0 & Serializable)() -> ArrayImplicits$.MODULE$.SparkArrayOps((Object)CatalogV2Implicits$.MODULE$.PartitionTypeHelper((Seq)this.partitioningColumns().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$)).asTransforms()).toImmutableArraySeq());
            UnresolvedTableSpec tableSpec = new UnresolvedTableSpec(properties, (Option)new Some((Object)this.source()), new OptionList((Seq)package$.MODULE$.Seq().empty()), this.extraOptions().get("path"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, (Seq)package$.MODULE$.Seq().empty());
            CreateTable cmd = new CreateTable((LogicalPlan)new UnresolvedIdentifier(originalMultipartIdentifier, UnresolvedIdentifier$.MODULE$.apply$default$2()), (Seq)this.ds.schema().asNullable().map((Function1 & Serializable)x$2 -> ColumnDefinition$.MODULE$.fromV1Column(x$2, parser)), (Seq)partitioningOrClusteringTransform, (TableSpecBase)tableSpec, false);
            v0 = Dataset$.MODULE$.ofRows(this.ds.sparkSession(), (LogicalPlan)cmd);
        } else {
            v0 = BoxedUnit.UNIT;
        }
        Table table = tableInstance = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().loadTable(identifier2);
        if (table instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table)).supports(TableCapability.STREAMING_WRITE)) {
            SupportsWrite x$1 = supportsWrite;
            CaseInsensitiveMap<String> x$22 = this.extraOptions();
            Some x$3 = new Some((Object)new Tuple2((Object)CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog(), (Object)identifier2));
            boolean x$4 = this.startQuery$default$3();
            Option<CatalogTable> x$5 = this.startQuery$default$5();
            return this.startQuery((Table)x$1, x$22, x$4, (Option<Tuple2<TableCatalog, Identifier>>)x$3, x$5);
        }
        if (table instanceof V2TableWithV1Fallback) {
            V2TableWithV1Fallback v2TableWithV1Fallback = (V2TableWithV1Fallback)table;
            return this.writeToV1Table$1(v2TableWithV1Fallback.v1Table(), tableName);
        }
        if (table instanceof V1Table) {
            V1Table v1Table = (V1Table)table;
            return this.writeToV1Table$1(v1Table.v1Table(), tableName);
        }
        throw QueryCompilationErrors$.MODULE$.tableNotSupportStreamingWriteError(tableName, table);
    }

    private StreamingQuery startInternal(Option<String> path, Option<CatalogTable> catalogTable) {
        Sink sink;
        Sink sink2;
        CaseInsensitiveMap optionsWithPath;
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("write");
        }
        String string3 = this.source();
        String string4 = DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY());
            if (this.extraOptions().get("queryName").isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.queryNameNotSpecifiedForMemorySinkError();
            }
            MemorySink sink3 = new MemorySink();
            org.apache.spark.sql.classic.Dataset<Row> resultDf = Dataset$.MODULE$.ofRows(this.ds.sparkSession(), new MemoryPlan(sink3, (Seq<Attribute>)DataTypeUtils$.MODULE$.toAttributes(this.ds.schema())));
            OutputMode outputMode = this.outputMode();
            OutputMode outputMode2 = OutputMode.Complete();
            boolean recoverFromCheckpoint = !(outputMode != null ? !outputMode.equals(outputMode2) : outputMode2 != null);
            MemorySink x$1 = sink3;
            CaseInsensitiveMap<String> x$2 = this.extraOptions();
            boolean x$3 = recoverFromCheckpoint;
            Option<CatalogTable> x$4 = catalogTable;
            Option<Tuple2<TableCatalog, Identifier>> x$5 = this.startQuery$default$4();
            StreamingQuery query = this.startQuery(x$1, x$2, x$3, x$5, x$4);
            resultDf.createOrReplaceTempView(query.name());
            return query;
        }
        String string5 = this.source();
        String string6 = DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH();
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            ForeachWriterTable<?> sink4;
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH());
            ForeachWriterTable<?> x$6 = sink4 = ForeachWriterTable$.MODULE$.apply(this.foreachWriter(), this.foreachWriterEncoder());
            CaseInsensitiveMap<String> x$7 = this.extraOptions();
            Option<CatalogTable> x$8 = catalogTable;
            boolean x$9 = this.startQuery$default$3();
            Option<Tuple2<TableCatalog, Identifier>> x$10 = this.startQuery$default$4();
            return this.startQuery(x$6, x$7, x$9, x$10, x$8);
        }
        String string7 = this.source();
        String string8 = DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH();
        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
            ForeachBatchSink<T> sink5;
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH());
            if (this.trigger() instanceof ContinuousTrigger) {
                throw QueryCompilationErrors$.MODULE$.sourceNotSupportedWithContinuousTriggerError(this.source());
            }
            ForeachBatchSink<T> x$11 = sink5 = new ForeachBatchSink<T>(this.foreachBatchWriter(), this.ds.exprEnc());
            CaseInsensitiveMap<String> x$12 = this.extraOptions();
            Option<CatalogTable> x$13 = catalogTable;
            boolean x$14 = this.startQuery$default$3();
            Option<Tuple2<TableCatalog, Identifier>> x$15 = this.startQuery$default$4();
            return this.startQuery(x$11, x$12, x$14, x$15, x$13);
        }
        Class<?> cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.ds.sparkSession().sessionState().conf());
        Seq disabledSources = Utils$.MODULE$.stringToSeq(this.ds.sparkSession().sessionState().conf().disabledV2StreamingWriters());
        boolean useV1Source = disabledSources.contains((Object)cls.getCanonicalName()) || FileDataSourceV2.class.isAssignableFrom(cls);
        CaseInsensitiveMap caseInsensitiveMap = optionsWithPath = path.isEmpty() ? this.extraOptions() : this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
        if (TableProvider.class.isAssignableFrom(cls) && !useV1Source) {
            SupportsWrite supportsWrite;
            Table table;
            TableProvider provider = (TableProvider)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.ds.sparkSession().sessionState().conf());
            scala.collection.immutable.Map finalOptions = (scala.collection.immutable.Map)((MapOps)sessionOptions.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataStreamWriter.$anonfun$startInternal$1(optionsWithPath, x0$1)))).$plus$plus((IterableOnce)optionsWithPath.originalMap());
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)finalOptions).asJava());
            None$ outputSchema = provider.supportsExternalMetadata() ? new Some((Object)this.ds.schema()) : None$.MODULE$;
            TableProvider tableProvider = provider;
            if (tableProvider instanceof PythonDataSourceV2) {
                PythonDataSourceV2 pythonDataSourceV2 = (PythonDataSourceV2)tableProvider;
                pythonDataSourceV2.setShortName(this.source());
            }
            Table table2 = table = DataSourceV2Utils$.MODULE$.getTableFromProvider(provider, dsOptions, (Option<StructType>)outputSchema);
            sink2 = table2 instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table2)).supports(TableCapability.STREAMING_WRITE) ? supportsWrite : this.createV1Sink((CaseInsensitiveMap<String>)optionsWithPath);
        } else {
            sink2 = this.createV1Sink((CaseInsensitiveMap<String>)optionsWithPath);
        }
        Sink x$16 = sink = sink2;
        CaseInsensitiveMap x$17 = optionsWithPath;
        Option<CatalogTable> x$18 = catalogTable;
        boolean x$19 = this.startQuery$default$3();
        Option<Tuple2<TableCatalog, Identifier>> x$20 = this.startQuery$default$4();
        return this.startQuery(x$16, (CaseInsensitiveMap<String>)x$17, x$19, x$20, x$18);
    }

    private Option<CatalogTable> startInternal$default$2() {
        return None$.MODULE$;
    }

    private StreamingQuery startQuery(Table sink, CaseInsensitiveMap<String> newOptions, boolean recoverFromCheckpoint, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent, Option<CatalogTable> catalogTable) {
        boolean useTempCheckpointLocation = DataStreamWriter$.MODULE$.SOURCES_ALLOW_ONE_TIME_QUERY().contains((Object)this.source());
        Option x$1 = newOptions.get("queryName");
        Option x$2 = newOptions.get("checkpointLocation");
        org.apache.spark.sql.classic.Dataset<T> x$3 = this.ds;
        scala.collection.immutable.Map x$4 = newOptions.originalMap();
        Table x$5 = sink;
        OutputMode x$6 = this.outputMode();
        boolean x$7 = useTempCheckpointLocation;
        boolean x$8 = recoverFromCheckpoint;
        Trigger x$9 = this.trigger();
        Option<Tuple2<TableCatalog, Identifier>> x$10 = catalogAndIdent;
        Option<CatalogTable> x$11 = catalogTable;
        Clock x$12 = this.ds.sparkSession().sessionState().streamingQueryManager().startQuery$default$10();
        return this.ds.sparkSession().sessionState().streamingQueryManager().startQuery((Option<String>)x$1, (Option<String>)x$2, x$3, (scala.collection.immutable.Map<String, String>)x$4, x$5, x$6, x$7, x$8, x$9, x$12, x$10, x$11);
    }

    private boolean startQuery$default$3() {
        return true;
    }

    private Option<Tuple2<TableCatalog, Identifier>> startQuery$default$4() {
        return None$.MODULE$;
    }

    private Option<CatalogTable> startQuery$default$5() {
        return None$.MODULE$;
    }

    private Sink createV1Sink(CaseInsensitiveMap<String> optionsWithPath) {
        scala.collection.immutable.Map map;
        scala.collection.immutable.Map optionsWithoutClusteringKey = (scala.collection.immutable.Map)optionsWithPath.originalMap().$minus((Object)DataSourceUtils$.MODULE$.CLUSTERING_COLUMNS_KEY());
        Option<Seq<String>> option = this.normalizedClusteringCols();
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq cols = (Seq)some.value();
            map = (scala.collection.immutable.Map)optionsWithoutClusteringKey.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.CLUSTERING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)cols)));
        } else if (None$.MODULE$.equals(option)) {
            map = optionsWithoutClusteringKey;
        } else {
            throw new MatchError(option);
        }
        scala.collection.immutable.Map optionsWithClusteringColumns = map;
        SparkSession x$1 = this.ds.sparkSession();
        String x$2 = this.source();
        scala.collection.immutable.Map x$3 = optionsWithClusteringColumns;
        Seq x$4 = (Seq)this.normalizedParCols().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource ds = new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$4, x$7, (scala.collection.immutable.Map<String, String>)x$3, x$8);
        return ds.createSink(this.outputMode());
    }

    public DataStreamWriter<T> foreach(ForeachWriter<T> writer) {
        return this.foreachImplementation(writer, this.foreachImplementation$default$2());
    }

    public DataStreamWriter<T> foreachImplementation(ForeachWriter<Object> writer, Option<ExpressionEncoder<Object>> encoder) {
        this.source_$eq(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH());
        if (writer == null) {
            throw new IllegalArgumentException("foreach writer cannot be null");
        }
        this.foreachWriter_$eq((ForeachWriter<Object>)((ForeachWriter)this.ds.sparkSession().sparkContext().clean(writer, this.ds.sparkSession().sparkContext().clean$default$2())));
        encoder.foreach((Function1 & Serializable)e -> {
            this.foreachWriterEncoder_$eq((ExpressionEncoder<Object>)e);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public Option<ExpressionEncoder<Object>> foreachImplementation$default$2() {
        return None$.MODULE$;
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(Function2<Dataset<T>, Object, BoxedUnit> function) {
        this.source_$eq(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH());
        if (function == null) {
            throw new IllegalArgumentException("foreachBatch function cannot be null");
        }
        this.foreachBatchWriter_$eq(function);
        return this;
    }

    private Option<Seq<String>> normalizedParCols() {
        return this.partitioningColumns().map((Function1 & Serializable)cols -> (Seq)cols.map((Function1 & Serializable)x$3 -> this.normalize((String)x$3, "Partition")));
    }

    private Option<Seq<String>> normalizedClusteringCols() {
        return this.clusteringColumns().map((Function1 & Serializable)cols -> (Seq)cols.map((Function1 & Serializable)x$4 -> this.normalize((String)x$4, "Clustering")));
    }

    private String normalize(String columnName, String columnType) {
        Seq validColumnNames = (Seq)this.ds.logicalPlan().output().map((Function1 & Serializable)x$5 -> x$5.name());
        return (String)validColumnNames.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DataStreamWriter.$anonfun$normalize$2(this, columnName, x$6))).getOrElse((Function0 & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.columnNotFoundInExistingColumnsError(columnType, columnName, validColumnNames);
        });
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.operationNotSupportPartitioningError(operation);
        }
    }

    private void validatePartitioningAndClustering() {
        if (this.clusteringColumns().nonEmpty() && this.partitioningColumns().nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.clusterByWithPartitionedBy();
        }
    }

    public DataStreamWriter<T> option(String key, boolean value) {
        return (DataStreamWriter)super.option(key, value);
    }

    public DataStreamWriter<T> option(String key, long value) {
        return (DataStreamWriter)super.option(key, value);
    }

    public DataStreamWriter<T> option(String key, double value) {
        return (DataStreamWriter)super.option(key, value);
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(VoidFunction2<Dataset<T>, Long> function) {
        return (DataStreamWriter)super.foreachBatch(function);
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private OutputMode outputMode() {
        return this.outputMode;
    }

    private void outputMode_$eq(OutputMode x$1) {
        this.outputMode = x$1;
    }

    private Trigger trigger() {
        return this.trigger;
    }

    private void trigger_$eq(Trigger x$1) {
        this.trigger = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private ForeachWriter<Object> foreachWriter() {
        return this.foreachWriter;
    }

    private void foreachWriter_$eq(ForeachWriter<Object> x$1) {
        this.foreachWriter = x$1;
    }

    private ExpressionEncoder<Object> foreachWriterEncoder() {
        return this.foreachWriterEncoder;
    }

    private void foreachWriterEncoder_$eq(ExpressionEncoder<Object> x$1) {
        this.foreachWriterEncoder = x$1;
    }

    private Function2<Dataset<T>, Object, BoxedUnit> foreachBatchWriter() {
        return this.foreachBatchWriter;
    }

    private void foreachBatchWriter_$eq(Function2<Dataset<T>, Object, BoxedUnit> x$1) {
        this.foreachBatchWriter = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> clusteringColumns() {
        return this.clusteringColumns;
    }

    private void clusteringColumns_$eq(Option<Seq<String>> x$1) {
        this.clusteringColumns = x$1;
    }

    private final StreamingQuery writeToV1Table$1(CatalogTable table, String tableName$1) {
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw QueryCompilationErrors$.MODULE$.streamingIntoViewNotSupportedError(tableName$1);
        }
        Predef$.MODULE$.require(table.provider().isDefined());
        String string = this.source();
        Object object = table.provider().get();
        if (string == null ? object != null : !string.equals(object)) {
            throw QueryCompilationErrors$.MODULE$.inputSourceDiffersFromDataSourceProviderError(this.source(), tableName$1, table);
        }
        return super.startInternal((Option<String>)new Some((Object)new Path(table.location()).toString()), (Option<CatalogTable>)new Some((Object)table));
    }

    public static final /* synthetic */ boolean $anonfun$startInternal$1(CaseInsensitiveMap optionsWithPath$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return !optionsWithPath$1.contains(k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$normalize$2(DataStreamWriter $this, String columnName$1, String x$6) {
        return BoxesRunTime.unboxToBoolean((Object)$this.ds.sparkSession().sessionState().analyzer().resolver().apply((Object)x$6, (Object)columnName$1));
    }

    public DataStreamWriter(org.apache.spark.sql.classic.Dataset<T> ds) {
        this.ds = ds;
        this.source = ds.sparkSession().sessionState().conf().defaultDataSourceName();
        this.outputMode = OutputMode.Append();
        this.trigger = Trigger.ProcessingTime((long)0L);
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.foreachWriterEncoder = ds.exprEnc();
        this.partitioningColumns = None$.MODULE$;
        this.clusteringColumns = None$.MODULE$;
    }
}

