/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.optimizer.EliminateResolvedHint$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.IgnoreCachedData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.classic.SparkSession$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.CacheManager$;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelationWithTable$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.ExtractV2Table$;
import org.apache.spark.sql.execution.datasources.v2.FileTable;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\teg\u0001\u0002\u0013&\u0001ABQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001A\u0002\u0013%\u0001\nC\u0004U\u0001\u0001\u0007I\u0011B+\t\rm\u0003\u0001\u0015)\u0003J\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u00151\u0007\u0001\"\u0001h\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0019Y\u0007\u0001\"\u0001\u0002\u0004!11\u000e\u0001C\u0001\u0003\u0003Bq!a\u001a\u0001\t\u0013\tI\u0007C\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u0005e\u0004\u0001\"\u0001\u0002\u0012\"9\u0011\u0011\u0010\u0001\u0005\u0002\u0005\u0005\u0006bBA=\u0001\u0011\u0005\u0011Q\u0016\u0005\b\u0003k\u0003A\u0011BA\\\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007Dq!a8\u0001\t\u0013\t\t\u000fC\u0004\u0002v\u0002!I!a>\t\u0011\t%\u0001\u0001\"\u0001(\u0005\u0017AqA!\n\u0001\t\u0003\u00119\u0003C\u0004\u0003.\u0001!IAa\f\t\u000f\te\u0002\u0001\"\u0001\u0003<!9!\u0011\b\u0001\u0005\u0002\t-\u0003b\u0002B*\u0001\u0011%!Q\u000b\u0005\t\u00053\u0002A\u0011A\u0014\u0003\\!9!q\f\u0001\u0005\u0002\t\u0005\u0004b\u0002B0\u0001\u0011\u0005!\u0011\u000e\u0005\b\u0005\u000f\u0003A\u0011\u0002BE\u0011\u001d\u0011\u0019\n\u0001C\u0005\u0005+CqAa+\u0001\t\u0003\u0011i\u000bC\u0004\u00038\u0002!IA!/\b\u000f\tuV\u0005#\u0001\u0003@\u001a1A%\nE\u0001\u0005\u0003DaaQ\u0011\u0005\u0002\t\r\u0007b\u0002BcC\u0011\u0005!q\u0019\u0002\r\u0007\u0006\u001c\u0007.Z'b]\u0006<WM\u001d\u0006\u0003M\u001d\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005!J\u0013aA:rY*\u0011!fK\u0001\u0006gB\f'o\u001b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\tt'\u0010\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005aZT\"A\u001d\u000b\u0005iJ\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005qJ$a\u0002'pO\u001eLgn\u001a\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u0016\n\u0001\"\u00193baRLg/Z\u0005\u0003\u0005~\u0012q#\u00113baRLg/Z*qCJ\\\u0007\u000b\\1o\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005)\u0005C\u0001$\u0001\u001b\u0005)\u0013AC2bG\",G\rR1uCV\t\u0011\nE\u0002K\u001fFk\u0011a\u0013\u0006\u0003\u00196\u000b\u0011\"[7nkR\f'\r\\3\u000b\u00059\u001b\u0014AC2pY2,7\r^5p]&\u0011\u0001k\u0013\u0002\u000b\u0013:$W\r_3e'\u0016\f\bC\u0001$S\u0013\t\u0019VE\u0001\u0006DC\u000eDW\r\u001a#bi\u0006\fabY1dQ\u0016$G)\u0019;b?\u0012*\u0017\u000f\u0006\u0002W3B\u0011!gV\u0005\u00031N\u0012A!\u00168ji\"9!lAA\u0001\u0002\u0004I\u0015a\u0001=%c\u0005Y1-Y2iK\u0012$\u0015\r^1!Q\t!Q\f\u0005\u00023=&\u0011ql\r\u0002\niJ\fgn]5f]RD#\u0001B1\u0011\u0005I\u0012\u0017BA24\u0005!1x\u000e\\1uS2,\u0017AC2mK\u0006\u00148)Y2iKR\ta+A\u0004jg\u0016k\u0007\u000f^=\u0016\u0003!\u0004\"AM5\n\u0005)\u001c$a\u0002\"p_2,\u0017M\\\u0001\u000bG\u0006\u001c\u0007.Z)vKJLHC\u0001,n\u0011\u0015qw\u00011\u0001p\u0003\u0015\tX/\u001a:za\t\u0001\b\u0010E\u0002riZl\u0011A\u001d\u0006\u0003g\u001e\nqa\u00197bgNL7-\u0003\u0002ve\n9A)\u0019;bg\u0016$\bCA<y\u0019\u0001!\u0011\"_7\u0002\u0002\u0003\u0005)\u0011\u0001>\u0003\u0007}#\u0013'\u0005\u0002|}B\u0011!\u0007`\u0005\u0003{N\u0012qAT8uQ&tw\r\u0005\u00023\u007f&\u0019\u0011\u0011A\u001a\u0003\u0007\u0005s\u0017\u0010F\u0004W\u0003\u000b\t\t\"!\r\t\r9D\u0001\u0019AA\u0004a\u0011\tI!!\u0004\u0011\tE$\u00181\u0002\t\u0004o\u00065AaCA\b\u0003\u000b\t\t\u0011!A\u0003\u0002i\u00141a\u0018\u00133\u0011\u001d\t\u0019\u0002\u0003a\u0001\u0003+\t\u0011\u0002^1cY\u0016t\u0015-\\3\u0011\u000bI\n9\"a\u0007\n\u0007\u0005e1G\u0001\u0004PaRLwN\u001c\t\u0005\u0003;\tYC\u0004\u0003\u0002 \u0005\u001d\u0002cAA\u0011g5\u0011\u00111\u0005\u0006\u0004\u0003Ky\u0013A\u0002\u001fs_>$h(C\u0002\u0002*M\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0017\u0003_\u0011aa\u0015;sS:<'bAA\u0015g!9\u00111\u0007\u0005A\u0002\u0005U\u0012\u0001D:u_J\fw-\u001a'fm\u0016d\u0007\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005m\u0012&A\u0004ti>\u0014\u0018mZ3\n\t\u0005}\u0012\u0011\b\u0002\r'R|'/Y4f\u0019\u00164X\r\u001c\u000b\n-\u0006\r\u00131JA2\u0003KBaAK\u0005A\u0002\u0005\u0015\u0003cA9\u0002H%\u0019\u0011\u0011\n:\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000f\u00055\u0013\u00021\u0001\u0002P\u0005Y\u0001\u000f\\1o)>\u001c\u0015m\u00195f!\u0011\t\t&a\u0018\u000e\u0005\u0005M#\u0002BA+\u0003/\nq\u0001\\8hS\u000e\fGN\u0003\u0003\u0002Z\u0005m\u0013!\u00029mC:\u001c(bAA/O\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002b\u0005M#a\u0003'pO&\u001c\u0017\r\u001c)mC:Dq!a\u0005\n\u0001\u0004\t)\u0002C\u0004\u00024%\u0001\r!!\u000e\u0002%\r\f7\r[3Rk\u0016\u0014\u00180\u00138uKJt\u0017\r\u001c\u000b\f-\u0006-\u0014QNA9\u0003k\n9\b\u0003\u0004+\u0015\u0001\u0007\u0011Q\t\u0005\b\u0003_R\u0001\u0019AA(\u0003A)hN\\8s[\u0006d\u0017N_3e!2\fg\u000eC\u0004\u0002t)\u0001\r!a\u0014\u0002\u001d9|'/\\1mSj,G\r\u00157b]\"9\u00111\u0003\u0006A\u0002\u0005U\u0001bBA\u001a\u0015\u0001\u0007\u0011QG\u0001\rk:\u001c\u0017m\u00195f#V,'/\u001f\u000b\b-\u0006u\u0014\u0011RAG\u0011\u0019q7\u00021\u0001\u0002\u0000A\"\u0011\u0011QAC!\u0011\tH/a!\u0011\u0007]\f)\tB\u0006\u0002\b\u0006u\u0014\u0011!A\u0001\u0006\u0003Q(aA0%g!1\u00111R\u0006A\u0002!\fqaY1tG\u0006$W\r\u0003\u0004\u0002\u0010.\u0001\r\u0001[\u0001\tE2|7m[5oOR)a+a%\u0002 \"1a\u000e\u0004a\u0001\u0003+\u0003D!a&\u0002\u001cB!\u0011\u000f^AM!\r9\u00181\u0014\u0003\f\u0003;\u000b\u0019*!A\u0001\u0002\u000b\u0005!PA\u0002`IQBa!a#\r\u0001\u0004AG#\u0003,\u0002$\u0006\u0015\u0016\u0011VAV\u0011\u0019QS\u00021\u0001\u0002F!9\u0011qU\u0007A\u0002\u0005=\u0013\u0001\u00029mC:Da!a#\u000e\u0001\u0004A\u0007BBAH\u001b\u0001\u0007\u0001\u000eF\u0004W\u0003_\u000b\t,a-\t\r)r\u0001\u0019AA#\u0011\u001d\t9K\u0004a\u0001\u0003\u001fBa!a#\u000f\u0001\u0004A\u0017\u0001F;oG\u0006\u001c\u0007.Z)vKJL\u0018J\u001c;fe:\fG\u000eF\u0005W\u0003s\u000bY,!0\u0002@\"1!f\u0004a\u0001\u0003\u000bBq!a*\u0010\u0001\u0004\ty\u0005\u0003\u0004\u0002\f>\u0001\r\u0001\u001b\u0005\u0007\u0003\u001f{\u0001\u0019\u00015\u0002%Ut7-Y2iKR\u000b'\r\\3PeZKWm\u001e\u000b\b-\u0006\u0015\u0017qYAo\u0011\u0019Q\u0003\u00031\u0001\u0002F!9\u0011\u0011\u001a\tA\u0002\u0005-\u0017\u0001\u00028b[\u0016\u0004b!!4\u0002X\u0006ma\u0002BAh\u0003'tA!!\t\u0002R&\tA'C\u0002\u0002VN\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002Z\u0006m'aA*fc*\u0019\u0011Q[\u001a\t\r\u0005-\u0005\u00031\u0001i\u0003QI7/T1uG\",G\rV1cY\u0016|%OV5foR9\u0001.a9\u0002f\u0006\u001d\bbBAT#\u0001\u0007\u0011q\n\u0005\b\u0003\u0013\f\u0002\u0019AAf\u0011\u001d\tI/\u0005a\u0001\u0003W\fAaY8oMB!\u0011Q^Ay\u001b\t\tyO\u0003\u0002;O%!\u00111_Ax\u0005\u001d\u0019\u0016\u000bT\"p]\u001a\f!#\u001e8dC\u000eDWMQ=D_:$\u0017\u000e^5p]RIa+!?\u0002|\n\u0015!q\u0001\u0005\u0007UI\u0001\r!!\u0012\t\u000f\u0005u(\u00031\u0001\u0002\u0000\u0006i\u0011n]'bi\u000eDW\r\u001a)mC:\u0004bA\rB\u0001\u0003\u001fB\u0017b\u0001B\u0002g\tIa)\u001e8di&|g.\r\u0005\u0007\u0003\u0017\u0013\u0002\u0019\u00015\t\r\u0005=%\u00031\u0001i\u0003]\tg.\u00197zu\u0016\u001cu\u000e\\;n]\u000e\u000b7\r[3Rk\u0016\u0014\u0018\u0010F\u0004W\u0005\u001b\u0011\tBa\u0005\t\u000f\t=1\u00031\u0001\u0002F\u0005a1\u000f]1sWN+7o]5p]\")qi\u0005a\u0001#\"9!QC\nA\u0002\t]\u0011AB2pYVlg\u000e\u0005\u0004\u0002N\u0006]'\u0011\u0004\t\u0005\u00057\u0011\t#\u0004\u0002\u0003\u001e)!!qDA.\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\t\r\"Q\u0004\u0002\n\u0003R$(/\u001b2vi\u0016\fQB]3dC\u000eDWMQ=QY\u0006tG#\u0002,\u0003*\t-\u0002B\u0002\u0016\u0015\u0001\u0004\t)\u0005C\u0004\u0002(R\u0001\r!a\u0014\u0002%I,7-Y2iK\nK8i\u001c8eSRLwN\u001c\u000b\u0006-\nE\"1\u0007\u0005\u0007UU\u0001\r!!\u0012\t\u000f\tUR\u00031\u0001\u00038\u0005I1m\u001c8eSRLwN\u001c\t\u0006e\t\u0005\u0011\u000b[\u0001\u0011Y>|7.\u001e9DC\u000eDW\r\u001a#bi\u0006$BA!\u0010\u0003@A!!'a\u0006R\u0011\u0019qg\u00031\u0001\u0003BA\"!1\tB$!\u0011\tHO!\u0012\u0011\u0007]\u00149\u0005B\u0006\u0003J\t}\u0012\u0011!A\u0001\u0006\u0003Q(aA0%kQ1!Q\bB'\u0005#BqAa\u0014\u0018\u0001\u0004\t)%A\u0004tKN\u001c\u0018n\u001c8\t\u000f\u0005\u001dv\u00031\u0001\u0002P\u0005ABn\\8lkB\u001c\u0015m\u00195fI\u0012\u000bG/Y%oi\u0016\u0014h.\u00197\u0015\t\tu\"q\u000b\u0005\b\u0003OC\u0002\u0019AA(\u00035)8/Z\"bG\",G\rR1uCR!\u0011q\nB/\u0011\u001d\t9+\u0007a\u0001\u0003\u001f\nQB]3dC\u000eDWMQ=QCRDG#\u0002,\u0003d\t\u0015\u0004B\u0002\u0016\u001b\u0001\u0004\t)\u0005C\u0004\u0003hi\u0001\r!a\u0007\u0002\u0019I,7o\\;sG\u0016\u0004\u0016\r\u001e5\u0015\u000fY\u0013YG!\u001c\u0003\u0000!1!f\u0007a\u0001\u0003\u000bBqAa\u001a\u001c\u0001\u0004\u0011y\u0007\u0005\u0003\u0003r\tmTB\u0001B:\u0015\u0011\u0011)Ha\u001e\u0002\u0005\u0019\u001c(b\u0001B=W\u00051\u0001.\u00193p_BLAA! \u0003t\t!\u0001+\u0019;i\u0011\u001d\u0011)h\u0007a\u0001\u0005\u0003\u0003BA!\u001d\u0003\u0004&!!Q\u0011B:\u0005)1\u0015\u000e\\3TsN$X-\\\u0001\u0011Y>|7.\u001e9B]\u0012\u0014VM\u001a:fg\"$r\u0001\u001bBF\u0005\u001b\u0013y\tC\u0004\u0002(r\u0001\r!a\u0014\t\u000f\tUD\u00041\u0001\u0003\u0002\"9!\u0011\u0013\u000fA\u0002\t=\u0014!D9vC2Lg-[3e!\u0006$\b.A\u000esK\u001a\u0014Xm\u001d5GS2,\u0017J\u001c3fq&3g*Z2fgN\f'/\u001f\u000b\bQ\n]%q\u0015BU\u0011\u001d\u0011I*\ba\u0001\u00057\u000b\u0011BZ5mK&sG-\u001a=\u0011\t\tu%1U\u0007\u0003\u0005?S1A!)&\u0003-!\u0017\r^1t_V\u00148-Z:\n\t\t\u0015&q\u0014\u0002\n\r&dW-\u00138eKbDqA!\u001e\u001e\u0001\u0004\u0011\t\tC\u0004\u0003\u0012v\u0001\rAa\u001c\u0002\u0011%\u001c8+\u001e2ESJ$R\u0001\u001bBX\u0005gCqA!-\u001f\u0001\u0004\u0011y'A\nrk\u0006d\u0017NZ5fIB\u000bG\u000f\u001b)be\u0016tG\u000fC\u0004\u00036z\u0001\rAa\u001c\u0002%E,\u0018\r\\5gS\u0016$\u0007+\u0019;i\u0007\"LG\u000eZ\u0001 O\u0016$xJ]\"m_:,7+Z:tS>tw+\u001b;i\u0007>tg-[4t\u001f\u001a4G\u0003BA#\u0005wCqAa\u0014 \u0001\u0004\t)%\u0001\u0007DC\u000eDW-T1oC\u001e,'\u000f\u0005\u0002GCM\u0019\u0011%M\u001c\u0015\u0005\t}\u0016!\u00057pO\u000e\u000b7\r[3Pa\u0016\u0014\u0018\r^5p]R\u0019aK!3\t\u0011\t-7\u0005\"a\u0001\u0005\u001b\f\u0011A\u001a\t\u0006e\t='1[\u0005\u0004\u0005#\u001c$\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0007a\u0012).C\u0002\u0003Xf\u0012!#T3tg\u0006<WmV5uQ\u000e{g\u000e^3yi\u0002")
public class CacheManager
implements Logging,
AdaptiveSparkPlanHelper {
    private volatile transient IndexedSeq<CachedData> cachedData;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void logCacheOperation(Function0<MessageWithContext> f) {
        CacheManager$.MODULE$.logCacheOperation(f);
    }

    @Override
    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$(this, p, f);
    }

    @Override
    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$(this, p, f);
    }

    @Override
    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$(this, p, f);
    }

    @Override
    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$(this, p, f);
    }

    @Override
    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, IterableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$(this, p, f);
    }

    @Override
    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$(this, p, pf);
    }

    @Override
    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$(this, p);
    }

    @Override
    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$(this, p, pf);
    }

    @Override
    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$(this, p, f);
    }

    @Override
    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$(this, p);
    }

    @Override
    public Seq<SparkPlan> allChildren(SparkPlan p) {
        return AdaptiveSparkPlanHelper.allChildren$(this, p);
    }

    @Override
    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$(this, p);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private IndexedSeq<CachedData> cachedData() {
        return this.cachedData;
    }

    private void cachedData_$eq(IndexedSeq<CachedData> x$1) {
        this.cachedData = x$1;
    }

    public synchronized void clearCache() {
        this.cachedData().foreach((Function1 & Serializable)x$1 -> {
            CacheManager.$anonfun$clearCache$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$)));
        CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cleared all Dataframe cache entries"}))).log((Seq)Nil$.MODULE$));
    }

    public boolean isEmpty() {
        return this.cachedData().isEmpty();
    }

    public void cacheQuery(Dataset<?> query) {
        this.cacheQuery(query, (Option<String>)None$.MODULE$, StorageLevel$.MODULE$.MEMORY_AND_DISK());
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        this.cacheQueryInternal(query.sparkSession(), query.queryExecution().analyzed(), query.queryExecution().normalized(), tableName, storageLevel);
    }

    public void cacheQuery(SparkSession spark, LogicalPlan planToCache, Option<String> tableName, StorageLevel storageLevel) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, planToCache, QueryExecution$.MODULE$.normalize$default$3());
        this.cacheQueryInternal(spark, planToCache, normalized, tableName, storageLevel);
    }

    private void cacheQueryInternal(SparkSession spark, LogicalPlan unnormalizedPlan, LogicalPlan normalizedPlan, Option<String> tableName, StorageLevel storageLevel) {
        StorageLevel storageLevel2 = storageLevel;
        StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel2 != null ? !storageLevel2.equals(storageLevel3) : storageLevel3 != null)) {
            return;
        }
        if (unnormalizedPlan instanceof IgnoreCachedData) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Asked to cache a plan that is inapplicable for caching: "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.LOGICAL_PLAN, unnormalizedPlan)})))));
            return;
        }
        if (this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(normalizedPlan).nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Asked to cache already cached data.");
            return;
        }
        SparkSession sessionWithConfigsOff = this.getOrCloneSessionWithConfigsOff(spark);
        InMemoryRelation inMemoryRelation = (InMemoryRelation)sessionWithConfigsOff.withActive((Function0 & Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(unnormalizedPlan, sessionWithConfigsOff.sessionState().executePlan$default$2());
            return InMemoryRelation$.MODULE$.apply(storageLevel, qe, tableName);
        });
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            if (this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(normalizedPlan).nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Data has already been cached.");
            } else {
                CachedData cd;
                CachedData cachedData = cd = new CachedData(normalizedPlan, inMemoryRelation);
                this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().$plus$colon((Object)cachedData)));
                CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Added Dataframe cache entry:"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY, cd)}))));
            }
        }
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade, boolean blocking) {
        this.uncacheQueryInternal(query.sparkSession(), query.queryExecution().normalized(), cascade, blocking);
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade) {
        this.uncacheQuery(query, cascade, false);
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, plan, QueryExecution$.MODULE$.normalize$default$3());
        this.uncacheQueryInternal(spark, normalized, cascade, blocking);
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade) {
        this.uncacheQuery(spark, plan, cascade, false);
    }

    private void uncacheQueryInternal(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        this.uncacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.sameResult((QueryPlan)plan)), cascade, blocking);
    }

    public void uncacheTableOrView(SparkSession spark, Seq<String> name, boolean cascade) {
        this.uncacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)this.isMatchedTableOrView(x$3, (Seq<String>)name, spark.sessionState().conf())), cascade, false);
    }

    private boolean isMatchedTableOrView(LogicalPlan plan, Seq<String> name, SQLConf conf) {
        Option option;
        LogicalRelation logicalRelation;
        Option<Tuple2<BaseRelation, Option<CatalogTable>>> option2;
        LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(plan);
        if (logicalPlan2 instanceof LogicalRelation && !(option2 = LogicalRelationWithTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)logicalPlan2)).isEmpty() && (option = (Option)((Tuple2)option2.get())._2()) instanceof Some) {
            Some some = (Some)option;
            CatalogTable catalogTable = (CatalogTable)some.value();
            return CacheManager.isSameName$1(catalogTable.identifier().nameParts(), name, conf);
        }
        if (logicalPlan2 instanceof DataSourceV2Relation) {
            DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2;
            Option option3 = dataSourceV2Relation.catalog();
            Option option4 = dataSourceV2Relation.identifier();
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                CatalogPlugin catalog = (CatalogPlugin)some.value();
                if (option4 instanceof Some) {
                    Some some2 = (Some)option4;
                    Identifier v2Ident = (Identifier)some2.value();
                    return CacheManager.isSameName$1(CatalogV2Implicits$.MODULE$.IdentifierHelper(v2Ident).toQualifiedNameParts(catalog), name, conf);
                }
            }
        }
        if (logicalPlan2 instanceof View) {
            View view = (View)logicalPlan2;
            return CacheManager.isSameName$1(view.desc().identifier().nameParts(), name, conf);
        }
        if (logicalPlan2 instanceof HiveTableRelation) {
            HiveTableRelation hiveTableRelation = (HiveTableRelation)logicalPlan2;
            CatalogTable catalogTable = hiveTableRelation.tableMeta();
            return CacheManager.isSameName$1(catalogTable.identifier().nameParts(), name, conf);
        }
        return false;
    }

    private void uncacheByCondition(SparkSession spark, Function1<LogicalPlan, Object> isMatchedPlan, boolean cascade, boolean blocking) {
        Function1 & Serializable shouldRemove = cascade ? (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.exists(isMatchedPlan)) : isMatchedPlan;
        IndexedSeq plansToUncache = (IndexedSeq)this.cachedData().filter((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$2(shouldRemove, cd)));
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plansToUncache.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$4(cd, x$5)))))));
        }
        plansToUncache.foreach((Function1 & Serializable)x$6 -> {
            CacheManager.$anonfun$uncacheByCondition$5(blocking, x$6);
            return BoxedUnit.UNIT;
        });
        CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Removed ", " Dataframe "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.SIZE, BoxesRunTime.boxToInteger((int)plansToUncache.size()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cache entries, with logical plans being "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\\n[", "]"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.QUERY_PLAN, ((IterableOnceOps)plansToUncache.map((Function1 & Serializable)x$7 -> x$7.plan())).mkString(",\n"))}))));
        if (!cascade) {
            this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$8(isMatchedPlan, cd)));
            return;
        }
    }

    public void analyzeColumnCacheQuery(SparkSession sparkSession, CachedData cachedData, Seq<Attribute> column) {
        InMemoryRelation relation = cachedData.cachedRepresentation();
        Tuple2<Object, scala.collection.immutable.Map<Attribute, ColumnStat>> tuple2 = CommandUtils$.MODULE$.computeColumnStats(sparkSession, relation, column);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long rowCount = tuple2._1$mcJ$sp();
        scala.collection.immutable.Map newColStats = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
        long rowCount2 = tuple22._1$mcJ$sp();
        scala.collection.immutable.Map newColStats2 = (scala.collection.immutable.Map)tuple22._2();
        relation.updateStats(rowCount2, (scala.collection.immutable.Map<Attribute, ColumnStat>)newColStats2);
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, plan, QueryExecution$.MODULE$.normalize$default$3());
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$1(normalized, x$9)));
    }

    private void recacheByCondition(SparkSession spark, Function1<CachedData, Object> condition) {
        IndexedSeq needToRecache = (IndexedSeq)this.cachedData().filter(condition);
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)needToRecache.exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$2(cd, x$11)))))));
        }
        needToRecache.foreach((Function1 & Serializable)cd -> {
            CacheManager.$anonfun$recacheByCondition$3(this, spark, cd);
            return BoxedUnit.UNIT;
        });
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(query.queryExecution().normalized());
    }

    public Option<CachedData> lookupCachedData(SparkSession session, LogicalPlan plan) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(session, plan, QueryExecution$.MODULE$.normalize$default$3());
        return this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(normalized);
    }

    public Option<CachedData> org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(LogicalPlan plan) {
        Option result;
        block0: {
            result = this.cachedData().find((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan())));
            if (!result.isDefined()) break block0;
            CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache hit for input plan:"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", " matched with cache entry:"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.QUERY_PLAN, plan)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY, result.get())}))));
        }
        return result;
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = (LogicalPlan)plan.transformDown((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof IgnoreCachedData) {
                    IgnoreCachedData ignoreCachedData = (IgnoreCachedData)A1;
                    return (B1)ignoreCachedData;
                }
                return (B1)this.$outer.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(A1).map((Function1 & Serializable)cached -> {
                    Seq hints = (Seq)EliminateResolvedHint$.MODULE$.extractHintsFromPlan(A1)._2();
                    InMemoryRelation cachedPlan = cached.cachedRepresentation().withOutput((Seq<Attribute>)A1.output());
                    return (LogicalPlan)hints.foldRight((Object)cachedPlan, (Function2 & Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 != null) {
                            HintInfo hint = (HintInfo)tuple2._1();
                            LogicalPlan p = (LogicalPlan)tuple2._2();
                            return new ResolvedHint(p, hint);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }).getOrElse((Function0 & Serializable)() -> A1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                if (logicalPlan2 instanceof IgnoreCachedData) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.HintInfo org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        LogicalPlan result = newPlan.transformAllExpressionsWithPruning((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())), newPlan.transformAllExpressionsWithPruning$default$2(), (PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    return (B1)subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                return expression instanceof SubqueryExpression;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (result.fastEquals((TreeNode)plan)) {
            CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache miss for input plan:\\n", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.QUERY_PLAN, plan)})));
            CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Last 20 Dataframe cache entry logical plans:\\n"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY, ((IterableOnceOps)((IndexedSeqOps)this.cachedData().take(20)).map((Function1 & Serializable)x$13 -> x$13.plan())).mkString(",\n"))}))));
        } else {
            CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache hit plan change summary:\\n"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.QUERY_PLAN_COMPARISON, org.apache.spark.sql.catalyst.util.package$.MODULE$.sideBySide(plan.treeString(), result.treeString()).mkString("\n"))}))));
        }
        return result;
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        Path path = new Path(resourcePath);
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
        this.recacheByPath(spark, path, fs);
    }

    public void recacheByPath(SparkSession spark, Path resourcePath, FileSystem fs) {
        Path qualifiedPath = fs.makeQualified(resourcePath);
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$1(this, fs, qualifiedPath, x$14)));
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        Table fileTable;
        DataSourceV2Relation dataSourceV2Relation;
        Option option;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                return this.refreshFileIndexIfNecessary(hadoopFsRelation.location(), fs, qualifiedPath);
            }
            return false;
        }
        if (logicalPlan2 instanceof DataSourceV2Relation && !(option = ExtractV2Table$.MODULE$.unapply(dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2)).isEmpty() && (fileTable = (Table)option.get()) instanceof FileTable) {
            FileTable fileTable2 = (FileTable)fileTable;
            return this.refreshFileIndexIfNecessary(fileTable2.fileIndex(), fs, qualifiedPath);
        }
        return false;
    }

    private boolean refreshFileIndexIfNecessary(FileIndex fileIndex, FileSystem fs, Path qualifiedPath) {
        boolean needToRefresh;
        block0: {
            needToRefresh = ((IterableOnceOps)fileIndex.rootPaths().map((Function1 & Serializable)x$16 -> x$16.makeQualified(fs.getUri(), fs.getWorkingDirectory()))).exists((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)this.isSubDir(qualifiedPath, x$17)));
            if (!needToRefresh) break block0;
            fileIndex.refresh();
        }
        return needToRefresh;
    }

    public boolean isSubDir(Path qualifiedPathParent, Path qualifiedPathChild) {
        return package$.MODULE$.Iterator().iterate((Object)qualifiedPathChild, (Function1 & Serializable)x$18 -> x$18.getParent()).takeWhile((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$isSubDir$2(x$19))).exists((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)x$20.equals((Object)qualifiedPathParent)));
    }

    private SparkSession getOrCloneSessionWithConfigsOff(SparkSession session) {
        .colon.colon disableConfigs;
        block0: {
            disableConfigs = new .colon.colon((Object)SQLConf$.MODULE$.AUTO_BUCKETED_SCAN_ENABLED(), (List)Nil$.MODULE$);
            if (BoxesRunTime.unboxToBoolean((Object)session.sessionState().conf().getConf(SQLConf$.MODULE$.CAN_CHANGE_CACHED_PLAN_OUTPUT_PARTITIONING()))) break block0;
            disableConfigs = (Seq)disableConfigs.$colon$plus((Object)SQLConf$.MODULE$.ADAPTIVE_EXECUTION_APPLY_FINAL_STAGE_SHUFFLE_OPTIMIZATIONS());
        }
        return SparkSession$.MODULE$.getOrCloneSessionWithConfigsOff(session, (Seq<ConfigEntry<Object>>)disableConfigs);
    }

    public static final /* synthetic */ void $anonfun$clearCache$1(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    private static final boolean isSameName$1(Seq nameInCache, Seq name$2, SQLConf conf$1) {
        return nameInCache.length() == name$2.length() && ((IterableOnceOps)nameInCache.zip((IterableOnce)name$2)).forall(conf$1.resolver().tupled());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$2(Function1 shouldRemove$1, CachedData cd) {
        return BoxesRunTime.unboxToBoolean((Object)shouldRemove$1.apply((Object)cd.plan()));
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$4(CachedData cd$2, CachedData x$5) {
        return x$5 == cd$2;
    }

    public static final /* synthetic */ void $anonfun$uncacheByCondition$5(boolean blocking$1, CachedData x$6) {
        x$6.cachedRepresentation().cacheBuilder().clearCache(blocking$1);
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$8(Function1 isMatchedPlan$1, CachedData cd) {
        boolean cacheAlreadyLoaded = cd.cachedRepresentation().cacheBuilder().isCachedColumnBuffersLoaded();
        return cd.plan().exists(isMatchedPlan$1) && !cacheAlreadyLoaded;
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$1(LogicalPlan normalized$1, CachedData x$9) {
        return x$9.plan().exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.sameResult((QueryPlan)normalized$1)));
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$2(CachedData cd$3, CachedData x$11) {
        return x$11 == cd$3;
    }

    public static final /* synthetic */ void $anonfun$recacheByCondition$3(CacheManager $this, SparkSession spark$2, CachedData cd) {
        InMemoryRelation newCache;
        cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
        SparkSession sessionWithConfigsOff = $this.getOrCloneSessionWithConfigsOff(spark$2);
        InMemoryRelation x$1 = newCache = (InMemoryRelation)sessionWithConfigsOff.withActive((Function0 & Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(cd.plan(), sessionWithConfigsOff.sessionState().executePlan$default$2());
            return InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder(), qe);
        });
        LogicalPlan x$2 = cd.copy$default$1();
        CachedData recomputedPlan = cd.copy(x$2, x$1);
        CacheManager cacheManager = $this;
        synchronized (cacheManager) {
            if ($this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(recomputedPlan.plan()).nonEmpty()) {
                $this.logWarning((Function0<String>)(Function0 & Serializable)() -> "While recaching, data was already added to cache.");
            } else {
                CachedData cachedData = recomputedPlan;
                $this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)$this.cachedData().$plus$colon((Object)cachedData)));
                CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Re-cached Dataframe cache entry:"}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY, recomputedPlan)}))));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$1(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, CachedData x$14) {
        return x$14.plan().exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$15, fs$1, qualifiedPath$1)));
    }

    public static final /* synthetic */ boolean $anonfun$isSubDir$2(Path x$19) {
        return x$19 != null;
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        AdaptiveSparkPlanHelper.$init$(this);
        this.cachedData = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$);
    }
}

