/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.guava.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sparkproject.connect.checkerframework.checker.nullness.qual.Nullable;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.connect.guava.collect.FluentIterable;
import org.sparkproject.connect.guava.collect.ImmutableList;
import org.sparkproject.connect.guava.reflect.ElementTypesAreNonnullByDefault;
import org.sparkproject.connect.guava.reflect.Invokable;
import org.sparkproject.connect.guava.reflect.TypeToken;

@ElementTypesAreNonnullByDefault
public final class Parameter
implements AnnotatedElement {
    private final Invokable<?, ?> declaration;
    private final int position;
    private final TypeToken<?> type;
    private final ImmutableList<Annotation> annotations;
    private final @Nullable Object annotatedType;

    Parameter(Invokable<?, ?> declaration, int position, TypeToken<?> type, Annotation[] annotations, @Nullable Object annotatedType) {
        this.declaration = declaration;
        this.position = position;
        this.type = type;
        this.annotations = ImmutableList.copyOf(annotations);
        this.annotatedType = annotatedType;
    }

    public TypeToken<?> getType() {
        return this.type;
    }

    public Invokable<?, ?> getDeclaringInvokable() {
        return this.declaration;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation((Class)annotationType) != null;
    }

    @CheckForNull
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        Preconditions.checkNotNull(annotationType);
        for (Annotation annotation : this.annotations) {
            if (!annotationType.isInstance(annotation)) continue;
            return (A)((Annotation)annotationType.cast(annotation));
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        return this.getDeclaredAnnotationsByType(annotationType);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.annotations.toArray(new Annotation[0]);
    }

    @CheckForNull
    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationType) {
        Preconditions.checkNotNull(annotationType);
        return (A)((Annotation)FluentIterable.from(this.annotations).filter(annotationType).first().orNull());
    }

    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> annotationType) {
        Annotation[] result;
        Annotation[] cast = result = (Annotation[])FluentIterable.from(this.annotations).filter(annotationType).toArray(annotationType);
        return cast;
    }

    public AnnotatedType getAnnotatedType() {
        return Objects.requireNonNull((AnnotatedType)this.annotatedType);
    }

    public boolean equals(@CheckForNull Object obj) {
        if (obj instanceof Parameter) {
            Parameter that = (Parameter)obj;
            return this.position == that.position && this.declaration.equals(that.declaration);
        }
        return false;
    }

    public int hashCode() {
        return this.position;
    }

    public String toString() {
        return this.type + " arg" + this.position;
    }
}

