/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UpCast;
import org.apache.spark.sql.catalyst.expressions.objects.LambdaVariable;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class UpCastResolution$
implements SQLConfHelper {
    public static final UpCastResolution$ MODULE$ = new UpCastResolution$();

    static {
        SQLConfHelper.$init$(MODULE$);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    public Expression resolve(UpCast unresolvedUpCast) {
        UpCast upCast = unresolvedUpCast;
        if (upCast != null) {
            AbstractDataType target;
            AbstractDataType abstractDataType = target = upCast.target();
            DecimalType$ decimalType$ = DecimalType$.MODULE$;
            if ((abstractDataType == null ? decimalType$ != null : !abstractDataType.equals(decimalType$)) && !(target instanceof DataType)) {
                throw SparkException$.MODULE$.internalError("UpCast only supports DecimalType as AbstractDataType yet, but got: " + target);
            }
        }
        if (upCast != null) {
            Expression child = upCast.child();
            AbstractDataType target = upCast.target();
            Seq<String> walkedTypePath = upCast.walkedTypePath();
            AbstractDataType abstractDataType = target;
            DecimalType$ decimalType$ = DecimalType$.MODULE$;
            if (!(abstractDataType != null ? !abstractDataType.equals(decimalType$) : decimalType$ != null) && child.dataType() instanceof DecimalType) {
                Predef$.MODULE$.assert(walkedTypePath.nonEmpty(), (Function0 & Serializable)() -> "object DecimalType should only be used inside ExpressionEncoder");
                return child;
            }
        }
        if (upCast != null) {
            Expression child = upCast.child();
            AbstractDataType target = upCast.target();
            if (target instanceof AtomicType) {
                AtomicType atomicType = (AtomicType)target;
                if (BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.LEGACY_LOOSE_UPCAST()))) {
                    DataType dataType = child.dataType();
                    StringType$ stringType$ = StringType$.MODULE$;
                    if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null)) {
                        return new Cast(child, atomicType.asNullable(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                    }
                }
            }
        }
        if (upCast != null) {
            Expression child = upCast.child();
            Seq<String> walkedTypePath = upCast.walkedTypePath();
            if (!Cast$.MODULE$.canUpCast(child.dataType(), upCast.dataType())) {
                throw this.fail(child, upCast.dataType(), walkedTypePath);
            }
        }
        if (upCast != null) {
            Expression child = upCast.child();
            return new Cast(child, upCast.dataType(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
        }
        throw new MatchError((Object)upCast);
    }

    private Nothing$ fail(Expression from, DataType to, Seq<String> walkedTypePath) {
        Expression expression = from;
        String fromStr = expression instanceof LambdaVariable ? "array element" : expression.sql();
        throw QueryCompilationErrors$.MODULE$.upCastFailureError(fromStr, from, to, walkedTypePath);
    }

    private UpCastResolution$() {
    }
}

