/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.InheritAnalysisRules;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeInterval;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TryMakeInterval$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple8;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([years[, months[, weeks[, days[, hours[, mins[, secs]]]]]]]) - This is a special version of `make_interval` that performs the same operation, but returns NULL when an overflow occurs.", arguments="\n    Arguments:\n      * years - the number of years, positive or negative\n      * months - the number of months, positive or negative\n      * weeks - the number of weeks, positive or negative\n      * days - the number of days, positive or negative\n      * hours - the number of hours, positive or negative\n      * mins - the number of minutes, positive or negative\n      * secs - the number of seconds with the fractional part in microsecond precision.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(100, 11, 1, 1, 12, 30, 01.001001);\n       100 years 11 months 8 days 12 hours 30 minutes 1.001001 seconds\n      > SELECT _FUNC_(100, null, 3);\n       NULL\n      > SELECT _FUNC_(0, 1, 0, 1, 0, 0, 100.000001);\n       1 months 1 days 1 minutes 40.000001 seconds\n      > SELECT _FUNC_(2147483647);\n       NULL\n  ", since="4.0.0", group="datetime_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u001dd\u0001B\u001a5\u0001\u0006C\u0001B\u0018\u0001\u0003\u0016\u0004%\ta\u0018\u0005\tA\u0002\u0011\t\u0012)A\u0005\u0005\"A\u0011\r\u0001BK\u0002\u0013\u0005q\f\u0003\u0005c\u0001\tE\t\u0015!\u0003C\u0011!\u0019\u0007A!f\u0001\n\u0003y\u0006\u0002\u00033\u0001\u0005#\u0005\u000b\u0011\u0002\"\t\u0011\u0015\u0004!Q3A\u0005\u0002}C\u0001B\u001a\u0001\u0003\u0012\u0003\u0006IA\u0011\u0005\tO\u0002\u0011)\u001a!C\u0001?\"A\u0001\u000e\u0001B\tB\u0003%!\t\u0003\u0005j\u0001\tU\r\u0011\"\u0001`\u0011!Q\u0007A!E!\u0002\u0013\u0011\u0005\u0002C6\u0001\u0005+\u0007I\u0011A0\t\u00111\u0004!\u0011#Q\u0001\n\tC\u0001\"\u001c\u0001\u0003\u0016\u0004%\ta\u0018\u0005\t]\u0002\u0011\t\u0012)A\u0005\u0005\")q\u000e\u0001C\u0001a\")q\u000e\u0001C\u0001u\"1q\u000e\u0001C\u0001\u0003\u000bAaa\u001c\u0001\u0005\u0002\u0005M\u0001BB8\u0001\t\u0003\ty\u0002\u0003\u0004p\u0001\u0011\u0005\u0011\u0011\u0006\u0005\u0007_\u0002!\t!!\r\t\r=\u0004A\u0011AA\u001c\u0011\u001d\tY\u0004\u0001C)\u0003{Aq!a\u0011\u0001\t\u0003\n)\u0005C\u0004\u0002N\u0001!\t%a\u0014\t\u0013\u0005\u0005\u0004!!A\u0005\u0002\u0005\r\u0004\"CA;\u0001E\u0005I\u0011AA<\u0011%\ti\tAI\u0001\n\u0003\t9\bC\u0005\u0002\u0010\u0002\t\n\u0011\"\u0001\u0002x!I\u0011\u0011\u0013\u0001\u0012\u0002\u0013\u0005\u0011q\u000f\u0005\n\u0003'\u0003\u0011\u0013!C\u0001\u0003oB\u0011\"!&\u0001#\u0003%\t!a\u001e\t\u0013\u0005]\u0005!%A\u0005\u0002\u0005]\u0004\"CAM\u0001E\u0005I\u0011AA<\u0011%\tY\nAA\u0001\n\u0003\ni\nC\u0005\u0002.\u0002\t\t\u0011\"\u0001\u00020\"I\u0011q\u0017\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0018\u0005\n\u0003\u000b\u0004\u0011\u0011!C!\u0003\u000fD\u0011\"!6\u0001\u0003\u0003%\t!a6\t\u0013\u0005\u0005\b!!A\u0005B\u0005\r\b\"CAt\u0001\u0005\u0005I\u0011IAu\u000f%\u0011\u0019\u0002NA\u0001\u0012\u0003\u0011)B\u0002\u00054i\u0005\u0005\t\u0012\u0001B\f\u0011\u0019yW\u0006\"\u0001\u00030!I!\u0011G\u0017\u0002\u0002\u0013\u0015#1\u0007\u0005\n\u0005ki\u0013\u0011!CA\u0005oA\u0011B!\u0013.\u0003\u0003%\tIa\u0013\t\u0013\tuS&!A\u0005\n\t}#a\u0004+ss6\u000b7.Z%oi\u0016\u0014h/\u00197\u000b\u0005U2\u0014aC3yaJ,7o]5p]NT!a\u000e\u001d\u0002\u0011\r\fG/\u00197zgRT!!\u000f\u001e\u0002\u0007M\fHN\u0003\u0002<y\u0005)1\u000f]1sW*\u0011QHP\u0001\u0007CB\f7\r[3\u000b\u0003}\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\"G\u00132\u0013\u0006CA\"E\u001b\u0005!\u0014BA#5\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u0007\u001eK!\u0001\u0013\u001b\u0003%I+h\u000e^5nKJ+\u0007\u000f\\1dK\u0006\u0014G.\u001a\t\u0003\u0007*K!a\u0013\u001b\u0003)%s\u0007.\u001a:ji\u0006s\u0017\r\\=tSN\u0014V\u000f\\3t!\ti\u0005+D\u0001O\u0015\u0005y\u0015!B:dC2\f\u0017BA)O\u0005\u001d\u0001&o\u001c3vGR\u0004\"aU.\u000f\u0005QKfBA+Y\u001b\u00051&BA,A\u0003\u0019a$o\\8u}%\tq*\u0003\u0002[\u001d\u00069\u0001/Y2lC\u001e,\u0017B\u0001/^\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tQf*A\u0003zK\u0006\u00148/F\u0001C\u0003\u0019IX-\u0019:tA\u00051Qn\u001c8uQN\fq!\\8oi\"\u001c\b%A\u0003xK\u0016\\7/\u0001\u0004xK\u0016\\7\u000fI\u0001\u0005I\u0006L8/A\u0003eCf\u001c\b%A\u0003i_V\u00148/\u0001\u0004i_V\u00148\u000fI\u0001\u0005[&t7/A\u0003nS:\u001c\b%\u0001\u0003tK\u000e\u001c\u0018!B:fGN\u0004\u0013a\u0003:fa2\f7-Z7f]R\fAB]3qY\u0006\u001cW-\\3oi\u0002\na\u0001P5oSRtD#C9sgR,ho\u001e=z!\t\u0019\u0005\u0001C\u0003_#\u0001\u0007!\tC\u0003b#\u0001\u0007!\tC\u0003d#\u0001\u0007!\tC\u0003f#\u0001\u0007!\tC\u0003h#\u0001\u0007!\tC\u0003j#\u0001\u0007!\tC\u0003l#\u0001\u0007!\tC\u0003n#\u0001\u0007!\t\u0006\u0006rwrlhp`A\u0001\u0003\u0007AQA\u0018\nA\u0002\tCQ!\u0019\nA\u0002\tCQa\u0019\nA\u0002\tCQ!\u001a\nA\u0002\tCQa\u001a\nA\u0002\tCQ!\u001b\nA\u0002\tCQa\u001b\nA\u0002\t#R\"]A\u0004\u0003\u0013\tY!!\u0004\u0002\u0010\u0005E\u0001\"\u00020\u0014\u0001\u0004\u0011\u0005\"B1\u0014\u0001\u0004\u0011\u0005\"B2\u0014\u0001\u0004\u0011\u0005\"B3\u0014\u0001\u0004\u0011\u0005\"B4\u0014\u0001\u0004\u0011\u0005\"B5\u0014\u0001\u0004\u0011EcC9\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0003;AQA\u0018\u000bA\u0002\tCQ!\u0019\u000bA\u0002\tCQa\u0019\u000bA\u0002\tCQ!\u001a\u000bA\u0002\tCQa\u001a\u000bA\u0002\t#\u0012\"]A\u0011\u0003G\t)#a\n\t\u000by+\u0002\u0019\u0001\"\t\u000b\u0005,\u0002\u0019\u0001\"\t\u000b\r,\u0002\u0019\u0001\"\t\u000b\u0015,\u0002\u0019\u0001\"\u0015\u000fE\fY#!\f\u00020!)aL\u0006a\u0001\u0005\")\u0011M\u0006a\u0001\u0005\")1M\u0006a\u0001\u0005R)\u0011/a\r\u00026!)al\u0006a\u0001\u0005\")\u0011m\u0006a\u0001\u0005R\u0019\u0011/!\u000f\t\u000byC\u0002\u0019\u0001\"\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\r\u0011\u0015q\b\u0005\u0007\u0003\u0003J\u0002\u0019\u0001\"\u0002\u00119,wo\u00115jY\u0012\f!\u0002]1sC6,G/\u001a:t+\t\t9\u0005\u0005\u0003T\u0003\u0013\u0012\u0015bAA&;\n\u00191+Z9\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002RA!\u00111KA.\u001d\u0011\t)&a\u0016\u0011\u0005Us\u0015bAA-\u001d\u00061\u0001K]3eK\u001aLA!!\u0018\u0002`\t11\u000b\u001e:j]\u001eT1!!\u0017O\u0003\u0011\u0019w\u000e]=\u0015#E\f)'a\u001a\u0002j\u0005-\u0014QNA8\u0003c\n\u0019\bC\u0004_9A\u0005\t\u0019\u0001\"\t\u000f\u0005d\u0002\u0013!a\u0001\u0005\"91\r\bI\u0001\u0002\u0004\u0011\u0005bB3\u001d!\u0003\u0005\rA\u0011\u0005\bOr\u0001\n\u00111\u0001C\u0011\u001dIG\u0004%AA\u0002\tCqa\u001b\u000f\u0011\u0002\u0003\u0007!\tC\u0004n9A\u0005\t\u0019\u0001\"\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0010\u0016\u0004\u0005\u0006m4FAA?!\u0011\ty(!#\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u000b\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001de*\u0001\u0006b]:|G/\u0019;j_:LA!a#\u0002\u0002\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY\nabY8qs\u0012\"WMZ1vYR$s'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001d\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\n\u0005\u0003\u0002\"\u0006-VBAAR\u0015\u0011\t)+a*\u0002\t1\fgn\u001a\u0006\u0003\u0003S\u000bAA[1wC&!\u0011QLAR\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\fE\u0002N\u0003gK1!!.O\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY,!1\u0011\u00075\u000bi,C\u0002\u0002@:\u00131!\u00118z\u0011%\t\u0019mJA\u0001\u0002\u0004\t\t,A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0013\u0004b!a3\u0002R\u0006mVBAAg\u0015\r\tyMT\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAj\u0003\u001b\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011\\Ap!\ri\u00151\\\u0005\u0004\u0003;t%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0007L\u0013\u0011!a\u0001\u0003w\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qTAs\u0011%\t\u0019MKA\u0001\u0002\u0004\t\t,\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00033\fY\u000fC\u0005\u0002D.\n\t\u00111\u0001\u0002<\":\u0002!a<\u0002v\u0006]\u00181`A\u007f\u0005\u0003\u0011\u0019Aa\u0002\u0003\n\t5!q\u0002\t\u0004\u0007\u0006E\u0018bAAzi\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA}\u0003\u0005utLR+O\u0007~C3,_3beN\\F\u0006I7p]RD7o\u0017\u0017!o\u0016,7n].-A\u0011\f\u0017p].-A!|WO]:\\Y\u0001j\u0017N\\:\\Y\u0001\u001aXmY:^;vkV,X/*A5\u0002C\u000b[5tA%\u001c\b%\u0019\u0011ta\u0016\u001c\u0017.\u00197!m\u0016\u00148/[8oA=4\u0007\u0005Y7bW\u0016|\u0016N\u001c;feZ\fG\u000e\u0019\u0011uQ\u0006$\b\u0005]3sM>\u0014Xn\u001d\u0011uQ\u0016\u00043/Y7fA=\u0004XM]1uS>tG\u0006\t2vi\u0002\u0012X\r^;s]N\u0004c*\u0016'MA]DWM\u001c\u0011b]\u0002zg/\u001a:gY><\be\\2dkJ\u001ch&A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011q`\u0001\u0004\u0010*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%_3beN\u0004S\u0006\t;iK\u0002rW/\u001c2fe\u0002zg\rI=fCJ\u001cH\u0006\t9pg&$\u0018N^3!_J\u0004c.Z4bi&4XM\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011n_:$\bn\u001d\u0011.AQDW\r\t8v[\n,'\u000fI8gA5|g\u000e\u001e5tY\u0001\u0002xn]5uSZ,\u0007e\u001c:!]\u0016<\u0017\r^5wK*\u0001\u0003\u0005\t\u0011!A)\u0002s/Z3lg\u0002j\u0003\u0005\u001e5fA9,XNY3sA=4\u0007e^3fWNd\u0003\u0005]8tSRLg/\u001a\u0011pe\u0002rWmZ1uSZ,'\u0002\t\u0011!A\u0001\u0002#\u0006\t3bsN\u0004S\u0006\t;iK\u0002rW/\u001c2fe\u0002zg\r\t3bsNd\u0003\u0005]8tSRLg/\u001a\u0011pe\u0002rWmZ1uSZ,'\u0002\t\u0011!A\u0001\u0002#\u0006\t5pkJ\u001c\b%\f\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011i_V\u00148\u000f\f\u0011q_NLG/\u001b<fA=\u0014\bE\\3hCRLg/\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0016![&t7\u000fI\u0017!i\",\u0007E\\;nE\u0016\u0014\be\u001c4![&tW\u000f^3tY\u0001\u0002xn]5uSZ,\u0007e\u001c:!]\u0016<\u0017\r^5wK*\u0001\u0003\u0005\t\u0011!A)\u00023/Z2tA5\u0002C\u000f[3!]Vl'-\u001a:!_\u001a\u00043/Z2p]\u0012\u001c\be^5uQ\u0002\"\b.\u001a\u0011ge\u0006\u001cG/[8oC2\u0004\u0003/\u0019:uA%t\u0007%\\5de>\u001cXmY8oI\u0002\u0002(/Z2jg&|gN\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003\u0006\u0005\u0011\u0019L\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152aAb\u0003%M\u0019-AEb\u0003%\r\u0017!cIb\u0003e\r\u0019-AA\nd\u0006\r\u00192aA\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112aA\u0002\u00130Z1sg\u0002\n\u0014\u0007I7p]RD7\u000f\t\u001d!I\u0006L8\u000fI\u00193A!|WO]:!gA\u0002S.\u001b8vi\u0016\u001c\b%\r\u00181aE\u0002\u0004'\r\u0011tK\u000e|g\u000eZ:\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QE\u0002\u0004\u0007\f\u0011ok2dG\u0006I\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QAb\u0003%\r\u0017!a1\u0002\u0013\u0007\f\u00111Y\u0001\u0002D\u0006I\u00191a9\u0002\u0004\u0007\r\u00191c%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u0011n_:$\bn\u001d\u00112A\u0011\f\u0017p\u001d\u00112A5Lg.\u001e;fg\u0002\"\u0004G\f\u00191aA\u0002\u0014\u0007I:fG>tGm\u001d\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)eE\"t\u0007\u000e\u001d4mQ:\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\t-\u0011!\u0002\u001b/a9\u0002\u0014!B4s_V\u0004\u0018E\u0001B\t\u00039!\u0017\r^3uS6,wLZ;oGN\fq\u0002\u0016:z\u001b\u0006\\W-\u00138uKJ4\u0018\r\u001c\t\u0003\u00076\u001aR!\fB\r\u0005K\u0001RBa\u0007\u0003\"\t\u0013%I\u0011\"C\u0005\n\u000bXB\u0001B\u000f\u0015\r\u0011yBT\u0001\beVtG/[7f\u0013\u0011\u0011\u0019C!\b\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0007\b\u0005\u0003\u0003(\t5RB\u0001B\u0015\u0015\u0011\u0011Y#a*\u0002\u0005%|\u0017b\u0001/\u0003*Q\u0011!QC\u0001\ti>\u001cFO]5oOR\u0011\u0011qT\u0001\u0006CB\u0004H.\u001f\u000b\u0012c\ne\"1\bB\u001f\u0005\u007f\u0011\tEa\u0011\u0003F\t\u001d\u0003\"\u000201\u0001\u0004\u0011\u0005\"B11\u0001\u0004\u0011\u0005\"B21\u0001\u0004\u0011\u0005\"B31\u0001\u0004\u0011\u0005\"B41\u0001\u0004\u0011\u0005\"B51\u0001\u0004\u0011\u0005\"B61\u0001\u0004\u0011\u0005\"B71\u0001\u0004\u0011\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u001b\u0012I\u0006E\u0003N\u0005\u001f\u0012\u0019&C\u0002\u0003R9\u0013aa\u00149uS>t\u0007cC'\u0003V\t\u0013%I\u0011\"C\u0005\nK1Aa\u0016O\u0005\u0019!V\u000f\u001d7fq!A!1L\u0019\u0002\u0002\u0003\u0007\u0011/A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u0019\u0011\t\u0005\u0005&1M\u0005\u0005\u0005K\n\u0019K\u0001\u0004PE*,7\r\u001e")
public class TryMakeInterval
extends Expression
implements RuntimeReplaceable,
InheritAnalysisRules,
Serializable {
    private final Expression years;
    private final Expression months;
    private final Expression weeks;
    private final Expression days;
    private final Expression hours;
    private final Expression mins;
    private final Expression secs;
    private final Expression replacement;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple8<Expression, Expression, Expression, Expression, Expression, Expression, Expression, Expression>> unapply(TryMakeInterval x$0) {
        return TryMakeInterval$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple8<Expression, Expression, Expression, Expression, Expression, Expression, Expression, Expression>, TryMakeInterval> tupled() {
        return TryMakeInterval$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, TryMakeInterval>>>>>>>> curried() {
        return TryMakeInterval$.MODULE$.curried();
    }

    @Override
    public Expression child() {
        return InheritAnalysisRules.child$(this);
    }

    @Override
    public Iterator<Object> flatArguments() {
        return InheritAnalysisRules.flatArguments$(this);
    }

    @Override
    public String makeSQLString(Seq<String> childrenSQL) {
        return InheritAnalysisRules.makeSQLString$(this, childrenSQL);
    }

    @Override
    public final String sql() {
        return InheritAnalysisRules.sql$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        TryMakeInterval tryMakeInterval = this;
        synchronized (tryMakeInterval) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        TryMakeInterval tryMakeInterval = this;
        synchronized (tryMakeInterval) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if (!this.bitmap$0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression years() {
        return this.years;
    }

    public Expression months() {
        return this.months;
    }

    public Expression weeks() {
        return this.weeks;
    }

    public Expression days() {
        return this.days;
    }

    public Expression hours() {
        return this.hours;
    }

    public Expression mins() {
        return this.mins;
    }

    public Expression secs() {
        return this.secs;
    }

    @Override
    public Expression replacement() {
        return this.replacement;
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        Expression x$6 = this.copy$default$5();
        Expression x$7 = this.copy$default$6();
        Expression x$8 = this.copy$default$7();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1);
    }

    @Override
    public Seq<Expression> parameters() {
        return new .colon.colon((Object)this.years(), (List)new .colon.colon((Object)this.months(), (List)new .colon.colon((Object)this.weeks(), (List)new .colon.colon((Object)this.days(), (List)new .colon.colon((Object)this.hours(), (List)new .colon.colon((Object)this.mins(), (List)new .colon.colon((Object)this.secs(), (List)Nil$.MODULE$)))))));
    }

    @Override
    public String prettyName() {
        return "try_make_interval";
    }

    public TryMakeInterval copy(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression secs, Expression replacement) {
        return new TryMakeInterval(years, months, weeks, days, hours, mins, secs, replacement);
    }

    public Expression copy$default$1() {
        return this.years();
    }

    public Expression copy$default$2() {
        return this.months();
    }

    public Expression copy$default$3() {
        return this.weeks();
    }

    public Expression copy$default$4() {
        return this.days();
    }

    public Expression copy$default$5() {
        return this.hours();
    }

    public Expression copy$default$6() {
        return this.mins();
    }

    public Expression copy$default$7() {
        return this.secs();
    }

    public Expression copy$default$8() {
        return this.replacement();
    }

    @Override
    public String productPrefix() {
        return "TryMakeInterval";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.years();
            }
            case 1: {
                return this.months();
            }
            case 2: {
                return this.weeks();
            }
            case 3: {
                return this.days();
            }
            case 4: {
                return this.hours();
            }
            case 5: {
                return this.mins();
            }
            case 6: {
                return this.secs();
            }
            case 7: {
                return this.replacement();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TryMakeInterval;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "years";
            }
            case 1: {
                return "months";
            }
            case 2: {
                return "weeks";
            }
            case 3: {
                return "days";
            }
            case 4: {
                return "hours";
            }
            case 5: {
                return "mins";
            }
            case 6: {
                return "secs";
            }
            case 7: {
                return "replacement";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TryMakeInterval)) return false;
        boolean bl = true;
        if (!bl) return false;
        TryMakeInterval tryMakeInterval = (TryMakeInterval)x$1;
        Expression expression = this.years();
        Expression expression2 = tryMakeInterval.years();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.months();
        Expression expression4 = tryMakeInterval.months();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.weeks();
        Expression expression6 = tryMakeInterval.weeks();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.days();
        Expression expression8 = tryMakeInterval.days();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.hours();
        Expression expression10 = tryMakeInterval.hours();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.mins();
        Expression expression12 = tryMakeInterval.mins();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Expression expression13 = this.secs();
        Expression expression14 = tryMakeInterval.secs();
        if (expression13 == null) {
            if (expression14 != null) {
                return false;
            }
        } else if (!expression13.equals(expression14)) return false;
        Expression expression15 = this.replacement();
        Expression expression16 = tryMakeInterval.replacement();
        if (expression15 == null) {
            if (expression16 != null) {
                return false;
            }
        } else if (!expression15.equals(expression16)) return false;
        if (!tryMakeInterval.canEqual(this)) return false;
        return true;
    }

    public TryMakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression secs, Expression replacement) {
        this.years = years;
        this.months = months;
        this.weeks = weeks;
        this.days = days;
        this.hours = hours;
        this.mins = mins;
        this.secs = secs;
        this.replacement = replacement;
        RuntimeReplaceable.$init$(this);
        UnaryLike.$init$(this);
        InheritAnalysisRules.$init$(this);
        Statics.releaseFence();
    }

    public TryMakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression secs) {
        this(years, months, weeks, days, hours, mins, secs, new MakeInterval(years, months, weeks, days, hours, mins, secs, false));
    }

    public TryMakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins) {
        this(years, months, weeks, days, hours, mins, Literal$.MODULE$.apply(Decimal$.MODULE$.apply(0L, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)));
    }

    public TryMakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours) {
        this(years, months, weeks, days, hours, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public TryMakeInterval(Expression years, Expression months, Expression weeks, Expression days) {
        this(years, months, weeks, days, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public TryMakeInterval(Expression years, Expression months, Expression weeks) {
        this(years, months, weeks, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public TryMakeInterval(Expression years, Expression months) {
        this(years, months, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public TryMakeInterval(Expression years) {
        this(years, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

