% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLContext.R
\name{read.stream}
\alias{read.stream}
\title{Load a streaming SparkDataFrame}
\usage{
read.stream(source = NULL, schema = NULL, ...)
}
\arguments{
\item{source}{The name of external data source}

\item{schema}{The data schema defined in structType or a DDL-formatted string, this is
required for file-based streaming data source}

\item{...}{additional external data source specific named options, for instance \code{path} for
file-based streaming data source. \code{timeZone} to indicate a timezone to be used to
parse timestamps in the JSON/CSV data sources or partition values; If it isn't set, it
uses the default value, session local timezone.}
}
\value{
SparkDataFrame
}
\description{
Returns the dataset in a data source as a SparkDataFrame
}
\details{
The data source is specified by the \code{source} and a set of options(...).
If \code{source} is not specified, the default data source configured by
"spark.sql.sources.default" will be used.
}
\note{
read.stream since 2.2.0

experimental
}
\examples{
\dontrun{
sparkR.session()
df <- read.stream("socket", host = "localhost", port = 9999)
q <- write.stream(df, "text", path = "/home/user/out", checkpointLocation = "/home/user/cp")

df <- read.stream("json", path = jsonDir, schema = schema, maxFilesPerTrigger = 1)
stringSchema <- "name STRING, info MAP<STRING, DOUBLE>"
df1 <- read.stream("json", path = jsonDir, schema = stringSchema, maxFilesPerTrigger = 1)
}
}
\seealso{
\link{write.stream}
}
