/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.highavailability;

import org.apache.flink.runtime.checkpoint.CheckpointStoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum KubernetesCheckpointStoreUtil implements CheckpointStoreUtil
{
    INSTANCE;

    private static final Logger LOG;

    public String checkpointIDToName(long checkpointId) {
        return "checkpointID-" + String.format("%019d", checkpointId);
    }

    public long nameToCheckpointID(String key) {
        try {
            return Long.parseLong(key.substring("checkpointID-".length()));
        }
        catch (NumberFormatException e) {
            LOG.warn("Could not parse checkpoint id from {}. This indicates that the checkpoint id to path conversion has changed.", (Object)key);
            return -1L;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(KubernetesCheckpointStoreUtil.class);
    }
}

