/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.util.Objects;
import javax.net.ssl.SSLEngine;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslContext;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;

public class SSLHandlerFactory {
    private final SslContext sslContext;
    private final int handshakeTimeoutMs;
    private final int closeNotifyFlushTimeoutMs;

    public SSLHandlerFactory(SslContext sslContext, int handshakeTimeoutMs, int closeNotifyFlushTimeoutMs) {
        this.sslContext = Objects.requireNonNull(sslContext, "sslContext must not be null");
        this.handshakeTimeoutMs = handshakeTimeoutMs;
        this.closeNotifyFlushTimeoutMs = closeNotifyFlushTimeoutMs;
    }

    public SslHandler createNettySSLHandler(ByteBufAllocator allocator) {
        return this.createNettySSLHandler(this.createSSLEngine(allocator));
    }

    public SslHandler createNettySSLHandler(ByteBufAllocator allocator, String hostname, int port) {
        return this.createNettySSLHandler(this.createSSLEngine(allocator, hostname, port));
    }

    private SslHandler createNettySSLHandler(SSLEngine sslEngine) {
        SslHandler sslHandler = new SslHandler(sslEngine);
        if (this.handshakeTimeoutMs >= 0) {
            sslHandler.setHandshakeTimeoutMillis((long)this.handshakeTimeoutMs);
        }
        if (this.closeNotifyFlushTimeoutMs >= 0) {
            sslHandler.setCloseNotifyFlushTimeoutMillis((long)this.closeNotifyFlushTimeoutMs);
        }
        return sslHandler;
    }

    private SSLEngine createSSLEngine(ByteBufAllocator allocator) {
        return this.sslContext.newEngine(allocator);
    }

    private SSLEngine createSSLEngine(ByteBufAllocator allocator, String hostname, int port) {
        return this.sslContext.newEngine(allocator, hostname, port);
    }
}

