/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.ExceptionUtils;

public class SnapshotResult<T extends StateObject>
implements StateObject {
    private static final long serialVersionUID = 1L;
    private static final SnapshotResult<?> EMPTY = new SnapshotResult<Object>(null, null);
    private final T jobManagerOwnedSnapshot;
    private final T taskLocalSnapshot;

    private SnapshotResult(T jobManagerOwnedSnapshot, T taskLocalSnapshot) {
        if (jobManagerOwnedSnapshot == null && taskLocalSnapshot != null) {
            throw new IllegalStateException("Cannot report local state snapshot without corresponding remote state!");
        }
        this.jobManagerOwnedSnapshot = jobManagerOwnedSnapshot;
        this.taskLocalSnapshot = taskLocalSnapshot;
    }

    @Nullable
    public T getJobManagerOwnedSnapshot() {
        return this.jobManagerOwnedSnapshot;
    }

    @Nullable
    public T getTaskLocalSnapshot() {
        return this.taskLocalSnapshot;
    }

    @Override
    public void discardState() throws Exception {
        Exception aggregatedExceptions = null;
        if (this.jobManagerOwnedSnapshot != null) {
            try {
                this.jobManagerOwnedSnapshot.discardState();
            }
            catch (Exception remoteDiscardEx) {
                aggregatedExceptions = remoteDiscardEx;
            }
        }
        if (this.taskLocalSnapshot != null) {
            try {
                this.taskLocalSnapshot.discardState();
            }
            catch (Exception localDiscardEx) {
                aggregatedExceptions = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)localDiscardEx, (Throwable)aggregatedExceptions);
            }
        }
        if (aggregatedExceptions != null) {
            throw aggregatedExceptions;
        }
    }

    @Override
    public long getStateSize() {
        return this.jobManagerOwnedSnapshot != null ? this.jobManagerOwnedSnapshot.getStateSize() : 0L;
    }

    public static <T extends StateObject> SnapshotResult<T> empty() {
        return EMPTY;
    }

    public static <T extends StateObject> SnapshotResult<T> of(@Nullable T jobManagerState) {
        return jobManagerState != null ? new SnapshotResult<Object>(jobManagerState, null) : SnapshotResult.empty();
    }

    public static <T extends StateObject> SnapshotResult<T> withLocalState(@Nonnull T jobManagerState, @Nonnull T localState) {
        return new SnapshotResult<T>(jobManagerState, localState);
    }
}

