/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.core.annotation.AppUpdated;
import org.apache.streampark.console.core.entity.Project;
import org.apache.streampark.console.core.enums.GitAuthorizedError;
import org.apache.streampark.console.core.service.ProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="PROJECT_TAG")
@Validated
@RestController
@RequestMapping(value={"flink/project"})
public class ProjectController {
    private static final Logger log = LoggerFactory.getLogger(ProjectController.class);
    @Autowired
    private ProjectService projectService;

    @Operation(summary="Create project")
    @PostMapping(value={"create"})
    @RequiresPermissions(value={"project:create"})
    public RestResponse create(Project project) {
        ApiAlertException.throwIfNull(project.getTeamId(), "The teamId can't be null. Create team failed.");
        return this.projectService.create(project);
    }

    @Operation(summary="Update project")
    @AppUpdated
    @PostMapping(value={"update"})
    @RequiresPermissions(value={"project:update"})
    public RestResponse update(Project project) {
        boolean update = this.projectService.update(project);
        return RestResponse.success().data(update);
    }

    @Operation(summary="Get project")
    @PostMapping(value={"get"})
    public RestResponse get(Long id) {
        return RestResponse.success().data(this.projectService.getById(id));
    }

    @Operation(summary="Build project")
    @PostMapping(value={"build"})
    @RequiresPermissions(value={"project:build"})
    public RestResponse build(Long id) throws Exception {
        this.projectService.build(id);
        return RestResponse.success();
    }

    @Operation(summary="Get project build logs")
    @PostMapping(value={"buildlog"})
    @RequiresPermissions(value={"project:build"})
    public RestResponse buildLog(Long id, @RequestParam(value="startOffset", required=false) Long startOffset) {
        return this.projectService.getBuildLog(id, startOffset);
    }

    @Operation(summary="List projects")
    @PostMapping(value={"list"})
    @RequiresPermissions(value={"project:view"})
    public RestResponse list(Project project, RestRequest restRequest) {
        if (project.getTeamId() == null) {
            return RestResponse.success(Collections.emptyList());
        }
        IPage<Project> page = this.projectService.page(project, restRequest);
        return RestResponse.success().data(page);
    }

    @Operation(summary="List git project branches")
    @PostMapping(value={"branches"})
    public RestResponse branches(Project project) {
        List<String> branches = project.getAllBranches();
        return RestResponse.success().data(branches);
    }

    @Operation(summary="Delete project")
    @PostMapping(value={"delete"})
    @RequiresPermissions(value={"project:delete"})
    public RestResponse delete(Long id) {
        Boolean deleted = this.projectService.delete(id);
        return RestResponse.success().data(deleted);
    }

    @Operation(summary="Authenticate git project")
    @PostMapping(value={"gitcheck"})
    public RestResponse gitCheck(Project project) {
        GitAuthorizedError error = project.gitCheck();
        return RestResponse.success().data(error.getType());
    }

    @Operation(summary="Check the project")
    @PostMapping(value={"exists"})
    public RestResponse exists(Project project) {
        boolean exists = this.projectService.checkExists(project);
        return RestResponse.success().data(exists);
    }

    @Operation(summary="List project modules")
    @PostMapping(value={"modules"})
    public RestResponse modules(Long id) {
        List<String> result = this.projectService.modules(id);
        return RestResponse.success().data(result);
    }

    @Operation(summary="List project jars")
    @PostMapping(value={"jars"})
    public RestResponse jars(Project project) {
        List<String> result = this.projectService.jars(project);
        return RestResponse.success().data(result);
    }

    @Operation(summary="List project configurations")
    @PostMapping(value={"listconf"})
    public RestResponse listConf(Project project) {
        List<Map<String, Object>> list = this.projectService.listConf(project);
        return RestResponse.success().data(list);
    }

    @Operation(summary="List the team projects")
    @PostMapping(value={"select"})
    public RestResponse select(@RequestParam Long teamId) {
        List<Project> list = this.projectService.findByTeamId(teamId);
        return RestResponse.success().data(list);
    }
}

