/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.bean;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.conf.CommonConfig;
import org.apache.streampark.common.conf.InternalConfigHolder;
import org.apache.streampark.common.conf.InternalOption;
import org.apache.streampark.console.core.entity.Setting;
import org.apache.streampark.console.core.service.SettingService;

public class MavenConfig {
    private String mvnSettings;
    private String mvnRepository;
    private String mvnAuthUser;
    private String mvnAuthPassword;

    public static MavenConfig fromSetting(Setting settings) {
        MavenConfig mavenConfig = new MavenConfig();
        String value = settings.getSettingValue();
        switch (settings.getSettingKey()) {
            case "streampark.maven.settings": {
                mavenConfig.setMvnSettings(value);
                break;
            }
            case "streampark.maven.central.repository": {
                mavenConfig.setMvnRepository(value);
                break;
            }
            case "streampark.maven.auth.user": {
                mavenConfig.setMvnAuthUser(value);
                break;
            }
            case "streampark.maven.auth.password": {
                mavenConfig.setMvnAuthPassword(value);
                break;
            }
        }
        return mavenConfig;
    }

    public static MavenConfig fromSetting() {
        MavenConfig mavenConfig = new MavenConfig();
        Map<String, Setting> settings = SettingService.SETTINGS;
        Setting emptySetting = new Setting();
        mavenConfig.setMvnSettings(settings.getOrDefault("streampark.maven.settings", emptySetting).getSettingValue());
        mavenConfig.setMvnRepository(settings.getOrDefault("streampark.maven.central.repository", emptySetting).getSettingValue());
        mavenConfig.setMvnAuthUser(settings.getOrDefault("streampark.maven.auth.user", emptySetting).getSettingValue());
        mavenConfig.setMvnAuthPassword(settings.getOrDefault("streampark.maven.auth.password", emptySetting).getSettingValue());
        return mavenConfig;
    }

    public void updateConfig() {
        if (StringUtils.isNotBlank((CharSequence)this.mvnSettings)) {
            InternalConfigHolder.set((InternalOption)CommonConfig.MAVEN_SETTINGS_PATH(), (Object)this.mvnSettings);
        }
        if (StringUtils.isNotBlank((CharSequence)this.mvnRepository)) {
            InternalConfigHolder.set((InternalOption)CommonConfig.MAVEN_REMOTE_URL(), (Object)this.mvnRepository);
        }
        if (StringUtils.isNotBlank((CharSequence)this.mvnAuthUser)) {
            InternalConfigHolder.set((InternalOption)CommonConfig.MAVEN_AUTH_USER(), (Object)this.mvnAuthUser);
        }
        if (StringUtils.isNotBlank((CharSequence)this.mvnAuthPassword)) {
            InternalConfigHolder.set((InternalOption)CommonConfig.MAVEN_AUTH_PASSWORD(), (Object)this.mvnAuthPassword);
        }
    }

    public String getMvnSettings() {
        return this.mvnSettings;
    }

    public String getMvnRepository() {
        return this.mvnRepository;
    }

    public String getMvnAuthUser() {
        return this.mvnAuthUser;
    }

    public String getMvnAuthPassword() {
        return this.mvnAuthPassword;
    }

    public void setMvnSettings(String mvnSettings) {
        this.mvnSettings = mvnSettings;
    }

    public void setMvnRepository(String mvnRepository) {
        this.mvnRepository = mvnRepository;
    }

    public void setMvnAuthUser(String mvnAuthUser) {
        this.mvnAuthUser = mvnAuthUser;
    }

    public void setMvnAuthPassword(String mvnAuthPassword) {
        this.mvnAuthPassword = mvnAuthPassword;
    }
}

