/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.cp.AppendCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;

public final class MatrixAppendCPInstruction
extends AppendCPInstruction {
    protected MatrixAppendCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, AppendCPInstruction.AppendType type, String opcode, String istr) {
        super(op, in1, in2, out, type, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixBlock matBlock1 = ec.getMatrixInput(this.input1.getName());
        MatrixBlock matBlock2 = ec.getMatrixInput(this.input2.getName());
        if (this._type == AppendCPInstruction.AppendType.CBIND && matBlock1.getNumRows() != matBlock2.getNumRows()) {
            throw new DMLRuntimeException("Append-cbind is not possible for input matrices " + this.input1.getName() + " and " + this.input2.getName() + " with different number of rows: " + matBlock1.getNumRows() + " vs " + matBlock2.getNumRows());
        }
        if (this._type == AppendCPInstruction.AppendType.RBIND && matBlock1.getNumColumns() != matBlock2.getNumColumns()) {
            throw new DMLRuntimeException("Append-rbind is not possible for input matrices " + this.input1.getName() + " and " + this.input2.getName() + " with different number of columns: " + matBlock1.getNumColumns() + " vs " + matBlock2.getNumColumns());
        }
        MatrixBlock ret = matBlock1.append(matBlock2, new MatrixBlock(), this._type == AppendCPInstruction.AppendType.CBIND);
        ec.setMatrixOutput(this.output.getName(), ret);
        ec.releaseMatrixInput(this.input1.getName(), this.input2.getName());
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        String opcode = this._type.toString().toLowerCase();
        return Pair.of((Object)this.output.getName(), (Object)new LineageItem(opcode, LineageItemUtils.getLineage(ec, this.input1, this.input2)));
    }
}

