/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http.internal.services;

import org.apache.tapestry5.http.services.BaseURLSource;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class BaseURLSourceImpl
implements BaseURLSource {
    private final Request request;
    private String hostname;
    private int hostPort;
    private int secureHostPort;

    public BaseURLSourceImpl(Request request, @Inject @Symbol(value="tapestry.hostname") String hostname, @Symbol(value="tapestry.hostport") int hostPort, @Symbol(value="tapestry.hostport-secure") int secureHostPort) {
        this.request = request;
        this.hostname = hostname;
        this.hostPort = hostPort;
        this.secureHostPort = secureHostPort;
    }

    @Override
    public String getBaseURL(boolean secure) {
        return String.format("%s://%s%s", secure ? "https" : "http", this.hostname(), this.portExtension(secure));
    }

    private String portExtension(boolean secure) {
        int expectedPort;
        int configuredPort;
        int n = configuredPort = secure ? this.secureHostPort : this.hostPort;
        if (configuredPort <= 0 && secure == this.request.isSecure()) {
            configuredPort = this.request.getServerPort();
        }
        int n2 = expectedPort = secure ? 443 : 80;
        if (configuredPort == expectedPort || configuredPort <= 0) {
            return "";
        }
        return ":" + configuredPort;
    }

    private String hostname() {
        if (InternalUtils.isBlank((String)this.hostname)) {
            return this.request.getServerName();
        }
        if (this.hostname.startsWith("$")) {
            return System.getenv(this.hostname.substring(1));
        }
        return this.hostname;
    }
}

