Scratch pad for changes destined for the 5.7 release notes page.

# Breaking Changes:

## Non-Internal Classes Moved to Different Packages

This was done to avoid split packages (i.e. packages which appear in more than one JAR) 
in Apache Tapestry and making it easier to be used in projects using Java 9 modules (JPMS).

# Possibly Breaking Changes:

## tapestry-json improvements

To improve intercompatiblity with `java.util.Map` / `java.util.Collection`, the type `JSONObject` now implements `Map<String, Object>`, and `JSONArray` implements `Collection<Object>`.

Existing `JSONObject` code might break due to slightly different method signatures:

```
JSONObject get(String name) => JSONObject get(Object name)
JSONObject putAll(Map<String, ?> newProperties) => void putAll(Map<? extends String, ? extends Object> newProperties)
```

# Non-Breaking Changes:

## tapestry-json improvements

Additionally to the new implemented interfaces, the types itself throw more descriptive `RuntimeException` descendants, with as much as contextual information as possible. They can be found in the package `org.apache.tapestry5.json.exceptions`.

* `JSONArrayIndexOutOfBoundsException`
* `JSONInvalidTypeException`
* `JSONSyntaxException`
* `JSONTypeMismatchException`
* `JSONValueNotFoundException`

The class `JSONCollectors` provides access to `java.util.streams.Collector` for `JSONArray` and `JSONObject`.
