/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.tapestry5.commons.AnnotationProvider;
import org.apache.tapestry5.commons.ObjectCreator;
import org.apache.tapestry5.commons.ObjectLocator;
import org.apache.tapestry5.commons.ObjectProvider;
import org.apache.tapestry5.commons.services.PlasticProxyFactory;
import org.apache.tapestry5.internal.jpa.JpaInternalUtils;
import org.apache.tapestry5.jpa.EntityManagerManager;

public class EntityManagerObjectProvider
implements ObjectProvider {
    private Map<String, EntityManager> emProxyByName = new HashMap<String, EntityManager>();

    public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
        if (objectType.equals(EntityManager.class)) {
            return objectType.cast(this.getOrCreateProxy(annotationProvider, locator));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManager getOrCreateProxy(AnnotationProvider annotationProvider, final ObjectLocator objectLocator) {
        final PersistenceContext annotation = (PersistenceContext)annotationProvider.getAnnotation(PersistenceContext.class);
        String unitName = annotation == null ? null : annotation.unitName();
        EntityManager proxy = this.emProxyByName.get(unitName);
        if (proxy == null) {
            EntityManagerObjectProvider entityManagerObjectProvider = this;
            synchronized (entityManagerObjectProvider) {
                PlasticProxyFactory proxyFactory = (PlasticProxyFactory)objectLocator.getService("PlasticProxyFactory", PlasticProxyFactory.class);
                proxy = (EntityManager)proxyFactory.createProxy(EntityManager.class, new ObjectCreator(){

                    public Object createObject() {
                        EntityManagerManager entityManagerManager = (EntityManagerManager)objectLocator.getService(EntityManagerManager.class);
                        return JpaInternalUtils.getEntityManager(entityManagerManager, annotation);
                    }
                }, "<EntityManagerProxy>");
                this.emProxyByName.put(unitName, proxy);
            }
        }
        return proxy;
    }
}

