/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import javax.persistence.EntityManager;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.commons.services.PropertyAccess;
import org.apache.tapestry5.commons.services.PropertyAdapter;
import org.apache.tapestry5.commons.services.TypeCoercer;
import org.apache.tapestry5.commons.util.ExceptionUtils;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.jpa.EntityManagerManager;
import org.slf4j.Logger;

public class JpaValueEncoder<E>
implements ValueEncoder<E> {
    private final EntityType<E> entity;
    private final EntityManagerManager entityManagerManager;
    private final String persistenceUnitName;
    private final TypeCoercer typeCoercer;
    private final Logger logger;
    private final String idPropertyName;
    private final PropertyAdapter propertyAdapter;

    public JpaValueEncoder(EntityType<E> entity, EntityManagerManager entityManagerManager, String persistenceUnitName, PropertyAccess propertyAccess, TypeCoercer typeCoercer, Logger logger) {
        this.entity = entity;
        this.entityManagerManager = entityManagerManager;
        this.persistenceUnitName = persistenceUnitName;
        this.typeCoercer = typeCoercer;
        this.logger = logger;
        Type idType = this.entity.getIdType();
        SingularAttribute idAttribute = this.entity.getId(idType.getJavaType());
        this.idPropertyName = idAttribute.getName();
        this.propertyAdapter = propertyAccess.getAdapter(entity.getJavaType()).getPropertyAdapter(this.idPropertyName);
    }

    public String toClient(E value) {
        if (value == null) {
            return null;
        }
        Object id = this.propertyAdapter.get(value);
        if (id == null) {
            return null;
        }
        return (String)this.typeCoercer.coerce(id, String.class);
    }

    public E toValue(String clientValue) {
        if (InternalUtils.isBlank((String)clientValue)) {
            return null;
        }
        Object id = null;
        Class entityClass = this.entity.getJavaType();
        try {
            id = this.typeCoercer.coerce((Object)clientValue, this.propertyAdapter.getType());
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Exception converting '%s' to instance of %s (id type for entity %s): %s", clientValue, this.propertyAdapter.getType().getName(), entityClass.getName(), ExceptionUtils.toMessage((Throwable)ex)), ex);
        }
        EntityManager em = this.entityManagerManager.getEntityManager(this.persistenceUnitName);
        Object result = em.find(entityClass, id);
        if (result == null) {
            this.logger.error(String.format("Unable to convert client value '%s' into an entity instance.", clientValue));
        }
        return (E)result;
    }
}

