/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.turbine.Turbine;
import org.apache.turbine.pipeline.PipelineData;

public class HttpUtils {
    private static FastDateFormat httpDateFormat = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy HH:mm:ss z", (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.US);

    public static String formatHttpDate(Date date) {
        return httpDateFormat.format(date);
    }

    public static void setCacheHeaders(PipelineData pipelineData, int expiry) {
        HttpServletResponse response = pipelineData.get(Turbine.class, HttpServletResponse.class);
        if (0 == expiry) {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", System.currentTimeMillis());
        } else {
            response.setDateHeader("Expires", System.currentTimeMillis() + (long)expiry);
        }
    }
}

