/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.callback;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.util.HashSet;
import java.util.Set;
import org.jabsorb.callback.CallbackData;
import org.jabsorb.callback.ErrorInvocationCallback;
import org.jabsorb.callback.InvocationCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackController
implements Serializable {
    private static final long serialVersionUID = 3L;
    private static final Logger log = LoggerFactory.getLogger(CallbackController.class);
    private Set callbackSet = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorCallback(Object context, Object instance, AccessibleObject accessibleObject, Throwable error) {
        Set set = this.callbackSet;
        synchronized (set) {
            for (CallbackData cbdata : this.callbackSet) {
                if (!cbdata.understands(context) || !(cbdata.getCallback() instanceof ErrorInvocationCallback)) continue;
                ErrorInvocationCallback ecb = (ErrorInvocationCallback)cbdata.getCallback();
                try {
                    ecb.invocationError(context, instance, accessibleObject, error);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvokeCallback(Object context, Object instance, AccessibleObject accessibleObject, Object result) throws Exception {
        Set set = this.callbackSet;
        synchronized (set) {
            for (CallbackData cbdata : this.callbackSet) {
                if (!cbdata.understands(context)) continue;
                cbdata.getCallback().postInvoke(context, instance, accessibleObject, result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preInvokeCallback(Object context, Object instance, AccessibleObject accessibleObject, Object[] arguments) throws Exception {
        Set set = this.callbackSet;
        synchronized (set) {
            for (CallbackData cbdata : this.callbackSet) {
                if (!cbdata.understands(context)) continue;
                cbdata.getCallback().preInvoke(context, instance, accessibleObject, arguments);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(InvocationCallback callback, Class contextInterface) {
        Set set = this.callbackSet;
        synchronized (set) {
            this.callbackSet.add(new CallbackData(callback, contextInterface));
        }
        if (log.isDebugEnabled()) {
            log.debug("registered callback " + callback.getClass().getName() + " with context interface " + contextInterface.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(InvocationCallback callback, Class contextInterface) {
        Set set = this.callbackSet;
        synchronized (set) {
            this.callbackSet.remove(new CallbackData(callback, contextInterface));
        }
        if (log.isDebugEnabled()) {
            log.debug("unregistered callback " + callback.getClass().getName() + " with context " + contextInterface.getName());
        }
    }
}

