/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;

class $XPathFactoryFinder {
    private static final String DEFAULT_PACKAGE = "com.sun.org.apache.xpath.internal";
    private static boolean debug = false;
    private static final Properties cacheProps;
    private static volatile boolean firstTime;
    private final ClassLoader classLoader;
    private static final Class<XPathFactory> SERVICE_CLASS;

    private static void debugPrintln(Supplier<String> msgGen) {
        if (debug) {
            System.err.println("JAXP: " + msgGen.get());
        }
    }

    public $XPathFactoryFinder(ClassLoader loader) {
        this.classLoader = loader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == $XPathFactoryFinder.getContextClassLoader()) {
                $XPathFactoryFinder.debugPrintln(() -> "using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            $XPathFactoryFinder.debugPrintln(() -> "using system class loader (" + this.classLoader + ") for search");
            return;
        }
        $XPathFactoryFinder.debugPrintln(() -> "using class loader (" + this.classLoader + ") for search");
    }

    public XPathFactory newFactory(String uri) throws XPathFactoryConfigurationException {
        if (uri == null) {
            throw new NullPointerException();
        }
        XPathFactory f = this._newFactory(uri);
        if (f != null) {
            $XPathFactoryFinder.debugPrintln(() -> "factory '" + f.getClass().getName() + "' was found for " + uri);
        } else {
            $XPathFactoryFinder.debugPrintln(() -> "unable to find a factory for " + uri);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XPathFactory _newFactory(String uri) throws XPathFactoryConfigurationException {
        XPathFactory xpathFactory;
        block18: {
            String propertyName;
            block17: {
                xpathFactory = null;
                propertyName = SERVICE_CLASS.getName() + ":" + uri;
                try {
                    $XPathFactoryFinder.debugPrintln(() -> "Looking up system property '" + propertyName + "'");
                    String r = $XPathFactoryFinder.getSystemProperty(propertyName);
                    if (r != null) {
                        $XPathFactoryFinder.debugPrintln(() -> "The value is '" + r + "'");
                        xpathFactory = this.createInstance(r, true);
                        if (xpathFactory != null) {
                            return xpathFactory;
                        }
                    } else {
                        $XPathFactoryFinder.debugPrintln(() -> "The property is undefined.");
                    }
                }
                catch (Throwable t) {
                    if (!debug) break block17;
                    $XPathFactoryFinder.debugPrintln(() -> "failed to look up system property '" + propertyName + "'");
                    t.printStackTrace();
                }
            }
            String javah = $XPathFactoryFinder.getSystemProperty("java.home");
            String configFile = javah + File.separator + "conf" + File.separator + "jaxp.properties";
            try {
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            File f = new File(configFile);
                            firstTime = false;
                            if ($XPathFactoryFinder.doesFileExist(f)) {
                                $XPathFactoryFinder.debugPrintln(() -> "Read properties file " + f);
                                cacheProps.load($XPathFactoryFinder.getFileInputStream(f));
                            }
                        }
                    }
                }
                String factoryClassName = cacheProps.getProperty(propertyName);
                $XPathFactoryFinder.debugPrintln(() -> "found " + factoryClassName + " in $java.home/conf/jaxp.properties");
                if (factoryClassName != null && (xpathFactory = this.createInstance(factoryClassName, true)) != null) {
                    return xpathFactory;
                }
            }
            catch (Exception ex) {
                if (!debug) break block18;
                ex.printStackTrace();
            }
        }
        assert (xpathFactory == null);
        xpathFactory = this.findServiceProvider(uri);
        if (xpathFactory != null) {
            return xpathFactory;
        }
        if (uri.equals("http://java.sun.com/jaxp/xpath/dom")) {
            $XPathFactoryFinder.debugPrintln(() -> "attempting to use the platform default W3C DOM XPath lib");
            return this.createInstance("com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl", true);
        }
        $XPathFactoryFinder.debugPrintln(() -> "all things were tried, but none was found. bailing out.");
        return null;
    }

    private Class<?> createClass(String className) {
        Class<?> clazz;
        boolean internal = false;
        if (System.getSecurityManager() != null && className != null && className.startsWith(DEFAULT_PACKAGE)) {
            internal = true;
        }
        try {
            clazz = this.classLoader != null && !internal ? Class.forName(className, false, this.classLoader) : Class.forName(className);
        }
        catch (Throwable t) {
            if (debug) {
                t.printStackTrace();
            }
            return null;
        }
        return clazz;
    }

    XPathFactory createInstance(String className) throws XPathFactoryConfigurationException {
        return this.createInstance(className, false);
    }

    XPathFactory createInstance(String className, boolean useServicesMechanism) throws XPathFactoryConfigurationException {
        XPathFactory xPathFactory = null;
        $XPathFactoryFinder.debugPrintln(() -> "createInstance(" + className + ")");
        Class<?> clazz = this.createClass(className);
        if (clazz == null) {
            $XPathFactoryFinder.debugPrintln(() -> "failed to getClass(" + className + ")");
            return null;
        }
        $XPathFactoryFinder.debugPrintln(() -> "loaded " + className + " from " + $XPathFactoryFinder.which(clazz));
        try {
            if (!useServicesMechanism) {
                xPathFactory = $XPathFactoryFinder.newInstanceNoServiceLoader(clazz);
            }
            if (xPathFactory == null) {
                xPathFactory = (XPathFactory)clazz.newInstance();
            }
        }
        catch (ClassCastException classCastException) {
            $XPathFactoryFinder.debugPrintln(() -> "could not instantiate " + clazz.getName());
            if (debug) {
                classCastException.printStackTrace();
            }
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            $XPathFactoryFinder.debugPrintln(() -> "could not instantiate " + clazz.getName());
            if (debug) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }
        catch (InstantiationException instantiationException) {
            $XPathFactoryFinder.debugPrintln(() -> "could not instantiate " + clazz.getName());
            if (debug) {
                instantiationException.printStackTrace();
            }
            return null;
        }
        return xPathFactory;
    }

    private static XPathFactory newInstanceNoServiceLoader(Class<?> providerClass) throws XPathFactoryConfigurationException {
        if (System.getSecurityManager() == null) {
            return null;
        }
        try {
            Method creationMethod = providerClass.getDeclaredMethod("newXPathFactoryNoServiceLoader", new Class[0]);
            int modifiers = creationMethod.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
                return null;
            }
            Class<?> returnType = creationMethod.getReturnType();
            if (SERVICE_CLASS.isAssignableFrom(returnType)) {
                return SERVICE_CLASS.cast(creationMethod.invoke(null, (Object[])null));
            }
            throw new ClassCastException(returnType + " cannot be cast to " + SERVICE_CLASS);
        }
        catch (ClassCastException e) {
            throw new XPathFactoryConfigurationException(e);
        }
        catch (NoSuchMethodException exc) {
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private boolean isObjectModelSupportedBy(final XPathFactory factory, final String objectModel, AccessControlContext acc) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return factory.isObjectModelSupported(objectModel);
            }
        }, acc);
    }

    private XPathFactory findServiceProvider(final String objectModel) throws XPathFactoryConfigurationException {
        assert (objectModel != null);
        final AccessControlContext acc = AccessController.getContext();
        try {
            return AccessController.doPrivileged(new PrivilegedAction<XPathFactory>(){

                @Override
                public XPathFactory run() {
                    ServiceLoader<XPathFactory> loader = ServiceLoader.load(SERVICE_CLASS);
                    for (XPathFactory factory : loader) {
                        if (!$XPathFactoryFinder.this.isObjectModelSupportedBy(factory, objectModel, acc)) continue;
                        return factory;
                    }
                    return null;
                }
            });
        }
        catch (ServiceConfigurationError error) {
            throw new XPathFactoryConfigurationException(error);
        }
    }

    private static String which(Class<?> clazz) {
        return $XPathFactoryFinder.getClassSource(clazz);
    }

    static ClassLoader getContextClassLoader() throws SecurityException {
        return AccessController.doPrivileged(() -> {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            return cl;
        });
    }

    private static String getSystemProperty(String propName) {
        return AccessController.doPrivileged(() -> System.getProperty(propName));
    }

    private static FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(() -> new FileInputStream(file));
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    private static String getClassSource(Class<?> cls) {
        return AccessController.doPrivileged(() -> {
            CodeSource cs = cls.getProtectionDomain().getCodeSource();
            if (cs != null) {
                URL loc = cs.getLocation();
                return loc != null ? loc.toString() : "(no location)";
            }
            return "(no code source)";
        });
    }

    private static boolean doesFileExist(File f) {
        return AccessController.doPrivileged(f::exists);
    }

    static {
        try {
            debug = $XPathFactoryFinder.getSystemProperty("jaxp.debug") != null;
        }
        catch (Exception unused) {
            debug = false;
        }
        cacheProps = new Properties();
        firstTime = true;
        SERVICE_CLASS = XPathFactory.class;
    }
}

