/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class InvalidateTokenRequest
implements Validatable,
ToXContentObject {
    private final String accessToken;
    private final String refreshToken;
    private final String realmName;
    private final String username;

    InvalidateTokenRequest(@Nullable String accessToken, @Nullable String refreshToken) {
        this(accessToken, refreshToken, null, null);
    }

    public InvalidateTokenRequest(@Nullable String accessToken, @Nullable String refreshToken, @Nullable String realmName, @Nullable String username) {
        if (Strings.hasText(realmName) || Strings.hasText(username)) {
            if (Strings.hasText(accessToken)) {
                throw new IllegalArgumentException("access token is not allowed when realm name or username are specified");
            }
            if (refreshToken != null) {
                throw new IllegalArgumentException("refresh token is not allowed when realm name or username are specified");
            }
        } else if (Strings.isNullOrEmpty(accessToken)) {
            if (Strings.isNullOrEmpty(refreshToken)) {
                throw new IllegalArgumentException("Either access token or refresh token is required when neither realm name or username are specified");
            }
        } else if (!Strings.isNullOrEmpty(refreshToken)) {
            throw new IllegalArgumentException("Cannot supply both access token and refresh token");
        }
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.realmName = realmName;
        this.username = username;
    }

    public static InvalidateTokenRequest accessToken(String accessToken) {
        if (Strings.isNullOrEmpty(accessToken)) {
            throw new IllegalArgumentException("token is required");
        }
        return new InvalidateTokenRequest(accessToken, null);
    }

    public static InvalidateTokenRequest refreshToken(String refreshToken) {
        if (Strings.isNullOrEmpty(refreshToken)) {
            throw new IllegalArgumentException("refresh_token is required");
        }
        return new InvalidateTokenRequest(null, refreshToken);
    }

    public static InvalidateTokenRequest realmTokens(String realmName) {
        if (Strings.isNullOrEmpty(realmName)) {
            throw new IllegalArgumentException("realm name is required");
        }
        return new InvalidateTokenRequest(null, null, realmName, null);
    }

    public static InvalidateTokenRequest userTokens(String username) {
        if (Strings.isNullOrEmpty(username)) {
            throw new IllegalArgumentException("username is required");
        }
        return new InvalidateTokenRequest(null, null, null, username);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.accessToken != null) {
            builder.field("token", this.accessToken);
        }
        if (this.refreshToken != null) {
            builder.field("refresh_token", this.refreshToken);
        }
        if (this.realmName != null) {
            builder.field("realm_name", this.realmName);
        }
        if (this.username != null) {
            builder.field("username", this.username);
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvalidateTokenRequest that = (InvalidateTokenRequest)o;
        return Objects.equals(this.accessToken, that.accessToken) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.realmName, that.realmName) && Objects.equals(this.username, that.username);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.refreshToken, this.realmName, this.username);
    }
}

