/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpMessage;
import org.apache.camel.http.common.HttpServletResolveConsumerStrategy;
import org.apache.camel.http.common.ServletResolveConsumerStrategy;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelServlet
extends HttpServlet {
    public static final String ASYNC_PARAM = "async";
    private static final long serialVersionUID = -7061982839117697829L;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String servletName;
    private boolean async;
    private ServletResolveConsumerStrategy servletResolveConsumerStrategy = new HttpServletResolveConsumerStrategy();
    private final ConcurrentMap<String, HttpConsumer> consumers = new ConcurrentHashMap<String, HttpConsumer>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletName = config.getServletName();
        String asyncParam = config.getInitParameter(ASYNC_PARAM);
        this.async = asyncParam == null ? false : ObjectHelper.toBoolean((Object)asyncParam);
        this.log.trace("servlet '{}' initialized with: async={}", new Object[]{this.servletName, this.async});
    }

    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isAsync()) {
            AsyncContext context = req.startAsync();
            context.start(() -> this.doServiceAsync(context));
        } else {
            this.doService(req, resp);
        }
    }

    protected void doServiceAsync(AsyncContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        HttpServletResponse response = (HttpServletResponse)context.getResponse();
        try {
            this.doService(request, response);
        }
        catch (Exception e) {
            this.log.error("Error processing request", (Throwable)e);
            try {
                response.sendError(500);
            }
            catch (Exception e1) {
                this.log.debug("Cannot send reply to client!", (Throwable)e1);
            }
            throw new RuntimeCamelException((Throwable)e);
        }
        finally {
            context.complete();
        }
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.trace("Service: {}", (Object)request);
        HttpConsumer consumer = this.resolve(request);
        if (consumer == null) {
            this.log.debug("No consumer to service request {}", (Object)request);
            response.sendError(404);
            return;
        }
        if (consumer.isSuspended()) {
            this.log.debug("Consumer suspended, cannot service request {}", (Object)request);
            response.sendError(503);
            return;
        }
        if ("OPTIONS".equals(request.getMethod()) && !consumer.isOptionsEnabled()) {
            String s = consumer.getEndpoint().getHttpMethodRestrict() != null ? "OPTIONS," + consumer.getEndpoint().getHttpMethodRestrict() : "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,CONNECT,PATCH";
            response.addHeader("Allow", s);
            response.setStatus(200);
            return;
        }
        if (consumer.getEndpoint().getHttpMethodRestrict() != null && !consumer.getEndpoint().getHttpMethodRestrict().contains(request.getMethod())) {
            response.sendError(405);
            return;
        }
        if ("TRACE".equals(request.getMethod()) && !consumer.isTraceEnabled()) {
            response.sendError(405);
            return;
        }
        Exchange exchange = consumer.getEndpoint().createExchange(ExchangePattern.InOut);
        if (consumer.getEndpoint().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
            exchange.setProperty("CamelSkipWwwFormUrlEncoding", (Object)Boolean.TRUE);
        }
        if (consumer.getEndpoint().isDisableStreamCache()) {
            exchange.setProperty("CamelDisableHttpStreamCache", (Object)Boolean.TRUE);
        }
        ClassLoader oldTccl = this.overrideTccl(exchange);
        HttpHelper.setCharsetFromContentType(request.getContentType(), exchange);
        exchange.setIn((Message)new HttpMessage(exchange, consumer.getEndpoint(), request, response));
        String contextPath = consumer.getEndpoint().getPath();
        exchange.getIn().setHeader("CamelServletContextPath", (Object)contextPath);
        String httpPath = (String)exchange.getIn().getHeader("CamelHttpPath");
        if (contextPath != null && httpPath.startsWith(contextPath)) {
            exchange.getIn().setHeader("CamelHttpPath", (Object)httpPath.substring(contextPath.length()));
        }
        try {
            consumer.createUoW(exchange);
        }
        catch (Exception e) {
            this.log.error("Error processing request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Processing request for exchangeId: {}", (Object)exchange.getExchangeId());
            }
            consumer.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        try {
            Integer bs;
            if (this.log.isTraceEnabled()) {
                this.log.trace("Writing response for exchangeId: {}", (Object)exchange.getExchangeId());
            }
            if ((bs = consumer.getEndpoint().getResponseBufferSize()) != null) {
                this.log.trace("Using response buffer size: {}", (Object)bs);
                response.setBufferSize(bs.intValue());
            }
            consumer.getBinding().writeResponse(exchange, response);
        }
        catch (IOException e) {
            this.log.error("Error processing request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error("Error processing request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            consumer.doneUoW(exchange);
            this.restoreTccl(exchange, oldTccl);
        }
    }

    @Deprecated
    protected HttpConsumer resolve(HttpServletRequest request) {
        return this.getServletResolveConsumerStrategy().resolve(request, this.getConsumers());
    }

    public void connect(HttpConsumer consumer) {
        this.log.debug("Connecting consumer: {}", (Object)consumer);
        this.consumers.put(consumer.getEndpoint().getEndpointUri(), consumer);
    }

    public void disconnect(HttpConsumer consumer) {
        this.log.debug("Disconnecting consumer: {}", (Object)consumer);
        this.consumers.remove(consumer.getEndpoint().getEndpointUri());
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public ServletResolveConsumerStrategy getServletResolveConsumerStrategy() {
        return this.servletResolveConsumerStrategy;
    }

    public void setServletResolveConsumerStrategy(ServletResolveConsumerStrategy servletResolveConsumerStrategy) {
        this.servletResolveConsumerStrategy = servletResolveConsumerStrategy;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public Map<String, HttpConsumer> getConsumers() {
        return Collections.unmodifiableMap(this.consumers);
    }

    protected ClassLoader overrideTccl(Exchange exchange) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader appCtxCl = exchange.getContext().getApplicationContextClassLoader();
        if (oldClassLoader == null || appCtxCl == null) {
            return null;
        }
        if (!oldClassLoader.equals(appCtxCl)) {
            Thread.currentThread().setContextClassLoader(appCtxCl);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Overrode TCCL for exchangeId {} to {} on thread {}", new Object[]{exchange.getExchangeId(), appCtxCl, Thread.currentThread().getName()});
            }
            return oldClassLoader;
        }
        return null;
    }

    protected void restoreTccl(Exchange exchange, ClassLoader oldTccl) {
        if (oldTccl == null) {
            return;
        }
        Thread.currentThread().setContextClassLoader(oldTccl);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Restored TCCL for exchangeId {} to {} on thread {}", (Object[])new String[]{exchange.getExchangeId(), oldTccl.toString(), Thread.currentThread().getName()});
        }
    }
}

