/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.AdviceWithTask;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.EndpointRequiredDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.util.EndpointHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdviceWithTasks {
    private static final Logger LOG = LoggerFactory.getLogger(AdviceWithTasks.class);

    private AdviceWithTasks() {
    }

    public static AdviceWithTask replaceByToString(RouteDefinition route, String toString, ProcessorDefinition<?> replace, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToString matchBy = new MatchByToString(toString);
        return AdviceWithTasks.doReplace(route, matchBy, replace, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask replaceByToUri(RouteDefinition route, String toUri, ProcessorDefinition<?> replace, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToUri matchBy = new MatchByToUri(toUri);
        return AdviceWithTasks.doReplace(route, matchBy, replace, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask replaceById(RouteDefinition route, String id, ProcessorDefinition<?> replace, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchById matchBy = new MatchById(id);
        return AdviceWithTasks.doReplace(route, matchBy, replace, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask replaceByType(RouteDefinition route, Class<?> type, ProcessorDefinition<?> replace, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByType matchBy = new MatchByType(type);
        return AdviceWithTasks.doReplace(route, matchBy, replace, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    private static AdviceWithTask doReplace(final RouteDefinition route, final MatchBy matchBy, final ProcessorDefinition<?> replace, final boolean selectFirst, final boolean selectLast, final int selectFrom, final int selectTo, final int maxDeep) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                Iterator it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
                boolean match = false;
                while (it.hasNext()) {
                    int index;
                    List outputs;
                    ProcessorDefinition output = (ProcessorDefinition)it.next();
                    if (!matchBy.match(output) || (outputs = AdviceWithTasks.getOutputs(output)) == null || (index = outputs.indexOf(output)) == -1) continue;
                    match = true;
                    outputs.add(index + 1, replace);
                    Object old = outputs.remove(index);
                    replace.setParent(output.getParent());
                    LOG.info("AdviceWith ({}) : [{}] --> replace [{}]", new Object[]{matchBy.getId(), old, replace});
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    public static AdviceWithTask removeByToString(RouteDefinition route, String toString, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToString matchBy = new MatchByToString(toString);
        return AdviceWithTasks.doRemove(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask removeByToUri(RouteDefinition route, String toUri, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToUri matchBy = new MatchByToUri(toUri);
        return AdviceWithTasks.doRemove(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask removeById(RouteDefinition route, String id, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchById matchBy = new MatchById(id);
        return AdviceWithTasks.doRemove(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask removeByType(RouteDefinition route, Class<?> type, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByType matchBy = new MatchByType(type);
        return AdviceWithTasks.doRemove(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    private static AdviceWithTask doRemove(final RouteDefinition route, final MatchBy matchBy, final boolean selectFirst, final boolean selectLast, final int selectFrom, final int selectTo, final int maxDeep) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                boolean match = false;
                Iterator it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
                while (it.hasNext()) {
                    int index;
                    List outputs;
                    ProcessorDefinition output = (ProcessorDefinition)it.next();
                    if (!matchBy.match(output) || (outputs = AdviceWithTasks.getOutputs(output)) == null || (index = outputs.indexOf(output)) == -1) continue;
                    match = true;
                    Object old = outputs.remove(index);
                    LOG.info("AdviceWith ({}) : [{}] --> remove", (Object)matchBy.getId(), old);
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    public static AdviceWithTask beforeByToString(RouteDefinition route, String toString, ProcessorDefinition<?> before, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToString matchBy = new MatchByToString(toString);
        return AdviceWithTasks.doBefore(route, matchBy, before, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask beforeByToUri(RouteDefinition route, String toUri, ProcessorDefinition<?> before, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToUri matchBy = new MatchByToUri(toUri);
        return AdviceWithTasks.doBefore(route, matchBy, before, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask beforeById(RouteDefinition route, String id, ProcessorDefinition<?> before, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchById matchBy = new MatchById(id);
        return AdviceWithTasks.doBefore(route, matchBy, before, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask beforeByType(RouteDefinition route, Class<?> type, ProcessorDefinition<?> before, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByType matchBy = new MatchByType(type);
        return AdviceWithTasks.doBefore(route, matchBy, before, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    private static AdviceWithTask doBefore(final RouteDefinition route, final MatchBy matchBy, final ProcessorDefinition<?> before, final boolean selectFirst, final boolean selectLast, final int selectFrom, final int selectTo, final int maxDeep) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                boolean match = false;
                Iterator it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
                while (it.hasNext()) {
                    int index;
                    List outputs;
                    ProcessorDefinition output = (ProcessorDefinition)it.next();
                    if (!matchBy.match(output) || (outputs = AdviceWithTasks.getOutputs(output)) == null || (index = outputs.indexOf(output)) == -1) continue;
                    match = true;
                    Object existing = outputs.get(index);
                    outputs.add(index, before);
                    before.setParent(output.getParent());
                    LOG.info("AdviceWith ({}) : [{}] --> before [{}]", new Object[]{matchBy.getId(), existing, before});
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    public static AdviceWithTask afterByToString(RouteDefinition route, String toString, ProcessorDefinition<?> after, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToString matchBy = new MatchByToString(toString);
        return AdviceWithTasks.doAfter(route, matchBy, after, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask afterByToUri(RouteDefinition route, String toUri, ProcessorDefinition<?> after, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToUri matchBy = new MatchByToUri(toUri);
        return AdviceWithTasks.doAfter(route, matchBy, after, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask afterById(RouteDefinition route, String id, ProcessorDefinition<?> after, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchById matchBy = new MatchById(id);
        return AdviceWithTasks.doAfter(route, matchBy, after, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask afterByType(RouteDefinition route, Class<?> type, ProcessorDefinition<?> after, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByType matchBy = new MatchByType(type);
        return AdviceWithTasks.doAfter(route, matchBy, after, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    private static AdviceWithTask doAfter(final RouteDefinition route, final MatchBy matchBy, final ProcessorDefinition<?> after, final boolean selectFirst, final boolean selectLast, final int selectFrom, final int selectTo, final int maxDeep) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                boolean match = false;
                Iterator it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
                while (it.hasNext()) {
                    int index;
                    List outputs;
                    ProcessorDefinition output = (ProcessorDefinition)it.next();
                    if (!matchBy.match(output) || (outputs = AdviceWithTasks.getOutputs(output)) == null || (index = outputs.indexOf(output)) == -1) continue;
                    match = true;
                    Object existing = outputs.get(index);
                    outputs.add(index + 1, after);
                    after.setParent(output.getParent());
                    LOG.info("AdviceWith ({}) : [{}] --> after [{}]", new Object[]{matchBy.getId(), existing, after});
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    private static List<ProcessorDefinition<?>> getOutputs(ProcessorDefinition<?> node) {
        if (node == null) {
            return null;
        }
        ProcessorDefinition<?> parent = node.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof ChoiceDefinition) {
            return node.getOutputs();
        }
        List<ProcessorDefinition<?>> outputs = parent.getOutputs();
        if (outputs.size() == 1 && outputs.get(0).isAbstract()) {
            outputs = outputs.get(0).getOutputs();
        }
        return outputs;
    }

    public static AdviceWithTask replaceFromWith(final RouteDefinition route, final String uri) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                FromDefinition from = route.getInputs().get(0);
                LOG.info("AdviceWith replace input from [{}] --> [{}]", from.getUriOrRef(), (Object)uri);
                from.setEndpoint(null);
                from.setRef(null);
                from.setUri(uri);
            }
        };
    }

    public static AdviceWithTask replaceFrom(final RouteDefinition route, final Endpoint endpoint) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                FromDefinition from = route.getInputs().get(0);
                LOG.info("AdviceWith replace input from [{}] --> [{}]", from.getUriOrRef(), (Object)endpoint.getEndpointUri());
                from.setRef(null);
                from.setUri(null);
                from.setEndpoint(endpoint);
            }
        };
    }

    private static Iterator<ProcessorDefinition<?>> createMatchByIterator(RouteDefinition route, MatchBy matchBy, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        ArrayList matched = new ArrayList();
        ArrayList outputs = new ArrayList();
        boolean skip = selectFirst || selectLast;
        for (ProcessorDefinition<?> output : route.getOutputs()) {
            if (output instanceof TransactedDefinition) {
                outputs.addAll(output.getOutputs());
                continue;
            }
            if (skip) {
                boolean invalid = outputs.isEmpty() && output.isAbstract();
                if (invalid) continue;
                outputs.add(output);
                continue;
            }
            outputs.add(output);
        }
        Iterator<ProcessorDefinition> itAll = ProcessorDefinitionHelper.filterTypeInOutputs(outputs, ProcessorDefinition.class, maxDeep);
        while (itAll.hasNext()) {
            ProcessorDefinition next = itAll.next();
            if (!matchBy.match(next)) continue;
            matched.add(next);
        }
        return AdviceWithTasks.createSelectorIterator(matched, selectFirst, selectLast, selectFrom, selectTo);
    }

    private static Iterator<ProcessorDefinition<?>> createSelectorIterator(final List<ProcessorDefinition<?>> list, final boolean selectFirst, final boolean selectLast, final int selectFrom, final int selectTo) {
        return new Iterator<ProcessorDefinition<?>>(){
            private int current;
            private boolean done;

            @Override
            public boolean hasNext() {
                if (list.isEmpty() || this.done) {
                    return false;
                }
                if (selectFirst) {
                    this.done = true;
                    this.current = 0;
                    return true;
                }
                if (selectLast) {
                    this.done = true;
                    this.current = list.size() - 1;
                    return true;
                }
                if (selectFrom >= 0 && selectTo >= 0) {
                    if (selectFrom >= list.size() || selectTo >= list.size()) {
                        return false;
                    }
                    if (this.current < selectFrom) {
                        this.current = selectFrom;
                    }
                    return this.current >= selectFrom && this.current <= selectTo;
                }
                return this.current < list.size();
            }

            @Override
            public ProcessorDefinition<?> next() {
                ProcessorDefinition answer = (ProcessorDefinition)list.get(this.current);
                ++this.current;
                return answer;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static final class MatchByType
    implements MatchBy {
        private final Class<?> type;

        private MatchByType(Class<?> type) {
            this.type = type;
        }

        @Override
        public String getId() {
            return this.type.getSimpleName();
        }

        @Override
        public boolean match(ProcessorDefinition<?> processor) {
            return this.type.isAssignableFrom(processor.getClass());
        }
    }

    private static final class MatchByToUri
    implements MatchBy {
        private final String toUri;

        private MatchByToUri(String toUri) {
            this.toUri = toUri;
        }

        @Override
        public String getId() {
            return this.toUri;
        }

        @Override
        public boolean match(ProcessorDefinition<?> processor) {
            if (processor instanceof EndpointRequiredDefinition) {
                String uri = ((EndpointRequiredDefinition)((Object)processor)).getEndpointUri();
                return EndpointHelper.matchPattern(uri, this.toUri);
            }
            return false;
        }
    }

    private static final class MatchByToString
    implements MatchBy {
        private final String toString;

        private MatchByToString(String toString) {
            this.toString = toString;
        }

        @Override
        public String getId() {
            return this.toString;
        }

        @Override
        public boolean match(ProcessorDefinition<?> processor) {
            return EndpointHelper.matchPattern(processor.toString(), this.toString);
        }
    }

    private static final class MatchById
    implements MatchBy {
        private final String id;

        private MatchById(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean match(ProcessorDefinition<?> processor) {
            if (this.id.equals("*")) {
                return true;
            }
            return EndpointHelper.matchPattern(processor.getId(), this.id);
        }
    }

    private static interface MatchBy {
        public String getId();

        public boolean match(ProcessorDefinition<?> var1);
    }
}

