/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ThreadSafeNodeList
implements NodeList {
    private final List<Node> list = new ArrayList<Node>();

    public ThreadSafeNodeList(NodeList source) throws Exception {
        this.init(source);
    }

    @Override
    public Node item(int index) {
        return this.list.get(index);
    }

    @Override
    public int getLength() {
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(NodeList source) throws Exception {
        for (int i = 0; i < source.getLength(); ++i) {
            Node node = source.item(i);
            if (node == null) continue;
            Document document = node.getOwnerDocument();
            synchronized (document) {
                Document doc = new XmlConverter().createDocument();
                Document document2 = node.getOwnerDocument();
                synchronized (document2) {
                    Node clone = doc.importNode(node, true);
                    if (clone instanceof Text) {
                        this.list.add(clone);
                    } else {
                        doc.appendChild(clone);
                        this.list.add(doc.getChildNodes().item(0));
                    }
                }
            }
        }
    }
}

