/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class DiscoveryNodeService
extends AbstractComponent {
    private final List<CustomAttributesProvider> customAttributesProviders = new CopyOnWriteArrayList<CustomAttributesProvider>();

    @Inject
    public DiscoveryNodeService(Settings settings) {
        super(settings);
    }

    public DiscoveryNodeService addCustomAttributeProvider(CustomAttributesProvider customAttributesProvider) {
        this.customAttributesProviders.add(customAttributesProvider);
        return this;
    }

    public Map<String, String> buildAttributes() {
        HashMap<String, String> attributes = Maps.newHashMap(this.settings.getByPrefix("node.").getAsMap());
        attributes.remove("name");
        if (attributes.containsKey("client")) {
            if (((String)attributes.get("client")).equals("false")) {
                attributes.remove("client");
            } else {
                attributes.put("data", "false");
            }
        }
        if (attributes.containsKey("data") && ((String)attributes.get("data")).equals("true")) {
            attributes.remove("data");
        }
        for (CustomAttributesProvider provider : this.customAttributesProviders) {
            try {
                Map<String, String> customAttributes = provider.buildAttributes();
                if (customAttributes == null) continue;
                for (Map.Entry<String, String> entry : customAttributes.entrySet()) {
                    if (attributes.containsKey(entry.getKey())) continue;
                    attributes.put(entry.getKey(), entry.getValue());
                }
            }
            catch (Exception e) {
                this.logger.warn("failed to build custom attributes from provider [{}]", e, provider);
            }
        }
        return attributes;
    }

    public static interface CustomAttributesProvider {
        public Map<String, String> buildAttributes();
    }
}

