/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.ExtendedCommonTermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class CommonTermsQueryParser
implements QueryParser {
    public static final String NAME = "common";
    static final float DEFAULT_MAX_TERM_DOC_FREQ = 0.01f;
    static final BooleanClause.Occur DEFAULT_HIGH_FREQ_OCCUR = BooleanClause.Occur.SHOULD;
    static final BooleanClause.Occur DEFAULT_LOW_FREQ_OCCUR = BooleanClause.Occur.SHOULD;
    static final boolean DEFAULT_DISABLE_COORD = true;

    @Inject
    public CommonTermsQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext, "[common] query malformed, no field", new Object[0]);
        }
        String fieldName = parser.currentName();
        Object value = null;
        float boost = 1.0f;
        String queryAnalyzer = null;
        String lowFreqMinimumShouldMatch = null;
        String highFreqMinimumShouldMatch = null;
        boolean disableCoord = true;
        BooleanClause.Occur highFreqOccur = DEFAULT_HIGH_FREQ_OCCUR;
        BooleanClause.Occur lowFreqOccur = DEFAULT_LOW_FREQ_OCCUR;
        float maxTermFrequency = 0.01f;
        String queryName = null;
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                String op;
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("minimum_should_match".equals(currentFieldName) || "minimumShouldMatch".equals(currentFieldName)) {
                        String innerFieldName = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                innerFieldName = parser.currentName();
                                continue;
                            }
                            if (!token.isValue()) continue;
                            if ("low_freq".equals(innerFieldName) || "lowFreq".equals(innerFieldName)) {
                                lowFreqMinimumShouldMatch = parser.text();
                                continue;
                            }
                            if ("high_freq".equals(innerFieldName) || "highFreq".equals(innerFieldName)) {
                                highFreqMinimumShouldMatch = parser.text();
                                continue;
                            }
                            throw new QueryParsingException(parseContext, "[common] query does not support [" + innerFieldName + "] for [" + currentFieldName + "]", new Object[0]);
                        }
                        continue;
                    }
                    throw new QueryParsingException(parseContext, "[common] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                if (!token.isValue()) continue;
                if ("query".equals(currentFieldName)) {
                    value = parser.objectText();
                    continue;
                }
                if ("analyzer".equals(currentFieldName)) {
                    String analyzer = parser.text();
                    if (parseContext.analysisService().analyzer(analyzer) == null) {
                        throw new QueryParsingException(parseContext, "[common] analyzer [" + parser.text() + "] not found", new Object[0]);
                    }
                    queryAnalyzer = analyzer;
                    continue;
                }
                if ("disable_coord".equals(currentFieldName) || "disableCoord".equals(currentFieldName)) {
                    disableCoord = parser.booleanValue();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if ("high_freq_operator".equals(currentFieldName) || "highFreqOperator".equals(currentFieldName)) {
                    op = parser.text();
                    if ("or".equalsIgnoreCase(op)) {
                        highFreqOccur = BooleanClause.Occur.SHOULD;
                        continue;
                    }
                    if ("and".equalsIgnoreCase(op)) {
                        highFreqOccur = BooleanClause.Occur.MUST;
                        continue;
                    }
                    throw new QueryParsingException(parseContext, "[common] query requires operator to be either 'and' or 'or', not [" + op + "]", new Object[0]);
                }
                if ("low_freq_operator".equals(currentFieldName) || "lowFreqOperator".equals(currentFieldName)) {
                    op = parser.text();
                    if ("or".equalsIgnoreCase(op)) {
                        lowFreqOccur = BooleanClause.Occur.SHOULD;
                        continue;
                    }
                    if ("and".equalsIgnoreCase(op)) {
                        lowFreqOccur = BooleanClause.Occur.MUST;
                        continue;
                    }
                    throw new QueryParsingException(parseContext, "[common] query requires operator to be either 'and' or 'or', not [" + op + "]", new Object[0]);
                }
                if ("minimum_should_match".equals(currentFieldName) || "minimumShouldMatch".equals(currentFieldName)) {
                    lowFreqMinimumShouldMatch = parser.text();
                    continue;
                }
                if ("cutoff_frequency".equals(currentFieldName)) {
                    maxTermFrequency = parser.floatValue();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new QueryParsingException(parseContext, "[common] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            parser.nextToken();
        } else {
            value = parser.objectText();
            token = parser.nextToken();
            if (token != XContentParser.Token.END_OBJECT) {
                throw new QueryParsingException(parseContext, "[common] query parsed in simplified form, with direct field name, but included more options than just the field name, possibly use its 'options' form, with 'query' element?", new Object[0]);
            }
        }
        if (value == null) {
            throw new QueryParsingException(parseContext, "No text specified for text query", new Object[0]);
        }
        MappedFieldType fieldType = parseContext.fieldMapper(fieldName);
        String field = fieldType != null ? fieldType.names().indexName() : fieldName;
        Analyzer analyzer = null;
        if (queryAnalyzer == null) {
            if (fieldType != null) {
                analyzer = fieldType.searchAnalyzer();
            }
            if (analyzer == null && fieldType != null) {
                analyzer = parseContext.getSearchAnalyzer(fieldType);
            }
            if (analyzer == null) {
                analyzer = parseContext.mapperService().searchAnalyzer();
            }
        } else {
            analyzer = parseContext.mapperService().analysisService().analyzer(queryAnalyzer);
            if (analyzer == null) {
                throw new IllegalArgumentException("No analyzer found for [" + queryAnalyzer + "]");
            }
        }
        ExtendedCommonTermsQuery commonsQuery = new ExtendedCommonTermsQuery(highFreqOccur, lowFreqOccur, maxTermFrequency, disableCoord, fieldType);
        commonsQuery.setBoost(boost);
        Query query = this.parseQueryString(commonsQuery, value.toString(), field, parseContext, analyzer, lowFreqMinimumShouldMatch, highFreqMinimumShouldMatch);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }

    private final Query parseQueryString(ExtendedCommonTermsQuery query, String queryString, String field, QueryParseContext parseContext, Analyzer analyzer, String lowFreqMinimumShouldMatch, String highFreqMinimumShouldMatch) throws IOException {
        int count = 0;
        try (TokenStream source = analyzer.tokenStream(field, queryString.toString());){
            source.reset();
            CharTermAttribute termAtt = source.addAttribute(CharTermAttribute.class);
            BytesRefBuilder builder = new BytesRefBuilder();
            while (source.incrementToken()) {
                builder.copyChars(termAtt);
                query.add(new Term(field, builder.toBytesRef()));
                ++count;
            }
        }
        if (count == 0) {
            return null;
        }
        query.setLowFreqMinimumNumberShouldMatch(lowFreqMinimumShouldMatch);
        query.setHighFreqMinimumNumberShouldMatch(highFreqMinimumShouldMatch);
        return query;
    }
}

