/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardRecoveryException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.threadpool.ThreadPool;

public class StoreRecoveryService
extends AbstractIndexShardComponent
implements Closeable {
    private final MappingUpdatedAction mappingUpdatedAction;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final TimeValue waitForMappingUpdatePostRecovery;
    private final CancellableThreads cancellableThreads = new CancellableThreads();
    private static final String SETTING_MAPPING_UPDATE_WAIT_LEGACY = "index.gateway.wait_for_mapping_update_post_recovery";
    private static final String SETTING_MAPPING_UPDATE_WAIT = "index.shard.wait_for_mapping_update_post_recovery";
    private final RestoreService restoreService;
    private final RepositoriesService repositoriesService;

    @Inject
    public StoreRecoveryService(ShardId shardId, IndexSettingsService indexSettingsService, ThreadPool threadPool, MappingUpdatedAction mappingUpdatedAction, ClusterService clusterService, RepositoriesService repositoriesService, RestoreService restoreService) {
        super(shardId, indexSettingsService.getSettings());
        this.threadPool = threadPool;
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.restoreService = restoreService;
        this.repositoriesService = repositoriesService;
        this.clusterService = clusterService;
        this.waitForMappingUpdatePostRecovery = this.indexSettings.getAsTime(SETTING_MAPPING_UPDATE_WAIT, this.indexSettings.getAsTime(SETTING_MAPPING_UPDATE_WAIT_LEGACY, TimeValue.timeValueSeconds(15L)));
    }

    public void recover(final IndexShard indexShard, final boolean indexShouldExists, final RecoveryListener listener) throws IndexShardRecoveryException {
        if (indexShard.state() == IndexShardState.CLOSED) {
            listener.onIgnoreRecovery("shard closed");
            return;
        }
        if (!indexShard.routingEntry().primary()) {
            listener.onRecoveryFailed(new IndexShardRecoveryException(this.shardId, "Trying to recover when the shard is in backup state", null));
            return;
        }
        try {
            if (indexShard.routingEntry().restoreSource() != null) {
                indexShard.recovering("from snapshot", RecoveryState.Type.SNAPSHOT, indexShard.routingEntry().restoreSource());
            } else {
                indexShard.recovering("from store", RecoveryState.Type.STORE, this.clusterService.localNode());
            }
        }
        catch (IllegalIndexShardStateException e) {
            listener.onIgnoreRecovery("already in recovering process, " + e.getMessage());
            return;
        }
        this.threadPool.generic().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    RecoveryState recoveryState = indexShard.recoveryState();
                    if (indexShard.routingEntry().restoreSource() != null) {
                        StoreRecoveryService.this.logger.debug("restoring from {} ...", indexShard.routingEntry().restoreSource());
                        StoreRecoveryService.this.restore(indexShard, recoveryState);
                    } else {
                        StoreRecoveryService.this.logger.debug("starting recovery from shard_store ...", new Object[0]);
                        StoreRecoveryService.this.recoverFromStore(indexShard, indexShouldExists, recoveryState);
                    }
                    IndexShardState shardState = indexShard.state();
                    assert (shardState != IndexShardState.CREATED && shardState != IndexShardState.RECOVERING) : "recovery process of " + StoreRecoveryService.this.shardId + " didn't get to post_recovery. shardState [" + (Object)((Object)shardState) + "]";
                    if (StoreRecoveryService.this.logger.isTraceEnabled()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("recovery completed from ").append("shard_store").append(", took [").append(TimeValue.timeValueMillis(recoveryState.getTimer().time())).append("]\n");
                        RecoveryState.Index index = recoveryState.getIndex();
                        sb.append("    index    : files           [").append(index.totalFileCount()).append("] with total_size [").append(new ByteSizeValue(index.totalBytes())).append("], took[").append(TimeValue.timeValueMillis(index.time())).append("]\n");
                        sb.append("             : recovered_files [").append(index.recoveredFileCount()).append("] with total_size [").append(new ByteSizeValue(index.recoveredBytes())).append("]\n");
                        sb.append("             : reusing_files   [").append(index.reusedFileCount()).append("] with total_size [").append(new ByteSizeValue(index.reusedBytes())).append("]\n");
                        sb.append("    verify_index    : took [").append(TimeValue.timeValueMillis(recoveryState.getVerifyIndex().time())).append("], check_index [").append(TimeValue.timeValueMillis(recoveryState.getVerifyIndex().checkIndexTime())).append("]\n");
                        sb.append("    translog : number_of_operations [").append(recoveryState.getTranslog().recoveredOperations()).append("], took [").append(TimeValue.timeValueMillis(recoveryState.getTranslog().time())).append("]");
                        StoreRecoveryService.this.logger.trace(sb.toString(), new Object[0]);
                    } else if (StoreRecoveryService.this.logger.isDebugEnabled()) {
                        StoreRecoveryService.this.logger.debug("recovery completed from [shard_store], took [{}]", TimeValue.timeValueMillis(recoveryState.getTimer().time()));
                    }
                    listener.onRecoveryDone();
                }
                catch (IndexShardRecoveryException e) {
                    if (indexShard.state() == IndexShardState.CLOSED) {
                        listener.onIgnoreRecovery("shard closed");
                        return;
                    }
                    if (e.getCause() instanceof IndexShardClosedException || e.getCause() instanceof IndexShardNotStartedException) {
                        listener.onIgnoreRecovery("shard closed");
                        return;
                    }
                    listener.onRecoveryFailed(e);
                }
                catch (IndexShardClosedException e) {
                    listener.onIgnoreRecovery("shard closed");
                }
                catch (IndexShardNotStartedException e) {
                    listener.onIgnoreRecovery("shard closed");
                }
                catch (Exception e) {
                    if (indexShard.state() == IndexShardState.CLOSED) {
                        listener.onIgnoreRecovery("shard closed");
                        return;
                    }
                    listener.onRecoveryFailed(new IndexShardRecoveryException(StoreRecoveryService.this.shardId, "failed recovery", e));
                }
            }
        });
    }

    private void recoverFromStore(IndexShard indexShard, boolean indexShouldExists, RecoveryState recoveryState) throws IndexShardRecoveryException {
        indexShard.prepareForIndexRecovery();
        long version = -1L;
        SegmentInfos si = null;
        Store store = indexShard.store();
        store.incRef();
        try {
            try {
                block19: {
                    store.failIfCorrupted();
                    try {
                        si = store.readLastCommittedSegmentsInfo();
                    }
                    catch (Throwable e) {
                        String files = "_unknown_";
                        try {
                            files = Arrays.toString(store.directory().listAll());
                        }
                        catch (Throwable e1) {
                            files = files + " (failure=" + ExceptionsHelper.detailedMessage(e1) + ")";
                        }
                        if (!indexShouldExists) break block19;
                        throw new IndexShardRecoveryException(this.shardId(), "shard allocated for local recovery (post api), should exist, but doesn't, current files: " + files, e);
                    }
                }
                if (si != null) {
                    if (indexShouldExists) {
                        version = si.getVersion();
                    } else {
                        this.logger.trace("cleaning existing shard, shouldn't exists", new Object[0]);
                        IndexWriter writer = new IndexWriter(store.directory(), new IndexWriterConfig(Lucene.STANDARD_ANALYZER).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
                        writer.close();
                        recoveryState.getTranslog().totalOperations(0);
                    }
                }
            }
            catch (Throwable e) {
                throw new IndexShardRecoveryException(this.shardId(), "failed to fetch index version after copying it over", e);
            }
            recoveryState.getIndex().updateVersion(version);
            try {
                RecoveryState.Index index = recoveryState.getIndex();
                if (si != null) {
                    Directory directory = store.directory();
                    for (String name : Lucene.files(si)) {
                        long length = directory.fileLength(name);
                        index.addFileDetail(name, length, true);
                    }
                }
            }
            catch (IOException e) {
                this.logger.debug("failed to list file details", e, new Object[0]);
            }
            Map<String, Mapping> typesToUpdate = indexShard.performTranslogRecovery(indexShouldExists);
            indexShard.finalizeRecovery();
            String indexName = indexShard.shardId().index().name();
            for (Map.Entry<String, Mapping> entry : typesToUpdate.entrySet()) {
                this.validateMappingUpdate(indexName, entry.getKey(), entry.getValue());
            }
            indexShard.postRecovery("post recovery from shard_store");
        }
        catch (EngineException e) {
            throw new IndexShardRecoveryException(this.shardId, "failed to recovery from gateway", e);
        }
        finally {
            store.decRef();
        }
    }

    private void validateMappingUpdate(String indexName, final String type, Mapping update) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference error = new AtomicReference();
        this.mappingUpdatedAction.updateMappingOnMaster(indexName, type, update, this.waitForMappingUpdatePostRecovery, new MappingUpdatedAction.MappingUpdateListener(){

            @Override
            public void onMappingUpdate() {
                latch.countDown();
            }

            @Override
            public void onFailure(Throwable t) {
                latch.countDown();
                error.set(t);
            }
        });
        this.cancellableThreads.execute(new CancellableThreads.Interruptable(){

            @Override
            public void run() throws InterruptedException {
                try {
                    if (!latch.await(StoreRecoveryService.this.waitForMappingUpdatePostRecovery.millis(), TimeUnit.MILLISECONDS)) {
                        StoreRecoveryService.this.logger.debug("waited for mapping update on master for [{}], yet timed out", type);
                    } else if (error.get() != null) {
                        throw new IndexShardRecoveryException(StoreRecoveryService.this.shardId, "Failed to propagate mappings on master post recovery", (Throwable)error.get());
                    }
                }
                catch (InterruptedException e) {
                    StoreRecoveryService.this.logger.debug("interrupted while waiting for mapping update", new Object[0]);
                    throw e;
                }
            }
        });
    }

    private void restore(IndexShard indexShard, RecoveryState recoveryState) {
        RestoreSource restoreSource = indexShard.routingEntry().restoreSource();
        if (restoreSource == null) {
            throw new IndexShardRestoreFailedException(this.shardId, "empty restore source");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] restoring shard  [{}]", restoreSource.snapshotId(), this.shardId);
        }
        try {
            recoveryState.getTranslog().totalOperations(0);
            recoveryState.getTranslog().totalOperationsOnStart(0);
            indexShard.prepareForIndexRecovery();
            IndexShardRepository indexShardRepository = this.repositoriesService.indexShardRepository(restoreSource.snapshotId().getRepository());
            ShardId snapshotShardId = this.shardId;
            if (!this.shardId.getIndex().equals(restoreSource.index())) {
                snapshotShardId = new ShardId(restoreSource.index(), this.shardId.id());
            }
            indexShardRepository.restore(restoreSource.snapshotId(), restoreSource.version(), this.shardId, snapshotShardId, recoveryState);
            indexShard.skipTranslogRecovery();
            indexShard.finalizeRecovery();
            indexShard.postRecovery("restore done");
            this.restoreService.indexShardRestoreCompleted(restoreSource.snapshotId(), this.shardId);
        }
        catch (Throwable t) {
            if (Lucene.isCorruptionException(t)) {
                this.restoreService.failRestore(restoreSource.snapshotId(), this.shardId());
            }
            throw new IndexShardRestoreFailedException(this.shardId, "restore failed", t);
        }
    }

    @Override
    public void close() {
        this.cancellableThreads.cancel("closed");
    }

    public static interface RecoveryListener {
        public void onRecoveryDone();

        public void onIgnoreRecovery(String var1);

        public void onRecoveryFailed(IndexShardRecoveryException var1);
    }
}

