/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import com.carrotsearch.hppc.IntObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.memory.ExtendedMemoryIndex;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.percolate.PercolateResponse;
import org.elasticsearch.action.percolate.PercolateShardRequest;
import org.elasticsearch.action.percolate.PercolateShardResponse;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.HasContextAndHeaders;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.percolator.stats.ShardPercolateService;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.percolator.MultiDocumentPercolatorIndex;
import org.elasticsearch.percolator.PercolateContext;
import org.elasticsearch.percolator.PercolateException;
import org.elasticsearch.percolator.PercolatorIndex;
import org.elasticsearch.percolator.QueryCollector;
import org.elasticsearch.percolator.SingleDocumentPercolatorIndex;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.AggregationPhase;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.HighlightPhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortParseElement;

public class PercolatorService
extends AbstractComponent {
    public static final float NO_SCORE = Float.NEGATIVE_INFINITY;
    public static final String TYPE_NAME = ".percolator";
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final IndicesService indicesService;
    private final IntObjectHashMap<PercolatorType> percolatorTypes;
    private final PageCacheRecycler pageCacheRecycler;
    private final BigArrays bigArrays;
    private final ClusterService clusterService;
    private final PercolatorIndex single;
    private final PercolatorIndex multi;
    private final HighlightPhase highlightPhase;
    private final AggregationPhase aggregationPhase;
    private final SortParseElement sortParseElement;
    private final ScriptService scriptService;
    private final MappingUpdatedAction mappingUpdatedAction;
    private final CloseableThreadLocal<MemoryIndex> cache;
    private final ParseFieldMatcher parseFieldMatcher;
    private final PercolatorType countPercolator = new PercolatorType(){

        @Override
        public byte id() {
            return 1;
        }

        @Override
        public ReduceResult reduce(List<PercolateShardResponse> shardResults, HasContextAndHeaders headersContext) {
            long finalCount = 0L;
            for (PercolateShardResponse shardResponse : shardResults) {
                finalCount += shardResponse.count();
            }
            assert (!shardResults.isEmpty());
            InternalAggregations reducedAggregations = PercolatorService.this.reduceAggregations(shardResults, headersContext);
            return new ReduceResult(finalCount, reducedAggregations);
        }

        @Override
        public PercolateShardResponse doPercolate(PercolateShardRequest request, PercolateContext context, boolean isNested) {
            long count = 0L;
            for (Map.Entry entry : context.percolateQueries().entrySet()) {
                try {
                    Query existsQuery = (Query)entry.getValue();
                    if (isNested) {
                        existsQuery = new BooleanQuery.Builder().add(existsQuery, BooleanClause.Occur.MUST).add(Queries.newNonNestedFilter(), BooleanClause.Occur.FILTER).build();
                    }
                    if (!Lucene.exists(context.docSearcher(), existsQuery)) continue;
                    ++count;
                }
                catch (Throwable e) {
                    PercolatorService.this.logger.debug("[" + entry.getKey() + "] failed to execute query", e, new Object[0]);
                    throw new PercolateException(context.indexShard().shardId(), "failed to execute", e);
                }
            }
            return new PercolateShardResponse(count, context, request.shardId());
        }
    };
    private final PercolatorType queryCountPercolator = new PercolatorType(){

        @Override
        public byte id() {
            return 2;
        }

        @Override
        public ReduceResult reduce(List<PercolateShardResponse> shardResults, HasContextAndHeaders headersContext) {
            return PercolatorService.this.countPercolator.reduce(shardResults, headersContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PercolateShardResponse doPercolate(PercolateShardRequest request, PercolateContext context, boolean isNested) {
            long count = 0L;
            try (Engine.Searcher percolatorSearcher = context.indexShard().acquireSearcher("percolate");){
                QueryCollector.Count countCollector = QueryCollector.count(PercolatorService.this.logger, context, isNested);
                PercolatorService.this.queryBasedPercolating(percolatorSearcher, context, countCollector);
                count = countCollector.counter();
            }
            return new PercolateShardResponse(count, context, request.shardId());
        }
    };
    private final PercolatorType matchPercolator = new PercolatorType(){

        @Override
        public byte id() {
            return 3;
        }

        @Override
        public ReduceResult reduce(List<PercolateShardResponse> shardResults, HasContextAndHeaders headersContext) {
            long foundMatches = 0L;
            int numMatches = 0;
            for (PercolateShardResponse response : shardResults) {
                foundMatches += response.count();
                numMatches += response.matches().length;
            }
            int requestedSize = shardResults.get(0).requestedSize();
            ArrayList<PercolateResponse.Match> finalMatches = new ArrayList<PercolateResponse.Match>(requestedSize == 0 ? numMatches : requestedSize);
            block1: for (PercolateShardResponse response : shardResults) {
                Text index = new Text(response.getIndex());
                for (int i = 0; i < response.matches().length; ++i) {
                    float score = response.scores().length == 0 ? Float.NEGATIVE_INFINITY : response.scores()[i];
                    Text match = new Text(new BytesArray(response.matches()[i]));
                    Map<String, HighlightField> hl = response.hls().isEmpty() ? null : response.hls().get(i);
                    finalMatches.add(new PercolateResponse.Match(index, match, score, hl));
                    if (requestedSize != 0 && finalMatches.size() == requestedSize) break block1;
                }
            }
            assert (!shardResults.isEmpty());
            InternalAggregations reducedAggregations = PercolatorService.this.reduceAggregations(shardResults, headersContext);
            return new ReduceResult(foundMatches, finalMatches.toArray(new PercolateResponse.Match[finalMatches.size()]), reducedAggregations);
        }

        @Override
        public PercolateShardResponse doPercolate(PercolateShardRequest request, PercolateContext context, boolean isNested) {
            long count = 0L;
            ArrayList matches = new ArrayList();
            ArrayList<Map<String, HighlightField>> hls = new ArrayList<Map<String, HighlightField>>();
            for (Map.Entry entry : context.percolateQueries().entrySet()) {
                if (context.highlight() != null) {
                    context.parsedQuery(new ParsedQuery((Query)entry.getValue()));
                    context.hitContext().cache().clear();
                }
                try {
                    Query existsQuery = (Query)entry.getValue();
                    if (isNested) {
                        existsQuery = new BooleanQuery.Builder().add(existsQuery, BooleanClause.Occur.MUST).add(Queries.newNonNestedFilter(), BooleanClause.Occur.FILTER).build();
                    }
                    if (!Lucene.exists(context.docSearcher(), existsQuery)) continue;
                    if (!context.limit || count < (long)context.size()) {
                        matches.add(entry.getKey());
                        if (context.highlight() != null) {
                            PercolatorService.this.highlightPhase.hitExecute(context, context.hitContext());
                            hls.add(context.hitContext().hit().getHighlightFields());
                        }
                    }
                    ++count;
                }
                catch (Throwable e) {
                    PercolatorService.this.logger.debug("[" + entry.getKey() + "] failed to execute query", e, new Object[0]);
                    throw new PercolateException(context.indexShard().shardId(), "failed to execute", e);
                }
            }
            BytesRef[] finalMatches = matches.toArray(new BytesRef[matches.size()]);
            return new PercolateShardResponse(finalMatches, hls, count, context, request.shardId());
        }
    };
    private final PercolatorType queryPercolator = new PercolatorType(){

        @Override
        public byte id() {
            return 4;
        }

        @Override
        public ReduceResult reduce(List<PercolateShardResponse> shardResults, HasContextAndHeaders headersContext) {
            return PercolatorService.this.matchPercolator.reduce(shardResults, headersContext);
        }

        @Override
        public PercolateShardResponse doPercolate(PercolateShardRequest request, PercolateContext context, boolean isNested) {
            try (Engine.Searcher percolatorSearcher = context.indexShard().acquireSearcher("percolate");){
                QueryCollector.Match match = QueryCollector.match(PercolatorService.this.logger, context, PercolatorService.this.highlightPhase, isNested);
                PercolatorService.this.queryBasedPercolating(percolatorSearcher, context, match);
                List<BytesRef> matches = match.matches();
                List<Map<String, HighlightField>> hls = match.hls();
                long count = match.counter();
                BytesRef[] finalMatches = matches.toArray(new BytesRef[matches.size()]);
                PercolateShardResponse percolateShardResponse = new PercolateShardResponse(finalMatches, hls, count, context, request.shardId());
                return percolateShardResponse;
            }
        }
    };
    private final PercolatorType scoringPercolator = new PercolatorType(){

        @Override
        public byte id() {
            return 5;
        }

        @Override
        public ReduceResult reduce(List<PercolateShardResponse> shardResults, HasContextAndHeaders headersContext) {
            return PercolatorService.this.matchPercolator.reduce(shardResults, headersContext);
        }

        @Override
        public PercolateShardResponse doPercolate(PercolateShardRequest request, PercolateContext context, boolean isNested) {
            try (Engine.Searcher percolatorSearcher = context.indexShard().acquireSearcher("percolate");){
                QueryCollector.MatchAndScore matchAndScore = QueryCollector.matchAndScore(PercolatorService.this.logger, context, PercolatorService.this.highlightPhase, isNested);
                PercolatorService.this.queryBasedPercolating(percolatorSearcher, context, matchAndScore);
                List<BytesRef> matches = matchAndScore.matches();
                List<Map<String, HighlightField>> hls = matchAndScore.hls();
                float[] scores = matchAndScore.scores().toArray();
                long count = matchAndScore.counter();
                BytesRef[] finalMatches = matches.toArray(new BytesRef[matches.size()]);
                PercolateShardResponse percolateShardResponse = new PercolateShardResponse(finalMatches, hls, count, scores, context, request.shardId());
                return percolateShardResponse;
            }
        }
    };
    private final PercolatorType topMatchingPercolator = new PercolatorType(){

        @Override
        public byte id() {
            return 6;
        }

        @Override
        public ReduceResult reduce(List<PercolateShardResponse> shardResults, HasContextAndHeaders headersContext) {
            long foundMatches = 0L;
            int nonEmptyResponses = 0;
            int firstNonEmptyIndex = 0;
            for (int i = 0; i < shardResults.size(); ++i) {
                PercolateShardResponse response = shardResults.get(i);
                foundMatches += response.count();
                if (response.matches().length == 0) continue;
                if (firstNonEmptyIndex == 0) {
                    firstNonEmptyIndex = i;
                }
                ++nonEmptyResponses;
            }
            int requestedSize = shardResults.get(0).requestedSize();
            ArrayList<PercolateResponse.Match> finalMatches = new ArrayList<PercolateResponse.Match>(requestedSize);
            if (nonEmptyResponses == 1) {
                PercolateShardResponse response = shardResults.get(firstNonEmptyIndex);
                Text index = new Text(response.getIndex());
                for (int i = 0; i < response.matches().length; ++i) {
                    float score = response.scores().length == 0 ? Float.NaN : response.scores()[i];
                    Text match = new Text(new BytesArray(response.matches()[i]));
                    if (!response.hls().isEmpty()) {
                        Map<String, HighlightField> hl = response.hls().get(i);
                        finalMatches.add(new PercolateResponse.Match(index, match, score, hl));
                        continue;
                    }
                    finalMatches.add(new PercolateResponse.Match(index, match, score));
                }
            } else {
                int[] slots = new int[shardResults.size()];
                do {
                    float score;
                    float lowestScore = Float.NEGATIVE_INFINITY;
                    int requestIndex = -1;
                    int itemIndex = -1;
                    for (int i = 0; i < shardResults.size(); ++i) {
                        int cmp;
                        int scoreIndex = slots[i];
                        float[] scores = shardResults.get(i).scores();
                        if (scoreIndex >= scores.length || (cmp = Float.compare(lowestScore, score = scores[scoreIndex])) >= 0) continue;
                        requestIndex = i;
                        itemIndex = scoreIndex;
                        lowestScore = score;
                    }
                    if (requestIndex == -1) break;
                    int n = requestIndex;
                    slots[n] = slots[n] + 1;
                    PercolateShardResponse shardResponse = shardResults.get(requestIndex);
                    Text index = new Text(shardResponse.getIndex());
                    Text match = new Text(new BytesArray(shardResponse.matches()[itemIndex]));
                    score = shardResponse.scores()[itemIndex];
                    if (!shardResponse.hls().isEmpty()) {
                        Map<String, HighlightField> hl = shardResponse.hls().get(itemIndex);
                        finalMatches.add(new PercolateResponse.Match(index, match, score, hl));
                        continue;
                    }
                    finalMatches.add(new PercolateResponse.Match(index, match, score));
                } while (finalMatches.size() != requestedSize);
            }
            assert (!shardResults.isEmpty());
            InternalAggregations reducedAggregations = PercolatorService.this.reduceAggregations(shardResults, headersContext);
            return new ReduceResult(foundMatches, finalMatches.toArray(new PercolateResponse.Match[finalMatches.size()]), reducedAggregations);
        }

        @Override
        public PercolateShardResponse doPercolate(PercolateShardRequest request, PercolateContext context, boolean isNested) {
            try (Engine.Searcher percolatorSearcher = context.indexShard().acquireSearcher("percolate");){
                PercolateShardResponse percolateShardResponse;
                QueryCollector.MatchAndSort matchAndSort = QueryCollector.matchAndSort(PercolatorService.this.logger, context, isNested);
                PercolatorService.this.queryBasedPercolating(percolatorSearcher, context, matchAndSort);
                TopDocs topDocs = matchAndSort.topDocs();
                long count = topDocs.totalHits;
                ArrayList<BytesRef> matches = new ArrayList<BytesRef>(topDocs.scoreDocs.length);
                float[] scores = new float[topDocs.scoreDocs.length];
                ArrayList<Map<String, HighlightField>> hls = null;
                if (context.highlight() != null) {
                    hls = new ArrayList<Map<String, HighlightField>>(topDocs.scoreDocs.length);
                }
                MappedFieldType uidMapper = context.mapperService().smartNameFieldType("_uid");
                Object uidFieldData = context.fieldData().getForField(uidMapper);
                int i = 0;
                for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                    int segmentIdx = ReaderUtil.subIndex(scoreDoc.doc, percolatorSearcher.reader().leaves());
                    LeafReaderContext atomicReaderContext = percolatorSearcher.reader().leaves().get(segmentIdx);
                    SortedBinaryDocValues values = uidFieldData.load(atomicReaderContext).getBytesValues();
                    int localDocId = scoreDoc.doc - atomicReaderContext.docBase;
                    values.setDocument(localDocId);
                    int numValues = values.count();
                    assert (numValues == 1);
                    BytesRef bytes = Uid.splitUidIntoTypeAndId(values.valueAt(0))[1];
                    matches.add(BytesRef.deepCopyOf(bytes));
                    if (hls != null) {
                        Query query = (Query)context.percolateQueries().get(bytes);
                        context.parsedQuery(new ParsedQuery(query));
                        context.hitContext().cache().clear();
                        PercolatorService.this.highlightPhase.hitExecute(context, context.hitContext());
                        hls.add(i, context.hitContext().hit().getHighlightFields());
                    }
                    scores[i++] = scoreDoc.score;
                }
                if (hls != null) {
                    percolateShardResponse = new PercolateShardResponse(matches.toArray(new BytesRef[matches.size()]), hls, count, scores, context, request.shardId());
                    return percolateShardResponse;
                }
                percolateShardResponse = new PercolateShardResponse(matches.toArray(new BytesRef[matches.size()]), count, scores, context, request.shardId());
                return percolateShardResponse;
            }
        }
    };

    @Inject
    public PercolatorService(Settings settings, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays, HighlightPhase highlightPhase, ClusterService clusterService, AggregationPhase aggregationPhase, ScriptService scriptService, MappingUpdatedAction mappingUpdatedAction) {
        super(settings);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.parseFieldMatcher = new ParseFieldMatcher(settings);
        this.indicesService = indicesService;
        this.pageCacheRecycler = pageCacheRecycler;
        this.bigArrays = bigArrays;
        this.clusterService = clusterService;
        this.highlightPhase = highlightPhase;
        this.aggregationPhase = aggregationPhase;
        this.scriptService = scriptService;
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.sortParseElement = new SortParseElement();
        final long maxReuseBytes = settings.getAsBytesSize("indices.memory.memory_index.size_per_thread", new ByteSizeValue(1L, ByteSizeUnit.MB)).bytes();
        this.cache = new CloseableThreadLocal<MemoryIndex>(){

            @Override
            protected MemoryIndex initialValue() {
                return new ExtendedMemoryIndex(true, false, maxReuseBytes);
            }
        };
        this.single = new SingleDocumentPercolatorIndex(this.cache);
        this.multi = new MultiDocumentPercolatorIndex(this.cache);
        this.percolatorTypes = new IntObjectHashMap(6);
        this.percolatorTypes.put(this.countPercolator.id(), this.countPercolator);
        this.percolatorTypes.put(this.queryCountPercolator.id(), this.queryCountPercolator);
        this.percolatorTypes.put(this.matchPercolator.id(), this.matchPercolator);
        this.percolatorTypes.put(this.queryPercolator.id(), this.queryPercolator);
        this.percolatorTypes.put(this.scoringPercolator.id(), this.scoringPercolator);
        this.percolatorTypes.put(this.topMatchingPercolator.id(), this.topMatchingPercolator);
    }

    public ReduceResult reduce(byte percolatorTypeId, List<PercolateShardResponse> shardResults, HasContextAndHeaders headersContext) {
        PercolatorType percolatorType = this.percolatorTypes.get(percolatorTypeId);
        return percolatorType.reduce(shardResults, headersContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PercolateShardResponse percolate(PercolateShardRequest request) {
        IndexService percolateIndexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = percolateIndexService.shardSafe(request.shardId().id());
        indexShard.readAllowed();
        ShardPercolateService shardPercolateService = indexShard.shardPercolateService();
        shardPercolateService.prePercolate();
        long startTime = System.nanoTime();
        String[] filteringAliases = this.indexNameExpressionResolver.filteringAliases(this.clusterService.state(), indexShard.shardId().index().name(), request.indices());
        Query aliasFilter = percolateIndexService.aliasesService().aliasFilter(filteringAliases);
        SearchShardTarget searchShardTarget = new SearchShardTarget(this.clusterService.localNode().id(), request.shardId().getIndex(), request.shardId().id());
        PercolateContext context = new PercolateContext(request, searchShardTarget, indexShard, percolateIndexService, this.pageCacheRecycler, this.bigArrays, this.scriptService, aliasFilter, this.parseFieldMatcher);
        String[] previousTypes = context.types();
        context.types(new String[]{TYPE_NAME});
        SearchContext.setCurrent(context);
        try {
            PercolatorIndex percolatorIndex;
            ParsedDocument parsedDocument = this.parseRequest(percolateIndexService, request, context, request.shardId().getIndex());
            if (context.percolateQueries().isEmpty()) {
                PercolateShardResponse percolateShardResponse = new PercolateShardResponse(context, request.shardId());
                return percolateShardResponse;
            }
            if (request.docSource() != null && request.docSource().length() != 0) {
                parsedDocument = this.parseFetchedDoc(context, request.docSource(), percolateIndexService, request.shardId().getIndex(), request.documentType());
            } else if (parsedDocument == null) {
                throw new IllegalArgumentException("Nothing to percolate");
            }
            if (context.percolateQuery() == null && (context.trackScores() || context.doSort || context.aggregations() != null) || context.aliasFilter() != null) {
                context.percolateQuery(new MatchAllDocsQuery());
            }
            if (context.doSort && !context.limit) {
                throw new IllegalArgumentException("Can't sort if size isn't specified");
            }
            if (context.highlight() != null && !context.limit) {
                throw new IllegalArgumentException("Can't highlight if size isn't specified");
            }
            if (context.size() < 0) {
                context.size(0);
            }
            boolean isNested = indexShard.mapperService().documentMapper(request.documentType()).hasNestedObjects();
            if (parsedDocument.docs().size() > 1) {
                assert (isNested);
                percolatorIndex = this.multi;
            } else {
                percolatorIndex = this.single;
            }
            PercolatorType action = request.onlyCount() ? (context.percolateQuery() != null ? this.queryCountPercolator : this.countPercolator) : (context.doSort ? this.topMatchingPercolator : (context.percolateQuery() != null ? (context.trackScores() ? this.scoringPercolator : this.queryPercolator) : this.matchPercolator));
            context.percolatorTypeId = action.id();
            percolatorIndex.prepare(context, parsedDocument);
            PercolateShardResponse percolateShardResponse = action.doPercolate(request, context, isNested);
            return percolateShardResponse;
        }
        finally {
            context.types(previousTypes);
            SearchContext.removeCurrent();
            context.close();
            shardPercolateService.postPercolate(System.nanoTime() - startTime);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ParsedDocument parseRequest(IndexService documentIndexService, PercolateShardRequest request, PercolateContext context, String index) {
        BytesReference source = request.source();
        if (source == null) return null;
        if (source.length() == 0) {
            return null;
        }
        Map<String, ? extends SearchParseElement> hlElements = this.highlightPhase.parseElements();
        Map<String, ? extends SearchParseElement> aggregationElements = this.aggregationPhase.parseElements();
        ParsedDocument doc = null;
        try (XContentParser parser = null;){
            XContentParser.Token token;
            parser = XContentFactory.xContent(source).createParser(source);
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    if (!"doc".equals(currentFieldName)) continue;
                    if (doc != null) {
                        throw new ElasticsearchParseException("Either specify doc or get, not both", new Object[0]);
                    }
                    MapperService mapperService = documentIndexService.mapperService();
                    DocumentMapperForType docMapper = mapperService.documentMapperWithAutoCreate(request.documentType());
                    doc = docMapper.getDocumentMapper().parse(SourceToParse.source(parser).index(index).type(request.documentType()).flyweight(true));
                    if (docMapper.getMapping() != null) {
                        doc.addDynamicMappingsUpdate(docMapper.getMapping());
                    }
                    if (doc.dynamicMappingsUpdate() != null) {
                        this.mappingUpdatedAction.updateMappingOnMasterSynchronously(request.shardId().getIndex(), request.documentType(), doc.dynamicMappingsUpdate());
                    }
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    SearchParseElement element = hlElements.get(currentFieldName);
                    if (element == null) {
                        element = aggregationElements.get(currentFieldName);
                    }
                    if ("query".equals(currentFieldName)) {
                        if (context.percolateQuery() != null) {
                            throw new ElasticsearchParseException("Either specify query or filter, not both", new Object[0]);
                        }
                        context.percolateQuery(documentIndexService.queryParserService().parse(parser).query());
                        continue;
                    }
                    if ("filter".equals(currentFieldName)) {
                        if (context.percolateQuery() != null) {
                            throw new ElasticsearchParseException("Either specify query or filter, not both", new Object[0]);
                        }
                        ParsedQuery parsedQuery = documentIndexService.queryParserService().parseInnerFilter(parser);
                        if (parsedQuery == null) continue;
                        context.percolateQuery(new ConstantScoreQuery(parsedQuery.query()));
                        continue;
                    }
                    if ("sort".equals(currentFieldName)) {
                        this.parseSort(parser, context);
                        continue;
                    }
                    if (element == null) continue;
                    element.parse(parser, context);
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (!"sort".equals(currentFieldName)) continue;
                    this.parseSort(parser, context);
                    continue;
                }
                if (token == null) break;
                if (!token.isValue()) continue;
                if ("size".equals(currentFieldName)) {
                    context.size(parser.intValue());
                    if (context.size() >= 0) continue;
                    throw new ElasticsearchParseException("size is set to [{}] and is expected to be higher or equal to 0", context.size());
                }
                if ("sort".equals(currentFieldName)) {
                    this.parseSort(parser, context);
                    continue;
                }
                if (!"track_scores".equals(currentFieldName) && !"trackScores".equals(currentFieldName)) continue;
                context.trackScores(parser.booleanValue());
            }
            if (context.highlight() == null) return doc;
            parser.close();
            currentFieldName = null;
            parser = XContentFactory.xContent(source).createParser(source);
            token = parser.nextToken();
            assert (token == XContentParser.Token.START_OBJECT);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("doc".equals(currentFieldName)) {
                        BytesStreamOutput bStream = new BytesStreamOutput();
                        XContentBuilder builder = XContentFactory.contentBuilder(XContentType.SMILE, bStream);
                        builder.copyCurrentStructure(parser);
                        builder.close();
                        doc.setSource(bStream.bytes());
                        return doc;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token == null) return doc;
            }
            return doc;
        }
    }

    private void parseSort(XContentParser parser, PercolateContext context) throws Exception {
        this.sortParseElement.parse(parser, context);
        if (context.sort() != null) {
            throw new ElasticsearchParseException("Only _score desc is supported", new Object[0]);
        }
        context.doSort = true;
    }

    private ParsedDocument parseFetchedDoc(PercolateContext context, BytesReference fetchedDoc, IndexService documentIndexService, String index, String type) {
        ParsedDocument doc = null;
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent(fetchedDoc).createParser(fetchedDoc);
            MapperService mapperService = documentIndexService.mapperService();
            DocumentMapperForType docMapper = mapperService.documentMapperWithAutoCreate(type);
            doc = docMapper.getDocumentMapper().parse(SourceToParse.source(parser).index(index).type(type).flyweight(true));
            if (context.highlight() != null) {
                doc.setSource(fetchedDoc);
            }
        }
        if (doc == null) {
            throw new ElasticsearchParseException("No doc to percolate in the request", new Object[0]);
        }
        return doc;
    }

    public void close() {
        this.cache.close();
    }

    private void queryBasedPercolating(Engine.Searcher percolatorSearcher, PercolateContext context, QueryCollector percolateCollector) throws IOException {
        Query filter;
        Query percolatorTypeFilter = context.indexService().mapperService().documentMapper(TYPE_NAME).typeFilter();
        if (context.aliasFilter() != null) {
            BooleanQuery.Builder booleanFilter = new BooleanQuery.Builder();
            booleanFilter.add(context.aliasFilter(), BooleanClause.Occur.MUST);
            booleanFilter.add(percolatorTypeFilter, BooleanClause.Occur.MUST);
            filter = booleanFilter.build();
        } else {
            filter = percolatorTypeFilter;
        }
        BooleanQuery query = Queries.filtered(context.percolateQuery(), filter);
        percolatorSearcher.searcher().search((Query)query, percolateCollector);
        percolateCollector.aggregatorCollector.postCollection();
        if (context.aggregations() != null) {
            this.aggregationPhase.execute(context);
        }
    }

    private InternalAggregations reduceAggregations(List<PercolateShardResponse> shardResults, HasContextAndHeaders headersContext) {
        List<SiblingPipelineAggregator> pipelineAggregators;
        if (shardResults.get(0).aggregations() == null) {
            return null;
        }
        ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(shardResults.size());
        for (PercolateShardResponse shardResult : shardResults) {
            aggregationsList.add(shardResult.aggregations());
        }
        InternalAggregations aggregations = InternalAggregations.reduce(aggregationsList, new InternalAggregation.ReduceContext(this.bigArrays, this.scriptService, headersContext));
        if (aggregations != null && (pipelineAggregators = shardResults.get(0).pipelineAggregators()) != null) {
            ArrayList<InternalAggregation> newAggs = new ArrayList<InternalAggregation>(CollectionUtils.eagerTransform(aggregations.asList(), PipelineAggregator.AGGREGATION_TRANFORM_FUNCTION));
            for (SiblingPipelineAggregator pipelineAggregator : pipelineAggregators) {
                InternalAggregation newAgg = pipelineAggregator.doReduce(new InternalAggregations(newAggs), new InternalAggregation.ReduceContext(this.bigArrays, this.scriptService, headersContext));
                newAggs.add(newAgg);
            }
            aggregations = new InternalAggregations(newAggs);
        }
        return aggregations;
    }

    static /* synthetic */ ESLogger access$500(PercolatorService x0) {
        return x0.logger;
    }

    static /* synthetic */ ESLogger access$1000(PercolatorService x0) {
        return x0.logger;
    }

    static /* synthetic */ ESLogger access$1200(PercolatorService x0) {
        return x0.logger;
    }

    static /* synthetic */ ESLogger access$1400(PercolatorService x0) {
        return x0.logger;
    }

    public static final class ReduceResult {
        private final long count;
        private final PercolateResponse.Match[] matches;
        private final InternalAggregations reducedAggregations;

        ReduceResult(long count, PercolateResponse.Match[] matches, InternalAggregations reducedAggregations) {
            this.count = count;
            this.matches = matches;
            this.reducedAggregations = reducedAggregations;
        }

        public ReduceResult(long count, InternalAggregations reducedAggregations) {
            this.count = count;
            this.matches = null;
            this.reducedAggregations = reducedAggregations;
        }

        public long count() {
            return this.count;
        }

        public PercolateResponse.Match[] matches() {
            return this.matches;
        }

        public InternalAggregations reducedAggregations() {
            return this.reducedAggregations;
        }
    }

    static interface PercolatorType {
        public byte id();

        public ReduceResult reduce(List<PercolateShardResponse> var1, HasContextAndHeaders var2);

        public PercolateShardResponse doPercolate(PercolateShardRequest var1, PercolateContext var2, boolean var3);
    }
}

