/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;

public abstract class AbstractRestChannel
implements RestChannel {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(AbstractRestChannel.class));
    protected final RestRequest request;
    protected final boolean detailedErrorsEnabled;
    private BytesStreamOutput bytesOut;

    protected AbstractRestChannel(RestRequest request, boolean detailedErrorsEnabled) {
        this.request = request;
        this.detailedErrorsEnabled = detailedErrorsEnabled;
    }

    @Override
    public XContentBuilder newBuilder() throws IOException {
        return this.newBuilder(this.request.hasContent() ? this.request.content() : null, this.request.hasParam("filter_path"));
    }

    @Override
    public XContentBuilder newErrorBuilder() throws IOException {
        return this.newBuilder(this.request.hasContent() ? this.request.content() : null, false);
    }

    @Override
    public XContentBuilder newBuilder(@Nullable BytesReference autoDetectSource, boolean useFiltering) throws IOException {
        XContentType contentType = XContentType.fromRestContentType(this.request.param("format", this.request.header("Content-Type")));
        if (contentType == null && autoDetectSource != null) {
            contentType = XContentFactory.xContentType(autoDetectSource);
        }
        if (contentType == null) {
            contentType = XContentType.JSON;
        }
        String[] filters = useFiltering ? this.request.paramAsStringArrayOrEmptyIfAll("filter_path") : null;
        XContentBuilder builder = new XContentBuilder(XContentFactory.xContent(contentType), this.bytesOutput(), filters);
        if (this.request.paramAsBoolean("pretty", false)) {
            builder.prettyPrint().lfAtEnd();
        }
        builder.humanReadable(this.request.paramAsBoolean("human", builder.humanReadable()));
        String casing = this.request.param("case");
        if (casing != null) {
            String msg = "Parameter 'case' has been deprecated, all responses will use underscore casing in the future";
            DEPRECATION_LOGGER.deprecated(msg, new Object[0]);
        }
        if (casing != null && "camelCase".equals(casing)) {
            builder.fieldCaseConversion(XContentBuilder.FieldCaseConversion.CAMELCASE);
        } else {
            builder.fieldCaseConversion(XContentBuilder.FieldCaseConversion.NONE);
        }
        return builder;
    }

    @Override
    public final BytesStreamOutput bytesOutput() {
        if (this.bytesOut == null) {
            this.bytesOut = this.newBytesOutput();
        } else {
            this.bytesOut.reset();
        }
        return this.bytesOut;
    }

    protected BytesStreamOutput newBytesOutput() {
        return new BytesStreamOutput();
    }

    @Override
    public RestRequest request() {
        return this.request;
    }

    @Override
    public boolean detailedErrorsEnabled() {
        return this.detailedErrorsEnabled;
    }
}

