/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.profile.ProfileBreakdown;
import org.elasticsearch.search.profile.ProfileScorer;

public final class ProfileWeight
extends Weight {
    private final Weight subQueryWeight;
    private final ProfileBreakdown profile;

    public ProfileWeight(Query query, Weight subQueryWeight, ProfileBreakdown profile) throws IOException {
        super(query);
        this.subQueryWeight = subQueryWeight;
        this.profile = profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        Scorer subQueryScorer;
        this.profile.startTime(ProfileBreakdown.TimingType.BUILD_SCORER);
        try {
            subQueryScorer = this.subQueryWeight.scorer(context);
        }
        finally {
            this.profile.stopAndRecordTime();
        }
        if (subQueryScorer == null) {
            return null;
        }
        return new ProfileScorer(this, subQueryScorer, this.profile);
    }

    @Override
    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        return super.bulkScorer(context);
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        return this.subQueryWeight.explain(context, doc);
    }

    @Override
    public float getValueForNormalization() throws IOException {
        return this.subQueryWeight.getValueForNormalization();
    }

    @Override
    public void normalize(float norm, float topLevelBoost) {
        this.subQueryWeight.normalize(norm, topLevelBoost);
    }

    @Override
    public void extractTerms(Set<Term> set) {
        this.subQueryWeight.extractTerms(set);
    }
}

