/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.election;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.atomix.core.election.Leader;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Leadership<T> {
    private final Leader<T> leader;
    private final List<T> candidates;

    public Leadership(Leader<T> leader, List<T> candidates) {
        this.leader = leader;
        this.candidates = ImmutableList.copyOf(candidates);
    }

    public Leader<T> leader() {
        return this.leader;
    }

    public List<T> candidates() {
        return this.candidates;
    }

    public <U> Leadership<U> map(Function<T, U> mapper) {
        return new Leadership<U>(this.leader != null ? this.leader.map(mapper) : null, this.candidates.stream().map(mapper).collect(Collectors.toList()));
    }

    public int hashCode() {
        return Objects.hash(this.leader, this.candidates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Leadership) {
            Leadership other = (Leadership)obj;
            return Objects.equals(this.leader, other.leader) && Objects.equals(this.candidates, other.candidates);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("leader", this.leader).add("candidates", this.candidates).toString();
    }
}

