/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.internal.InfluxDBClientImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import okhttp3.Cookie;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class AuthenticateInterceptor
implements Interceptor {
    private static final Logger LOG = Logger.getLogger(InfluxDBClientImpl.class.getName());
    private static final List<String> NO_AUTH_ROUTE = Arrays.asList("/api/v2/signin", "/api/v2/signout", "/api/v2/setup");
    private final InfluxDBClientOptions influxDBClientOptions;
    private OkHttpClient okHttpClient;
    private char[] sessionToken;
    private AtomicBoolean signout = new AtomicBoolean(false);

    AuthenticateInterceptor(@Nonnull InfluxDBClientOptions influxDBClientOptions) {
        Arguments.checkNotNull(influxDBClientOptions, "InfluxDBClientOptions");
        this.influxDBClientOptions = influxDBClientOptions;
    }

    @Override
    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String requestPath = request.url().encodedPath();
        if (NO_AUTH_ROUTE.stream().anyMatch(requestPath::endsWith) || this.signout.get()) {
            return chain.proceed(request);
        }
        if (InfluxDBClientOptions.AuthScheme.TOKEN.equals((Object)this.influxDBClientOptions.getAuthScheme())) {
            request = request.newBuilder().header("Authorization", "Token " + this.string(this.influxDBClientOptions.getToken())).build();
        } else if (InfluxDBClientOptions.AuthScheme.SESSION.equals((Object)this.influxDBClientOptions.getAuthScheme())) {
            this.initToken(this.okHttpClient);
            if (this.sessionToken != null) {
                request = request.newBuilder().header("Cookie", "session=" + this.string(this.sessionToken)).build();
            }
        }
        return chain.proceed(request);
    }

    void initToken(@Nonnull OkHttpClient okHttpClient) {
        Arguments.checkNotNull(okHttpClient, "okHttpClient");
        this.okHttpClient = okHttpClient;
        if (!InfluxDBClientOptions.AuthScheme.SESSION.equals((Object)this.influxDBClientOptions.getAuthScheme()) || this.signout.get()) {
            return;
        }
        if (this.sessionToken == null) {
            Response authResponse;
            String credentials = Credentials.basic(this.influxDBClientOptions.getUsername(), this.string(this.influxDBClientOptions.getPassword()));
            Request authRequest = new Request.Builder().url(this.influxDBClientOptions.getUrl() + "/api/v2/signin").addHeader("Authorization", credentials).post(RequestBody.create(null, "")).build();
            try {
                authResponse = this.okHttpClient.newCall(authRequest).execute();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Cannot retrieve the Session token!", e);
                return;
            }
            Cookie sessionCookie = Cookie.parseAll(authRequest.url(), authResponse.headers()).stream().filter(cookie -> "session".equals(cookie.name())).findFirst().orElse(null);
            if (sessionCookie != null) {
                this.sessionToken = sessionCookie.value().toCharArray();
            }
        }
    }

    void signout() throws IOException {
        if (!InfluxDBClientOptions.AuthScheme.SESSION.equals((Object)this.influxDBClientOptions.getAuthScheme()) || this.signout.get()) {
            this.signout.set(true);
            return;
        }
        this.signout.set(true);
        this.sessionToken = null;
        Request authRequest = new Request.Builder().url(this.influxDBClientOptions.getUrl() + "/api/v2/signout").post(RequestBody.create(null, "")).build();
        this.okHttpClient.newCall(authRequest).execute();
    }

    @Nonnull
    private String string(char[] password) {
        return String.valueOf(password);
    }
}

