/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.TelegrafsApi;
import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import com.influxdb.client.domain.Telegraf;
import com.influxdb.client.domain.TelegrafPlugin;
import com.influxdb.client.domain.TelegrafRequest;
import com.influxdb.client.domain.TelegrafRequestMetadata;
import com.influxdb.client.domain.Telegrafs;
import com.influxdb.client.domain.User;
import com.influxdb.client.service.TelegrafsService;
import com.influxdb.internal.AbstractRestClient;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Call;

final class TelegrafsApiImpl
extends AbstractRestClient
implements TelegrafsApi {
    private static final Logger LOG = Logger.getLogger(TelegrafsApiImpl.class.getName());
    private final TelegrafsService service;

    TelegrafsApiImpl(@Nonnull TelegrafsService service) {
        Arguments.checkNotNull(service, "service");
        this.service = service;
    }

    @Override
    @Nonnull
    public Telegraf createTelegraf(@Nonnull String name, @Nullable String description, @Nonnull Organization org, @Nonnull Collection<TelegrafPlugin> plugins) {
        Arguments.checkNotNull(org, "org");
        return this.createTelegraf(name, description, org, this.createAgentConfiguration(), plugins);
    }

    @Override
    @Nonnull
    public Telegraf createTelegraf(@Nonnull String name, @Nullable String description, @Nonnull Organization org, @Nonnull Map<String, Object> agentConfiguration, @Nonnull Collection<TelegrafPlugin> plugins) {
        Arguments.checkNotNull(org, "org");
        return this.createTelegraf(name, description, org.getId(), agentConfiguration, plugins);
    }

    @Override
    @Nonnull
    public Telegraf createTelegraf(@Nonnull String name, @Nullable String description, @Nonnull String orgID, @Nonnull Collection<TelegrafPlugin> plugins) {
        return this.createTelegraf(name, description, orgID, this.createAgentConfiguration(), plugins);
    }

    @Override
    public Telegraf createTelegraf(@Nonnull String name, @Nullable String description, @Nonnull String orgID, @Nonnull Map<String, Object> agentConfiguration, @Nonnull Collection<TelegrafPlugin> plugins) {
        Arguments.checkNonEmpty(name, "name");
        Arguments.checkNonEmpty(orgID, "orgID");
        Arguments.checkNotNull(agentConfiguration, "agentConfiguration");
        Arguments.checkNotNull(plugins, "plugins");
        StringBuilder config = new StringBuilder();
        config.append("[agent]").append("\n");
        agentConfiguration.forEach((key, value) -> this.appendConfiguration(config, (String)key, value));
        config.append("\n");
        for (TelegrafPlugin plugin : plugins) {
            if (plugin.getDescription() != null) {
                config.append("#").append(plugin.getDescription()).append("\n");
            }
            config.append("[[").append((Object)plugin.getType()).append(".").append(plugin.getName()).append("]]").append("\n");
            plugin.getConfig().forEach((key, value) -> this.appendConfiguration(config, (String)key, value));
        }
        TelegrafRequest telegrafRequest = new TelegrafRequest().name(name).description(description).orgID(orgID).config(config.toString());
        return this.createTelegraf(telegrafRequest);
    }

    @Override
    @Nonnull
    public Telegraf createTelegraf(@Nonnull String name, @Nullable String description, @Nonnull String orgID, @Nonnull String config, @Nullable TelegrafRequestMetadata metadata) {
        Arguments.checkNonEmpty(name, "name");
        Arguments.checkNonEmpty(orgID, "orgID");
        Arguments.checkNonEmpty(config, "config");
        TelegrafRequest telegrafRequest = new TelegrafRequest().name(name).description(description).orgID(orgID).config(config).metadata(metadata);
        return this.createTelegraf(telegrafRequest);
    }

    @Override
    @Nonnull
    public Telegraf createTelegraf(@Nonnull String name, @Nullable String description, @Nonnull Organization org, @Nonnull String config, @Nullable TelegrafRequestMetadata metadata) {
        Arguments.checkNonEmpty(name, "name");
        Arguments.checkNotNull(org, "org");
        Arguments.checkNonEmpty(config, "config");
        return this.createTelegraf(name, description, org.getId(), config, metadata);
    }

    @Override
    @Nonnull
    public Telegraf createTelegraf(@Nonnull TelegrafRequest telegrafRequest) {
        Arguments.checkNotNull(telegrafRequest, "telegrafRequest");
        Call<Telegraf> call = this.service.postTelegrafs(telegrafRequest, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public HashMap<String, Object> createAgentConfiguration() {
        LinkedHashMap<String, Object> agent = new LinkedHashMap<String, Object>();
        agent.put("interval", "10s");
        agent.put("round_interval", true);
        agent.put("metric_batch_size", 1000);
        agent.put("metric_buffer_limit", 10000);
        agent.put("collection_jitter", "0s");
        agent.put("flush_jitter", "0s");
        agent.put("precision", "");
        agent.put("omit_hostname", false);
        return agent;
    }

    @Override
    @Nonnull
    public Telegraf updateTelegraf(@Nonnull Telegraf telegraf) {
        Arguments.checkNotNull(telegraf, "TelegrafConfig");
        TelegrafRequest telegrafRequest = this.toTelegrafRequest(telegraf);
        return this.updateTelegraf(telegraf.getId(), telegrafRequest);
    }

    @Override
    @Nonnull
    public Telegraf updateTelegraf(@Nonnull String telegrafID, @Nonnull TelegrafRequest telegrafRequest) {
        Arguments.checkNotNull(telegrafRequest, "TelegrafRequest");
        Call<Telegraf> telegrafConfigCall = this.service.putTelegrafsID(telegrafID, telegrafRequest, null);
        return this.execute(telegrafConfigCall);
    }

    @Override
    public void deleteTelegraf(@Nonnull Telegraf telegraf) {
        Arguments.checkNotNull(telegraf, "TelegrafConfig");
        this.deleteTelegraf(telegraf.getId());
    }

    @Override
    public void deleteTelegraf(@Nonnull String telegrafID) {
        Arguments.checkNonEmpty(telegrafID, "telegrafConfigID");
        Call<Void> call = this.service.deleteTelegrafsID(telegrafID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Telegraf cloneTelegraf(@Nonnull String clonedName, @Nonnull String telegrafConfigID) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNonEmpty(telegrafConfigID, "telegrafConfigID");
        Telegraf telegrafConfig = this.findTelegrafByID(telegrafConfigID);
        return this.cloneTelegraf(clonedName, telegrafConfig);
    }

    @Override
    @Nonnull
    public Telegraf cloneTelegraf(@Nonnull String clonedName, @Nonnull Telegraf telegraf) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNotNull(telegraf, "TelegrafConfig");
        TelegrafRequest telegrafRequest = this.toTelegrafRequest(telegraf);
        Telegraf created = this.createTelegraf(telegrafRequest);
        created.setName(clonedName);
        this.getLabels(telegraf).forEach(label -> this.addLabel((Label)label, created));
        return created;
    }

    @Override
    @Nonnull
    public Telegraf findTelegrafByID(@Nonnull String telegrafID) {
        Arguments.checkNonEmpty(telegrafID, "TelegrafConfig ID");
        Call<Telegraf> telegrafConfig = this.service.getTelegrafsIDTelegraf(telegrafID, null, "application/json");
        return this.execute(telegrafConfig);
    }

    @Override
    @Nonnull
    public List<Telegraf> findTelegrafs() {
        return this.findTelegrafsByOrgId(null);
    }

    @Override
    @Nonnull
    public List<Telegraf> findTelegrafsByOrg(@Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "organization");
        return this.findTelegrafsByOrgId(organization.getId());
    }

    @Override
    @Nonnull
    public List<Telegraf> findTelegrafsByOrgId(@Nullable String orgID) {
        Call<Telegrafs> configsCall = this.service.getTelegrafs(orgID, null);
        Telegrafs telegrafConfigs = this.execute(configsCall);
        LOG.log(Level.FINEST, "findTelegrafs found: {0}", telegrafConfigs);
        return telegrafConfigs.getConfigurations();
    }

    @Override
    @Nonnull
    public String getTOML(@Nonnull Telegraf telegraf) {
        Arguments.checkNotNull(telegraf, "TelegrafConfig");
        return this.getTOML(telegraf.getId());
    }

    @Override
    @Nonnull
    public String getTOML(@Nonnull String telegrafID) {
        Arguments.checkNonEmpty(telegrafID, "TelegrafConfig ID");
        Call<String> telegrafConfig = this.service.getTelegrafsID(telegrafID, null, "application/toml");
        return this.execute(telegrafConfig);
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull Telegraf telegraf) {
        Arguments.checkNotNull(telegraf, "TelegrafConfig");
        return this.getMembers(telegraf.getId());
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull String telegrafID) {
        Arguments.checkNonEmpty(telegrafID, "TelegrafConfig.ID");
        Call<ResourceMembers> call = this.service.getTelegrafsIDMembers(telegrafID, null);
        ResourceMembers resourceMembers = this.execute(call);
        LOG.log(Level.FINEST, "findTelegrafConfigMembers found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull User member, @Nonnull Telegraf telegraf) {
        Arguments.checkNotNull(telegraf, "telegrafConfig");
        Arguments.checkNotNull(member, "member");
        return this.addMember(member.getId(), telegraf.getId());
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull String memberID, @Nonnull String telegrafID) {
        Arguments.checkNonEmpty(memberID, "Member ID");
        Arguments.checkNonEmpty(telegrafID, "TelegrafConfig.ID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(memberID);
        Call<ResourceMember> call = this.service.postTelegrafsIDMembers(telegrafID, user, null);
        return this.execute(call);
    }

    @Override
    public void deleteMember(@Nonnull User member, @Nonnull Telegraf telegraf) {
        Arguments.checkNotNull(telegraf, "telegrafConfig");
        Arguments.checkNotNull(member, "member");
        this.deleteMember(member.getId(), telegraf.getId());
    }

    @Override
    public void deleteMember(@Nonnull String memberID, @Nonnull String telegrafID) {
        Arguments.checkNonEmpty(memberID, "Member ID");
        Arguments.checkNonEmpty(telegrafID, "TelegrafConfig.ID");
        Call<Void> call = this.service.deleteTelegrafsIDMembersID(memberID, telegrafID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull Telegraf telegraf) {
        Arguments.checkNotNull(telegraf, "telegrafConfig");
        return this.getOwners(telegraf.getId());
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull String telegrafID) {
        Arguments.checkNonEmpty(telegrafID, "TelegrafConfig.ID");
        Call<ResourceOwners> call = this.service.getTelegrafsIDOwners(telegrafID, null);
        ResourceOwners resourceMembers = this.execute(call);
        LOG.log(Level.FINEST, "findTelegrafConfigOwners found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull User owner, @Nonnull Telegraf telegraf) {
        Arguments.checkNotNull(telegraf, "telegrafConfig");
        Arguments.checkNotNull(owner, "owner");
        return this.addOwner(owner.getId(), telegraf.getId());
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull String ownerID, @Nonnull String telegrafID) {
        Arguments.checkNonEmpty(ownerID, "Owner ID");
        Arguments.checkNonEmpty(telegrafID, "TelegrafConfig.ID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(ownerID);
        Call<ResourceOwner> call = this.service.postTelegrafsIDOwners(telegrafID, user, null);
        return this.execute(call);
    }

    @Override
    public void deleteOwner(@Nonnull User owner, @Nonnull Telegraf telegraf) {
        Arguments.checkNotNull(telegraf, "telegrafConfig");
        Arguments.checkNotNull(owner, "owner");
        this.deleteOwner(owner.getId(), telegraf.getId());
    }

    @Override
    public void deleteOwner(@Nonnull String ownerID, @Nonnull String telegrafID) {
        Arguments.checkNonEmpty(ownerID, "Owner ID");
        Arguments.checkNonEmpty(telegrafID, "TelegrafConfig.ID");
        Call<Void> call = this.service.deleteTelegrafsIDOwnersID(ownerID, telegrafID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull Telegraf telegraf) {
        Arguments.checkNotNull(telegraf, "telegrafConfig");
        return this.getLabels(telegraf.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String telegrafID) {
        Arguments.checkNonEmpty(telegrafID, "TelegrafConfig.ID");
        Call<LabelsResponse> call = this.service.getTelegrafsIDLabels(telegrafID, null);
        return this.execute(call).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull Telegraf telegraf) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(telegraf, "telegrafConfig");
        return this.addLabel(label.getId(), telegraf.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String telegrafID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(telegrafID, "telegrafConfigID");
        LabelMapping labelMapping = new LabelMapping();
        labelMapping.setLabelID(labelID);
        Call<LabelResponse> call = this.service.postTelegrafsIDLabels(telegrafID, labelMapping, null);
        return this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull Telegraf telegraf) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(telegraf, "telegrafConfig");
        this.deleteLabel(label.getId(), telegraf.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String telegrafID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(telegrafID, "telegrafConfigID");
        Call<Void> call = this.service.deleteTelegrafsIDLabelsID(telegrafID, labelID, null);
        this.execute(call);
    }

    @Nonnull
    private TelegrafRequest toTelegrafRequest(@Nonnull Telegraf telegraf) {
        Arguments.checkNotNull(telegraf, "telegraf");
        TelegrafRequest telegrafRequest = new TelegrafRequest();
        telegrafRequest.setName(telegraf.getName());
        telegrafRequest.setDescription(telegraf.getDescription());
        telegrafRequest.setConfig(telegraf.getConfig());
        telegrafRequest.setMetadata(telegraf.getMetadata());
        telegrafRequest.setOrgID(telegraf.getOrgID());
        return telegrafRequest;
    }

    private void appendConfiguration(@Nonnull StringBuilder config, @Nonnull String key, @Nullable Object value) {
        if (value != null) {
            config.append("  ").append(key).append(" = ");
            if (value instanceof Collection) {
                Stream<String> values = ((Collection)value).stream().map(it -> {
                    if (it instanceof String) {
                        return "\"" + it.toString() + "\"";
                    }
                    return it.toString();
                });
                config.append("[");
                config.append(values.collect(Collectors.joining(", ")));
                config.append("]");
            } else if (value instanceof String) {
                config.append('\"');
                config.append(value.toString());
                config.append('\"');
            } else {
                config.append(value.toString());
            }
            config.append("\n");
        }
    }
}

