/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.write.events;

import com.influxdb.Arguments;
import com.influxdb.client.write.events.AbstractWriteEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public final class WriteRetriableErrorEvent
extends AbstractWriteEvent {
    private static final Logger LOG = Logger.getLogger(WriteRetriableErrorEvent.class.getName());
    private final Throwable throwable;
    private final Long retryInterval;

    public WriteRetriableErrorEvent(@Nonnull Throwable throwable, @Nonnull Long retryInterval) {
        Arguments.checkNotNull(throwable, "Throwable");
        Arguments.checkNotNull(retryInterval, "retryInterval");
        this.throwable = throwable;
        this.retryInterval = retryInterval;
    }

    @Nonnull
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Nonnull
    public Long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public void logEvent() {
        String msg = "The retriable error occurred during writing of data. Retry in: {0} [ms]";
        LOG.log(Level.WARNING, msg, this.retryInterval);
    }
}

