/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

public class JSONObjectUtils {
    public static JSONObject parse(String s2) throws java.text.ParseException {
        Object o;
        try {
            o = new JSONParser(640).parse(s2);
        }
        catch (ParseException e) {
            throw new java.text.ParseException("Invalid JSON: " + e.getMessage(), 0);
        }
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new java.text.ParseException("JSON entity is not an object", 0);
    }

    @Deprecated
    public static JSONObject parseJSONObject(String s2) throws java.text.ParseException {
        return JSONObjectUtils.parse(s2);
    }

    private static <T> T getGeneric(JSONObject o, String key2, Class<T> clazz) throws java.text.ParseException {
        if (!o.containsKey((Object)key2)) {
            throw new java.text.ParseException("Missing JSON object member with key \"" + key2 + "\"", 0);
        }
        if (o.get((Object)key2) == null) {
            throw new java.text.ParseException("JSON object member with key \"" + key2 + "\" has null value", 0);
        }
        Object value2 = o.get((Object)key2);
        if (!clazz.isAssignableFrom(value2.getClass())) {
            throw new java.text.ParseException("Unexpected type of JSON object member with key \"" + key2 + "\"", 0);
        }
        return (T)value2;
    }

    public static boolean getBoolean(JSONObject o, String key2) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key2, Boolean.class);
    }

    public static int getInt(JSONObject o, String key2) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key2, Number.class).intValue();
    }

    public static long getLong(JSONObject o, String key2) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key2, Number.class).longValue();
    }

    public static float getFloat(JSONObject o, String key2) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key2, Number.class).floatValue();
    }

    public static double getDouble(JSONObject o, String key2) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key2, Number.class).doubleValue();
    }

    public static String getString(JSONObject o, String key2) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key2, String.class);
    }

    public static URI getURI(JSONObject o, String key2) throws java.text.ParseException {
        try {
            return new URI(JSONObjectUtils.getGeneric(o, key2, String.class));
        }
        catch (URISyntaxException e) {
            throw new java.text.ParseException(e.getMessage(), 0);
        }
    }

    public static JSONArray getJSONArray(JSONObject o, String key2) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key2, JSONArray.class);
    }

    public static String[] getStringArray(JSONObject o, String key2) throws java.text.ParseException {
        JSONArray jsonArray = JSONObjectUtils.getJSONArray(o, key2);
        try {
            return (String[])jsonArray.toArray((Object[])new String[0]);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new java.text.ParseException("JSON object member with key \"" + key2 + "\" is not an array of strings", 0);
        }
    }

    public static List<String> getStringList(JSONObject o, String key2) throws java.text.ParseException {
        String[] array = JSONObjectUtils.getStringArray(o, key2);
        return Arrays.asList(array);
    }

    public static JSONObject getJSONObject(JSONObject o, String key2) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o, key2, JSONObject.class);
    }

    private JSONObjectUtils() {
    }
}

