/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.Headers;
import io.netty.handler.codec.HeadersUtils;
import io.netty.handler.codec.ValueConverter;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DefaultHeaders<K, V, T extends Headers<K, V, T>>
implements Headers<K, V, T> {
    static final int HASH_CODE_SEED = -1028477387;
    private final HeaderEntry<K, V>[] entries;
    protected final HeaderEntry<K, V> head;
    private final byte hashMask;
    private final ValueConverter<V> valueConverter;
    private final NameValidator<K> nameValidator;
    private final HashingStrategy<K> hashingStrategy;
    int size;

    public DefaultHeaders(ValueConverter<V> valueConverter) {
        this(HashingStrategy.JAVA_HASHER, valueConverter);
    }

    public DefaultHeaders(ValueConverter<V> valueConverter, NameValidator<K> nameValidator) {
        this(HashingStrategy.JAVA_HASHER, valueConverter, nameValidator);
    }

    public DefaultHeaders(HashingStrategy<K> nameHashingStrategy, ValueConverter<V> valueConverter) {
        this(nameHashingStrategy, valueConverter, NameValidator.NOT_NULL);
    }

    public DefaultHeaders(HashingStrategy<K> nameHashingStrategy, ValueConverter<V> valueConverter, NameValidator<K> nameValidator) {
        this(nameHashingStrategy, valueConverter, nameValidator, 16);
    }

    public DefaultHeaders(HashingStrategy<K> nameHashingStrategy, ValueConverter<V> valueConverter, NameValidator<K> nameValidator, int arraySizeHint) {
        this.valueConverter = ObjectUtil.checkNotNull(valueConverter, "valueConverter");
        this.nameValidator = ObjectUtil.checkNotNull(nameValidator, "nameValidator");
        this.hashingStrategy = ObjectUtil.checkNotNull(nameHashingStrategy, "nameHashingStrategy");
        this.entries = new HeaderEntry[MathUtil.findNextPositivePowerOfTwo(Math.max(2, Math.min(arraySizeHint, 128)))];
        this.hashMask = (byte)(this.entries.length - 1);
        this.head = new HeaderEntry();
    }

    @Override
    public V get(K name2) {
        ObjectUtil.checkNotNull(name2, "name");
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        HeaderEntry<K, V> e = this.entries[i2];
        V value2 = null;
        while (e != null) {
            if (e.hash == h && this.hashingStrategy.equals(name2, e.key)) {
                value2 = e.value;
            }
            e = e.next;
        }
        return value2;
    }

    @Override
    public V get(K name2, V defaultValue) {
        V value2 = this.get(name2);
        if (value2 == null) {
            return defaultValue;
        }
        return value2;
    }

    @Override
    public V getAndRemove(K name2) {
        int h = this.hashingStrategy.hashCode(name2);
        return this.remove0(h, this.index(h), ObjectUtil.checkNotNull(name2, "name"));
    }

    @Override
    public V getAndRemove(K name2, V defaultValue) {
        V value2 = this.getAndRemove(name2);
        if (value2 == null) {
            return defaultValue;
        }
        return value2;
    }

    @Override
    public List<V> getAll(K name2) {
        ObjectUtil.checkNotNull(name2, "name");
        LinkedList<V> values = new LinkedList<V>();
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        HeaderEntry<K, V> e = this.entries[i2];
        while (e != null) {
            if (e.hash == h && this.hashingStrategy.equals(name2, e.key)) {
                values.addFirst(e.getValue());
            }
            e = e.next;
        }
        return values;
    }

    public Iterator<V> valueIterator(K name2) {
        return new ValueIterator(name2);
    }

    @Override
    public List<V> getAllAndRemove(K name2) {
        List<V> all = this.getAll(name2);
        this.remove(name2);
        return all;
    }

    @Override
    public boolean contains(K name2) {
        return this.get(name2) != null;
    }

    @Override
    public boolean containsObject(K name2, Object value2) {
        return this.contains(name2, this.valueConverter.convertObject(ObjectUtil.checkNotNull(value2, "value")));
    }

    @Override
    public boolean containsBoolean(K name2, boolean value2) {
        return this.contains(name2, this.valueConverter.convertBoolean(value2));
    }

    @Override
    public boolean containsByte(K name2, byte value2) {
        return this.contains(name2, this.valueConverter.convertByte(value2));
    }

    @Override
    public boolean containsChar(K name2, char value2) {
        return this.contains(name2, this.valueConverter.convertChar(value2));
    }

    @Override
    public boolean containsShort(K name2, short value2) {
        return this.contains(name2, this.valueConverter.convertShort(value2));
    }

    @Override
    public boolean containsInt(K name2, int value2) {
        return this.contains(name2, this.valueConverter.convertInt(value2));
    }

    @Override
    public boolean containsLong(K name2, long value2) {
        return this.contains(name2, this.valueConverter.convertLong(value2));
    }

    @Override
    public boolean containsFloat(K name2, float value2) {
        return this.contains(name2, this.valueConverter.convertFloat(value2));
    }

    @Override
    public boolean containsDouble(K name2, double value2) {
        return this.contains(name2, this.valueConverter.convertDouble(value2));
    }

    @Override
    public boolean containsTimeMillis(K name2, long value2) {
        return this.contains(name2, this.valueConverter.convertTimeMillis(value2));
    }

    @Override
    public boolean contains(K name2, V value2) {
        return this.contains(name2, value2, HashingStrategy.JAVA_HASHER);
    }

    public final boolean contains(K name2, V value2, HashingStrategy<? super V> valueHashingStrategy) {
        ObjectUtil.checkNotNull(name2, "name");
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        HeaderEntry<K, V> e = this.entries[i2];
        while (e != null) {
            if (e.hash == h && this.hashingStrategy.equals(name2, e.key) && valueHashingStrategy.equals(value2, e.value)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public Set<K> names() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet names2 = new LinkedHashSet(this.size());
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            names2.add(e.getKey());
            e = e.after;
        }
        return names2;
    }

    @Override
    public T add(K name2, V value2) {
        this.nameValidator.validateName(name2);
        ObjectUtil.checkNotNull(value2, "value");
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        this.add0(h, i2, name2, value2);
        return this.thisT();
    }

    @Override
    public T add(K name2, Iterable<? extends V> values) {
        this.nameValidator.validateName(name2);
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        for (V v : values) {
            this.add0(h, i2, name2, v);
        }
        return this.thisT();
    }

    @Override
    public T add(K name2, V ... values) {
        this.nameValidator.validateName(name2);
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        for (V v : values) {
            this.add0(h, i2, name2, v);
        }
        return this.thisT();
    }

    @Override
    public T addObject(K name2, Object value2) {
        return this.add(name2, this.valueConverter.convertObject(ObjectUtil.checkNotNull(value2, "value")));
    }

    @Override
    public T addObject(K name2, Iterable<?> values) {
        for (Object value2 : values) {
            this.addObject(name2, value2);
        }
        return this.thisT();
    }

    @Override
    public T addObject(K name2, Object ... values) {
        for (Object value2 : values) {
            this.addObject(name2, value2);
        }
        return this.thisT();
    }

    @Override
    public T addInt(K name2, int value2) {
        return this.add(name2, this.valueConverter.convertInt(value2));
    }

    @Override
    public T addLong(K name2, long value2) {
        return this.add(name2, this.valueConverter.convertLong(value2));
    }

    @Override
    public T addDouble(K name2, double value2) {
        return this.add(name2, this.valueConverter.convertDouble(value2));
    }

    @Override
    public T addTimeMillis(K name2, long value2) {
        return this.add(name2, this.valueConverter.convertTimeMillis(value2));
    }

    @Override
    public T addChar(K name2, char value2) {
        return this.add(name2, this.valueConverter.convertChar(value2));
    }

    @Override
    public T addBoolean(K name2, boolean value2) {
        return this.add(name2, this.valueConverter.convertBoolean(value2));
    }

    @Override
    public T addFloat(K name2, float value2) {
        return this.add(name2, this.valueConverter.convertFloat(value2));
    }

    @Override
    public T addByte(K name2, byte value2) {
        return this.add(name2, this.valueConverter.convertByte(value2));
    }

    @Override
    public T addShort(K name2, short value2) {
        return this.add(name2, this.valueConverter.convertShort(value2));
    }

    @Override
    public T add(Headers<? extends K, ? extends V, ?> headers) {
        if (headers == this) {
            throw new IllegalArgumentException("can't add to itself.");
        }
        this.addImpl(headers);
        return this.thisT();
    }

    protected void addImpl(Headers<? extends K, ? extends V, ?> headers) {
        if (headers instanceof DefaultHeaders) {
            DefaultHeaders defaultHeaders = (DefaultHeaders)headers;
            HeaderEntry e = defaultHeaders.head.after;
            if (defaultHeaders.hashingStrategy == this.hashingStrategy && defaultHeaders.nameValidator == this.nameValidator) {
                while (e != defaultHeaders.head) {
                    this.add0(e.hash, this.index(e.hash), e.key, e.value);
                    e = e.after;
                }
            } else {
                while (e != defaultHeaders.head) {
                    this.add((K)e.key, (V)e.value);
                    e = e.after;
                }
            }
        } else {
            for (Map.Entry<K, V> header : headers) {
                this.add(header.getKey(), header.getValue());
            }
        }
    }

    @Override
    public T set(K name2, V value2) {
        this.nameValidator.validateName(name2);
        ObjectUtil.checkNotNull(value2, "value");
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        this.remove0(h, i2, name2);
        this.add0(h, i2, name2, value2);
        return this.thisT();
    }

    @Override
    public T set(K name2, Iterable<? extends V> values) {
        this.nameValidator.validateName(name2);
        ObjectUtil.checkNotNull(values, "values");
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        this.remove0(h, i2, name2);
        for (V v : values) {
            if (v == null) break;
            this.add0(h, i2, name2, v);
        }
        return this.thisT();
    }

    @Override
    public T set(K name2, V ... values) {
        this.nameValidator.validateName(name2);
        ObjectUtil.checkNotNull(values, "values");
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        this.remove0(h, i2, name2);
        for (V v : values) {
            if (v == null) break;
            this.add0(h, i2, name2, v);
        }
        return this.thisT();
    }

    @Override
    public T setObject(K name2, Object value2) {
        ObjectUtil.checkNotNull(value2, "value");
        V convertedValue = ObjectUtil.checkNotNull(this.valueConverter.convertObject(value2), "convertedValue");
        return this.set(name2, convertedValue);
    }

    @Override
    public T setObject(K name2, Iterable<?> values) {
        this.nameValidator.validateName(name2);
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        this.remove0(h, i2, name2);
        for (Object v : values) {
            if (v == null) break;
            this.add0(h, i2, name2, this.valueConverter.convertObject(v));
        }
        return this.thisT();
    }

    @Override
    public T setObject(K name2, Object ... values) {
        this.nameValidator.validateName(name2);
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        this.remove0(h, i2, name2);
        for (Object v : values) {
            if (v == null) break;
            this.add0(h, i2, name2, this.valueConverter.convertObject(v));
        }
        return this.thisT();
    }

    @Override
    public T setInt(K name2, int value2) {
        return this.set(name2, this.valueConverter.convertInt(value2));
    }

    @Override
    public T setLong(K name2, long value2) {
        return this.set(name2, this.valueConverter.convertLong(value2));
    }

    @Override
    public T setDouble(K name2, double value2) {
        return this.set(name2, this.valueConverter.convertDouble(value2));
    }

    @Override
    public T setTimeMillis(K name2, long value2) {
        return this.set(name2, this.valueConverter.convertTimeMillis(value2));
    }

    @Override
    public T setFloat(K name2, float value2) {
        return this.set(name2, this.valueConverter.convertFloat(value2));
    }

    @Override
    public T setChar(K name2, char value2) {
        return this.set(name2, this.valueConverter.convertChar(value2));
    }

    @Override
    public T setBoolean(K name2, boolean value2) {
        return this.set(name2, this.valueConverter.convertBoolean(value2));
    }

    @Override
    public T setByte(K name2, byte value2) {
        return this.set(name2, this.valueConverter.convertByte(value2));
    }

    @Override
    public T setShort(K name2, short value2) {
        return this.set(name2, this.valueConverter.convertShort(value2));
    }

    @Override
    public T set(Headers<? extends K, ? extends V, ?> headers) {
        if (headers != this) {
            this.clear();
            this.addImpl(headers);
        }
        return this.thisT();
    }

    @Override
    public T setAll(Headers<? extends K, ? extends V, ?> headers) {
        if (headers != this) {
            for (K key2 : headers.names()) {
                this.remove(key2);
            }
            this.addImpl(headers);
        }
        return this.thisT();
    }

    @Override
    public boolean remove(K name2) {
        return this.getAndRemove(name2) != null;
    }

    @Override
    public T clear() {
        Arrays.fill(this.entries, null);
        this.head.after = this.head;
        this.head.before = this.head.after;
        this.size = 0;
        return this.thisT();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new HeaderIterator();
    }

    @Override
    public Boolean getBoolean(K name2) {
        V v = this.get(name2);
        try {
            return v != null ? Boolean.valueOf(this.valueConverter.convertToBoolean(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public boolean getBoolean(K name2, boolean defaultValue) {
        Boolean v = this.getBoolean(name2);
        return v != null ? v : defaultValue;
    }

    @Override
    public Byte getByte(K name2) {
        V v = this.get(name2);
        try {
            return v != null ? Byte.valueOf(this.valueConverter.convertToByte(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public byte getByte(K name2, byte defaultValue) {
        Byte v = this.getByte(name2);
        return v != null ? v : defaultValue;
    }

    @Override
    public Character getChar(K name2) {
        V v = this.get(name2);
        try {
            return v != null ? Character.valueOf(this.valueConverter.convertToChar(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public char getChar(K name2, char defaultValue) {
        Character v = this.getChar(name2);
        return v != null ? v.charValue() : defaultValue;
    }

    @Override
    public Short getShort(K name2) {
        V v = this.get(name2);
        try {
            return v != null ? Short.valueOf(this.valueConverter.convertToShort(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public short getShort(K name2, short defaultValue) {
        Short v = this.getShort(name2);
        return v != null ? v : defaultValue;
    }

    @Override
    public Integer getInt(K name2) {
        V v = this.get(name2);
        try {
            return v != null ? Integer.valueOf(this.valueConverter.convertToInt(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public int getInt(K name2, int defaultValue) {
        Integer v = this.getInt(name2);
        return v != null ? v : defaultValue;
    }

    @Override
    public Long getLong(K name2) {
        V v = this.get(name2);
        try {
            return v != null ? Long.valueOf(this.valueConverter.convertToLong(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public long getLong(K name2, long defaultValue) {
        Long v = this.getLong(name2);
        return v != null ? v : defaultValue;
    }

    @Override
    public Float getFloat(K name2) {
        V v = this.get(name2);
        try {
            return v != null ? Float.valueOf(this.valueConverter.convertToFloat(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public float getFloat(K name2, float defaultValue) {
        Float v = this.getFloat(name2);
        return v != null ? v.floatValue() : defaultValue;
    }

    @Override
    public Double getDouble(K name2) {
        V v = this.get(name2);
        try {
            return v != null ? Double.valueOf(this.valueConverter.convertToDouble(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public double getDouble(K name2, double defaultValue) {
        Double v = this.getDouble(name2);
        return v != null ? v : defaultValue;
    }

    @Override
    public Long getTimeMillis(K name2) {
        V v = this.get(name2);
        try {
            return v != null ? Long.valueOf(this.valueConverter.convertToTimeMillis(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public long getTimeMillis(K name2, long defaultValue) {
        Long v = this.getTimeMillis(name2);
        return v != null ? v : defaultValue;
    }

    @Override
    public Boolean getBooleanAndRemove(K name2) {
        V v = this.getAndRemove(name2);
        try {
            return v != null ? Boolean.valueOf(this.valueConverter.convertToBoolean(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public boolean getBooleanAndRemove(K name2, boolean defaultValue) {
        Boolean v = this.getBooleanAndRemove(name2);
        return v != null ? v : defaultValue;
    }

    @Override
    public Byte getByteAndRemove(K name2) {
        V v = this.getAndRemove(name2);
        try {
            return v != null ? Byte.valueOf(this.valueConverter.convertToByte(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public byte getByteAndRemove(K name2, byte defaultValue) {
        Byte v = this.getByteAndRemove(name2);
        return v != null ? v : defaultValue;
    }

    @Override
    public Character getCharAndRemove(K name2) {
        V v = this.getAndRemove(name2);
        try {
            return v != null ? Character.valueOf(this.valueConverter.convertToChar(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public char getCharAndRemove(K name2, char defaultValue) {
        Character v = this.getCharAndRemove(name2);
        return v != null ? v.charValue() : defaultValue;
    }

    @Override
    public Short getShortAndRemove(K name2) {
        V v = this.getAndRemove(name2);
        try {
            return v != null ? Short.valueOf(this.valueConverter.convertToShort(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public short getShortAndRemove(K name2, short defaultValue) {
        Short v = this.getShortAndRemove(name2);
        return v != null ? v : defaultValue;
    }

    @Override
    public Integer getIntAndRemove(K name2) {
        V v = this.getAndRemove(name2);
        try {
            return v != null ? Integer.valueOf(this.valueConverter.convertToInt(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public int getIntAndRemove(K name2, int defaultValue) {
        Integer v = this.getIntAndRemove(name2);
        return v != null ? v : defaultValue;
    }

    @Override
    public Long getLongAndRemove(K name2) {
        V v = this.getAndRemove(name2);
        try {
            return v != null ? Long.valueOf(this.valueConverter.convertToLong(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public long getLongAndRemove(K name2, long defaultValue) {
        Long v = this.getLongAndRemove(name2);
        return v != null ? v : defaultValue;
    }

    @Override
    public Float getFloatAndRemove(K name2) {
        V v = this.getAndRemove(name2);
        try {
            return v != null ? Float.valueOf(this.valueConverter.convertToFloat(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public float getFloatAndRemove(K name2, float defaultValue) {
        Float v = this.getFloatAndRemove(name2);
        return v != null ? v.floatValue() : defaultValue;
    }

    @Override
    public Double getDoubleAndRemove(K name2) {
        V v = this.getAndRemove(name2);
        try {
            return v != null ? Double.valueOf(this.valueConverter.convertToDouble(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public double getDoubleAndRemove(K name2, double defaultValue) {
        Double v = this.getDoubleAndRemove(name2);
        return v != null ? v : defaultValue;
    }

    @Override
    public Long getTimeMillisAndRemove(K name2) {
        V v = this.getAndRemove(name2);
        try {
            return v != null ? Long.valueOf(this.valueConverter.convertToTimeMillis(v)) : null;
        }
        catch (RuntimeException ignore) {
            return null;
        }
    }

    @Override
    public long getTimeMillisAndRemove(K name2, long defaultValue) {
        Long v = this.getTimeMillisAndRemove(name2);
        return v != null ? v : defaultValue;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Headers)) {
            return false;
        }
        return this.equals((Headers)o, HashingStrategy.JAVA_HASHER);
    }

    public int hashCode() {
        return this.hashCode(HashingStrategy.JAVA_HASHER);
    }

    public final boolean equals(Headers<K, V, ?> h2, HashingStrategy<V> valueHashingStrategy) {
        if (h2.size() != this.size()) {
            return false;
        }
        if (this == h2) {
            return true;
        }
        for (K name2 : this.names()) {
            List<V> otherValues = h2.getAll(name2);
            List<V> values = this.getAll(name2);
            if (otherValues.size() != values.size()) {
                return false;
            }
            for (int i2 = 0; i2 < otherValues.size(); ++i2) {
                if (valueHashingStrategy.equals(otherValues.get(i2), values.get(i2))) continue;
                return false;
            }
        }
        return true;
    }

    public final int hashCode(HashingStrategy<V> valueHashingStrategy) {
        int result2 = -1028477387;
        for (K name2 : this.names()) {
            result2 = 31 * result2 + this.hashingStrategy.hashCode(name2);
            List<V> values = this.getAll(name2);
            for (int i2 = 0; i2 < values.size(); ++i2) {
                result2 = 31 * result2 + valueHashingStrategy.hashCode(values.get(i2));
            }
        }
        return result2;
    }

    public String toString() {
        return HeadersUtils.toString(this.getClass(), this.iterator(), this.size());
    }

    protected HeaderEntry<K, V> newHeaderEntry(int h, K name2, V value2, HeaderEntry<K, V> next2) {
        return new HeaderEntry<K, V>(h, name2, value2, next2, this.head);
    }

    protected ValueConverter<V> valueConverter() {
        return this.valueConverter;
    }

    private int index(int hash2) {
        return hash2 & this.hashMask;
    }

    private void add0(int h, int i2, K name2, V value2) {
        this.entries[i2] = this.newHeaderEntry(h, name2, value2, this.entries[i2]);
        ++this.size;
    }

    private V remove0(int h, int i2, K name2) {
        HeaderEntry<K, V> e = this.entries[i2];
        if (e == null) {
            return null;
        }
        V value2 = null;
        HeaderEntry next2 = e.next;
        while (next2 != null) {
            if (next2.hash == h && this.hashingStrategy.equals(name2, next2.key)) {
                value2 = next2.value;
                e.next = next2.next;
                next2.remove();
                --this.size;
            } else {
                e = next2;
            }
            next2 = e.next;
        }
        e = this.entries[i2];
        if (e.hash == h && this.hashingStrategy.equals(name2, e.key)) {
            if (value2 == null) {
                value2 = e.value;
            }
            this.entries[i2] = e.next;
            e.remove();
            --this.size;
        }
        return value2;
    }

    private HeaderEntry<K, V> remove0(HeaderEntry<K, V> entry, HeaderEntry<K, V> previous) {
        int i2 = this.index(entry.hash);
        HeaderEntry<K, V> e = this.entries[i2];
        if (e == entry) {
            this.entries[i2] = entry.next;
            previous = this.entries[i2];
        } else {
            previous.next = entry.next;
        }
        entry.remove();
        --this.size;
        return previous;
    }

    private T thisT() {
        return (T)this;
    }

    public DefaultHeaders<K, V, T> copy() {
        DefaultHeaders<K, V, T> copy = new DefaultHeaders<K, V, T>(this.hashingStrategy, this.valueConverter, this.nameValidator, this.entries.length);
        copy.addImpl(this);
        return copy;
    }

    protected static class HeaderEntry<K, V>
    implements Map.Entry<K, V> {
        protected final int hash;
        protected final K key;
        protected V value;
        protected HeaderEntry<K, V> next;
        protected HeaderEntry<K, V> before;
        protected HeaderEntry<K, V> after;

        protected HeaderEntry(int hash2, K key2) {
            this.hash = hash2;
            this.key = key2;
        }

        HeaderEntry(int hash2, K key2, V value2, HeaderEntry<K, V> next2, HeaderEntry<K, V> head) {
            this.hash = hash2;
            this.key = key2;
            this.value = value2;
            this.next = next2;
            this.after = head;
            this.before = head.before;
            this.pointNeighborsToThis();
        }

        HeaderEntry() {
            this.hash = -1;
            this.key = null;
            this.before = this.after = this;
        }

        protected final void pointNeighborsToThis() {
            this.before.after = this;
            this.after.before = this;
        }

        public final HeaderEntry<K, V> before() {
            return this.before;
        }

        public final HeaderEntry<K, V> after() {
            return this.after;
        }

        protected void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V value2) {
            ObjectUtil.checkNotNull(value2, "value");
            V oldValue = this.value;
            this.value = value2;
            return oldValue;
        }

        public final String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            return (this.getKey() == null ? other.getKey() == null : this.getKey().equals(other.getKey())) && (this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private final class ValueIterator
    implements Iterator<V> {
        private final K name;
        private final int hash;
        private HeaderEntry<K, V> removalPrevious;
        private HeaderEntry<K, V> previous;
        private HeaderEntry<K, V> next;

        ValueIterator(K name2) {
            this.name = ObjectUtil.checkNotNull(name2, "name");
            this.hash = DefaultHeaders.this.hashingStrategy.hashCode(name2);
            this.calculateNext(DefaultHeaders.this.entries[DefaultHeaders.this.index(this.hash)]);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.previous != null) {
                this.removalPrevious = this.previous;
            }
            this.previous = this.next;
            this.calculateNext(this.next.next);
            return this.previous.value;
        }

        @Override
        public void remove() {
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            this.removalPrevious = DefaultHeaders.this.remove0(this.previous, this.removalPrevious);
            this.previous = null;
        }

        private void calculateNext(HeaderEntry<K, V> entry) {
            while (entry != null) {
                if (entry.hash == this.hash && DefaultHeaders.this.hashingStrategy.equals(this.name, entry.key)) {
                    this.next = entry;
                    return;
                }
                entry = entry.next;
            }
            this.next = null;
        }
    }

    private final class HeaderIterator
    implements Iterator<Map.Entry<K, V>> {
        private HeaderEntry<K, V> current;

        private HeaderIterator() {
            this.current = DefaultHeaders.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current.after != DefaultHeaders.this.head;
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.current.after;
            if (this.current == DefaultHeaders.this.head) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("read only");
        }
    }

    public static interface NameValidator<K> {
        public static final NameValidator NOT_NULL = new NameValidator(){

            public void validateName(Object name2) {
                ObjectUtil.checkNotNull(name2, "name");
            }
        };

        public void validateName(K var1);
    }
}

