/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.ByteProcessor;
import io.netty.util.Signal;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

final class ReplayingDecoderByteBuf
extends ByteBuf {
    private static final Signal REPLAY = ReplayingDecoder.REPLAY;
    private ByteBuf buffer;
    private boolean terminated;
    private SwappedByteBuf swapped;
    static final ReplayingDecoderByteBuf EMPTY_BUFFER = new ReplayingDecoderByteBuf(Unpooled.EMPTY_BUFFER);

    ReplayingDecoderByteBuf() {
    }

    ReplayingDecoderByteBuf(ByteBuf buffer) {
        this.setCumulation(buffer);
    }

    void setCumulation(ByteBuf buffer) {
        this.buffer = buffer;
    }

    void terminate() {
        this.terminated = true;
    }

    @Override
    public int capacity() {
        if (this.terminated) {
            return this.buffer.capacity();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int maxCapacity() {
        return this.capacity();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.buffer.alloc();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf clear() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int compareTo(ByteBuf buffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf copy() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf copy(int index2, int length2) {
        this.checkIndex(index2, length2);
        return this.buffer.copy(index2, length2);
    }

    @Override
    public ByteBuf discardReadBytes() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf ensureWritable(int writableBytes) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int ensureWritable(int minWritableBytes, boolean force) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf duplicate() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf retainedDuplicate() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public boolean getBoolean(int index2) {
        this.checkIndex(index2, 1);
        return this.buffer.getBoolean(index2);
    }

    @Override
    public byte getByte(int index2) {
        this.checkIndex(index2, 1);
        return this.buffer.getByte(index2);
    }

    @Override
    public short getUnsignedByte(int index2) {
        this.checkIndex(index2, 1);
        return this.buffer.getUnsignedByte(index2);
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length2) {
        this.checkIndex(index2, length2);
        this.buffer.getBytes(index2, dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst) {
        this.checkIndex(index2, dst.length);
        this.buffer.getBytes(index2, dst);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length2) {
        this.checkIndex(index2, length2);
        this.buffer.getBytes(index2, dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int getBytes(int index2, FileChannel out, long position, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int getInt(int index2) {
        this.checkIndex(index2, 4);
        return this.buffer.getInt(index2);
    }

    @Override
    public int getIntLE(int index2) {
        this.checkIndex(index2, 4);
        return this.buffer.getIntLE(index2);
    }

    @Override
    public long getUnsignedInt(int index2) {
        this.checkIndex(index2, 4);
        return this.buffer.getUnsignedInt(index2);
    }

    @Override
    public long getUnsignedIntLE(int index2) {
        this.checkIndex(index2, 4);
        return this.buffer.getUnsignedIntLE(index2);
    }

    @Override
    public long getLong(int index2) {
        this.checkIndex(index2, 8);
        return this.buffer.getLong(index2);
    }

    @Override
    public long getLongLE(int index2) {
        this.checkIndex(index2, 8);
        return this.buffer.getLongLE(index2);
    }

    @Override
    public int getMedium(int index2) {
        this.checkIndex(index2, 3);
        return this.buffer.getMedium(index2);
    }

    @Override
    public int getMediumLE(int index2) {
        this.checkIndex(index2, 3);
        return this.buffer.getMediumLE(index2);
    }

    @Override
    public int getUnsignedMedium(int index2) {
        this.checkIndex(index2, 3);
        return this.buffer.getUnsignedMedium(index2);
    }

    @Override
    public int getUnsignedMediumLE(int index2) {
        this.checkIndex(index2, 3);
        return this.buffer.getUnsignedMediumLE(index2);
    }

    @Override
    public short getShort(int index2) {
        this.checkIndex(index2, 2);
        return this.buffer.getShort(index2);
    }

    @Override
    public short getShortLE(int index2) {
        this.checkIndex(index2, 2);
        return this.buffer.getShortLE(index2);
    }

    @Override
    public int getUnsignedShort(int index2) {
        this.checkIndex(index2, 2);
        return this.buffer.getUnsignedShort(index2);
    }

    @Override
    public int getUnsignedShortLE(int index2) {
        this.checkIndex(index2, 2);
        return this.buffer.getUnsignedShortLE(index2);
    }

    @Override
    public char getChar(int index2) {
        this.checkIndex(index2, 2);
        return this.buffer.getChar(index2);
    }

    @Override
    public float getFloat(int index2) {
        this.checkIndex(index2, 4);
        return this.buffer.getFloat(index2);
    }

    @Override
    public double getDouble(int index2) {
        this.checkIndex(index2, 8);
        return this.buffer.getDouble(index2);
    }

    @Override
    public CharSequence getCharSequence(int index2, int length2, Charset charset) {
        this.checkIndex(index2, length2);
        return this.buffer.getCharSequence(index2, length2, charset);
    }

    @Override
    public int hashCode() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int indexOf(int fromIndex, int toIndex, byte value2) {
        if (fromIndex == toIndex) {
            return -1;
        }
        if (Math.max(fromIndex, toIndex) > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.indexOf(fromIndex, toIndex, value2);
    }

    @Override
    public int bytesBefore(byte value2) {
        int bytes2 = this.buffer.bytesBefore(value2);
        if (bytes2 < 0) {
            throw REPLAY;
        }
        return bytes2;
    }

    @Override
    public int bytesBefore(int length2, byte value2) {
        return this.bytesBefore(this.buffer.readerIndex(), length2, value2);
    }

    @Override
    public int bytesBefore(int index2, int length2, byte value2) {
        int writerIndex = this.buffer.writerIndex();
        if (index2 >= writerIndex) {
            throw REPLAY;
        }
        if (index2 <= writerIndex - length2) {
            return this.buffer.bytesBefore(index2, length2, value2);
        }
        int res = this.buffer.bytesBefore(index2, writerIndex - index2, value2);
        if (res < 0) {
            throw REPLAY;
        }
        return res;
    }

    @Override
    public int forEachByte(ByteProcessor processor) {
        int ret = this.buffer.forEachByte(processor);
        if (ret < 0) {
            throw REPLAY;
        }
        return ret;
    }

    @Override
    public int forEachByte(int index2, int length2, ByteProcessor processor) {
        int writerIndex = this.buffer.writerIndex();
        if (index2 >= writerIndex) {
            throw REPLAY;
        }
        if (index2 <= writerIndex - length2) {
            return this.buffer.forEachByte(index2, length2, processor);
        }
        int ret = this.buffer.forEachByte(index2, writerIndex - index2, processor);
        if (ret < 0) {
            throw REPLAY;
        }
        return ret;
    }

    @Override
    public int forEachByteDesc(ByteProcessor processor) {
        if (this.terminated) {
            return this.buffer.forEachByteDesc(processor);
        }
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int forEachByteDesc(int index2, int length2, ByteProcessor processor) {
        if (index2 + length2 > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.forEachByteDesc(index2, length2, processor);
    }

    @Override
    public ByteBuf markReaderIndex() {
        this.buffer.markReaderIndex();
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        if (ObjectUtil.checkNotNull(endianness, "endianness") == this.order()) {
            return this;
        }
        SwappedByteBuf swapped = this.swapped;
        if (swapped == null) {
            this.swapped = swapped = new SwappedByteBuf(this);
        }
        return swapped;
    }

    @Override
    public boolean isReadable() {
        return !this.terminated || this.buffer.isReadable();
    }

    @Override
    public boolean isReadable(int size2) {
        return !this.terminated || this.buffer.isReadable(size2);
    }

    @Override
    public int readableBytes() {
        if (this.terminated) {
            return this.buffer.readableBytes();
        }
        return Integer.MAX_VALUE - this.buffer.readerIndex();
    }

    @Override
    public boolean readBoolean() {
        this.checkReadableBytes(1);
        return this.buffer.readBoolean();
    }

    @Override
    public byte readByte() {
        this.checkReadableBytes(1);
        return this.buffer.readByte();
    }

    @Override
    public short readUnsignedByte() {
        this.checkReadableBytes(1);
        return this.buffer.readUnsignedByte();
    }

    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length2) {
        this.checkReadableBytes(length2);
        this.buffer.readBytes(dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] dst) {
        this.checkReadableBytes(dst.length);
        this.buffer.readBytes(dst);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length2) {
        this.checkReadableBytes(length2);
        this.buffer.readBytes(dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst) {
        this.checkReadableBytes(dst.writableBytes());
        this.buffer.readBytes(dst);
        return this;
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int readBytes(FileChannel out, long position, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf readBytes(int length2) {
        this.checkReadableBytes(length2);
        return this.buffer.readBytes(length2);
    }

    @Override
    public ByteBuf readSlice(int length2) {
        this.checkReadableBytes(length2);
        return this.buffer.readSlice(length2);
    }

    @Override
    public ByteBuf readRetainedSlice(int length2) {
        this.checkReadableBytes(length2);
        return this.buffer.readRetainedSlice(length2);
    }

    @Override
    public ByteBuf readBytes(OutputStream out, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    @Override
    public ByteBuf readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
        return this;
    }

    @Override
    public int readInt() {
        this.checkReadableBytes(4);
        return this.buffer.readInt();
    }

    @Override
    public int readIntLE() {
        this.checkReadableBytes(4);
        return this.buffer.readIntLE();
    }

    @Override
    public long readUnsignedInt() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedInt();
    }

    @Override
    public long readUnsignedIntLE() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedIntLE();
    }

    @Override
    public long readLong() {
        this.checkReadableBytes(8);
        return this.buffer.readLong();
    }

    @Override
    public long readLongLE() {
        this.checkReadableBytes(8);
        return this.buffer.readLongLE();
    }

    @Override
    public int readMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readMedium();
    }

    @Override
    public int readMediumLE() {
        this.checkReadableBytes(3);
        return this.buffer.readMediumLE();
    }

    @Override
    public int readUnsignedMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMedium();
    }

    @Override
    public int readUnsignedMediumLE() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMediumLE();
    }

    @Override
    public short readShort() {
        this.checkReadableBytes(2);
        return this.buffer.readShort();
    }

    @Override
    public short readShortLE() {
        this.checkReadableBytes(2);
        return this.buffer.readShortLE();
    }

    @Override
    public int readUnsignedShort() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShort();
    }

    @Override
    public int readUnsignedShortLE() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShortLE();
    }

    @Override
    public char readChar() {
        this.checkReadableBytes(2);
        return this.buffer.readChar();
    }

    @Override
    public float readFloat() {
        this.checkReadableBytes(4);
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() {
        this.checkReadableBytes(8);
        return this.buffer.readDouble();
    }

    @Override
    public CharSequence readCharSequence(int length2, Charset charset) {
        this.checkReadableBytes(length2);
        return this.buffer.readCharSequence(length2, charset);
    }

    @Override
    public ByteBuf resetReaderIndex() {
        this.buffer.resetReaderIndex();
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBoolean(int index2, boolean value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setByte(int index2, int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int setBytes(int index2, InputStream in, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setZero(int index2, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int setBytes(int index2, FileChannel in, long position, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setIndex(int readerIndex, int writerIndex) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setInt(int index2, int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setIntLE(int index2, int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setLong(int index2, long value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setLongLE(int index2, long value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setMedium(int index2, int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setMediumLE(int index2, int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setShort(int index2, int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setShortLE(int index2, int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setChar(int index2, int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setFloat(int index2, float value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setDouble(int index2, double value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf skipBytes(int length2) {
        this.checkReadableBytes(length2);
        this.buffer.skipBytes(length2);
        return this;
    }

    @Override
    public ByteBuf slice() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf retainedSlice() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf slice(int index2, int length2) {
        this.checkIndex(index2, length2);
        return this.buffer.slice(index2, length2);
    }

    @Override
    public ByteBuf retainedSlice(int index2, int length2) {
        this.checkIndex(index2, length2);
        return this.buffer.slice(index2, length2);
    }

    @Override
    public int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    @Override
    public ByteBuffer nioBuffer() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        return this.buffer.nioBuffer(index2, length2);
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length2) {
        this.checkIndex(index2, length2);
        return this.buffer.nioBuffers(index2, length2);
    }

    @Override
    public ByteBuffer internalNioBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        return this.buffer.internalNioBuffer(index2, length2);
    }

    @Override
    public String toString(int index2, int length2, Charset charset) {
        this.checkIndex(index2, length2);
        return this.buffer.toString(index2, length2, charset);
    }

    @Override
    public String toString(Charset charsetName) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + "ridx=" + this.readerIndex() + ", widx=" + this.writerIndex() + ')';
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isWritable(int size2) {
        return false;
    }

    @Override
    public int writableBytes() {
        return 0;
    }

    @Override
    public int maxWritableBytes() {
        return 0;
    }

    @Override
    public ByteBuf writeBoolean(boolean value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeByte(int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(byte[] src, int srcIndex, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(byte[] src) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer src) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writeBytes(InputStream in, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writeBytes(ScatteringByteChannel in, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writeBytes(FileChannel in, long position, int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeInt(int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeIntLE(int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeLong(long value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeLongLE(long value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeMedium(int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeMediumLE(int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeZero(int length2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    @Override
    public ByteBuf writerIndex(int writerIndex) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeShort(int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeShortLE(int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeChar(int value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeFloat(float value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeDouble(double value2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int setCharSequence(int index2, CharSequence sequence, Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writeCharSequence(CharSequence sequence, Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    private void checkIndex(int index2, int length2) {
        if (index2 + length2 > this.buffer.writerIndex()) {
            throw REPLAY;
        }
    }

    private void checkReadableBytes(int readableBytes) {
        if (this.buffer.readableBytes() < readableBytes) {
            throw REPLAY;
        }
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int refCnt() {
        return this.buffer.refCnt();
    }

    @Override
    public ByteBuf retain() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf retain(int increment) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf touch() {
        this.buffer.touch();
        return this;
    }

    @Override
    public ByteBuf touch(Object hint) {
        this.buffer.touch(hint);
        return this;
    }

    @Override
    public boolean release() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public boolean release(int decrement) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf unwrap() {
        throw ReplayingDecoderByteBuf.reject();
    }

    private static UnsupportedOperationException reject() {
        return new UnsupportedOperationException("not a replayable operation");
    }

    static {
        EMPTY_BUFFER.terminate();
    }
}

