/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = SystemPropertyUtil.get("line.separator", "\n");
    public static final char DOUBLE_QUOTE = '\"';
    public static final char COMMA = ',';
    public static final char LINE_FEED = '\n';
    public static final char CARRIAGE_RETURN = '\r';
    public static final char TAB = '\t';
    public static final char SPACE = ' ';
    private static final String[] BYTE2HEX_PAD = new String[256];
    private static final String[] BYTE2HEX_NOPAD = new String[256];
    private static final byte[] HEX2B;
    private static final int CSV_NUMBER_ESCAPE_CHARACTERS = 7;
    private static final char PACKAGE_SEPARATOR_CHAR = '.';

    private StringUtil() {
    }

    public static String substringAfter(String value2, char delim) {
        int pos2 = value2.indexOf(delim);
        if (pos2 >= 0) {
            return value2.substring(pos2 + 1);
        }
        return null;
    }

    public static boolean commonSuffixOfLength(String s2, String p2, int len) {
        return s2 != null && p2 != null && len >= 0 && s2.regionMatches(s2.length() - len, p2, p2.length() - len, len);
    }

    public static String byteToHexStringPadded(int value2) {
        return BYTE2HEX_PAD[value2 & 0xFF];
    }

    public static <T extends Appendable> T byteToHexStringPadded(T buf, int value2) {
        try {
            buf.append(StringUtil.byteToHexStringPadded(value2));
        }
        catch (IOException e) {
            PlatformDependent.throwException(e);
        }
        return buf;
    }

    public static String toHexStringPadded(byte[] src) {
        return StringUtil.toHexStringPadded(src, 0, src.length);
    }

    public static String toHexStringPadded(byte[] src, int offset2, int length2) {
        return StringUtil.toHexStringPadded(new StringBuilder(length2 << 1), src, offset2, length2).toString();
    }

    public static <T extends Appendable> T toHexStringPadded(T dst, byte[] src) {
        return StringUtil.toHexStringPadded(dst, src, 0, src.length);
    }

    public static <T extends Appendable> T toHexStringPadded(T dst, byte[] src, int offset2, int length2) {
        int end2 = offset2 + length2;
        for (int i2 = offset2; i2 < end2; ++i2) {
            StringUtil.byteToHexStringPadded(dst, src[i2]);
        }
        return dst;
    }

    public static String byteToHexString(int value2) {
        return BYTE2HEX_NOPAD[value2 & 0xFF];
    }

    public static <T extends Appendable> T byteToHexString(T buf, int value2) {
        try {
            buf.append(StringUtil.byteToHexString(value2));
        }
        catch (IOException e) {
            PlatformDependent.throwException(e);
        }
        return buf;
    }

    public static String toHexString(byte[] src) {
        return StringUtil.toHexString(src, 0, src.length);
    }

    public static String toHexString(byte[] src, int offset2, int length2) {
        return StringUtil.toHexString(new StringBuilder(length2 << 1), src, offset2, length2).toString();
    }

    public static <T extends Appendable> T toHexString(T dst, byte[] src) {
        return StringUtil.toHexString(dst, src, 0, src.length);
    }

    public static <T extends Appendable> T toHexString(T dst, byte[] src, int offset2, int length2) {
        int i2;
        assert (length2 >= 0);
        if (length2 == 0) {
            return dst;
        }
        int end2 = offset2 + length2;
        int endMinusOne = end2 - 1;
        for (i2 = offset2; i2 < endMinusOne && src[i2] == 0; ++i2) {
        }
        StringUtil.byteToHexString(dst, src[i2++]);
        int remaining = end2 - i2;
        StringUtil.toHexStringPadded(dst, src, i2, remaining);
        return dst;
    }

    public static int decodeHexNibble(char c) {
        assert (HEX2B.length == 65536);
        char index2 = c;
        return HEX2B[index2];
    }

    public static byte decodeHexByte(CharSequence s2, int pos2) {
        int hi = StringUtil.decodeHexNibble(s2.charAt(pos2));
        int lo = StringUtil.decodeHexNibble(s2.charAt(pos2 + 1));
        if (hi == -1 || lo == -1) {
            throw new IllegalArgumentException(String.format("invalid hex byte '%s' at index %d of '%s'", s2.subSequence(pos2, pos2 + 2), pos2, s2));
        }
        return (byte)((hi << 4) + lo);
    }

    public static byte[] decodeHexDump(CharSequence hexDump, int fromIndex, int length2) {
        if (length2 < 0 || (length2 & 1) != 0) {
            throw new IllegalArgumentException("length: " + length2);
        }
        if (length2 == 0) {
            return EmptyArrays.EMPTY_BYTES;
        }
        byte[] bytes2 = new byte[length2 >>> 1];
        for (int i2 = 0; i2 < length2; i2 += 2) {
            bytes2[i2 >>> 1] = StringUtil.decodeHexByte(hexDump, fromIndex + i2);
        }
        return bytes2;
    }

    public static byte[] decodeHexDump(CharSequence hexDump) {
        return StringUtil.decodeHexDump(hexDump, 0, hexDump.length());
    }

    public static String simpleClassName(Object o) {
        if (o == null) {
            return "null_object";
        }
        return StringUtil.simpleClassName(o.getClass());
    }

    public static String simpleClassName(Class<?> clazz) {
        String className = ObjectUtil.checkNotNull(clazz, "clazz").getName();
        int lastDotIdx = className.lastIndexOf(46);
        if (lastDotIdx > -1) {
            return className.substring(lastDotIdx + 1);
        }
        return className;
    }

    public static CharSequence escapeCsv(CharSequence value2) {
        return StringUtil.escapeCsv(value2, false);
    }

    public static CharSequence escapeCsv(CharSequence value2, boolean trimWhiteSpace) {
        int last2;
        int start2;
        int length2 = ObjectUtil.checkNotNull(value2, "value").length();
        if (trimWhiteSpace) {
            start2 = StringUtil.indexOfFirstNonOwsChar(value2, length2);
            last2 = StringUtil.indexOfLastNonOwsChar(value2, start2, length2);
        } else {
            start2 = 0;
            last2 = length2 - 1;
        }
        if (start2 > last2) {
            return EMPTY_STRING;
        }
        int firstUnescapedSpecial = -1;
        boolean quoted = false;
        if (StringUtil.isDoubleQuote(value2.charAt(start2))) {
            boolean bl = quoted = StringUtil.isDoubleQuote(value2.charAt(last2)) && last2 > start2;
            if (quoted) {
                ++start2;
                --last2;
            } else {
                firstUnescapedSpecial = start2;
            }
        }
        if (firstUnescapedSpecial < 0) {
            int i2;
            if (quoted) {
                for (i2 = start2; i2 <= last2; ++i2) {
                    if (!StringUtil.isDoubleQuote(value2.charAt(i2))) continue;
                    if (i2 == last2 || !StringUtil.isDoubleQuote(value2.charAt(i2 + 1))) {
                        firstUnescapedSpecial = i2;
                        break;
                    }
                    ++i2;
                }
            } else {
                for (i2 = start2; i2 <= last2; ++i2) {
                    char c = value2.charAt(i2);
                    if (c == '\n' || c == '\r' || c == ',') {
                        firstUnescapedSpecial = i2;
                        break;
                    }
                    if (!StringUtil.isDoubleQuote(c)) continue;
                    if (i2 == last2 || !StringUtil.isDoubleQuote(value2.charAt(i2 + 1))) {
                        firstUnescapedSpecial = i2;
                        break;
                    }
                    ++i2;
                }
            }
            if (firstUnescapedSpecial < 0) {
                return quoted ? value2.subSequence(start2 - 1, last2 + 2) : value2.subSequence(start2, last2 + 1);
            }
        }
        StringBuilder result2 = new StringBuilder(last2 - start2 + 1 + 7);
        result2.append('\"').append(value2, start2, firstUnescapedSpecial);
        for (int i3 = firstUnescapedSpecial; i3 <= last2; ++i3) {
            char c = value2.charAt(i3);
            if (StringUtil.isDoubleQuote(c)) {
                result2.append('\"');
                if (i3 < last2 && StringUtil.isDoubleQuote(value2.charAt(i3 + 1))) {
                    ++i3;
                }
            }
            result2.append(c);
        }
        return result2.append('\"');
    }

    public static CharSequence unescapeCsv(CharSequence value2) {
        boolean quoted;
        int length2 = ObjectUtil.checkNotNull(value2, "value").length();
        if (length2 == 0) {
            return value2;
        }
        int last2 = length2 - 1;
        boolean bl = quoted = StringUtil.isDoubleQuote(value2.charAt(0)) && StringUtil.isDoubleQuote(value2.charAt(last2)) && length2 != 1;
        if (!quoted) {
            StringUtil.validateCsvFormat(value2);
            return value2;
        }
        StringBuilder unescaped = InternalThreadLocalMap.get().stringBuilder();
        for (int i2 = 1; i2 < last2; ++i2) {
            char current2 = value2.charAt(i2);
            if (current2 == '\"') {
                if (StringUtil.isDoubleQuote(value2.charAt(i2 + 1)) && i2 + 1 != last2) {
                    ++i2;
                } else {
                    throw StringUtil.newInvalidEscapedCsvFieldException(value2, i2);
                }
            }
            unescaped.append(current2);
        }
        return unescaped.toString();
    }

    public static List<CharSequence> unescapeCsvFields(CharSequence value2) {
        ArrayList<CharSequence> unescaped = new ArrayList<CharSequence>(2);
        StringBuilder current2 = InternalThreadLocalMap.get().stringBuilder();
        boolean quoted = false;
        int last2 = value2.length() - 1;
        block8: for (int i2 = 0; i2 <= last2; ++i2) {
            char c = value2.charAt(i2);
            if (quoted) {
                switch (c) {
                    case '\"': {
                        char next2;
                        if (i2 == last2) {
                            unescaped.add(current2.toString());
                            return unescaped;
                        }
                        if ((next2 = value2.charAt(++i2)) == '\"') {
                            current2.append('\"');
                            break;
                        }
                        if (next2 == ',') {
                            quoted = false;
                            unescaped.add(current2.toString());
                            current2.setLength(0);
                            break;
                        }
                        throw StringUtil.newInvalidEscapedCsvFieldException(value2, i2 - 1);
                    }
                    default: {
                        current2.append(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case ',': {
                    unescaped.add(current2.toString());
                    current2.setLength(0);
                    continue block8;
                }
                case '\"': {
                    if (current2.length() == 0) {
                        quoted = true;
                        continue block8;
                    }
                }
                case '\n': 
                case '\r': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(value2, i2);
                }
                default: {
                    current2.append(c);
                }
            }
        }
        if (quoted) {
            throw StringUtil.newInvalidEscapedCsvFieldException(value2, last2);
        }
        unescaped.add(current2.toString());
        return unescaped;
    }

    private static void validateCsvFormat(CharSequence value2) {
        int length2 = value2.length();
        for (int i2 = 0; i2 < length2; ++i2) {
            switch (value2.charAt(i2)) {
                case '\n': 
                case '\r': 
                case '\"': 
                case ',': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(value2, i2);
                }
            }
        }
    }

    private static IllegalArgumentException newInvalidEscapedCsvFieldException(CharSequence value2, int index2) {
        return new IllegalArgumentException("invalid escaped CSV field: " + value2 + " index: " + index2);
    }

    public static int length(String s2) {
        return s2 == null ? 0 : s2.length();
    }

    public static boolean isNullOrEmpty(String s2) {
        return s2 == null || s2.isEmpty();
    }

    public static int indexOfNonWhiteSpace(CharSequence seq, int offset2) {
        while (offset2 < seq.length()) {
            if (!Character.isWhitespace(seq.charAt(offset2))) {
                return offset2;
            }
            ++offset2;
        }
        return -1;
    }

    public static int indexOfWhiteSpace(CharSequence seq, int offset2) {
        while (offset2 < seq.length()) {
            if (Character.isWhitespace(seq.charAt(offset2))) {
                return offset2;
            }
            ++offset2;
        }
        return -1;
    }

    public static boolean isSurrogate(char c) {
        return c >= '\ud800' && c <= '\udfff';
    }

    private static boolean isDoubleQuote(char c) {
        return c == '\"';
    }

    public static boolean endsWith(CharSequence s2, char c) {
        int len = s2.length();
        return len > 0 && s2.charAt(len - 1) == c;
    }

    public static CharSequence trimOws(CharSequence value2) {
        int length2 = value2.length();
        if (length2 == 0) {
            return value2;
        }
        int start2 = StringUtil.indexOfFirstNonOwsChar(value2, length2);
        int end2 = StringUtil.indexOfLastNonOwsChar(value2, start2, length2);
        return start2 == 0 && end2 == length2 - 1 ? value2 : value2.subSequence(start2, end2 + 1);
    }

    public static CharSequence join(CharSequence separator, Iterable<? extends CharSequence> elements) {
        ObjectUtil.checkNotNull(separator, "separator");
        ObjectUtil.checkNotNull(elements, "elements");
        Iterator<? extends CharSequence> iterator = elements.iterator();
        if (!iterator.hasNext()) {
            return EMPTY_STRING;
        }
        CharSequence firstElement = iterator.next();
        if (!iterator.hasNext()) {
            return firstElement;
        }
        StringBuilder builder = new StringBuilder(firstElement);
        do {
            builder.append(separator).append(iterator.next());
        } while (iterator.hasNext());
        return builder;
    }

    private static int indexOfFirstNonOwsChar(CharSequence value2, int length2) {
        int i2;
        for (i2 = 0; i2 < length2 && StringUtil.isOws(value2.charAt(i2)); ++i2) {
        }
        return i2;
    }

    private static int indexOfLastNonOwsChar(CharSequence value2, int start2, int length2) {
        int i2;
        for (i2 = length2 - 1; i2 > start2 && StringUtil.isOws(value2.charAt(i2)); --i2) {
        }
        return i2;
    }

    private static boolean isOws(char c) {
        return c == ' ' || c == '\t';
    }

    static {
        for (int i2 = 0; i2 < BYTE2HEX_PAD.length; ++i2) {
            String str = Integer.toHexString(i2);
            StringUtil.BYTE2HEX_PAD[i2] = i2 > 15 ? str : '0' + str;
            StringUtil.BYTE2HEX_NOPAD[i2] = str;
        }
        HEX2B = new byte[65536];
        Arrays.fill(HEX2B, (byte)-1);
        StringUtil.HEX2B[48] = 0;
        StringUtil.HEX2B[49] = 1;
        StringUtil.HEX2B[50] = 2;
        StringUtil.HEX2B[51] = 3;
        StringUtil.HEX2B[52] = 4;
        StringUtil.HEX2B[53] = 5;
        StringUtil.HEX2B[54] = 6;
        StringUtil.HEX2B[55] = 7;
        StringUtil.HEX2B[56] = 8;
        StringUtil.HEX2B[57] = 9;
        StringUtil.HEX2B[65] = 10;
        StringUtil.HEX2B[66] = 11;
        StringUtil.HEX2B[67] = 12;
        StringUtil.HEX2B[68] = 13;
        StringUtil.HEX2B[69] = 14;
        StringUtil.HEX2B[70] = 15;
        StringUtil.HEX2B[97] = 10;
        StringUtil.HEX2B[98] = 11;
        StringUtil.HEX2B[99] = 12;
        StringUtil.HEX2B[100] = 13;
        StringUtil.HEX2B[101] = 14;
        StringUtil.HEX2B[102] = 15;
    }
}

