/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueL3Pad;
import io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;

public class MpscArrayQueue<E>
extends MpscArrayQueueL3Pad<E> {
    public MpscArrayQueue(int capacity) {
        super(capacity);
    }

    public boolean offerIfBelowThreshold(E e, int threshold) {
        long pIndex;
        if (null == e) {
            throw new NullPointerException();
        }
        long mask = this.mask;
        long capacity = mask + 1L;
        long producerLimit = this.lvProducerLimit();
        do {
            long available;
            long size2;
            if ((size2 = capacity - (available = producerLimit - (pIndex = this.lvProducerIndex()))) < (long)threshold) continue;
            long cIndex = this.lvConsumerIndex();
            size2 = pIndex - cIndex;
            if (size2 >= (long)threshold) {
                return false;
            }
            producerLimit = cIndex + capacity;
            this.soProducerLimit(producerLimit);
        } while (!this.casProducerIndex(pIndex, pIndex + 1L));
        long offset2 = MpscArrayQueue.calcElementOffset(pIndex, mask);
        UnsafeRefArrayAccess.soElement(this.buffer, offset2, e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        long pIndex;
        if (null == e) {
            throw new NullPointerException();
        }
        long mask = this.mask;
        long producerLimit = this.lvProducerLimit();
        do {
            if ((pIndex = this.lvProducerIndex()) < producerLimit) continue;
            long cIndex = this.lvConsumerIndex();
            producerLimit = cIndex + mask + 1L;
            if (pIndex >= producerLimit) {
                return false;
            }
            this.soProducerLimit(producerLimit);
        } while (!this.casProducerIndex(pIndex, pIndex + 1L));
        long offset2 = MpscArrayQueue.calcElementOffset(pIndex, mask);
        UnsafeRefArrayAccess.soElement(this.buffer, offset2, e);
        return true;
    }

    public final int failFastOffer(E e) {
        long producerLimit;
        if (null == e) {
            throw new NullPointerException();
        }
        long mask = this.mask;
        long capacity = mask + 1L;
        long pIndex = this.lvProducerIndex();
        if (pIndex >= (producerLimit = this.lvProducerLimit())) {
            long cIndex = this.lvConsumerIndex();
            producerLimit = cIndex + capacity;
            if (pIndex >= producerLimit) {
                return 1;
            }
            this.soProducerLimit(producerLimit);
        }
        if (!this.casProducerIndex(pIndex, pIndex + 1L)) {
            return -1;
        }
        long offset2 = MpscArrayQueue.calcElementOffset(pIndex, mask);
        UnsafeRefArrayAccess.soElement(this.buffer, offset2, e);
        return 0;
    }

    @Override
    public E poll() {
        Object[] buffer = this.buffer;
        long cIndex = this.lpConsumerIndex();
        long offset2 = this.calcElementOffset(cIndex);
        Object e = UnsafeRefArrayAccess.lvElement(buffer, offset2);
        if (null == e) {
            if (cIndex != this.lvProducerIndex()) {
                while ((e = UnsafeRefArrayAccess.lvElement(buffer, offset2)) == null) {
                }
            } else {
                return null;
            }
        }
        UnsafeRefArrayAccess.spElement(buffer, offset2, null);
        this.soConsumerIndex(cIndex + 1L);
        return (E)e;
    }

    @Override
    public E peek() {
        Object[] buffer = this.buffer;
        long cIndex = this.lpConsumerIndex();
        long offset2 = this.calcElementOffset(cIndex);
        Object e = UnsafeRefArrayAccess.lvElement(buffer, offset2);
        if (null == e) {
            if (cIndex != this.lvProducerIndex()) {
                while ((e = UnsafeRefArrayAccess.lvElement(buffer, offset2)) == null) {
                }
            } else {
                return null;
            }
        }
        return (E)e;
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        Object[] buffer = this.buffer;
        long cIndex = this.lpConsumerIndex();
        long offset2 = this.calcElementOffset(cIndex);
        Object e = UnsafeRefArrayAccess.lvElement(buffer, offset2);
        if (null == e) {
            return null;
        }
        UnsafeRefArrayAccess.spElement(buffer, offset2, null);
        this.soConsumerIndex(cIndex + 1L);
        return (E)e;
    }

    @Override
    public E relaxedPeek() {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long cIndex = this.lpConsumerIndex();
        return (E)UnsafeRefArrayAccess.lvElement(buffer, MpscArrayQueue.calcElementOffset(cIndex, mask));
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return this.drain(c, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2) {
        int filled;
        long result2 = 0L;
        int capacity = this.capacity();
        do {
            if ((filled = this.fill(s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)result2;
        } while ((result2 += (long)filled) <= (long)capacity);
        return (int)result2;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit2) {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long cIndex = this.lpConsumerIndex();
        for (int i2 = 0; i2 < limit2; ++i2) {
            long index2 = cIndex + (long)i2;
            long offset2 = MpscArrayQueue.calcElementOffset(index2, mask);
            Object e = UnsafeRefArrayAccess.lvElement(buffer, offset2);
            if (null == e) {
                return i2;
            }
            UnsafeRefArrayAccess.spElement(buffer, offset2, null);
            this.soConsumerIndex(index2 + 1L);
            c.accept(e);
        }
        return limit2;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2, int limit2) {
        long available;
        long pIndex;
        long mask = this.mask;
        long capacity = mask + 1L;
        long producerLimit = this.lvProducerLimit();
        int actualLimit = 0;
        do {
            if ((available = producerLimit - (pIndex = this.lvProducerIndex())) > 0L) continue;
            long cIndex = this.lvConsumerIndex();
            producerLimit = cIndex + capacity;
            available = producerLimit - pIndex;
            if (available <= 0L) {
                return 0;
            }
            this.soProducerLimit(producerLimit);
        } while (!this.casProducerIndex(pIndex, pIndex + (long)(actualLimit = Math.min((int)available, limit2))));
        Object[] buffer = this.buffer;
        for (int i2 = 0; i2 < actualLimit; ++i2) {
            long offset2 = MpscArrayQueue.calcElementOffset(pIndex + (long)i2, mask);
            UnsafeRefArrayAccess.soElement(buffer, offset2, s2.get());
        }
        return actualLimit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit2) {
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long cIndex = this.lpConsumerIndex();
        int counter = 0;
        while (exit2.keepRunning()) {
            for (int i2 = 0; i2 < 4096; ++i2) {
                long offset2 = MpscArrayQueue.calcElementOffset(cIndex, mask);
                Object e = UnsafeRefArrayAccess.lvElement(buffer, offset2);
                if (null == e) {
                    counter = w.idle(counter);
                    continue;
                }
                counter = 0;
                UnsafeRefArrayAccess.spElement(buffer, offset2, null);
                this.soConsumerIndex(++cIndex);
                c.accept(e);
            }
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s2, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit2) {
        int idleCounter = 0;
        while (exit2.keepRunning()) {
            if (this.fill(s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                idleCounter = w.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
        }
    }
}

