/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.BaseLinkedQueue;
import io.netty.util.internal.shaded.org.jctools.queues.LinkedQueueNode;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;

public class SpscLinkedQueue<E>
extends BaseLinkedQueue<E> {
    public SpscLinkedQueue() {
        LinkedQueueNode node = this.newNode();
        this.spProducerNode(node);
        this.spConsumerNode(node);
        node.soNext(null);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        LinkedQueueNode<E> nextNode = this.newNode(e);
        this.lpProducerNode().soNext(nextNode);
        this.spProducerNode(nextNode);
        return true;
    }

    @Override
    public E poll() {
        return (E)this.relaxedPoll();
    }

    @Override
    public E peek() {
        return (E)this.relaxedPeek();
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2) {
        long result2 = 0L;
        do {
            this.fill(s2, 4096);
        } while ((result2 += 4096L) <= 0x7FFFEFFFL);
        return (int)result2;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2, int limit2) {
        LinkedQueueNode<E> tail;
        if (limit2 == 0) {
            return 0;
        }
        LinkedQueueNode<E> head = tail = this.newNode(s2.get());
        for (int i2 = 1; i2 < limit2; ++i2) {
            LinkedQueueNode<E> temp = this.newNode(s2.get());
            tail.soNext(temp);
            tail = temp;
        }
        LinkedQueueNode<E> oldPNode = this.lpProducerNode();
        oldPNode.soNext(head);
        this.spProducerNode(tail);
        return limit2;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s2, MessagePassingQueue.WaitStrategy wait3, MessagePassingQueue.ExitCondition exit2) {
        LinkedQueueNode<E> chaserNode = this.producerNode;
        while (exit2.keepRunning()) {
            for (int i2 = 0; i2 < 4096; ++i2) {
                LinkedQueueNode<E> nextNode = this.newNode(s2.get());
                chaserNode.soNext(nextNode);
                this.producerNode = chaserNode = nextNode;
            }
        }
    }
}

