/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.commons.crypto.stream.CryptoOutputStream;
import org.apache.commons.crypto.stream.CtrCryptoInputStream;
import org.apache.commons.crypto.stream.output.ChannelOutput;
import org.apache.commons.crypto.stream.output.Output;
import org.apache.commons.crypto.stream.output.StreamOutput;
import org.apache.commons.crypto.utils.Utils;

public class CtrCryptoOutputStream
extends CryptoOutputStream {
    private long streamOffset = 0L;
    private final byte[] initIV;
    private byte[] iv;
    private byte padding;
    private boolean cipherReset = false;

    public CtrCryptoOutputStream(Properties props, OutputStream out, byte[] key2, byte[] iv) throws IOException {
        this(props, out, key2, iv, 0L);
    }

    public CtrCryptoOutputStream(Properties props, WritableByteChannel out, byte[] key2, byte[] iv) throws IOException {
        this(props, out, key2, iv, 0L);
    }

    protected CtrCryptoOutputStream(OutputStream out, CryptoCipher cipher, int bufferSize, byte[] key2, byte[] iv) throws IOException {
        this(out, cipher, bufferSize, key2, iv, 0L);
    }

    protected CtrCryptoOutputStream(WritableByteChannel channel, CryptoCipher cipher, int bufferSize, byte[] key2, byte[] iv) throws IOException {
        this(channel, cipher, bufferSize, key2, iv, 0L);
    }

    protected CtrCryptoOutputStream(Output output, CryptoCipher cipher, int bufferSize, byte[] key2, byte[] iv) throws IOException {
        this(output, cipher, bufferSize, key2, iv, 0L);
    }

    public CtrCryptoOutputStream(Properties props, OutputStream out, byte[] key2, byte[] iv, long streamOffset) throws IOException {
        this(out, Utils.getCipherInstance("AES/CTR/NoPadding", props), CryptoInputStream.getBufferSize(props), key2, iv, streamOffset);
    }

    public CtrCryptoOutputStream(Properties props, WritableByteChannel out, byte[] key2, byte[] iv, long streamOffset) throws IOException {
        this(out, Utils.getCipherInstance("AES/CTR/NoPadding", props), CryptoInputStream.getBufferSize(props), key2, iv, streamOffset);
    }

    protected CtrCryptoOutputStream(OutputStream out, CryptoCipher cipher, int bufferSize, byte[] key2, byte[] iv, long streamOffset) throws IOException {
        this(new StreamOutput(out, bufferSize), cipher, bufferSize, key2, iv, streamOffset);
    }

    protected CtrCryptoOutputStream(WritableByteChannel channel, CryptoCipher cipher, int bufferSize, byte[] key2, byte[] iv, long streamOffset) throws IOException {
        this(new ChannelOutput(channel), cipher, bufferSize, key2, iv, streamOffset);
    }

    protected CtrCryptoOutputStream(Output output, CryptoCipher cipher, int bufferSize, byte[] key2, byte[] iv, long streamOffset) throws IOException {
        super(output, cipher, bufferSize, (Key)new SecretKeySpec(key2, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
        CryptoInputStream.checkStreamCipher(cipher);
        this.streamOffset = streamOffset;
        this.initIV = (byte[])iv.clone();
        this.iv = (byte[])iv.clone();
        this.resetCipher();
    }

    @Override
    protected void encrypt() throws IOException {
        Utils.checkState(this.inBuffer.position() >= this.padding);
        if (this.inBuffer.position() == this.padding) {
            return;
        }
        this.inBuffer.flip();
        this.outBuffer.clear();
        this.encryptBuffer(this.outBuffer);
        this.inBuffer.clear();
        this.outBuffer.flip();
        if (this.padding > 0) {
            this.outBuffer.position(this.padding);
            this.padding = 0;
        }
        int len = this.output.write(this.outBuffer);
        this.streamOffset += (long)len;
        if (this.cipherReset) {
            this.resetCipher();
        }
    }

    @Override
    protected void encryptFinal() throws IOException {
        this.encrypt();
    }

    @Override
    protected void initCipher() {
    }

    private void resetCipher() throws IOException {
        long counter = this.streamOffset / (long)this.cipher.getBlockSize();
        this.padding = (byte)(this.streamOffset % (long)this.cipher.getBlockSize());
        this.inBuffer.position(this.padding);
        CtrCryptoInputStream.calculateIV(this.initIV, counter, this.iv);
        try {
            this.cipher.init(1, this.key, new IvParameterSpec(this.iv));
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException(e);
        }
        this.cipherReset = false;
    }

    private void encryptBuffer(ByteBuffer out) throws IOException {
        int inputSize = this.inBuffer.remaining();
        try {
            int n = this.cipher.update(this.inBuffer, out);
            if (n < inputSize) {
                this.cipher.doFinal(this.inBuffer, out);
                this.cipherReset = true;
            }
        }
        catch (ShortBufferException e) {
            throw new IOException(e);
        }
        catch (BadPaddingException e) {
            throw new IOException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IOException(e);
        }
    }

    protected long getStreamOffset() {
        return this.streamOffset;
    }

    protected void setStreamOffset(long streamOffset) {
        this.streamOffset = streamOffset;
    }
}

